/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.SpoonPerspective;
import org.pentaho.di.ui.spoon.XulSpoonResourceBundle;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulOverlay;
import org.pentaho.ui.xul.containers.XulDeck;
import org.pentaho.ui.xul.impl.XulEventHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpoonPerspectiveManager {
    private static SpoonPerspectiveManager instance = new SpoonPerspectiveManager();
    private Map<Class<? extends SpoonPerspective>, SpoonPerspective> perspectives = new LinkedHashMap<Class<? extends SpoonPerspective>, SpoonPerspective>();
    private TreeSet<SpoonPerspective> orderedPerspectives = new TreeSet<SpoonPerspective>(new SpoonPerspectiveComparator());
    private XulDeck deck;
    private SpoonPerspective activePerspective;
    private XulDomContainer domContainer;
    private boolean forcePerspective = false;

    private SpoonPerspectiveManager() {
    }

    public static SpoonPerspectiveManager getInstance() {
        return instance;
    }

    public void setDeck(XulDeck deck) {
        this.deck = deck;
    }

    public void setXulDoc(XulDomContainer doc) {
        this.domContainer = doc;
    }

    public void addPerspective(SpoonPerspective perspective) {
        if (this.activePerspective == null) {
            this.activePerspective = perspective;
        }
        this.perspectives.put(perspective.getClass(), perspective);
        this.orderedPerspectives.add(perspective);
    }

    public List<SpoonPerspective> getPerspectives() {
        return Collections.unmodifiableList(new ArrayList<SpoonPerspective>(this.orderedPerspectives));
    }

    private void unloadPerspective(SpoonPerspective per) {
        per.setActive(false);
        List<XulOverlay> overlays = per.getOverlays();
        if (overlays != null) {
            for (XulOverlay overlay : overlays) {
                try {
                    this.domContainer.removeOverlay(overlay.getOverlayUri());
                }
                catch (XulException e) {
                    e.printStackTrace();
                }
            }
        }
        Spoon.getInstance().enableMenus();
    }

    public void activatePerspective(Class<? extends SpoonPerspective> clazz) throws KettleException {
        List<XulEventHandler> theXulEventHandlers;
        if (this.forcePerspective) {
            return;
        }
        SpoonPerspective sp = this.perspectives.get(clazz);
        if (sp == null) {
            throw new KettleException("Could not locate perspective by class: " + clazz);
        }
        this.unloadPerspective(this.activePerspective);
        this.activePerspective = sp;
        List<XulOverlay> overlays = sp.getOverlays();
        if (overlays != null) {
            for (XulOverlay overlay : overlays) {
                try {
                    ResourceBundle res = null;
                    if (overlay.getResourceBundleUri() != null) {
                        try {
                            res = ResourceBundle.getBundle(overlay.getResourceBundleUri());
                        }
                        catch (MissingResourceException ignored) {}
                    } else {
                        try {
                            res = ResourceBundle.getBundle(overlay.getOverlayUri().replace(".xul", ".properties"));
                        }
                        catch (MissingResourceException ignored) {
                            // empty catch block
                        }
                    }
                    if (res == null) {
                        res = new XulSpoonResourceBundle(sp.getClass());
                    }
                    this.domContainer.loadOverlay(overlay.getOverlayUri(), (Object)res);
                }
                catch (XulException e) {
                    e.printStackTrace();
                }
            }
        }
        if ((theXulEventHandlers = sp.getEventHandlers()) != null) {
            for (XulEventHandler handler : theXulEventHandlers) {
                this.domContainer.addEventHandler(handler);
            }
        }
        sp.setActive(true);
        this.deck.setSelectedIndex(this.deck.getChildNodes().indexOf(this.deck.getElementById("perspective-" + sp.getId())));
        Spoon.getInstance().enableMenus();
    }

    public SpoonPerspective getActivePerspective() {
        return this.activePerspective;
    }

    public boolean isForcePerspective() {
        return this.forcePerspective;
    }

    public void setForcePerspective(boolean forcePerspective) {
        this.forcePerspective = forcePerspective;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SpoonPerspectiveComparator
    implements Comparator<SpoonPerspective> {
        private SpoonPerspectiveComparator() {
        }

        @Override
        public int compare(SpoonPerspective o1, SpoonPerspective o2) {
            return o1.getId().compareTo(o2.getId());
        }
    }
}

