/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.ObjectRevision;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.trans.step.StepStatus;
import org.pentaho.di.ui.core.ConstUI;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.EnterNumberDialog;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TreeMemory;
import org.pentaho.di.ui.core.widget.TreeUtil;
import org.pentaho.di.ui.spoon.ChangedWarningInterface;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.TabItemInterface;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.www.SlaveServerJobStatus;
import org.pentaho.di.www.SlaveServerStatus;
import org.pentaho.di.www.SlaveServerTransStatus;
import org.pentaho.di.www.WebResult;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class SpoonSlave
extends Composite
implements TabItemInterface {
    private static Class<?> PKG = Spoon.class;
    public static final long UPDATE_TIME_VIEW = 30000L;
    public static final String STRING_SLAVE_LOG_TREE_NAME = "SLAVE_LOG : ";
    private Shell shell;
    private Display display;
    private SlaveServer slaveServer;
    private Map<String, Integer> lastLineMap;
    private Map<String, String> loggingMap;
    private Spoon spoon;
    private ColumnInfo[] colinf;
    private Tree wTree;
    private Text wText;
    private Button wError;
    private Button wStart;
    private Button wPause;
    private Button wStop;
    private Button wRemove;
    private Button wSniff;
    private Button wRefresh;
    private FormData fdTree;
    private FormData fdText;
    private FormData fdSash;
    private boolean refreshBusy;
    private SlaveServerStatus slaveServerStatus;
    private Timer timer;
    private TimerTask timerTask;
    private TreeItem transParentItem;
    private TreeItem jobParentItem;
    private LogChannelInterface log;

    public SpoonSlave(Composite parent, int style, Spoon spoon, SlaveServer slaveServer) {
        super(parent, style);
        this.shell = parent.getShell();
        this.display = this.shell.getDisplay();
        this.spoon = spoon;
        this.slaveServer = slaveServer;
        this.log = spoon.getLog();
        this.lastLineMap = new HashMap<String, Integer>();
        this.loggingMap = new HashMap<String, String>();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.setLayout((Layout)formLayout);
        this.setVisible(true);
        spoon.props.setLook((Control)this);
        SashForm sash = new SashForm((Composite)this, 512);
        sash.setLayout((Layout)new FillLayout());
        this.colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"SpoonSlave.Column.Stepname", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"SpoonSlave.Column.Copynr", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"SpoonSlave.Column.Read", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"SpoonSlave.Column.Written", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"SpoonSlave.Column.Input", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"SpoonSlave.Column.Output", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"SpoonSlave.Column.Updated", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"SpoonSlave.Column.Rejected", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"SpoonSlave.Column.Errors", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"SpoonSlave.Column.Active", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"SpoonSlave.Column.Time", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"SpoonSlave.Column.Speed", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"SpoonSlave.Column.PriorityBufferSizes", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"SpoonSlave.Column.CarteObjectId", (String[])new String[0]), 1, false, true)};
        this.colinf[1].setAllignement(131072);
        this.colinf[2].setAllignement(131072);
        this.colinf[3].setAllignement(131072);
        this.colinf[4].setAllignement(131072);
        this.colinf[5].setAllignement(131072);
        this.colinf[6].setAllignement(131072);
        this.colinf[7].setAllignement(131072);
        this.colinf[8].setAllignement(131072);
        this.colinf[9].setAllignement(131072);
        this.colinf[10].setAllignement(131072);
        this.colinf[11].setAllignement(131072);
        this.colinf[12].setAllignement(131072);
        this.wTree = new Tree((Composite)sash, 772);
        this.wTree.setHeaderVisible(true);
        TreeMemory.addTreeListener(this.wTree, STRING_SLAVE_LOG_TREE_NAME + slaveServer.toString());
        Rectangle bounds = spoon.tabfolder.getSwtTabset().getBounds();
        for (int i = 0; i < this.colinf.length; ++i) {
            ColumnInfo columnInfo = this.colinf[i];
            TreeColumn treeColumn = new TreeColumn(this.wTree, columnInfo.getAllignement());
            treeColumn.setText(columnInfo.getName());
            treeColumn.setWidth(bounds.width / this.colinf.length);
        }
        this.transParentItem = new TreeItem(this.wTree, 0);
        this.transParentItem.setText(Spoon.STRING_TRANSFORMATIONS);
        this.transParentItem.setImage(GUIResource.getInstance().getImageTransGraph());
        this.jobParentItem = new TreeItem(this.wTree, 0);
        this.jobParentItem.setText(Spoon.STRING_JOBS);
        this.jobParentItem.setImage(GUIResource.getInstance().getImageJobGraph());
        this.wTree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SpoonSlave.this.enableButtons();
                SpoonSlave.this.treeItemSelected((TreeItem)event.item);
                ((TreeItem)event.item).setExpanded(true);
                SpoonSlave.this.showLog();
            }
        });
        this.wTree.addTreeListener(new TreeListener(){

            public void treeExpanded(TreeEvent event) {
                SpoonSlave.this.treeItemSelected((TreeItem)event.item);
                SpoonSlave.this.showLog();
            }

            public void treeCollapsed(TreeEvent arg0) {
            }
        });
        this.wText = new Text((Composite)sash, 2826);
        spoon.props.setLook((Control)this.wText);
        this.wText.setVisible(true);
        this.wRefresh = new Button((Composite)this, 8);
        this.wRefresh.setText(BaseMessages.getString(PKG, (String)"SpoonSlave.Button.Refresh", (String[])new String[0]));
        this.wRefresh.setEnabled(true);
        this.wRefresh.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpoonSlave.this.refreshViewAndLog();
            }
        });
        this.wError = new Button((Composite)this, 8);
        this.wError.setText(BaseMessages.getString(PKG, (String)"SpoonSlave.Button.ShowErrorLines", (String[])new String[0]));
        this.wError.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpoonSlave.this.showErrors();
            }
        });
        this.wSniff = new Button((Composite)this, 8);
        this.wSniff.setText(BaseMessages.getString(PKG, (String)"SpoonSlave.Button.Sniff", (String[])new String[0]));
        this.wSniff.setEnabled(false);
        this.wSniff.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpoonSlave.this.sniff();
            }
        });
        this.wStart = new Button((Composite)this, 8);
        this.wStart.setText(BaseMessages.getString(PKG, (String)"SpoonSlave.Button.Start", (String[])new String[0]));
        this.wStart.setEnabled(false);
        this.wStart.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpoonSlave.this.start();
            }
        });
        this.wPause = new Button((Composite)this, 8);
        this.wPause.setText(BaseMessages.getString(PKG, (String)"SpoonSlave.Button.Pause", (String[])new String[0]));
        this.wPause.setEnabled(false);
        this.wPause.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpoonSlave.this.pause();
            }
        });
        this.wStop = new Button((Composite)this, 8);
        this.wStop.setText(BaseMessages.getString(PKG, (String)"SpoonSlave.Button.Stop", (String[])new String[0]));
        this.wStop.setEnabled(false);
        this.wStop.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpoonSlave.this.stop();
            }
        });
        this.wRemove = new Button((Composite)this, 8);
        this.wRemove.setText(BaseMessages.getString(PKG, (String)"SpoonSlave.Button.Remove", (String[])new String[0]));
        this.wRemove.setEnabled(false);
        this.wRemove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SpoonSlave.this.remove();
            }
        });
        BaseStepDialog.positionBottomButtons(this, new Button[]{this.wRefresh, this.wSniff, this.wStart, this.wPause, this.wStop, this.wRemove, this.wError}, 4, null);
        this.fdTree = new FormData();
        this.fdTree.left = new FormAttachment(0, 0);
        this.fdTree.top = new FormAttachment(0, 0);
        this.fdTree.right = new FormAttachment(100, 0);
        this.fdTree.bottom = new FormAttachment(100, 0);
        this.wTree.setLayoutData((Object)this.fdTree);
        this.fdText = new FormData();
        this.fdText.left = new FormAttachment(0, 0);
        this.fdText.top = new FormAttachment(0, 0);
        this.fdText.right = new FormAttachment(100, 0);
        this.fdText.bottom = new FormAttachment(100, 0);
        this.wText.setLayoutData((Object)this.fdText);
        this.fdSash = new FormData();
        this.fdSash.left = new FormAttachment(0, 0);
        this.fdSash.top = new FormAttachment(0, 0);
        this.fdSash.right = new FormAttachment(100, 0);
        this.fdSash.bottom = new FormAttachment((Control)this.wRefresh, -5);
        sash.setLayoutData((Object)this.fdSash);
        this.pack();
        this.timer = new Timer("SpoonSlave: " + this.getMeta().getName());
        this.timerTask = new TimerTask(){

            public void run() {
                if (SpoonSlave.this.display != null && !SpoonSlave.this.display.isDisposed()) {
                    SpoonSlave.this.display.asyncExec(new Runnable(){

                        public void run() {
                            SpoonSlave.this.refreshViewAndLog();
                        }
                    });
                }
            }
        };
        this.timer.schedule(this.timerTask, 0L, 30000L);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                SpoonSlave.this.timer.cancel();
            }
        });
    }

    public void treeItemSelected(TreeItem item) {
        if (item.getData("transStatus") != null) {
            SlaveServerTransStatus transStatus = (SlaveServerTransStatus)item.getData("transStatus");
            try {
                Integer lastLine;
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Getting transformation status for [{0}] on server [{1}]", new Object[]{transStatus.getTransName(), this.slaveServer});
                }
                int lastLineNr = (lastLine = this.lastLineMap.get(transStatus.getId())) == null ? 0 : lastLine;
                SlaveServerTransStatus ts = this.slaveServer.getTransStatus(transStatus.getTransName(), transStatus.getId(), lastLineNr);
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Finished receiving transformation status for [{0}] from server [{1}]", new Object[]{transStatus.getTransName(), this.slaveServer});
                }
                List stepStatusList = ts.getStepStatusList();
                transStatus.setStepStatusList(stepStatusList);
                this.lastLineMap.put(transStatus.getId(), ts.getLastLoggingLineNr());
                String logging = this.loggingMap.get(transStatus.getId());
                logging = logging == null ? ts.getLoggingString() : new StringBuffer(logging).append(ts.getLoggingString()).toString();
                String[] lines = logging.split("\r\n|\r|\n");
                if (lines.length > PropsUI.getInstance().getMaxNrLinesInLog()) {
                    int offset = lines.length - PropsUI.getInstance().getMaxNrLinesInLog();
                    StringBuffer trimmedLog = new StringBuffer();
                    while (offset != lines.length) {
                        trimmedLog.append(lines[offset++] + '\n');
                    }
                    logging = trimmedLog.toString();
                }
                this.loggingMap.put(transStatus.getId(), logging);
                item.removeAll();
                for (int s = 0; s < stepStatusList.size(); ++s) {
                    StepStatus stepStatus = (StepStatus)stepStatusList.get(s);
                    TreeItem stepItem = new TreeItem(item, 0);
                    stepItem.setText(stepStatus.getSpoonSlaveLogFields());
                }
            }
            catch (Exception e) {
                transStatus.setErrorDescription("Unable to access transformation details : " + Const.CR + Const.getStackTracker((Throwable)e));
            }
        } else if (item.getData("jobStatus") != null) {
            SlaveServerJobStatus jobStatus = (SlaveServerJobStatus)item.getData("jobStatus");
            try {
                Integer lastLine;
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Getting job status for [{0}] on server [{1}]", new Object[]{jobStatus.getJobName(), this.slaveServer});
                }
                int lastLineNr = (lastLine = this.lastLineMap.get(jobStatus.getId())) == null ? 0 : lastLine;
                SlaveServerJobStatus ts = this.slaveServer.getJobStatus(jobStatus.getJobName(), jobStatus.getId(), lastLineNr);
                if (this.log.isDetailed()) {
                    this.log.logDetailed("Finished receiving job status for [{0}] from server [{1}]", new Object[]{jobStatus.getJobName(), this.slaveServer});
                }
                this.lastLineMap.put(jobStatus.getId(), ts.getLastLoggingLineNr());
                String logging = this.loggingMap.get(jobStatus.getId());
                logging = logging == null ? ts.getLoggingString() : new StringBuffer(logging).append(ts.getLoggingString()).toString();
                String[] lines = logging.split("\r\n|\r|\n");
                if (lines.length > PropsUI.getInstance().getMaxNrLinesInLog()) {
                    int offset = lines.length - PropsUI.getInstance().getMaxNrLinesInLog();
                    StringBuffer trimmedLog = new StringBuffer();
                    while (offset != lines.length) {
                        trimmedLog.append(lines[offset++] + '\n');
                    }
                    logging = trimmedLog.toString();
                }
                this.loggingMap.put(jobStatus.getId(), logging);
                Result result = ts.getResult();
                if (result != null) {
                    item.setText(2, "" + result.getNrLinesRead());
                    item.setText(3, "" + result.getNrLinesWritten());
                    item.setText(4, "" + result.getNrLinesInput());
                    item.setText(5, "" + result.getNrLinesOutput());
                    item.setText(6, "" + result.getNrLinesUpdated());
                    item.setText(7, "" + result.getNrLinesRejected());
                    item.setText(8, "" + result.getNrErrors());
                }
            }
            catch (Exception e) {
                jobStatus.setErrorDescription("Unable to access transformation details : " + Const.CR + Const.getStackTracker((Throwable)e));
            }
        }
    }

    protected void enableButtons() {
        TreeEntry treeEntry = this.getTreeEntry();
        boolean isTrans = treeEntry != null && treeEntry.isTransformation();
        boolean isJob = treeEntry != null && treeEntry.isJob();
        boolean hasId = treeEntry != null && !Const.isEmpty((String)treeEntry.id);
        boolean isRunning = treeEntry != null && treeEntry.isRunning();
        boolean isStopped = treeEntry != null && treeEntry.isStopped();
        boolean isFinished = treeEntry != null && treeEntry.isFinished();
        boolean isPaused = treeEntry != null && treeEntry.isPaused();
        boolean isWaiting = treeEntry != null && treeEntry.isWaiting();
        boolean isStep = treeEntry != null && treeEntry.length == 3;
        this.wStart.setEnabled(!(!isTrans && !isJob || !hasId || isRunning || !isFinished && !isStopped && !isWaiting));
        this.wPause.setEnabled(isTrans && hasId && (isRunning || isPaused));
        this.wStop.setEnabled(!(!isTrans && !isJob || !hasId || !isRunning && !isPaused));
        this.wRemove.setEnabled(!(!isTrans && !isJob || !hasId || !isFinished && !isStopped && !isWaiting));
        this.wSniff.setEnabled(isTrans && hasId && isRunning && isStep);
    }

    protected void refreshViewAndLog() {
        TreeItem treeItem;
        String[] selectionPath = null;
        if (this.wTree.getSelectionCount() == 1) {
            selectionPath = ConstUI.getTreeStrings(this.wTree.getSelection()[0]);
        }
        this.refreshView();
        if (selectionPath != null && (treeItem = TreeUtil.findTreeItem(this.wTree, selectionPath)) != null) {
            this.wTree.setSelection(treeItem);
            this.wTree.showItem(treeItem);
            this.treeItemSelected(treeItem);
            treeItem.setExpanded(true);
        }
        this.showLog();
    }

    public boolean canBeClosed() {
        this.spoon.tabfolder.setSelected(0);
        return true;
    }

    public void showLog() {
        String logging;
        String errorDescription;
        StringBuffer message;
        TreeEntry treeEntry = this.getTreeEntry();
        if (treeEntry == null) {
            return;
        }
        if (treeEntry.length <= 1) {
            return;
        }
        if (treeEntry.isTransformation()) {
            SlaveServerTransStatus transStatus = this.slaveServerStatus.findTransStatus(treeEntry.name, treeEntry.id);
            message = new StringBuffer();
            errorDescription = transStatus.getErrorDescription();
            if (!Const.isEmpty((String)errorDescription)) {
                message.append(errorDescription).append(Const.CR).append(Const.CR);
            }
            if (!Const.isEmpty((String)(logging = this.loggingMap.get(transStatus.getId())))) {
                message.append(logging).append(Const.CR);
            }
            this.wText.setText(message.toString());
            this.wText.setSelection(this.wText.getText().length());
            this.wText.showSelection();
        }
        if (treeEntry.isJob()) {
            SlaveServerJobStatus jobStatus = this.slaveServerStatus.findJobStatus(treeEntry.name, treeEntry.id);
            message = new StringBuffer();
            errorDescription = jobStatus.getErrorDescription();
            if (!Const.isEmpty((String)errorDescription)) {
                message.append(errorDescription).append(Const.CR).append(Const.CR);
            }
            if (!Const.isEmpty((String)(logging = this.loggingMap.get(jobStatus.getId())))) {
                message.append(logging).append(Const.CR);
            }
            this.wText.setText(message.toString());
            this.wText.setSelection(this.wText.getText().length());
            this.wText.showSelection();
        }
    }

    protected void start() {
        SlaveServerJobStatus jobStatus;
        EnterTextDialog dialog;
        WebResult webResult;
        SlaveServerTransStatus transStatus;
        TreeEntry treeEntry = this.getTreeEntry();
        if (treeEntry == null) {
            return;
        }
        if (treeEntry.isTransformation() && (transStatus = this.slaveServerStatus.findTransStatus(treeEntry.name, treeEntry.id)) != null && !transStatus.isRunning()) {
            try {
                webResult = this.slaveServer.startTransformation(treeEntry.name, transStatus.getId());
                if (!webResult.getResult().equalsIgnoreCase("OK")) {
                    dialog = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"SpoonSlave.ErrorStartingTrans.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SpoonSlave.ErrorStartingTrans.Message", (String[])new String[0]), webResult.getMessage());
                    dialog.setReadOnly();
                    dialog.open();
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SpoonSlave.ErrorStartingTrans.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SpoonSlave.ErrorStartingTrans.Message", (String[])new String[0]), e);
            }
        }
        if (treeEntry.isJob() && (jobStatus = this.slaveServerStatus.findJobStatus(treeEntry.name, treeEntry.id)) != null && !jobStatus.isRunning()) {
            try {
                webResult = this.slaveServer.startJob(treeEntry.name, jobStatus.getId());
                if (!webResult.getResult().equalsIgnoreCase("OK")) {
                    dialog = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"SpoonSlave.ErrorStartingJob.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SpoonSlave.ErrorStartingJob.Message", (String[])new String[0]), webResult.getMessage());
                    dialog.setReadOnly();
                    dialog.open();
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SpoonSlave.ErrorStartingJob.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SpoonSlave.ErrorStartingJob.Message", (String[])new String[0]), e);
            }
        }
    }

    private TreeEntry getTreeEntry() {
        TreeItem[] ti = this.wTree.getSelection();
        if (ti.length == 1) {
            TreeEntry treeEntry = new TreeEntry(ti[0]);
            if (treeEntry.length <= 1) {
                return null;
            }
            return treeEntry;
        }
        return null;
    }

    protected void stop() {
        SlaveServerJobStatus jobStatus;
        EnterTextDialog dialog;
        WebResult webResult;
        SlaveServerTransStatus transStatus;
        TreeEntry treeEntry = this.getTreeEntry();
        if (treeEntry == null) {
            return;
        }
        if (treeEntry.isTransformation() && (transStatus = this.slaveServerStatus.findTransStatus(treeEntry.name, treeEntry.id)) != null && (transStatus.isRunning() || transStatus.isPaused())) {
            try {
                webResult = this.slaveServer.stopTransformation(treeEntry.name, transStatus.getId());
                if (!webResult.getResult().equalsIgnoreCase("OK")) {
                    dialog = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"SpoonSlave.ErrorStoppingTrans.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SpoonSlave.ErrorStoppingTrans.Message", (String[])new String[0]), webResult.getMessage());
                    dialog.setReadOnly();
                    dialog.open();
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SpoonSlave.ErrorStoppingTrans.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SpoonSlave.ErrorStoppingTrans.Message", (String[])new String[0]), e);
            }
        }
        if (treeEntry.isJob() && (jobStatus = this.slaveServerStatus.findJobStatus(treeEntry.name, treeEntry.id)) != null && jobStatus.isRunning()) {
            try {
                webResult = this.slaveServer.stopJob(treeEntry.name, jobStatus.getId());
                if (!webResult.getResult().equalsIgnoreCase("OK")) {
                    dialog = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"SpoonSlave.ErrorStoppingJob.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SpoonSlave.ErrorStoppingJob.Message", (String[])new String[0]), webResult.getMessage());
                    dialog.setReadOnly();
                    dialog.open();
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SpoonSlave.ErrorStoppingJob.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SpoonSlave.ErrorStoppingJob.Message", (String[])new String[0]), e);
            }
        }
    }

    protected void remove() {
        SlaveServerTransStatus transStatus;
        TreeEntry treeEntry = this.getTreeEntry();
        if (treeEntry == null) {
            return;
        }
        if (treeEntry.isTransformation() && (transStatus = this.slaveServerStatus.findTransStatus(treeEntry.name, treeEntry.id)) != null && !transStatus.isRunning() && !transStatus.isPaused() && !transStatus.isStopped()) {
            try {
                WebResult webResult = this.slaveServer.removeTransformation(treeEntry.name, transStatus.getId());
                if (!webResult.getResult().equalsIgnoreCase("OK")) {
                    EnterTextDialog dialog = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"SpoonSlave.ErrorRemovingTrans.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SpoonSlave.ErrorRemovingTrans.Message", (String[])new String[0]), webResult.getMessage());
                    dialog.setReadOnly();
                    dialog.open();
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SpoonSlave.ErrorRemovingTrans.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SpoonSlave.ErrorRemovingTrans.Message", (String[])new String[0]), e);
            }
        }
    }

    protected void pause() {
        TreeEntry treeEntry = this.getTreeEntry();
        if (treeEntry == null) {
            return;
        }
        if (treeEntry.isTransformation()) {
            try {
                WebResult webResult = this.slaveServer.pauseResumeTransformation(treeEntry.name, treeEntry.id);
                if (!webResult.getResult().equalsIgnoreCase("OK")) {
                    EnterTextDialog dialog = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"SpoonSlave.ErrorPausingOrResumingTrans.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SpoonSlave.ErrorPausingOrResumingTrans.Message", (String[])new String[0]), webResult.getMessage());
                    dialog.setReadOnly();
                    dialog.open();
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SpoonSlave.ErrorPausingOrResumingTrans.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SpoonSlave.ErrorPausingOrResumingTrans.Message", (String[])new String[0]), e);
            }
        }
    }

    private synchronized void refreshView() {
        int i;
        if (this.wTree.isDisposed()) {
            return;
        }
        if (this.refreshBusy) {
            return;
        }
        this.refreshBusy = true;
        if (this.log.isDetailed()) {
            this.log.logDetailed("Refresh");
        }
        this.transParentItem.removeAll();
        this.jobParentItem.removeAll();
        try {
            this.slaveServerStatus = this.slaveServer.getStatus();
        }
        catch (Exception e) {
            this.slaveServerStatus = new SlaveServerStatus("Error contacting server");
            this.slaveServerStatus.setErrorDescription(Const.getStackTracker((Throwable)e));
            this.wText.setText(this.slaveServerStatus.getErrorDescription());
        }
        List transStatusList = this.slaveServerStatus.getTransStatusList();
        for (i = 0; i < transStatusList.size(); ++i) {
            SlaveServerTransStatus transStatus = (SlaveServerTransStatus)transStatusList.get(i);
            TreeItem transItem = new TreeItem(this.transParentItem, 0);
            transItem.setText(0, transStatus.getTransName());
            transItem.setText(9, transStatus.getStatusDescription());
            transItem.setText(13, Const.NVL((String)transStatus.getId(), (String)""));
            transItem.setImage(GUIResource.getInstance().getImageTransGraph());
            transItem.setData("transStatus", (Object)transStatus);
        }
        for (i = 0; i < this.slaveServerStatus.getJobStatusList().size(); ++i) {
            SlaveServerJobStatus jobStatus = (SlaveServerJobStatus)this.slaveServerStatus.getJobStatusList().get(i);
            TreeItem jobItem = new TreeItem(this.jobParentItem, 0);
            jobItem.setText(0, jobStatus.getJobName());
            jobItem.setText(9, jobStatus.getStatusDescription());
            jobItem.setText(13, Const.NVL((String)jobStatus.getId(), (String)""));
            jobItem.setImage(GUIResource.getInstance().getImageJobGraph());
            jobItem.setData("jobStatus", (Object)jobStatus);
        }
        TreeMemory.setExpandedFromMemory(this.wTree, STRING_SLAVE_LOG_TREE_NAME + this.slaveServer.toString());
        TreeUtil.setOptimalWidthOnColumns(this.wTree);
        this.refreshBusy = false;
    }

    public void showErrors() {
        String uLine;
        String line;
        int i;
        String all = this.wText.getText();
        ArrayList<String> err = new ArrayList<String>();
        int startpos = 0;
        int crlen = Const.CR.length();
        for (i = 0; i < all.length() - crlen; ++i) {
            if (!all.substring(i, i + crlen).equalsIgnoreCase(Const.CR)) continue;
            line = all.substring(startpos, i);
            uLine = line.toUpperCase();
            if (uLine.indexOf(BaseMessages.getString(PKG, (String)"TransLog.System.ERROR", (String[])new String[0])) >= 0 || uLine.indexOf(BaseMessages.getString(PKG, (String)"TransLog.System.EXCEPTION", (String[])new String[0])) >= 0 || uLine.indexOf("ERROR") >= 0 || uLine.indexOf("EXCEPTION") >= 0) {
                err.add(line);
            }
            startpos = i + crlen;
        }
        line = all.substring(startpos);
        uLine = line.toUpperCase();
        if (uLine.indexOf(BaseMessages.getString(PKG, (String)"TransLog.System.ERROR2", (String[])new String[0])) >= 0 || uLine.indexOf(BaseMessages.getString(PKG, (String)"TransLog.System.EXCEPTION2", (String[])new String[0])) >= 0 || uLine.indexOf("ERROR") >= 0 || uLine.indexOf("EXCEPTION") >= 0) {
            err.add(line);
        }
        if (err.size() > 0) {
            String[] err_lines = new String[err.size()];
            for (i = 0; i < err_lines.length; ++i) {
                err_lines[i] = (String)err.get(i);
            }
            EnterSelectionDialog esd = new EnterSelectionDialog(this.shell, err_lines, BaseMessages.getString(PKG, (String)"TransLog.Dialog.ErrorLines.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"TransLog.Dialog.ErrorLines.Message", (String[])new String[0]));
            line = esd.open();
        }
    }

    public String toString() {
        return Spoon.APP_NAME;
    }

    public Object getManagedObject() {
        return this.slaveServer;
    }

    public boolean hasContentChanged() {
        return false;
    }

    public boolean applyChanges() {
        return true;
    }

    public int showChangedWarning() {
        return 64;
    }

    public EngineMetaInterface getMeta() {
        return new EngineMetaInterface(){

            public void setModifiedUser(String user) {
            }

            public void setModifiedDate(Date date) {
            }

            public void setInternalKettleVariables() {
            }

            public void setObjectId(ObjectId id) {
            }

            public void setFilename(String filename) {
            }

            public void setCreatedUser(String createduser) {
            }

            public void setCreatedDate(Date date) {
            }

            public void saveSharedObjects() {
            }

            public void nameFromFilename() {
            }

            public String getXML() {
                return null;
            }

            public boolean canSave() {
                return true;
            }

            public String getName() {
                return SpoonSlave.this.slaveServer.getName();
            }

            public String getModifiedUser() {
                return null;
            }

            public Date getModifiedDate() {
                return null;
            }

            public String[] getFilterNames() {
                return null;
            }

            public String[] getFilterExtensions() {
                return null;
            }

            public String getFilename() {
                return null;
            }

            public String getFileType() {
                return null;
            }

            public RepositoryDirectoryInterface getRepositoryDirectory() {
                return null;
            }

            public String getDefaultExtension() {
                return null;
            }

            public String getCreatedUser() {
                return null;
            }

            public Date getCreatedDate() {
                return null;
            }

            public void clearChanged() {
            }

            public ObjectId getObjectId() {
                return null;
            }

            public RepositoryObjectType getRepositoryElementType() {
                return null;
            }

            public void setName(String name) {
            }

            public void setRepositoryDirectory(RepositoryDirectoryInterface repositoryDirectory) {
            }

            public String getDescription() {
                return null;
            }

            public void setDescription(String description) {
            }

            public ObjectRevision getObjectRevision() {
                return null;
            }

            public void setObjectRevision(ObjectRevision objectRevision) {
            }
        };
    }

    public void setControlStates() {
    }

    public boolean canHandleSave() {
        return false;
    }

    protected void sniff() {
        TreeItem[] ti = this.wTree.getSelection();
        if (ti.length == 1) {
            TreeItem treeItem = ti[0];
            String[] path = ConstUI.getTreeStrings(treeItem);
            if (path.length <= 2) {
                return;
            }
            String name = path[1];
            String step = path[2];
            String copy = treeItem.getText(1);
            EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, PropsUI.getInstance().getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"SpoonSlave.SniffSizeQuestion.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SpoonSlave.SniffSizeQuestion.Message", (String[])new String[0]));
            int lines = numberDialog.open();
            if (lines <= 0) {
                return;
            }
            EnterSelectionDialog selectionDialog = new EnterSelectionDialog(this.shell, new String[]{"input", "output"}, BaseMessages.getString(PKG, (String)"SpoonSlave.SniffTypeQuestion.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SpoonSlave.SniffTypeQuestion.Message", (String[])new String[0]));
            String type = selectionDialog.open(1);
            if (type == null) {
                return;
            }
            try {
                String xml = this.slaveServer.sniffStep(name, step, copy, lines, type);
                Document doc = XMLHandler.loadXMLString((String)xml);
                Node node = XMLHandler.getSubNode((Node)doc, (String)"step-sniff");
                Node metaNode = XMLHandler.getSubNode((Node)node, (String)"row-meta");
                RowMeta rowMeta = new RowMeta(metaNode);
                int nrRows = Const.toInt((String)XMLHandler.getTagValue((Node)node, (String)"nr_rows"), (int)0);
                ArrayList<Object[]> rowBuffer = new ArrayList<Object[]>();
                for (int i = 0; i < nrRows; ++i) {
                    Node dataNode = XMLHandler.getSubNodeByNr((Node)node, (String)"row-data", (int)i);
                    Object[] row = rowMeta.getRow(dataNode);
                    rowBuffer.add(row);
                }
                PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, (VariableSpace)new Variables(), 0, step, (RowMetaInterface)rowMeta, rowBuffer);
                prd.open();
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SpoonSlave.ErrorSniffingStep.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SpoonSlave.ErrorSniffingStep.Message", (String[])new String[0]), e);
            }
        }
    }

    public ChangedWarningInterface getChangedWarning() {
        return null;
    }

    private class TreeEntry {
        String itemType;
        String name;
        String status;
        String id;
        int length;

        public TreeEntry(TreeItem treeItem) {
            String[] path = ConstUI.getTreeStrings(treeItem);
            this.length = path.length;
            if (path.length > 0) {
                this.itemType = path[0];
            }
            if (path.length > 1) {
                this.name = path[1];
            }
            if (path.length == 3) {
                treeItem = treeItem.getParentItem();
            }
            this.status = treeItem.getText(9);
            this.id = treeItem.getText(13);
        }

        boolean isTransformation() {
            return this.itemType.equals(SpoonSlave.this.transParentItem.getText());
        }

        boolean isJob() {
            return this.itemType.equals(SpoonSlave.this.jobParentItem.getText());
        }

        boolean isRunning() {
            return "Running".equals(this.status);
        }

        boolean isStopped() {
            return "Stopped".equals(this.status);
        }

        boolean isFinished() {
            return "Finished".equals(this.status);
        }

        boolean isPaused() {
            return "Paused".equals(this.status);
        }

        boolean isWaiting() {
            return "Waiting".equals(this.status);
        }
    }
}

