/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon;

import java.util.Locale;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.graphics.Image;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.gui.OverwritePrompter;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.RepositoryElementInterface;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.spoon.FileListener;
import org.pentaho.di.ui.spoon.MainSpoonPerspective;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.SpoonPerspectiveManager;
import org.w3c.dom.Node;

public class TransFileListener
implements FileListener {
    private static Class<?> PKG = Spoon.class;

    public boolean open(Node transNode, String fname, boolean importfile) {
        final Spoon spoon = Spoon.getInstance();
        final PropsUI props = PropsUI.getInstance();
        try {
            TransMeta transMeta = new TransMeta();
            transMeta.loadXML(transNode, spoon.getRepository(), true, (VariableSpace)new Variables(), new OverwritePrompter(){

                public boolean overwritePrompt(String message, String rememberText, String rememberPropertyName) {
                    MessageDialogWithToggle.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
                    Object[] res = spoon.messageDialogWithToggle(BaseMessages.getString((Class)PKG, (String)"System.Button.Yes", (String[])new String[0]), null, message, 1, new String[]{BaseMessages.getString((Class)PKG, (String)"System.Button.Yes", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"System.Button.No", (String[])new String[0])}, 1, rememberText, !props.askAboutReplacingDatabaseConnections());
                    int idx = (Integer)res[0];
                    boolean toggleState = (Boolean)res[1];
                    props.setAskAboutReplacingDatabaseConnections(!toggleState);
                    return (idx & 0xFF) == 0;
                }
            });
            transMeta.setRepositoryDirectory(Spoon.getInstance().getDefaultSaveLocation((RepositoryElementInterface)transMeta));
            spoon.setTransMetaVariables(transMeta);
            spoon.getProperties().addLastFile("Trans", fname, null, false, null);
            spoon.addMenuLast();
            if (!importfile) {
                transMeta.clearChanged();
            }
            transMeta.setFilename(fname);
            spoon.addTransGraph(transMeta);
            spoon.sharedObjectsFileMap.put(transMeta.getSharedObjects().getFilename(), transMeta.getSharedObjects());
            SpoonPerspectiveManager.getInstance().activatePerspective(MainSpoonPerspective.class);
            spoon.refreshTree();
            return true;
        }
        catch (KettleException e) {
            Spoon.getInstance().hideSplash();
            new ErrorDialog(spoon.getShell(), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorOpening.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Dialog.ErrorOpening.Message", (String[])new String[0]) + fname, (Exception)((Object)e));
            return false;
        }
    }

    public boolean save(EngineMetaInterface meta, String fname, boolean export) {
        Spoon spoon = Spoon.getInstance();
        Object lmeta = export ? (TransMeta)((TransMeta)meta).realClone(false) : meta;
        return spoon.saveMeta((EngineMetaInterface)lmeta, fname);
    }

    public void syncMetaName(EngineMetaInterface meta, String name) {
        ((TransMeta)meta).setName(name);
    }

    public boolean accepts(String fileName) {
        if (fileName == null || fileName.indexOf(46) == -1) {
            return false;
        }
        String extension = fileName.substring(fileName.lastIndexOf(46) + 1);
        return extension.equals("ktr");
    }

    public boolean acceptsXml(String nodeName) {
        return nodeName.equals("transformation");
    }

    public String[] getFileTypeDisplayNames(Locale locale) {
        return new String[]{"Transformations", "XML"};
    }

    public String getRootNodeName() {
        return "transformation";
    }

    public String[] getSupportedExtensions() {
        return new String[]{"ktr", "xml"};
    }
}

