/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.delegates;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.MessageBox;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.EngineMetaInterface;
import org.pentaho.di.core.NotePadMeta;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.gui.Point;
import org.pentaho.di.core.gui.UndoInterface;
import org.pentaho.di.core.logging.DefaultLogLevel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.TransLogTable;
import org.pentaho.di.core.undo.TransAction;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransHopMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.cluster.TransSplitter;
import org.pentaho.di.trans.debug.StepDebugMeta;
import org.pentaho.di.trans.debug.TransDebugMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.TabMapEntry;
import org.pentaho.di.ui.spoon.delegates.SpoonDelegate;
import org.pentaho.di.ui.spoon.job.JobGraph;
import org.pentaho.di.ui.spoon.trans.TransGraph;
import org.pentaho.di.ui.trans.debug.TransDebugDialog;
import org.pentaho.di.ui.trans.dialog.TransExecutionConfigurationDialog;
import org.pentaho.xul.swt.tab.TabItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpoonTransformationDelegate
extends SpoonDelegate {
    private static Class<?> PKG = Spoon.class;
    private List<TransMeta> transformationMap = new ArrayList<TransMeta>();
    private Map<TransMeta, TransDebugMeta> transDebugMetaMap = new Hashtable<TransMeta, TransDebugMeta>();
    private Map<TransMeta, TransDebugMeta> transPreviewMetaMap = new Hashtable<TransMeta, TransDebugMeta>();

    public SpoonTransformationDelegate(Spoon spoon) {
        super(spoon);
    }

    public boolean addTransformation(TransMeta transMeta) {
        int index = this.transformationMap.indexOf(transMeta);
        if (index < 0) {
            this.transformationMap.add(transMeta);
            return true;
        }
        return false;
    }

    public synchronized void closeTransformation(TransMeta transMeta) {
        int index;
        TabMapEntry entry = this.spoon.delegates.tabs.findTabMapEntry(transMeta);
        if (entry != null) {
            this.spoon.delegates.tabs.removeTab(entry);
        }
        if ((index = this.transformationMap.indexOf(transMeta)) >= 0) {
            this.transformationMap.remove(index);
        }
        this.spoon.refreshTree();
        this.spoon.enableMenus();
    }

    public void addTransGraph(TransMeta transMeta) {
        boolean added = this.addTransformation(transMeta);
        if (added) {
            boolean showLocation = false;
            boolean addTab = true;
            String tabName = this.spoon.delegates.tabs.makeTabName((EngineMetaInterface)transMeta, showLocation);
            TabMapEntry tabEntry = this.spoon.delegates.tabs.findTabMapEntry(tabName, TabMapEntry.ObjectType.TRANSFORMATION_GRAPH);
            if (tabEntry != null) {
                showLocation = true;
                tabName = this.spoon.delegates.tabs.makeTabName((EngineMetaInterface)transMeta, showLocation);
                TabMapEntry exactSameEntry = this.spoon.delegates.tabs.findTabMapEntry(tabName, TabMapEntry.ObjectType.TRANSFORMATION_GRAPH);
                if (exactSameEntry != null) {
                    addTab = false;
                } else {
                    tabEntry.setShowingLocation(true);
                    String newTabName = this.spoon.delegates.tabs.makeTabName(tabEntry.getObject().getMeta(), showLocation);
                    tabEntry.getTabItem().setText(newTabName);
                }
            }
            if (addTab) {
                TransGraph transGraph = new TransGraph((Composite)this.spoon.tabfolder.getSwtTabset(), this.spoon, transMeta);
                TabItem tabItem = new TabItem(this.spoon.tabfolder, tabName, tabName);
                String toolTipText = BaseMessages.getString(PKG, (String)"Spoon.TabTrans.Tooltip", (String[])new String[]{this.spoon.delegates.tabs.makeTabName((EngineMetaInterface)transMeta, showLocation)});
                if (!Const.isEmpty((String)transMeta.getFilename())) {
                    toolTipText = toolTipText + Const.CR + Const.CR + transMeta.getFilename();
                }
                tabItem.setToolTipText(toolTipText);
                tabItem.setImage(GUIResource.getInstance().getImageTransGraph());
                tabItem.setControl((Control)transGraph);
                TransLogTable logTable = transMeta.getTransLogTable();
                if (logTable.getDatabaseMeta() != null && !Const.isEmpty((String)logTable.getTableName()) && !transMeta.isSlaveTransformation()) {
                    transGraph.addAllTabs();
                    transGraph.extraViewTabFolder.setSelection(transGraph.transHistoryDelegate.getTransHistoryTab());
                }
                String versionLabel = transMeta.getObjectRevision() == null ? null : transMeta.getObjectRevision().getName();
                tabEntry = new TabMapEntry(tabItem, transMeta.getFilename(), transMeta.getName(), transMeta.getRepositoryDirectory(), versionLabel, transGraph, TabMapEntry.ObjectType.TRANSFORMATION_GRAPH);
                tabEntry.setShowingLocation(showLocation);
                this.spoon.delegates.tabs.addTab(tabEntry);
            }
            int idx = this.spoon.tabfolder.indexOf(tabEntry.getTabItem());
            this.spoon.tabfolder.setSelected(idx);
            this.spoon.setUndoMenu((UndoInterface)transMeta);
            this.spoon.enableMenus();
        } else {
            TabMapEntry tabEntry = this.spoon.delegates.tabs.findTabMapEntry(transMeta);
            if (tabEntry != null) {
                int idx = this.spoon.tabfolder.indexOf(tabEntry.getTabItem());
                this.spoon.tabfolder.setSelected(idx);
                this.spoon.setUndoMenu((UndoInterface)transMeta);
                this.spoon.enableMenus();
            }
        }
    }

    public void tabSelected(TabItem item) {
        List<TabMapEntry> collection = this.spoon.delegates.tabs.getTabs();
        for (TabMapEntry entry : collection) {
            if (!item.equals(entry.getTabItem()) || !(entry.getObject() instanceof TransGraph) && !(entry.getObject() instanceof JobGraph)) continue;
            EngineMetaInterface meta = entry.getObject().getMeta();
            if (meta != null) {
                meta.setInternalKettleVariables();
            }
            if (this.spoon.getCoreObjectsState() == 3) continue;
            this.spoon.refreshCoreObjects();
        }
        this.spoon.refreshTree();
        this.spoon.enableMenus();
    }

    public List<TransMeta> getTransformationList() {
        return this.transformationMap;
    }

    public TransMeta getTransformation(String name) {
        TabMapEntry entry = this.spoon.delegates.tabs.findTabMapEntry(name, TabMapEntry.ObjectType.TRANSFORMATION_GRAPH);
        if (entry != null) {
            return (TransMeta)entry.getObject().getManagedObject();
        }
        for (TransMeta xform : this.transformationMap) {
            if (name == null || !name.equals(xform.getName())) continue;
            return xform;
        }
        return null;
    }

    public void removeTransformation(TransMeta transMeta) {
        this.transformationMap.remove(transMeta);
    }

    public TransMeta[] getLoadedTransformations() {
        return this.transformationMap.toArray(new TransMeta[this.transformationMap.size()]);
    }

    public TransGraph findTransGraphOfTransformation(TransMeta transMeta) {
        for (TabMapEntry mapEntry : this.spoon.delegates.tabs.getTabs()) {
            TransGraph transGraph;
            if (!(mapEntry.getObject() instanceof TransGraph) || !(transGraph = (TransGraph)mapEntry.getObject()).getMeta().equals(transMeta)) continue;
            return transGraph;
        }
        return null;
    }

    public boolean isDefaultTransformationName(String name) {
        if (!name.startsWith(Spoon.STRING_TRANSFORMATION)) {
            return false;
        }
        for (int i = Spoon.STRING_TRANSFORMATION.length() + 1; i < name.length(); ++i) {
            if (Character.isDigit(name.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public void undoTransformationAction(TransMeta transMeta, TransAction transAction) {
        switch (transAction.getType()) {
            case 5: {
                for (int i = transAction.getCurrent().length - 1; i >= 0; --i) {
                    int idx = transAction.getCurrentIndex()[i];
                    transMeta.removeStep(idx);
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 6: {
                for (int i = transAction.getCurrent().length - 1; i >= 0; --i) {
                    int idx = transAction.getCurrentIndex()[i];
                    transMeta.removeDatabase(idx);
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 8: {
                for (int i = transAction.getCurrent().length - 1; i >= 0; --i) {
                    int idx = transAction.getCurrentIndex()[i];
                    transMeta.removeNote(idx);
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 7: {
                for (int i = transAction.getCurrent().length - 1; i >= 0; --i) {
                    int idx = transAction.getCurrentIndex()[i];
                    transMeta.removeTransHop(idx);
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 33: {
                for (int i = transAction.getCurrent().length - 1; i >= 0; --i) {
                    int idx = transAction.getCurrentIndex()[i];
                    transMeta.getSlaveServers().remove(idx);
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 36: {
                for (int i = transAction.getCurrent().length - 1; i >= 0; --i) {
                    int idx = transAction.getCurrentIndex()[i];
                    transMeta.getClusterSchemas().remove(idx);
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 9: {
                for (int i = 0; i < transAction.getCurrent().length; ++i) {
                    StepMeta stepMeta = (StepMeta)transAction.getCurrent()[i];
                    int idx = transAction.getCurrentIndex()[i];
                    transMeta.addStep(idx, stepMeta);
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 10: {
                for (int i = 0; i < transAction.getCurrent().length; ++i) {
                    DatabaseMeta ci = (DatabaseMeta)transAction.getCurrent()[i];
                    int idx = transAction.getCurrentIndex()[i];
                    transMeta.addDatabase(idx, ci);
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 12: {
                for (int i = 0; i < transAction.getCurrent().length; ++i) {
                    NotePadMeta ni = (NotePadMeta)transAction.getCurrent()[i];
                    int idx = transAction.getCurrentIndex()[i];
                    transMeta.addNote(idx, ni);
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 11: {
                for (int i = 0; i < transAction.getCurrent().length; ++i) {
                    TransHopMeta hi = (TransHopMeta)transAction.getCurrent()[i];
                    int idx = transAction.getCurrentIndex()[i];
                    StepMeta from = transMeta.findStep(hi.getFromStep().getName());
                    StepMeta to = transMeta.findStep(hi.getToStep().getName());
                    TransHopMeta hinew = new TransHopMeta(from, to);
                    transMeta.addTransHop(idx, hinew);
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 1: {
                for (int i = 0; i < transAction.getCurrent().length; ++i) {
                    StepMeta prev = (StepMeta)((StepMeta)transAction.getPrevious()[i]).clone();
                    int idx = transAction.getCurrentIndex()[i];
                    transMeta.getStep(idx).replaceMeta(prev);
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 2: {
                for (int i = 0; i < transAction.getCurrent().length; ++i) {
                    DatabaseMeta prev = (DatabaseMeta)transAction.getPrevious()[i];
                    int idx = transAction.getCurrentIndex()[i];
                    transMeta.getDatabase(idx).replaceMeta((DatabaseMeta)prev.clone());
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 4: {
                for (int i = 0; i < transAction.getCurrent().length; ++i) {
                    int idx = transAction.getCurrentIndex()[i];
                    transMeta.removeNote(idx);
                    NotePadMeta prev = (NotePadMeta)transAction.getPrevious()[i];
                    transMeta.addNote(idx, (NotePadMeta)prev.clone());
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 3: {
                for (int i = 0; i < transAction.getCurrent().length; ++i) {
                    TransHopMeta prev = (TransHopMeta)transAction.getPrevious()[i];
                    int idx = transAction.getCurrentIndex()[i];
                    transMeta.removeTransHop(idx);
                    transMeta.addTransHop(idx, (TransHopMeta)prev.clone());
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 13: {
                for (int i = 0; i < transAction.getCurrentIndex().length; ++i) {
                    StepMeta stepMeta = transMeta.getStep(transAction.getCurrentIndex()[i]);
                    stepMeta.setLocation(transAction.getPreviousLocation()[i]);
                }
                this.spoon.refreshGraph();
                break;
            }
            case 14: {
                for (int i = 0; i < transAction.getCurrentIndex().length; ++i) {
                    int idx = transAction.getCurrentIndex()[i];
                    NotePadMeta npi = transMeta.getNote(idx);
                    Point prev = transAction.getPreviousLocation()[i];
                    npi.setLocation(prev);
                }
                this.spoon.refreshGraph();
                break;
            }
        }
        if (transMeta.viewNextUndo() != null && transMeta.viewNextUndo().getNextAlso()) {
            this.spoon.undoAction((UndoInterface)transMeta);
        }
    }

    public void redoTransformationAction(TransMeta transMeta, TransAction transAction) {
        switch (transAction.getType()) {
            case 5: {
                for (int i = 0; i < transAction.getCurrent().length; ++i) {
                    StepMeta stepMeta = (StepMeta)transAction.getCurrent()[i];
                    int idx = transAction.getCurrentIndex()[i];
                    transMeta.addStep(idx, stepMeta);
                    this.spoon.refreshTree();
                    this.spoon.refreshGraph();
                }
                break;
            }
            case 6: {
                for (int i = 0; i < transAction.getCurrent().length; ++i) {
                    DatabaseMeta ci = (DatabaseMeta)transAction.getCurrent()[i];
                    int idx = transAction.getCurrentIndex()[i];
                    transMeta.addDatabase(idx, ci);
                    this.spoon.refreshTree();
                    this.spoon.refreshGraph();
                }
                break;
            }
            case 8: {
                for (int i = 0; i < transAction.getCurrent().length; ++i) {
                    NotePadMeta ni = (NotePadMeta)transAction.getCurrent()[i];
                    int idx = transAction.getCurrentIndex()[i];
                    transMeta.addNote(idx, ni);
                    this.spoon.refreshTree();
                    this.spoon.refreshGraph();
                }
                break;
            }
            case 7: {
                for (int i = 0; i < transAction.getCurrent().length; ++i) {
                    TransHopMeta hi = (TransHopMeta)transAction.getCurrent()[i];
                    int idx = transAction.getCurrentIndex()[i];
                    transMeta.addTransHop(idx, hi);
                    this.spoon.refreshTree();
                    this.spoon.refreshGraph();
                }
                break;
            }
            case 9: {
                for (int i = transAction.getCurrent().length - 1; i >= 0; --i) {
                    int idx = transAction.getCurrentIndex()[i];
                    transMeta.removeStep(idx);
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 10: {
                for (int i = transAction.getCurrent().length - 1; i >= 0; --i) {
                    int idx = transAction.getCurrentIndex()[i];
                    transMeta.removeDatabase(idx);
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 12: {
                for (int i = transAction.getCurrent().length - 1; i >= 0; --i) {
                    int idx = transAction.getCurrentIndex()[i];
                    transMeta.removeNote(idx);
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 11: {
                for (int i = transAction.getCurrent().length - 1; i >= 0; --i) {
                    int idx = transAction.getCurrentIndex()[i];
                    transMeta.removeTransHop(idx);
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 1: {
                for (int i = 0; i < transAction.getCurrent().length; ++i) {
                    StepMeta stepMeta = (StepMeta)((StepMeta)transAction.getCurrent()[i]).clone();
                    transMeta.getStep(transAction.getCurrentIndex()[i]).replaceMeta(stepMeta);
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 2: {
                for (int i = 0; i < transAction.getCurrent().length; ++i) {
                    DatabaseMeta databaseMeta = (DatabaseMeta)transAction.getCurrent()[i];
                    int idx = transAction.getCurrentIndex()[i];
                    transMeta.getDatabase(idx).replaceMeta((DatabaseMeta)databaseMeta.clone());
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 4: {
                for (int i = 0; i < transAction.getCurrent().length; ++i) {
                    NotePadMeta ni = (NotePadMeta)transAction.getCurrent()[i];
                    int idx = transAction.getCurrentIndex()[i];
                    transMeta.removeNote(idx);
                    transMeta.addNote(idx, (NotePadMeta)ni.clone());
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 3: {
                for (int i = 0; i < transAction.getCurrent().length; ++i) {
                    TransHopMeta hi = (TransHopMeta)transAction.getCurrent()[i];
                    int idx = transAction.getCurrentIndex()[i];
                    transMeta.removeTransHop(idx);
                    transMeta.addTransHop(idx, (TransHopMeta)hi.clone());
                }
                this.spoon.refreshTree();
                this.spoon.refreshGraph();
                break;
            }
            case 13: {
                for (int i = 0; i < transAction.getCurrentIndex().length; ++i) {
                    StepMeta stepMeta = transMeta.getStep(transAction.getCurrentIndex()[i]);
                    stepMeta.setLocation(transAction.getCurrentLocation()[i]);
                }
                this.spoon.refreshGraph();
                break;
            }
            case 14: {
                for (int i = 0; i < transAction.getCurrentIndex().length; ++i) {
                    int idx = transAction.getCurrentIndex()[i];
                    NotePadMeta npi = transMeta.getNote(idx);
                    Point curr = transAction.getCurrentLocation()[i];
                    npi.setLocation(curr);
                }
                this.spoon.refreshGraph();
                break;
            }
        }
        if (transMeta.viewNextUndo() != null && transMeta.viewNextUndo().getNextAlso()) {
            this.spoon.redoAction((UndoInterface)transMeta);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void executeTransformation(TransMeta transMeta, boolean local, boolean remote, boolean cluster, boolean preview, boolean debug, Date replayDate, boolean safe) throws KettleException {
        StepDebugMeta stepDebugMeta;
        List selectedSteps;
        if (transMeta == null) {
            return;
        }
        TransDebugMeta transDebugMeta = null;
        TransExecutionConfiguration executionConfiguration = null;
        executionConfiguration = preview ? this.spoon.getTransPreviewExecutionConfiguration() : (debug ? this.spoon.getTransDebugExecutionConfiguration() : this.spoon.getTransExecutionConfiguration());
        if (debug) {
            transDebugMeta = this.transDebugMetaMap.get(transMeta);
            if (transDebugMeta == null) {
                transDebugMeta = new TransDebugMeta(transMeta);
                this.transDebugMetaMap.put(transMeta, transDebugMeta);
            }
            if ((selectedSteps = transMeta.getSelectedSteps()) != null && selectedSteps.size() > 0) {
                transDebugMeta.getStepDebugMetaMap().clear();
                for (StepMeta stepMeta : transMeta.getSelectedSteps()) {
                    stepDebugMeta = new StepDebugMeta(stepMeta);
                    stepDebugMeta.setRowCount(PropsUI.getInstance().getDefaultPreviewSize());
                    stepDebugMeta.setPausingOnBreakPoint(true);
                    stepDebugMeta.setReadingFirstRows(false);
                    transDebugMeta.getStepDebugMetaMap().put(stepMeta, stepDebugMeta);
                }
            }
        } else if (preview) {
            transDebugMeta = this.transPreviewMetaMap.get(transMeta);
            if (transDebugMeta == null) {
                transDebugMeta = new TransDebugMeta(transMeta);
                this.transPreviewMetaMap.put(transMeta, transDebugMeta);
            }
            if ((selectedSteps = transMeta.getSelectedSteps()) != null && selectedSteps.size() > 0) {
                transDebugMeta.getStepDebugMetaMap().clear();
                for (StepMeta stepMeta : transMeta.getSelectedSteps()) {
                    stepDebugMeta = new StepDebugMeta(stepMeta);
                    stepDebugMeta.setRowCount(PropsUI.getInstance().getDefaultPreviewSize());
                    stepDebugMeta.setPausingOnBreakPoint(false);
                    stepDebugMeta.setReadingFirstRows(true);
                    transDebugMeta.getStepDebugMetaMap().put(stepMeta, stepDebugMeta);
                }
            }
        }
        executionConfiguration.setRepository(this.spoon.rep);
        executionConfiguration.setSafeModeEnabled(safe);
        int debugAnswer = 2;
        if (debug || preview) {
            transDebugMeta.getTransMeta().setRepository(this.spoon.rep);
            TransDebugDialog transDebugDialog = new TransDebugDialog(this.spoon.getShell(), transDebugMeta);
            debugAnswer = transDebugDialog.open();
            if (debugAnswer == 0) return;
            executionConfiguration.setExecutingLocally(true);
            executionConfiguration.setExecutingRemotely(false);
            executionConfiguration.setExecutingClustered(false);
        } else if (transMeta.findFirstUsedClusterSchema() != null) {
            executionConfiguration.setExecutingLocally(false);
            executionConfiguration.setExecutingRemotely(false);
            executionConfiguration.setExecutingClustered(true);
        } else {
            executionConfiguration.setExecutingLocally(true);
            executionConfiguration.setExecutingRemotely(false);
            executionConfiguration.setExecutingClustered(false);
        }
        Object[] data = this.spoon.variables.getData();
        String[] fields = this.spoon.variables.getRowMeta().getFieldNames();
        HashMap<String, String> variableMap = new HashMap<String, String>();
        variableMap.putAll(executionConfiguration.getVariables());
        for (int idx = 0; idx < fields.length; ++idx) {
            String value = (String)executionConfiguration.getVariables().get(fields[idx]);
            if (Const.isEmpty((String)value)) {
                value = data[idx].toString();
            }
            variableMap.put(fields[idx], value);
        }
        executionConfiguration.setVariables(variableMap);
        executionConfiguration.getUsedVariables(transMeta);
        executionConfiguration.getUsedArguments(transMeta, this.spoon.getArguments());
        executionConfiguration.setReplayDate(replayDate);
        executionConfiguration.setLogLevel(DefaultLogLevel.getLogLevel());
        boolean execConfigAnswer = true;
        if (debugAnswer == 2 && replayDate == null) {
            TransExecutionConfigurationDialog dialog = new TransExecutionConfigurationDialog(this.spoon.getShell(), executionConfiguration, transMeta);
            execConfigAnswer = dialog.open();
        }
        if (!execConfigAnswer) return;
        if ((debug || preview) && transDebugMeta.getNrOfUsedSteps() == 0) {
            MessageBox box = new MessageBox(this.spoon.getShell(), 200);
            box.setText(BaseMessages.getString(PKG, (String)"Spoon.Dialog.Warning.NoPreviewOrDebugSteps.Title", (String[])new String[0]));
            box.setMessage(BaseMessages.getString(PKG, (String)"Spoon.Dialog.Warning.NoPreviewOrDebugSteps.Message", (String[])new String[0]));
            int answer = box.open();
            if (answer != 64) {
                return;
            }
        }
        TransGraph activeTransGraph = this.spoon.getActiveTransGraph();
        if (executionConfiguration.isExecutingLocally()) {
            if (debug || preview) {
                activeTransGraph.debug(executionConfiguration, transDebugMeta);
                return;
            } else {
                activeTransGraph.start(executionConfiguration);
            }
            return;
        } else if (executionConfiguration.isExecutingRemotely()) {
            if (executionConfiguration.getRemoteServer() != null) {
                String carteObjectId = Trans.sendToSlaveServer((TransMeta)transMeta, (TransExecutionConfiguration)executionConfiguration, (Repository)this.spoon.rep);
                this.monitorRemoteTrans(transMeta, carteObjectId, executionConfiguration.getRemoteServer());
                this.spoon.delegates.slaves.addSpoonSlave(executionConfiguration.getRemoteServer());
                return;
            } else {
                MessageBox mb = new MessageBox(this.spoon.getShell(), 34);
                mb.setMessage(BaseMessages.getString(PKG, (String)"Spoon.Dialog.NoRemoteServerSpecified.Message", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"Spoon.Dialog.NoRemoteServerSpecified.Title", (String[])new String[0]));
                mb.open();
            }
            return;
        } else {
            if (!executionConfiguration.isExecutingClustered()) return;
            activeTransGraph.handleTransMetaChanges(transMeta);
            this.splitTrans(transMeta, executionConfiguration);
        }
    }

    private void monitorRemoteTrans(final TransMeta transMeta, final String carteObjectId, final SlaveServer remoteSlaveServer) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                Trans.monitorRemoteTransformation((LogChannelInterface)SpoonTransformationDelegate.this.spoon.getLog(), (String)carteObjectId, (String)transMeta.toString(), (SlaveServer)remoteSlaveServer);
            }
        });
        thread.setName("Monitor remote transformation '" + transMeta.getName() + "', carte object id=" + carteObjectId + ", slave server: " + remoteSlaveServer.getName());
        thread.start();
    }

    protected void splitTrans(final TransMeta transMeta, TransExecutionConfiguration executionConfiguration) throws KettleException {
        try {
            final TransSplitter transSplitter = new TransSplitter(transMeta);
            transSplitter.splitOriginalTransformation();
            TransMeta master = transSplitter.getMaster();
            SlaveServer masterServer = null;
            List masterSteps = master.getTransHopSteps(false);
            SlaveServer[] slaves = transSplitter.getSlaveTargets();
            if (executionConfiguration.isClusterShowingTransformation()) {
                if (masterSteps.size() > 0) {
                    masterServer = transSplitter.getMasterServer();
                    this.addTransGraph(master);
                }
                for (int i = 0; i < slaves.length; ++i) {
                    TransMeta slaveTrans = (TransMeta)transSplitter.getSlaveTransMap().get(slaves[i]);
                    this.addTransGraph(slaveTrans);
                }
            }
            for (String var : Const.INTERNAL_TRANS_VARIABLES) {
                executionConfiguration.getVariables().put(var, transMeta.getVariable(var));
            }
            for (String var : Const.INTERNAL_JOB_VARIABLES) {
                executionConfiguration.getVariables().put(var, transMeta.getVariable(var));
            }
            TransMeta ot = transSplitter.getOriginalTransformation();
            for (String param : ot.listParameters()) {
                String value = Const.NVL((String)ot.getParameterValue(param), (String)Const.NVL((String)ot.getParameterDefault(param), (String)ot.getVariable(param)));
                if (Const.isEmpty((String)value)) continue;
                executionConfiguration.getVariables().put(param, value);
            }
            try {
                Trans.executeClustered((TransSplitter)transSplitter, (TransExecutionConfiguration)executionConfiguration);
            }
            catch (Exception e) {
                Trans.cleanupCluster((LogChannelInterface)this.log, (TransSplitter)transSplitter);
                throw e;
            }
            if (executionConfiguration.isClusterPosting() && masterServer != null) {
                this.spoon.addSpoonSlave(masterServer);
                for (int i = 0; i < slaves.length; ++i) {
                    this.spoon.addSpoonSlave(slaves[i]);
                }
            }
            new Thread(new Runnable(){

                public void run() {
                    Trans.monitorClusteredTransformation((LogChannelInterface)SpoonTransformationDelegate.this.log, (TransSplitter)transSplitter, null);
                    Result result = Trans.getClusteredTransformationResult((LogChannelInterface)SpoonTransformationDelegate.this.log, (TransSplitter)transSplitter, null);
                    SpoonTransformationDelegate.this.log.logBasic("-----------------------------------------------------");
                    SpoonTransformationDelegate.this.log.logBasic("Got result back from clustered transformation:");
                    SpoonTransformationDelegate.this.log.logBasic(transMeta.toString(), new Object[]{"-----------------------------------------------------"});
                    SpoonTransformationDelegate.this.log.logBasic(transMeta.toString(), new Object[]{"Errors : " + result.getNrErrors()});
                    SpoonTransformationDelegate.this.log.logBasic(transMeta.toString(), new Object[]{"Input : " + result.getNrLinesInput()});
                    SpoonTransformationDelegate.this.log.logBasic(transMeta.toString(), new Object[]{"Output : " + result.getNrLinesOutput()});
                    SpoonTransformationDelegate.this.log.logBasic(transMeta.toString(), new Object[]{"Updated : " + result.getNrLinesUpdated()});
                    SpoonTransformationDelegate.this.log.logBasic(transMeta.toString(), new Object[]{"Read : " + result.getNrLinesRead()});
                    SpoonTransformationDelegate.this.log.logBasic(transMeta.toString(), new Object[]{"Written : " + result.getNrLinesWritten()});
                    SpoonTransformationDelegate.this.log.logBasic(transMeta.toString(), new Object[]{"Rejected : " + result.getNrLinesRejected()});
                    SpoonTransformationDelegate.this.log.logBasic(transMeta.toString(), new Object[]{"-----------------------------------------------------"});
                }
            }).start();
        }
        catch (Exception e) {
            throw new KettleException((Throwable)e);
        }
    }
}

