/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.dialog;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.ProgressMonitorAdapter;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.DatabaseImpact;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnalyseImpactProgressDialog {
    private static Class<?> PKG = AnalyseImpactProgressDialog.class;
    private Shell shell;
    private TransMeta transMeta;
    private List<DatabaseImpact> impact;
    private boolean impactHasRun;

    public AnalyseImpactProgressDialog(Shell shell, TransMeta transMeta, List<DatabaseImpact> impact) {
        this.shell = shell;
        this.transMeta = transMeta;
        this.impact = impact;
    }

    public boolean open() {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    AnalyseImpactProgressDialog.this.impact.clear();
                    AnalyseImpactProgressDialog.this.transMeta.analyseImpact(AnalyseImpactProgressDialog.this.impact, (ProgressMonitorListener)new ProgressMonitorAdapter(monitor));
                    AnalyseImpactProgressDialog.this.impactHasRun = true;
                }
                catch (Exception e) {
                    AnalyseImpactProgressDialog.this.impact.clear();
                    AnalyseImpactProgressDialog.this.impactHasRun = false;
                    throw new InvocationTargetException(e, BaseMessages.getString((Class)PKG, (String)"AnalyseImpactProgressDialog.RuntimeError.UnableToAnalyzeImpact.Exception", (String[])new String[]{e.toString()}));
                }
            }
        };
        try {
            ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.shell);
            pmd.run(true, true, op);
        }
        catch (InvocationTargetException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"AnalyseImpactProgressDialog.Dialog.UnableToAnalyzeImpact.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"AnalyseImpactProgressDialog.Dialog.UnableToAnalyzeImpact.Messages", (String[])new String[0]), e);
        }
        catch (InterruptedException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"AnalyseImpactProgressDialog.Dialog.UnableToAnalyzeImpact.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"AnalyseImpactProgressDialog.Dialog.UnableToAnalyzeImpact.Messages", (String[])new String[0]), e);
        }
        return this.impactHasRun;
    }
}

