/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.dialog;

import java.lang.reflect.InvocationTargetException;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Shell;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.ProgressMonitorAdapter;
import org.pentaho.di.core.ProgressMonitorListener;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CheckTransProgressDialog {
    private static Class<?> PKG = CheckTransProgressDialog.class;
    private Shell shell;
    private TransMeta transMeta;
    private List<CheckResultInterface> remarks;
    private boolean onlySelected;

    public CheckTransProgressDialog(Shell shell, TransMeta transMeta, List<CheckResultInterface> remarks, boolean onlySelected) {
        this.shell = shell;
        this.transMeta = transMeta;
        this.onlySelected = onlySelected;
        this.remarks = remarks;
    }

    public void open() {
        final ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.shell);
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                try {
                    CheckTransProgressDialog.this.transMeta.checkSteps(CheckTransProgressDialog.this.remarks, CheckTransProgressDialog.this.onlySelected, (ProgressMonitorListener)new ProgressMonitorAdapter(monitor));
                }
                catch (Exception e) {
                    throw new InvocationTargetException(e, BaseMessages.getString((Class)PKG, (String)"AnalyseImpactProgressDialog.RuntimeError.ErrorCheckingTransformation.Exception", (String[])new String[]{e.toString()}));
                }
            }
        };
        try {
            Runnable run = new Runnable(){

                public void run() {
                    IProgressMonitor monitor = pmd.getProgressMonitor();
                    while (pmd.getShell() == null || !pmd.getShell().isDisposed() && !monitor.isCanceled()) {
                        try {
                            Thread.sleep(250L);
                        }
                        catch (InterruptedException e) {}
                    }
                    if (monitor.isCanceled()) {
                        try {
                            CheckTransProgressDialog.this.transMeta.cancelQueries();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
            };
            new Thread(run).start();
            pmd.run(true, true, op);
        }
        catch (InvocationTargetException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"CheckTransProgressDialog.Dialog.ErrorCheckingTransformation.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CheckTransProgressDialog.Dialog.ErrorCheckingTransformation.Message", (String[])new String[0]), e);
        }
        catch (InterruptedException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"CheckTransProgressDialog.Dialog.ErrorCheckingTransformation.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CheckTransProgressDialog.Dialog.ErrorCheckingTransformation.Message", (String[])new String[0]), e);
        }
    }
}

