/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.dialog;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.NotePadMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.StyledTextComp;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class NotePadDialog
extends Dialog {
    private static Class<?> PKG = NotePadDialog.class;
    private NotePadMeta notePadMeta;
    private Label wlDesc;
    private StyledTextComp wDesc;
    private FormData fdlDesc;
    private FormData fdDesc;
    private Button wOK;
    private Button wCancel;
    private Listener lsOK;
    private Listener lsCancel;
    private Shell shell;
    private String title;
    private PropsUI props = PropsUI.getInstance();
    private CTabFolder wNoteFolder;
    private FormData fdNoteFolder;
    private CTabItem wNoteContentTab;
    private CTabItem wNoteFontTab;
    private FormData fdNoteContentComp;
    private FormData fdNoteFontComp;
    private Label wlFontName;
    private CCombo wFontName;
    private FormData fdlFontName;
    private FormData fdFontName;
    private Label wlFontSize;
    private Spinner wFontSize;
    private FormData fdlFontSize;
    private FormData fdFontSize;
    private Label wlFontBold;
    private Button wFontBold;
    private FormData fdlFontBold;
    private FormData fdFontBold;
    private Label wlDrawShadow;
    private Button wDrawShadow;
    private FormData fdlDrawShadow;
    private FormData fdDrawShadow;
    private Label wlFontItalic;
    private Button wFontItalic;
    private FormData fdlFontItalic;
    private FormData fdFontItalic;
    private Button wbBackGroundColorChange;
    private FormData fdBackGroundColorChange;
    private Label wBackGroundColor;
    private FormData fdBackGroundColor;
    private Button wbFontColorChange;
    private FormData fdFontColorChange;
    private Label wFontColor;
    private FormData fdFontColor;
    private Button wbBorderColorChange;
    private FormData fdBorderColorChange;
    private Label wBorderColor;
    private FormData fdBorderColor;
    private Label wlFontColor;
    private FormData fdlFontColor;
    private Label wlBackGroundColor;
    private FormData fdlBackGroundColor;
    private Label wlBorderColor;
    private FormData fdlBorderColor;
    private static GUIResource guiresource = GUIResource.getInstance();
    public static RGB COLOR_RGB_BLACK = guiresource.getColorBlack().getRGB();
    public static RGB COLOR_RGB_YELLOW = guiresource.getColorYellow().getRGB();
    public static RGB COLOR_RGB_GRAY = guiresource.getColorGray().getRGB();
    private Color fontColor;
    private Color bgColor;
    private Color borderColor;
    private Font font;
    private VariableSpace variables;

    public NotePadDialog(VariableSpace space, Shell parent, String title, NotePadMeta nMeta) {
        super(parent, 0);
        this.title = title;
        if (nMeta != null) {
            this.notePadMeta = nMeta;
        }
        this.variables = space;
    }

    public NotePadDialog(VariableSpace space, Shell parent, String title) {
        this(space, parent, title, null);
    }

    public NotePadMeta open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(guiresource.getImageNoteSmall());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(this.title);
        int margin = 4;
        int middle = 30;
        this.wNoteFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wNoteFolder, 5);
        this.wNoteContentTab = new CTabItem(this.wNoteFolder, 0);
        this.wNoteContentTab.setText(BaseMessages.getString(PKG, (String)"NotePadDialog.ContentTab.Note", (String[])new String[0]));
        Composite wNoteContentComp = new Composite((Composite)this.wNoteFolder, 0);
        this.props.setLook((Control)wNoteContentComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        wNoteContentComp.setLayout((Layout)fileLayout);
        this.wlDesc = new Label(wNoteContentComp, 0);
        this.wlDesc.setText(BaseMessages.getString(PKG, (String)"NotePadDialog.ContentTab.Note.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlDesc);
        this.fdlDesc = new FormData();
        this.fdlDesc.left = new FormAttachment(0, 0);
        this.fdlDesc.top = new FormAttachment(0, margin);
        this.wlDesc.setLayoutData((Object)this.fdlDesc);
        this.wDesc = new StyledTextComp(this.variables, wNoteContentComp, 19202, "");
        this.wDesc.setText("");
        this.fdDesc = new FormData();
        this.fdDesc.left = new FormAttachment(0, 0);
        this.fdDesc.top = new FormAttachment((Control)this.wlDesc, margin);
        this.fdDesc.right = new FormAttachment(100, -10);
        this.fdDesc.bottom = new FormAttachment(100, -margin);
        this.wDesc.setLayoutData(this.fdDesc);
        this.fdNoteContentComp = new FormData();
        this.fdNoteContentComp.left = new FormAttachment(0, 0);
        this.fdNoteContentComp.top = new FormAttachment(0, 0);
        this.fdNoteContentComp.right = new FormAttachment(100, 0);
        this.fdNoteContentComp.bottom = new FormAttachment(100, 0);
        wNoteContentComp.setLayoutData((Object)this.fdNoteContentComp);
        wNoteContentComp.layout();
        this.wNoteContentTab.setControl((Control)wNoteContentComp);
        this.wNoteFontTab = new CTabItem(this.wNoteFolder, 0);
        this.wNoteFontTab.setText(BaseMessages.getString(PKG, (String)"NotePadDialog.Font.Label", (String[])new String[0]));
        Composite wNoteFontComp = new Composite((Composite)this.wNoteFolder, 0);
        this.props.setLook((Control)wNoteFontComp);
        FormLayout notefontLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        wNoteFontComp.setLayout((Layout)notefontLayout);
        this.wlFontName = new Label(wNoteFontComp, 131072);
        this.wlFontName.setText(BaseMessages.getString(PKG, (String)"NotePadDialog.Font.Name.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFontName);
        this.fdlFontName = new FormData();
        this.fdlFontName.left = new FormAttachment(margin, margin);
        this.fdlFontName.top = new FormAttachment(0, 3 * margin);
        this.fdlFontName.right = new FormAttachment(middle, -margin);
        this.wlFontName.setLayoutData((Object)this.fdlFontName);
        this.wFontName = new CCombo(wNoteFontComp, 2056);
        this.wFontName.setItems(Const.GetAvailableFontNames());
        this.props.setLook((Control)this.wFontName);
        this.fdFontName = new FormData();
        this.fdFontName.left = new FormAttachment(middle, 0);
        this.fdFontName.top = new FormAttachment(0, 3 * margin);
        this.fdFontName.right = new FormAttachment(100, -margin);
        this.wFontName.setLayoutData((Object)this.fdFontName);
        this.wFontName.select(0);
        this.wFontName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                NotePadDialog.this.refreshTextNote();
            }
        });
        this.wlFontSize = new Label(wNoteFontComp, 131072);
        this.wlFontSize.setText(BaseMessages.getString(PKG, (String)"NotePadDialog.Font.Size.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFontSize);
        this.fdlFontSize = new FormData();
        this.fdlFontSize.left = new FormAttachment(margin, margin);
        this.fdlFontSize.top = new FormAttachment((Control)this.wFontName, margin);
        this.fdlFontSize.right = new FormAttachment(middle, -margin);
        this.wlFontSize.setLayoutData((Object)this.fdlFontSize);
        this.wFontSize = new Spinner(wNoteFontComp, 2048);
        this.wFontSize.setMinimum(0);
        this.wFontSize.setMaximum(70);
        this.wFontSize.setIncrement(1);
        this.fdFontSize = new FormData();
        this.fdFontSize.left = new FormAttachment(middle, 0);
        this.fdFontSize.top = new FormAttachment((Control)this.wFontName, margin);
        this.fdFontSize.right = new FormAttachment(100, -margin);
        this.wFontSize.setLayoutData((Object)this.fdFontSize);
        this.wFontSize.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                NotePadDialog.this.refreshTextNote();
            }
        });
        this.wlFontBold = new Label(wNoteFontComp, 131072);
        this.wlFontBold.setText(BaseMessages.getString(PKG, (String)"NotePadDialog.Font.Bold.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFontBold);
        this.fdlFontBold = new FormData();
        this.fdlFontBold.left = new FormAttachment(margin, margin);
        this.fdlFontBold.top = new FormAttachment((Control)this.wFontSize, margin);
        this.fdlFontBold.right = new FormAttachment(middle, -margin);
        this.wlFontBold.setLayoutData((Object)this.fdlFontBold);
        this.wFontBold = new Button(wNoteFontComp, 32);
        this.props.setLook((Control)this.wFontBold);
        this.fdFontBold = new FormData();
        this.fdFontBold.left = new FormAttachment(middle, 0);
        this.fdFontBold.top = new FormAttachment((Control)this.wFontSize, margin);
        this.fdFontBold.right = new FormAttachment(100, -margin);
        this.wFontBold.setLayoutData((Object)this.fdFontBold);
        this.wFontBold.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                NotePadDialog.this.refreshTextNote();
            }
        });
        this.wlFontItalic = new Label(wNoteFontComp, 131072);
        this.wlFontItalic.setText(BaseMessages.getString(PKG, (String)"NotePadDialog.Font.Italic.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFontItalic);
        this.fdlFontItalic = new FormData();
        this.fdlFontItalic.left = new FormAttachment(margin, margin);
        this.fdlFontItalic.top = new FormAttachment((Control)this.wFontBold, margin);
        this.fdlFontItalic.right = new FormAttachment(middle, -margin);
        this.wlFontItalic.setLayoutData((Object)this.fdlFontItalic);
        this.wFontItalic = new Button(wNoteFontComp, 32);
        this.props.setLook((Control)this.wFontItalic);
        this.fdFontItalic = new FormData();
        this.fdFontItalic.left = new FormAttachment(middle, 0);
        this.fdFontItalic.top = new FormAttachment((Control)this.wFontBold, margin);
        this.fdFontItalic.right = new FormAttachment(100, -margin);
        this.wFontItalic.setLayoutData((Object)this.fdFontItalic);
        this.wFontItalic.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                NotePadDialog.this.refreshTextNote();
            }
        });
        this.wlFontColor = new Label(wNoteFontComp, 131072);
        this.wlFontColor.setText(BaseMessages.getString(PKG, (String)"NotePadDialog.Font.Color.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFontColor);
        this.fdlFontColor = new FormData();
        this.fdlFontColor.left = new FormAttachment(margin, margin);
        this.fdlFontColor.top = new FormAttachment((Control)this.wFontItalic, 2 * margin);
        this.fdlFontColor.right = new FormAttachment(middle, -margin);
        this.wlFontColor.setLayoutData((Object)this.fdlFontColor);
        this.wbFontColorChange = new Button(wNoteFontComp, 8);
        this.wbFontColorChange.setImage(guiresource.getImageColor());
        this.wbFontColorChange.setToolTipText(BaseMessages.getString(PKG, (String)"NotePadDialog.Font.Color.Change.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wbFontColorChange);
        this.fdFontColorChange = new FormData();
        this.fdFontColorChange.top = new FormAttachment((Control)this.wFontItalic, 2 * margin);
        this.fdFontColorChange.right = new FormAttachment(100, -margin);
        this.wbFontColorChange.setLayoutData((Object)this.fdFontColorChange);
        this.wbFontColorChange.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorDialog cd = new ColorDialog(NotePadDialog.this.shell);
                cd.setText(BaseMessages.getString((Class)PKG, (String)"NotePadDialog.Font.Color.Dialog.Label", (String[])new String[0]));
                cd.setRGB(NotePadDialog.this.wFontColor.getBackground().getRGB());
                RGB newColor = cd.open();
                if (newColor == null) {
                    return;
                }
                NotePadDialog.this.fontColor.dispose();
                NotePadDialog.this.fontColor = new Color((Device)NotePadDialog.this.shell.getDisplay(), newColor);
                NotePadDialog.this.wFontColor.setBackground(NotePadDialog.this.fontColor);
                NotePadDialog.this.refreshTextNote();
            }
        });
        this.wFontColor = new Label(wNoteFontComp, 0);
        this.wFontColor.setToolTipText(BaseMessages.getString(PKG, (String)"NotePadDialog.Font.Color.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wFontColor);
        this.wFontColor.setEnabled(false);
        this.fdFontColor = new FormData();
        this.fdFontColor.left = new FormAttachment((Control)this.wlFontColor, margin);
        this.fdFontColor.top = new FormAttachment((Control)this.wFontItalic, 2 * margin);
        this.fdFontColor.right = new FormAttachment((Control)this.wbFontColorChange, -margin);
        this.wFontColor.setLayoutData((Object)this.fdFontColor);
        this.wlBackGroundColor = new Label(wNoteFontComp, 131072);
        this.wlBackGroundColor.setText(BaseMessages.getString(PKG, (String)"NotePadDialog.Font.BackGroundColor.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlBackGroundColor);
        this.fdlBackGroundColor = new FormData();
        this.fdlBackGroundColor.left = new FormAttachment(margin, margin);
        this.fdlBackGroundColor.top = new FormAttachment((Control)this.wFontColor, 2 * margin);
        this.fdlBackGroundColor.right = new FormAttachment(middle, -margin);
        this.wlBackGroundColor.setLayoutData((Object)this.fdlBackGroundColor);
        this.wbBackGroundColorChange = new Button(wNoteFontComp, 8);
        this.wbBackGroundColorChange.setImage(guiresource.getImageColor());
        this.wbBackGroundColorChange.setToolTipText(BaseMessages.getString(PKG, (String)"NotePadDialog.Font.BackGroundColor.Change.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wbBackGroundColorChange);
        this.fdBackGroundColorChange = new FormData();
        this.fdBackGroundColorChange.top = new FormAttachment((Control)this.wFontColor, 2 * margin);
        this.fdBackGroundColorChange.right = new FormAttachment(100, -margin);
        this.fdBackGroundColorChange.right = new FormAttachment(100, -margin);
        this.wbBackGroundColorChange.setLayoutData((Object)this.fdBackGroundColorChange);
        this.wbBackGroundColorChange.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorDialog cd = new ColorDialog(NotePadDialog.this.shell);
                cd.setText(BaseMessages.getString((Class)PKG, (String)"NotePadDialog.Font.Color.Dialog.Label", (String[])new String[0]));
                cd.setRGB(NotePadDialog.this.wBackGroundColor.getBackground().getRGB());
                RGB newColor = cd.open();
                if (newColor == null) {
                    return;
                }
                NotePadDialog.this.bgColor.dispose();
                NotePadDialog.this.bgColor = new Color((Device)NotePadDialog.this.shell.getDisplay(), newColor);
                NotePadDialog.this.wBackGroundColor.setBackground(NotePadDialog.this.bgColor);
                NotePadDialog.this.refreshTextNote();
            }
        });
        this.wBackGroundColor = new Label(wNoteFontComp, 2048);
        this.wBackGroundColor.setToolTipText(BaseMessages.getString(PKG, (String)"NotePadDialog.Font.BackGroundColor.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wBackGroundColor);
        this.wBackGroundColor.setEnabled(false);
        this.fdBackGroundColor = new FormData();
        this.fdBackGroundColor.left = new FormAttachment((Control)this.wlBackGroundColor, margin);
        this.fdBackGroundColor.top = new FormAttachment((Control)this.wFontColor, 2 * margin);
        this.fdBackGroundColor.right = new FormAttachment((Control)this.wbBackGroundColorChange, -margin);
        this.wBackGroundColor.setLayoutData((Object)this.fdBackGroundColor);
        this.wlBorderColor = new Label(wNoteFontComp, 131072);
        this.wlBorderColor.setText(BaseMessages.getString(PKG, (String)"NotePadDialog.Font.BorderColor.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlBorderColor);
        this.fdlBorderColor = new FormData();
        this.fdlBorderColor.left = new FormAttachment(margin, margin);
        this.fdlBorderColor.top = new FormAttachment((Control)this.wBackGroundColor, 2 * margin);
        this.fdlBorderColor.right = new FormAttachment(middle, -margin);
        this.wlBorderColor.setLayoutData((Object)this.fdlBorderColor);
        this.wbBorderColorChange = new Button(wNoteFontComp, 8);
        this.wbBorderColorChange.setImage(guiresource.getImageColor());
        this.wbBorderColorChange.setToolTipText(BaseMessages.getString(PKG, (String)"NotePadDialog.Font.BorderColor.Change.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wbBorderColorChange);
        this.fdBorderColorChange = new FormData();
        this.fdBorderColorChange.top = new FormAttachment((Control)this.wBackGroundColor, 2 * margin);
        this.fdBorderColorChange.right = new FormAttachment(100, -margin);
        this.wbBorderColorChange.setLayoutData((Object)this.fdBorderColorChange);
        this.wbBorderColorChange.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorDialog cd = new ColorDialog(NotePadDialog.this.shell);
                cd.setText(BaseMessages.getString((Class)PKG, (String)"NotePadDialog.Font.Color.Dialog.Label", (String[])new String[0]));
                cd.setRGB(NotePadDialog.this.wBorderColor.getBackground().getRGB());
                RGB newColor = cd.open();
                if (newColor == null) {
                    return;
                }
                NotePadDialog.this.borderColor.dispose();
                NotePadDialog.this.borderColor = new Color((Device)NotePadDialog.this.shell.getDisplay(), newColor);
                NotePadDialog.this.wBorderColor.setBackground(NotePadDialog.this.borderColor);
            }
        });
        this.wBorderColor = new Label(wNoteFontComp, 2048);
        this.wBorderColor.setToolTipText(BaseMessages.getString(PKG, (String)"NotePadDialog.Font.BorderColor.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wBorderColor);
        this.wBorderColor.setEnabled(false);
        this.fdBorderColor = new FormData();
        this.fdBorderColor.left = new FormAttachment((Control)this.wlBorderColor, margin);
        this.fdBorderColor.top = new FormAttachment((Control)this.wBackGroundColor, 2 * margin);
        this.fdBorderColor.right = new FormAttachment((Control)this.wbBorderColorChange, -margin);
        this.wBorderColor.setLayoutData((Object)this.fdBorderColor);
        this.wlDrawShadow = new Label(wNoteFontComp, 131072);
        this.wlDrawShadow.setText(BaseMessages.getString(PKG, (String)"NotePadDialog.DrawShadow.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlDrawShadow);
        this.fdlDrawShadow = new FormData();
        this.fdlDrawShadow.left = new FormAttachment(margin, margin);
        this.fdlDrawShadow.top = new FormAttachment((Control)this.wBorderColor, margin);
        this.fdlDrawShadow.right = new FormAttachment(middle, -margin);
        this.wlDrawShadow.setLayoutData((Object)this.fdlDrawShadow);
        this.wDrawShadow = new Button(wNoteFontComp, 32);
        this.wDrawShadow.setToolTipText(BaseMessages.getString(PKG, (String)"NotePadDialog.DrawShadow.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wDrawShadow);
        this.fdDrawShadow = new FormData();
        this.fdDrawShadow.left = new FormAttachment(middle, 0);
        this.fdDrawShadow.top = new FormAttachment((Control)this.wBorderColor, margin);
        this.fdDrawShadow.right = new FormAttachment(100, -margin);
        this.wDrawShadow.setLayoutData((Object)this.fdDrawShadow);
        this.fdNoteFontComp = new FormData();
        this.fdNoteFontComp.left = new FormAttachment(0, 0);
        this.fdNoteFontComp.top = new FormAttachment(0, 0);
        this.fdNoteFontComp.right = new FormAttachment(100, 0);
        this.fdNoteFontComp.bottom = new FormAttachment(100, 0);
        wNoteFontComp.setLayoutData((Object)this.fdNoteFontComp);
        wNoteFontComp.layout();
        this.wNoteFontTab.setControl((Control)wNoteFontComp);
        this.fdNoteFolder = new FormData();
        this.fdNoteFolder.left = new FormAttachment(0, 0);
        this.fdNoteFolder.top = new FormAttachment(0, margin);
        this.fdNoteFolder.right = new FormAttachment(100, 0);
        this.fdNoteFolder.bottom = new FormAttachment(100, -50);
        this.wNoteFolder.setLayoutData((Object)this.fdNoteFolder);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wOK, this.wCancel}, margin, (Control)this.wNoteFolder);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                NotePadDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                NotePadDialog.this.ok();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wCancel.addListener(13, this.lsCancel);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                NotePadDialog.this.cancel();
            }
        });
        this.getData();
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.notePadMeta;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.fontColor.dispose();
        this.bgColor.dispose();
        this.borderColor.dispose();
        if (this.font != null && !this.font.isDisposed()) {
            this.font.dispose();
        }
        this.shell.dispose();
    }

    public void getData() {
        if (this.notePadMeta != null) {
            this.wDesc.setText(this.notePadMeta.getNote());
            this.wFontName.setText(this.notePadMeta.getFontName() == null ? this.props.getNoteFont().getName() : this.notePadMeta.getFontName());
            this.wFontSize.setSelection(this.notePadMeta.getFontSize() == -1 ? this.props.getNoteFont().getHeight() : this.notePadMeta.getFontSize());
            this.wFontBold.setSelection(this.notePadMeta.isFontBold());
            this.wFontItalic.setSelection(this.notePadMeta.isFontItalic());
            this.fontColor = new Color((Device)this.shell.getDisplay(), new RGB(this.notePadMeta.getFontColorRed(), this.notePadMeta.getFontColorGreen(), this.notePadMeta.getFontColorBlue()));
            this.bgColor = new Color((Device)this.shell.getDisplay(), new RGB(this.notePadMeta.getBackGroundColorRed(), this.notePadMeta.getBackGroundColorGreen(), this.notePadMeta.getBackGroundColorBlue()));
            this.borderColor = new Color((Device)this.shell.getDisplay(), new RGB(this.notePadMeta.getBorderColorRed(), this.notePadMeta.getBorderColorGreen(), this.notePadMeta.getBorderColorBlue()));
            this.wDrawShadow.setSelection(this.notePadMeta.isDrawShadow());
        } else {
            this.wFontName.setText(this.props.getNoteFont().getName());
            this.wFontSize.setSelection(this.props.getNoteFont().getHeight());
            this.wFontBold.setSelection(false);
            this.wFontItalic.setSelection(false);
            this.fontColor = new Color((Device)this.shell.getDisplay(), new RGB(0, 0, 0));
            this.bgColor = new Color((Device)this.shell.getDisplay(), new RGB(255, 165, 0));
            this.borderColor = new Color((Device)this.shell.getDisplay(), new RGB(100, 100, 100));
            this.wDrawShadow.setSelection(true);
        }
        this.wFontColor.setBackground(this.fontColor);
        this.wBackGroundColor.setBackground(this.bgColor);
        this.wBorderColor.setBackground(this.borderColor);
        this.wNoteFolder.setSelection(0);
        this.wDesc.setFocus();
        this.wDesc.setSelection(this.wDesc.getText().length());
        this.refreshTextNote();
    }

    private void cancel() {
        this.notePadMeta = null;
        this.dispose();
    }

    private void ok() {
        this.notePadMeta = new NotePadMeta();
        if (this.wDesc.getText() != null) {
            this.notePadMeta.setNote(this.wDesc.getText());
        }
        if (this.wFontName.getText() != null) {
            this.notePadMeta.setFontName(this.wFontName.getText());
        }
        this.notePadMeta.setFontSize(this.wFontSize.getSelection());
        this.notePadMeta.setFontBold(this.wFontBold.getSelection());
        this.notePadMeta.setFontItalic(this.wFontItalic.getSelection());
        this.notePadMeta.setFontColorRed(this.wFontColor.getBackground().getRed());
        this.notePadMeta.setFontColorGreen(this.wFontColor.getBackground().getGreen());
        this.notePadMeta.setFontColorBlue(this.wFontColor.getBackground().getBlue());
        this.notePadMeta.setBackGroundColorRed(this.wBackGroundColor.getBackground().getRed());
        this.notePadMeta.setBackGroundColorGreen(this.wBackGroundColor.getBackground().getGreen());
        this.notePadMeta.setBackGroundColorBlue(this.wBackGroundColor.getBackground().getBlue());
        this.notePadMeta.setBorderColorRed(this.wBorderColor.getBackground().getRed());
        this.notePadMeta.setBorderColorGreen(this.wBorderColor.getBackground().getGreen());
        this.notePadMeta.setBorderColorBlue(this.wBorderColor.getBackground().getBlue());
        this.notePadMeta.setDrawShadow(this.wDrawShadow.getSelection());
        this.dispose();
    }

    private void refreshTextNote() {
        int swt = 0;
        if (this.wFontBold.getSelection()) {
            swt = 1;
        }
        if (this.wFontItalic.getSelection()) {
            swt |= 2;
        }
        Font oldFont = this.font;
        this.font = new Font((Device)this.shell.getDisplay(), this.wFontName.getText(), this.wFontSize.getSelection(), swt);
        this.wDesc.setFont(this.font);
        if (oldFont != null && !oldFont.isDisposed()) {
            oldFont.dispose();
        }
        for (Control control : this.wDesc.getChildren()) {
            control.setBackground(this.bgColor);
        }
        this.wFontColor.setBackground(this.fontColor);
        this.wBackGroundColor.setBackground(this.bgColor);
        this.wBorderColor.setBackground(this.borderColor);
    }
}

