/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.dialog;

import java.util.List;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class PreviewSelectDialog
extends Dialog {
    private static Class<?> PKG = PreviewSelectDialog.class;
    private Label wlFields;
    private TableView wFields;
    private FormData fdlFields;
    private FormData fdFields;
    private Button wPreview;
    private Button wCancel;
    private Listener lsPreview;
    private Listener lsCancel;
    private Shell shell;
    private TransMeta trans;
    public String[] previewSteps;
    public int[] previewSizes;
    private PropsUI props;

    public PreviewSelectDialog(Shell parent, int style, LogWriter l, PropsUI props, TransMeta tr) {
        super(parent, style);
        this.trans = tr;
        this.props = props;
        this.previewSteps = null;
        this.previewSizes = null;
    }

    public void open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GUIResource.getInstance().getImageSpoon());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"PreviewSelectDialog.Dialog.PreviewSelection.Title", (String[])new String[0]));
        this.shell.setImage(GUIResource.getInstance().getImageLogoSmall());
        int margin = 4;
        this.wlFields = new Label((Composite)this.shell, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"PreviewSelectDialog.Label.Steps", (String[])new String[0]));
        this.props.setLook((Control)this.wlFields);
        this.fdlFields = new FormData();
        this.fdlFields.left = new FormAttachment(0, 0);
        this.fdlFields.top = new FormAttachment(0, margin);
        this.wlFields.setLayoutData((Object)this.fdlFields);
        List usedSteps = this.trans.getUsedSteps();
        int FieldsRows = usedSteps.size();
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"PreviewSelectDialog.Column.Stepname", (String[])new String[0]), 1, false, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"PreviewSelectDialog.Column.PreviewSize", (String[])new String[0]), 1, false, false)};
        this.wFields = new TableView((VariableSpace)this.trans, (Composite)this.shell, 67586, colinf, FieldsRows, true, null, this.props);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        this.fdFields.right = new FormAttachment(100, 0);
        this.fdFields.bottom = new FormAttachment(100, -50);
        this.wFields.setLayoutData(this.fdFields);
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"System.Button.Show", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Close", (String[])new String[0]));
        BaseStepDialog.positionBottomButtons((Composite)this.shell, new Button[]{this.wPreview, this.wCancel}, margin, null);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                PreviewSelectDialog.this.cancel();
            }
        };
        this.lsPreview = new Listener(){

            public void handleEvent(Event e) {
                PreviewSelectDialog.this.preview();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wPreview.addListener(13, this.lsPreview);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                PreviewSelectDialog.this.cancel();
            }
        });
        BaseStepDialog.setSize(this.shell);
        this.getData();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        String[] prSteps = this.props.getLastPreview();
        int[] prSizes = this.props.getLastPreviewSize();
        List selectedSteps = this.trans.getSelectedSteps();
        List usedSteps = this.trans.getUsedSteps();
        if (selectedSteps.size() == 0) {
            int line = 0;
            for (StepMeta stepMeta : usedSteps) {
                TableItem item = this.wFields.table.getItem(line++);
                String name = stepMeta.getName();
                item.setText(1, stepMeta.getName());
                item.setText(2, "0");
                for (int x = 0; x < prSteps.length; ++x) {
                    if (!prSteps[x].equalsIgnoreCase(name)) continue;
                    item.setText(2, "" + prSizes[x]);
                }
            }
        } else {
            int line = 0;
            for (StepMeta stepMeta : usedSteps) {
                TableItem item = this.wFields.table.getItem(line++);
                String name = stepMeta.getName();
                item.setText(1, stepMeta.getName());
                item.setText(2, "");
                if (!stepMeta.isSelected()) continue;
                item.setText(2, "" + this.props.getDefaultPreviewSize());
            }
        }
        this.wFields.optWidth(true);
    }

    private void cancel() {
        this.dispose();
    }

    private void preview() {
        int size;
        TableItem ti;
        int i;
        int sels = 0;
        for (i = 0; i < this.wFields.table.getItemCount(); ++i) {
            ti = this.wFields.table.getItem(i);
            size = Const.toInt((String)ti.getText(2), (int)0);
            if (size <= 0) continue;
            ++sels;
        }
        this.previewSteps = new String[sels];
        this.previewSizes = new int[sels];
        sels = 0;
        for (i = 0; i < this.wFields.table.getItemCount(); ++i) {
            ti = this.wFields.table.getItem(i);
            size = Const.toInt((String)ti.getText(2), (int)0);
            if (size <= 0) continue;
            this.previewSteps[sels] = ti.getText(1);
            this.previewSizes[sels] = size;
            ++sels;
        }
        this.props.setLastPreview(this.previewSteps, this.previewSizes);
        this.dispose();
    }
}

