/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.job;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.gui.JobTracker;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobEntryResult;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.TreeMemory;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.delegates.SpoonDelegate;
import org.pentaho.di.ui.spoon.job.JobGraph;

public class JobGridDelegate
extends SpoonDelegate {
    private static Class<?> PKG = JobGraph.class;
    public static final long REFRESH_TIME = 100L;
    public static final long UPDATE_TIME_VIEW = 1000L;
    private static final String STRING_CHEF_LOG_TREE_NAME = "Job Log Tree";
    private JobGraph jobGraph;
    private CTabItem jobGridTab;
    private Tree wTree;
    public JobTracker jobTracker;
    public int previousNrItems;
    private int nrRow = 0;

    public JobGridDelegate(Spoon spoon, JobGraph transGraph) {
        super(spoon);
        this.jobGraph = transGraph;
    }

    public void addJobGrid() {
        if (this.jobGraph.extraViewComposite == null || this.jobGraph.extraViewComposite.isDisposed()) {
            this.jobGraph.addExtraView();
        } else if (this.jobGridTab != null && !this.jobGridTab.isDisposed()) {
            this.jobGraph.extraViewTabFolder.setSelection(this.jobGridTab);
            return;
        }
        this.jobGridTab = new CTabItem(this.jobGraph.extraViewTabFolder, 0);
        this.jobGridTab.setImage(GUIResource.getInstance().getImageShowGrid());
        this.jobGridTab.setText(BaseMessages.getString(PKG, (String)"Spoon.TransGraph.GridTab.Name", (String[])new String[0]));
        this.addControls();
        this.jobGridTab.setControl((Control)this.wTree);
        this.jobGraph.extraViewTabFolder.setSelection(this.jobGridTab);
    }

    private void addControls() {
        this.wTree = new Tree((Composite)this.jobGraph.extraViewTabFolder, 768);
        this.wTree.setHeaderVisible(true);
        TreeMemory.addTreeListener(this.wTree, STRING_CHEF_LOG_TREE_NAME);
        TreeColumn column1 = new TreeColumn(this.wTree, 16384);
        column1.setText(BaseMessages.getString(PKG, (String)"JobLog.Column.JobJobEntry", (String[])new String[0]));
        column1.setWidth(200);
        TreeColumn column2 = new TreeColumn(this.wTree, 16384);
        column2.setText(BaseMessages.getString(PKG, (String)"JobLog.Column.Comment", (String[])new String[0]));
        column2.setWidth(200);
        TreeColumn column3 = new TreeColumn(this.wTree, 16384);
        column3.setText(BaseMessages.getString(PKG, (String)"JobLog.Column.Result", (String[])new String[0]));
        column3.setWidth(100);
        TreeColumn column4 = new TreeColumn(this.wTree, 16384);
        column4.setText(BaseMessages.getString(PKG, (String)"JobLog.Column.Reason", (String[])new String[0]));
        column4.setWidth(200);
        TreeColumn column5 = new TreeColumn(this.wTree, 16384);
        column5.setText(BaseMessages.getString(PKG, (String)"JobLog.Column.Filename", (String[])new String[0]));
        column5.setWidth(200);
        TreeColumn column6 = new TreeColumn(this.wTree, 131072);
        column6.setText(BaseMessages.getString(PKG, (String)"JobLog.Column.Nr", (String[])new String[0]));
        column6.setWidth(50);
        TreeColumn column7 = new TreeColumn(this.wTree, 131072);
        column7.setText(BaseMessages.getString(PKG, (String)"JobLog.Column.LogDate", (String[])new String[0]));
        column7.setWidth(120);
        FormData fdTree = new FormData();
        fdTree.left = new FormAttachment(0, 0);
        fdTree.top = new FormAttachment(0, 0);
        fdTree.right = new FormAttachment(100, 0);
        fdTree.bottom = new FormAttachment(100, 0);
        this.wTree.setLayoutData((Object)fdTree);
        final Timer tim = new Timer("JobGrid: " + this.jobGraph.getMeta().getName());
        TimerTask timtask = new TimerTask(){

            public void run() {
                Display display = JobGridDelegate.this.jobGraph.getDisplay();
                if (display != null && !display.isDisposed()) {
                    display.asyncExec(new Runnable(){

                        public void run() {
                            if (!JobGridDelegate.this.wTree.isDisposed()) {
                                JobGridDelegate.this.refreshTreeTable();
                            }
                        }
                    });
                }
            }
        };
        tim.schedule(timtask, 10L, 10L);
        this.jobGraph.jobLogDelegate.getJobLogTab().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent disposeEvent) {
                tim.cancel();
            }
        });
    }

    private void refreshTreeTable() {
        int nrItems;
        if (this.jobTracker != null && (nrItems = this.jobTracker.getTotalNumberOfItems()) != this.previousNrItems) {
            this.wTree.removeAll();
            TreeItem treeItem = new TreeItem(this.wTree, 0);
            String jobName = this.jobTracker.getJobName();
            if (Const.isEmpty((String)jobName)) {
                jobName = !Const.isEmpty((String)this.jobTracker.getJobFilename()) ? this.jobTracker.getJobFilename() : BaseMessages.getString(PKG, (String)"JobLog.Tree.StringToDisplayWhenJobHasNoName", (String[])new String[0]);
            }
            treeItem.setText(0, jobName);
            TreeMemory.getInstance().storeExpanded(STRING_CHEF_LOG_TREE_NAME, new String[]{jobName}, true);
            for (int i = 0; i < this.jobTracker.nrJobTrackers(); ++i) {
                this.addTrackerToTree(this.jobTracker.getJobTracker(i), treeItem);
            }
            this.previousNrItems = nrItems;
            TreeMemory.setExpandedFromMemory(this.wTree, STRING_CHEF_LOG_TREE_NAME);
        }
    }

    private void addTrackerToTree(JobTracker jobTracker, TreeItem parentItem) {
        try {
            if (jobTracker != null) {
                TreeItem treeItem = new TreeItem(parentItem, 0);
                if (this.nrRow % 2 != 0) {
                    treeItem.setBackground(GUIResource.getInstance().getColorBlueCustomGrid());
                }
                ++this.nrRow;
                if (jobTracker.nrJobTrackers() > 0) {
                    treeItem.setText(0, BaseMessages.getString(PKG, (String)"JobLog.Tree.JobPrefix", (String[])new String[0]) + jobTracker.getJobName());
                    for (int i = 0; i < jobTracker.nrJobTrackers(); ++i) {
                        this.addTrackerToTree(jobTracker.getJobTracker(i), treeItem);
                    }
                } else {
                    JobEntryResult result = jobTracker.getJobEntryResult();
                    if (result != null) {
                        Date logDate;
                        String reason;
                        Result res;
                        String jobEntryName = result.getJobEntryName();
                        if (!Const.isEmpty((String)jobEntryName)) {
                            treeItem.setText(0, jobEntryName);
                            treeItem.setText(4, Const.NVL((String)result.getJobEntryFilename(), (String)""));
                        } else {
                            treeItem.setText(0, BaseMessages.getString(PKG, (String)"JobLog.Tree.JobPrefix2", (String[])new String[0]) + jobTracker.getJobName());
                        }
                        String comment = result.getComment();
                        if (comment != null) {
                            treeItem.setText(1, comment);
                        }
                        if ((res = result.getResult()) != null) {
                            treeItem.setText(2, res.getResult() ? BaseMessages.getString(PKG, (String)"JobLog.Tree.Success", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"JobLog.Tree.Failure", (String[])new String[0]));
                            treeItem.setText(5, Long.toString(res.getEntryNr()));
                            if (res.getResult()) {
                                treeItem.setForeground(GUIResource.getInstance().getColorSuccessGreen());
                            } else {
                                treeItem.setForeground(GUIResource.getInstance().getColorRed());
                            }
                        }
                        if ((reason = result.getReason()) != null) {
                            treeItem.setText(3, reason);
                        }
                        if ((logDate = result.getLogDate()) != null) {
                            treeItem.setText(6, new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(logDate));
                        }
                    }
                }
                treeItem.setExpanded(true);
            }
        }
        catch (Exception e) {
            this.log.logError(Const.getStackTracker((Throwable)e));
        }
    }

    public CTabItem getJobGridTab() {
        return this.jobGridTab;
    }

    public void setJobTracker(JobTracker jobTracker) {
        this.jobTracker = jobTracker;
    }
}

