/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.job;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Props;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.JobEntryLogTable;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogStatus;
import org.pentaho.di.core.logging.LogTableField;
import org.pentaho.di.core.logging.LogTableInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryCopy;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.spoon.XulSpoonResourceBundle;
import org.pentaho.di.ui.spoon.XulSpoonSettingsManager;
import org.pentaho.di.ui.spoon.delegates.SpoonDelegate;
import org.pentaho.di.ui.spoon.job.JobEntryCopyResult;
import org.pentaho.di.ui.spoon.job.JobGraph;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulSettingsManager;
import org.pentaho.ui.xul.components.XulToolbarbutton;
import org.pentaho.ui.xul.containers.XulToolbar;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.swt.SwtXulLoader;

public class JobHistoryDelegate
extends SpoonDelegate
implements XulEventHandler {
    private static Class<?> PKG = JobGraph.class;
    private static final String XUL_FILE_TRANS_GRID_TOOLBAR = "ui/job-history-toolbar.xul";
    private JobGraph jobGraph;
    private CTabItem jobHistoryTab;
    private List<ColumnInfo[]> columns;
    private List<Text> wText;
    private List<TableView> wFields;
    private XulToolbar toolbar;
    private Composite jobHistoryComposite;
    private JobMeta jobMeta;
    private CTabFolder tabFolder;
    private XulToolbarbutton refreshButton;
    private XulToolbarbutton fetchNextBatchButton;
    private XulToolbarbutton fetchAllButton;
    private TransHistoryModel[] models;

    public JobHistoryDelegate(Spoon spoon, JobGraph jobGraph) {
        super(spoon);
        this.jobGraph = jobGraph;
    }

    public void addJobHistory() {
        if (this.jobGraph.extraViewComposite == null || this.jobGraph.extraViewComposite.isDisposed()) {
            this.jobGraph.addExtraView();
        } else if (this.jobHistoryTab != null && !this.jobHistoryTab.isDisposed()) {
            this.jobGraph.extraViewTabFolder.setSelection(this.jobHistoryTab);
            return;
        }
        this.jobMeta = this.jobGraph.getManagedObject();
        this.jobHistoryTab = new CTabItem(this.jobGraph.extraViewTabFolder, 0);
        this.jobHistoryTab.setImage(GUIResource.getInstance().getImageShowHistory());
        this.jobHistoryTab.setText(BaseMessages.getString(PKG, (String)"Spoon.TransGraph.HistoryTab.Name", (String[])new String[0]));
        this.jobHistoryComposite = new Composite((Composite)this.jobGraph.extraViewTabFolder, 0);
        this.jobHistoryComposite.setLayout((Layout)new FormLayout());
        this.spoon.props.setLook((Control)this.jobHistoryComposite);
        this.addToolBar();
        Control toolbarControl = (Control)this.toolbar.getManagedObject();
        toolbarControl.setLayoutData((Object)new FormData());
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        toolbarControl.setLayoutData((Object)fd);
        toolbarControl.setParent(this.jobHistoryComposite);
        this.addLogTableTabs();
        this.tabFolder.setSelection(0);
        this.tabFolder.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                JobHistoryDelegate.this.setMoreRows(true);
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }
        });
        this.jobHistoryComposite.pack();
        this.jobHistoryTab.setControl((Control)this.jobHistoryComposite);
        this.jobGraph.extraViewTabFolder.setSelection(this.jobHistoryTab);
        if (!Props.getInstance().disableInitialExecutionHistory()) {
            this.refreshAllHistory();
        }
    }

    private void addLogTableTabs() {
        this.models = new TransHistoryModel[this.jobMeta.getLogTables().size()];
        for (int i = 0; i < this.models.length; ++i) {
            this.models[i] = new TransHistoryModel();
            this.models[i].logTable = (LogTableInterface)this.jobMeta.getLogTables().get(i);
        }
        this.columns = new ArrayList<ColumnInfo[]>(this.models.length);
        this.wFields = new ArrayList<TableView>(this.models.length);
        this.wText = new ArrayList<Text>(this.models.length);
        this.tabFolder = new CTabFolder(this.jobHistoryComposite, 2);
        this.spoon.props.setLook((Control)this.tabFolder, 5);
        for (TransHistoryModel model : this.models) {
            LogTableInterface logTable = model.logTable;
            CTabItem tabItem = new CTabItem(this.tabFolder, 0);
            tabItem.setText(logTable.getLogTableType());
            Composite logTableComposite = new Composite((Composite)this.tabFolder, 0);
            logTableComposite.setLayout((Layout)new FormLayout());
            this.spoon.props.setLook((Control)logTableComposite);
            tabItem.setControl((Control)logTableComposite);
            SashForm sash = new SashForm(logTableComposite, 512);
            sash.setLayout((Layout)new FillLayout());
            FormData fdSash = new FormData();
            fdSash.left = new FormAttachment(0, 0);
            fdSash.top = new FormAttachment(0, 0);
            fdSash.right = new FormAttachment(100, 0);
            fdSash.bottom = new FormAttachment(100, 0);
            sash.setLayoutData((Object)fdSash);
            ArrayList<ColumnInfo> columnList = new ArrayList<ColumnInfo>();
            ArrayList<LogTableField> fields = new ArrayList<LogTableField>();
            for (LogTableField field : logTable.getFields()) {
                if (!field.isEnabled() || !field.isVisible()) continue;
                fields.add(field);
                if (field.isLogField()) continue;
                ColumnInfo column = new ColumnInfo(field.getName(), 1, false, true);
                ValueMeta valueMeta = new ValueMeta(field.getFieldName(), field.getDataType(), field.getLength(), -1);
                switch (field.getDataType()) {
                    case 5: {
                        valueMeta.setConversionMask("###,###,##0");
                        column.setAllignement(131072);
                        break;
                    }
                    case 3: {
                        valueMeta.setConversionMask("yyyy/MM/dd HH:mm:ss");
                        column.setAllignement(0x1000000);
                        break;
                    }
                    case 1: {
                        valueMeta.setConversionMask(" ###,###,##0.00;-###,###,##0.00");
                        column.setAllignement(131072);
                        break;
                    }
                    case 2: {
                        column.setAllignement(16384);
                        break;
                    }
                    case 4: {
                        DatabaseMeta databaseMeta = logTable.getDatabaseMeta();
                        if (databaseMeta == null || databaseMeta.supportsBooleanDataType()) break;
                        valueMeta.setType(2);
                    }
                }
                column.setValueMeta((ValueMetaInterface)valueMeta);
                columnList.add(column);
            }
            model.logTableFields = fields;
            boolean FieldsRows = true;
            ColumnInfo[] colinf = columnList.toArray(new ColumnInfo[columnList.size()]);
            this.columns.add(colinf);
            TableView tableView = new TableView((VariableSpace)this.jobGraph.getManagedObject(), (Composite)sash, 67588, colinf, 1, true, null, this.spoon.props);
            this.wFields.add(tableView);
            tableView.table.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent arg0) {
                    JobHistoryDelegate.this.showLogEntry();
                }
            });
            if (logTable.getLogField() != null) {
                Text text = new Text((Composite)sash, 778);
                this.spoon.props.setLook((Control)text);
                text.setVisible(true);
                this.wText.add(text);
                FormData fdText = new FormData();
                fdText.left = new FormAttachment(0, 0);
                fdText.top = new FormAttachment(0, 0);
                fdText.right = new FormAttachment(100, 0);
                fdText.bottom = new FormAttachment(100, 0);
                text.setLayoutData((Object)fdText);
                sash.setWeights(new int[]{70, 30});
                continue;
            }
            this.wText.add(null);
            sash.setWeights(new int[]{100});
        }
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.toolbar.getManagedObject(), 0);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment(100, 0);
        this.tabFolder.setLayoutData((Object)fdTabFolder);
    }

    private void addToolBar() {
        try {
            SwtXulLoader loader = new SwtXulLoader();
            loader.setSettingsManager((XulSettingsManager)XulSpoonSettingsManager.getInstance());
            XulSpoonResourceBundle bundle = new XulSpoonResourceBundle(Spoon.class);
            XulDomContainer xulDomContainer = loader.loadXul(XUL_FILE_TRANS_GRID_TOOLBAR, (Object)bundle);
            xulDomContainer.addEventHandler((XulEventHandler)this);
            this.toolbar = (XulToolbar)xulDomContainer.getDocumentRoot().getElementById("nav-toolbar");
            this.refreshButton = (XulToolbarbutton)xulDomContainer.getDocumentRoot().getElementById("refresh-history");
            this.fetchNextBatchButton = (XulToolbarbutton)xulDomContainer.getDocumentRoot().getElementById("fetch-next-batch-history");
            this.fetchAllButton = (XulToolbarbutton)xulDomContainer.getDocumentRoot().getElementById("fetch-all-history");
            ToolBar swtToolBar = (ToolBar)this.toolbar.getManagedObject();
            swtToolBar.layout(true, true);
        }
        catch (Throwable t) {
            this.log.logError(Const.getStackTracker((Throwable)t));
            new ErrorDialog(this.jobHistoryComposite.getShell(), BaseMessages.getString(PKG, (String)"Spoon.Exception.ErrorReadingXULFile.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"Spoon.Exception.ErrorReadingXULFile.Message", (String[])new String[]{XUL_FILE_TRANS_GRID_TOOLBAR}), new Exception(t));
        }
    }

    public void clearLogTable() {
        this.clearLogTable(this.tabFolder.getSelectionIndex());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearLogTable(int index) {
        LogTableInterface logTable = this.models[index].logTable;
        if (logTable.isDefined()) {
            String schemaTable = logTable.getQuotedSchemaTableCombination();
            DatabaseMeta databaseMeta = logTable.getDatabaseMeta();
            MessageBox mb = new MessageBox(this.jobGraph.getShell(), 196);
            mb.setMessage(BaseMessages.getString(PKG, (String)"JobGraph.Dialog.AreYouSureYouWantToRemoveAllLogEntries.Message", (String[])new String[]{schemaTable}));
            mb.setText(BaseMessages.getString(PKG, (String)"JobGraph.Dialog.AreYouSureYouWantToRemoveAllLogEntries.Title", (String[])new String[0]));
            if (mb.open() == 64) {
                Database database = new Database(loggingObject, databaseMeta);
                try {
                    database.connect();
                    database.truncateTable(schemaTable);
                }
                catch (Exception e) {
                    new ErrorDialog(this.jobGraph.getShell(), BaseMessages.getString(PKG, (String)"JobGraph.Dialog.ErrorClearningLoggingTable.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobGraph.Dialog.AreYouSureYouWantToRemoveAllLogEntries.Message", (String[])new String[0]), e);
                }
                finally {
                    if (database != null) {
                        database.disconnect();
                    }
                    this.refreshHistory();
                    if (this.wText.get(index) != null) {
                        this.wText.get(index).setText("");
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replayHistory() {
        int tabIndex = this.tabFolder.getSelectionIndex();
        int idx = this.wFields.get(tabIndex).getSelectionIndex();
        if (idx >= 0) {
            String[] fields = this.wFields.get(tabIndex).getItem(idx);
            int batchId = Const.toInt((String)fields[0], (int)-1);
            ArrayList<JobEntryCopyResult> results = null;
            boolean gotResults = false;
            JobEntryLogTable jeLogTable = this.jobMeta.getJobEntryLogTable();
            if (jeLogTable.isDefined()) {
                try {
                    DatabaseMeta databaseMeta = this.jobMeta.getJobEntryLogTable().getDatabaseMeta();
                    Database db = new Database(Spoon.loggingObject, databaseMeta);
                    try {
                        db.connect();
                        String schemaTable = databaseMeta.getQuotedSchemaTableCombination(jeLogTable.getActualSchemaName(), jeLogTable.getActualTableName());
                        String sql = "SELECT * FROM " + schemaTable + " WHERE " + databaseMeta.quoteField(jeLogTable.getKeyField().getFieldName()) + " = " + batchId;
                        List rows = db.getRows(sql, 0);
                        RowMetaInterface rowMeta = db.getReturnRowMeta();
                        results = new ArrayList();
                        int jobEntryNameIndex = rowMeta.indexOfValue(jeLogTable.findField(JobEntryLogTable.ID.JOBENTRYNAME.toString()).getFieldName());
                        int jobEntryResultIndex = rowMeta.indexOfValue(jeLogTable.findField(JobEntryLogTable.ID.RESULT.toString()).getFieldName());
                        int jobEntryErrorsIndex = rowMeta.indexOfValue(jeLogTable.findField(JobEntryLogTable.ID.ERRORS.toString()).getFieldName());
                        LogTableField copyNrField = jeLogTable.findField(JobEntryLogTable.ID.COPY_NR.toString());
                        int jobEntryCopyNrIndex = copyNrField == null ? -1 : (copyNrField.isEnabled() ? rowMeta.indexOfValue(copyNrField.getFieldName()) : -1);
                        for (Object[] row : rows) {
                            String jobEntryName = rowMeta.getString(row, jobEntryNameIndex);
                            boolean jobEntryResult = rowMeta.getBoolean(row, jobEntryResultIndex);
                            long errors = rowMeta.getInteger(row, jobEntryErrorsIndex);
                            long copyNr = jobEntryCopyNrIndex < 0 ? 0L : rowMeta.getInteger(row, jobEntryCopyNrIndex);
                            JobEntryCopyResult result = new JobEntryCopyResult(jobEntryName, jobEntryResult, errors, (int)copyNr);
                            results.add(result);
                        }
                    }
                    finally {
                        db.disconnect();
                    }
                    gotResults = true;
                }
                catch (Exception e) {
                    new ErrorDialog(this.spoon.getShell(), BaseMessages.getString(PKG, (String)"JobHistoryDelegate.ReplayHistory.UnexpectedErrorReadingJobEntryHistory.Text", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JobHistoryDelegate.ReplayHistory.UnexpectedErrorReadingJobEntryHistory.Message", (String[])new String[0]), e);
                }
            } else {
                MessageBox box = new MessageBox(this.spoon.getShell(), 33);
                box.setText(BaseMessages.getString(PKG, (String)"JobHistoryDelegate.ReplayHistory.NoJobEntryTable.Text", (String[])new String[0]));
                box.setMessage(BaseMessages.getString(PKG, (String)"JobHistoryDelegate.ReplayHistory.NoJobEntryTable.Message", (String[])new String[0]));
                box.open();
            }
            if (!gotResults) {
                results = new ArrayList<JobEntryCopyResult>();
                for (JobEntryCopy copy : this.jobMeta.getJobCopies()) {
                    results.add(new JobEntryCopyResult(copy.getName(), null, null, copy.getNr()));
                }
            }
            Object selection = null;
            boolean more = true;
            JobEntryCopy start = this.jobMeta.findStart();
            while (selection == null && more) {
                int nrNext = this.jobMeta.findNrNextJobEntries(start);
                more = nrNext > 0;
                for (int n = 0; n < nrNext; ++n) {
                    JobEntryCopy copy = this.jobMeta.findNextJobEntry(start, n);
                    JobEntryCopyResult result = JobEntryCopyResult.findResult(results, copy);
                    if (result == null) continue;
                }
            }
            for (JobEntryCopyResult result : results) {
                System.out.println("Job entry copy result --  Name=" + result.getJobEntryName() + ", result=" + result.getResult() + ", errors=" + result.getErrors() + ", nr=" + result.getCopyNr());
            }
        }
    }

    public void refreshHistory() {
        int tabIndex = this.tabFolder.getSelectionIndex();
        this.refreshHistory(tabIndex);
    }

    private void refreshAllHistory() {
        for (int i = 0; i < this.models.length; ++i) {
            this.refreshHistory(i);
        }
    }

    private void refreshHistory(final int index) {
        new Thread(new Runnable(){

            public void run() {
                JobHistoryDelegate.this.spoon.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        JobHistoryDelegate.this.setQueryInProgress(true);
                    }
                });
                final boolean moreRows = JobHistoryDelegate.this.getHistoryData(index, Mode.INITIAL);
                JobHistoryDelegate.this.spoon.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        JobHistoryDelegate.this.displayHistoryData(index);
                        JobHistoryDelegate.this.setQueryInProgress(false);
                        JobHistoryDelegate.this.setMoreRows(moreRows);
                    }
                });
            }
        }).start();
    }

    private void setMoreRows(boolean moreRows) {
        this.fetchNextBatchButton.setDisabled(!moreRows);
    }

    private void setQueryInProgress(boolean inProgress) {
        this.refreshButton.setDisabled(inProgress);
        this.fetchNextBatchButton.setDisabled(inProgress);
        this.fetchAllButton.setDisabled(inProgress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getHistoryData(int index, Mode mode) {
        int BATCH_SIZE = Props.getInstance().getLinesInHistoryFetchSize();
        boolean moreRows = false;
        LogTableInterface logTable = this.models[index].logTable;
        if (this.jobMeta != null && !Const.isEmpty((String)this.jobMeta.getName()) && logTable.isDefined()) {
            Database database = null;
            try {
                DatabaseMeta logConnection = logTable.getDatabaseMeta();
                database = new Database(loggingObject, logConnection);
                database.shareVariablesWith((VariableSpace)this.jobMeta);
                database.connect();
                int queryLimit = 0;
                switch (mode) {
                    case ALL: {
                        this.models[index].batchCount = 0;
                        queryLimit = Props.getInstance().getMaxNrLinesInHistory();
                        break;
                    }
                    case NEXT_BATCH: {
                        ++this.models[index].batchCount;
                        queryLimit = BATCH_SIZE * this.models[index].batchCount;
                        break;
                    }
                    case INITIAL: {
                        this.models[index].batchCount = 1;
                        queryLimit = BATCH_SIZE;
                    }
                }
                database.setQueryLimit(queryLimit);
                String schemaTable = logTable.getQuotedSchemaTableCombination();
                String sql = "SELECT ";
                boolean first = true;
                for (LogTableField field : logTable.getFields()) {
                    if (!field.isEnabled() || !field.isVisible()) continue;
                    if (!first) {
                        sql = sql + ", ";
                    }
                    first = false;
                    sql = sql + logConnection.quoteField(field.getFieldName());
                }
                sql = sql + " FROM " + schemaTable;
                RowMetaAndData params = new RowMetaAndData();
                LogTableField nameField = logTable.getNameField();
                LogTableField keyField = logTable.getKeyField();
                if (nameField != null) {
                    sql = sql + " WHERE " + logConnection.quoteField(nameField.getFieldName()) + " LIKE ?";
                    params.addValue(new ValueMeta("transname_literal", 2), (Object)this.jobMeta.getName());
                }
                if (keyField != null && keyField.isEnabled()) {
                    sql = sql + " ORDER BY " + logConnection.quoteField(keyField.getFieldName()) + " DESC";
                }
                ResultSet resultSet = database.openQuery(sql, params.getRowMeta(), params.getData());
                ArrayList<Object[]> rows = new ArrayList<Object[]>();
                Object[] rowData = database.getRow(resultSet);
                int rowsFetched = 1;
                while (rowData != null) {
                    rows.add(rowData);
                    rowData = database.getRow(resultSet);
                    ++rowsFetched;
                }
                if (rowsFetched >= queryLimit) {
                    moreRows = true;
                }
                database.closeQuery(resultSet);
                this.models[index].rows = rows;
            }
            catch (Exception e) {
                LogChannel.GENERAL.logError("Unable to get rows of data from logging table " + this.models[index].logTable, (Throwable)e);
                this.models[index].rows = new ArrayList<Object[]>();
            }
            finally {
                if (database != null) {
                    database.disconnect();
                }
            }
        } else {
            this.models[index].rows = new ArrayList<Object[]>();
        }
        return moreRows;
    }

    private void displayHistoryData(int index) {
        LogTableInterface logTable = this.models[index].logTable;
        List<Object[]> rows = this.models[index].rows;
        ColumnInfo[] colinf = this.columns.get(index);
        if (index >= this.wFields.size() || this.wFields.get(index).isDisposed()) {
            return;
        }
        int selectionIndex = this.wFields.get(index).getSelectionIndex();
        this.wFields.get((int)index).table.clearAll();
        if (rows != null && rows.size() > 0) {
            for (int i = 0; i < rows.size(); ++i) {
                LogTableField statusField;
                Object[] rowData = rows.get(i);
                TableItem item = new TableItem(this.wFields.get((int)index).table, 0);
                for (int c = 0; c < colinf.length; ++c) {
                    ColumnInfo column = colinf[c];
                    ValueMetaInterface valueMeta = column.getValueMeta();
                    String string = null;
                    try {
                        string = valueMeta.getString(rowData[c]);
                    }
                    catch (KettleValueException e) {
                        this.log.logError("history data conversion issue", (Throwable)e);
                    }
                    item.setText(c + 1, Const.NVL((String)string, (String)""));
                }
                Long errors = null;
                LogStatus status = null;
                LogTableField errorsField = logTable.getErrorsField();
                if (errorsField != null) {
                    int index1 = this.models[index].logTableFields.indexOf(errorsField);
                    try {
                        errors = colinf[index1].getValueMeta().getInteger(rowData[index1]);
                    }
                    catch (KettleValueException e) {
                        this.log.logError("history data conversion issue", (Throwable)e);
                    }
                }
                if ((statusField = logTable.getStatusField()) != null) {
                    int index1 = this.models[index].logTableFields.indexOf(statusField);
                    String statusString = null;
                    try {
                        statusString = colinf[index1].getValueMeta().getString(rowData[index1]);
                    }
                    catch (KettleValueException e) {
                        this.log.logError("history data conversion issue", (Throwable)e);
                    }
                    if (statusString != null) {
                        status = LogStatus.findStatus((String)statusString);
                    }
                }
                if (errors != null && errors > 0L) {
                    item.setBackground(GUIResource.getInstance().getColorRed());
                    continue;
                }
                if (status == null || !LogStatus.STOP.equals(status)) continue;
                item.setBackground(GUIResource.getInstance().getColorYellow());
            }
            this.wFields.get(index).removeEmptyRows();
            this.wFields.get(index).setRowNums();
            this.wFields.get(index).optWidth(true);
        } else {
            this.wFields.get(index).clearAll(false);
        }
        if (selectionIndex >= 0 && selectionIndex < this.wFields.get(index).getItemCount()) {
            this.wFields.get((int)index).table.select(selectionIndex);
            this.showLogEntry();
        }
    }

    private void showLogEntry() {
        int tabIndex = this.tabFolder.getSelectionIndex();
        LogTableInterface logTable = this.models[tabIndex].logTable;
        List<LogTableField> fields = this.models[tabIndex].logTableFields;
        Text text = this.wText.get(tabIndex);
        if (text == null || text.isDisposed()) {
            return;
        }
        List<Object[]> list = this.models[tabIndex].rows;
        if (list == null || list.size() == 0) {
            String message = logTable.isDefined() ? BaseMessages.getString(PKG, (String)"JobHistory.PleaseRefresh.Message", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"JobHistory.HistoryConfiguration.Message", (String[])new String[0]);
            text.setText(message);
            return;
        }
        int nr = this.wFields.get((int)tabIndex).table.getSelectionIndex();
        if (nr >= 0 && list != null && nr < list.size()) {
            Object[] row = list.get(nr);
            LogTableField logField = this.models[tabIndex].logTable.getLogField();
            if (logField != null) {
                int index = fields.indexOf(logField);
                if (index >= 0) {
                    String logText = row[index].toString();
                    text.setText(Const.NVL((String)logText, (String)""));
                    text.setSelection(text.getText().length());
                    text.showSelection();
                } else {
                    text.setText(BaseMessages.getString(PKG, (String)"JobHistory.HistoryConfiguration.NoLoggingFieldDefined", (String[])new String[0]));
                }
            }
        }
    }

    public CTabItem getJobHistoryTab() {
        return this.jobHistoryTab;
    }

    public Object getData() {
        return null;
    }

    public String getName() {
        return "history";
    }

    public XulDomContainer getXulDomContainer() {
        return null;
    }

    public void setData(Object data) {
    }

    public void setName(String name) {
    }

    public void setXulDomContainer(XulDomContainer xulDomContainer) {
    }

    public void fetchNextBatch() {
        int tabIndex = this.tabFolder.getSelectionIndex();
        this.fetchNextBatch(tabIndex);
    }

    private void fetchNextBatch(final int index) {
        new Thread(new Runnable(){

            public void run() {
                JobHistoryDelegate.this.spoon.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        JobHistoryDelegate.this.setQueryInProgress(true);
                    }
                });
                final boolean moreRows = JobHistoryDelegate.this.getHistoryData(index, Mode.NEXT_BATCH);
                JobHistoryDelegate.this.spoon.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        JobHistoryDelegate.this.displayHistoryData(index);
                        JobHistoryDelegate.this.setQueryInProgress(false);
                        JobHistoryDelegate.this.setMoreRows(moreRows);
                    }
                });
            }
        }).start();
    }

    public void fetchAll() {
        int tabIndex = this.tabFolder.getSelectionIndex();
        this.fetchAll(tabIndex);
    }

    private void fetchAll(final int index) {
        new Thread(new Runnable(){

            public void run() {
                JobHistoryDelegate.this.spoon.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        JobHistoryDelegate.this.setQueryInProgress(true);
                    }
                });
                final boolean moreRows = JobHistoryDelegate.this.getHistoryData(index, Mode.ALL);
                JobHistoryDelegate.this.spoon.getDisplay().syncExec(new Runnable(){

                    public void run() {
                        JobHistoryDelegate.this.displayHistoryData(index);
                        JobHistoryDelegate.this.setQueryInProgress(false);
                        JobHistoryDelegate.this.setMoreRows(moreRows);
                    }
                });
            }
        }).start();
    }

    private static class TransHistoryModel {
        public List<LogTableField> logTableFields;
        public List<Object[]> rows;
        public LogTableInterface logTable;
        public int batchCount;

        private TransHistoryModel() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Mode {
        INITIAL,
        NEXT_BATCH,
        ALL;

    }
}

