/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.trans;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.geom.Ellipse2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.LineAndShapeRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.performance.StepPerformanceSnapShot;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.util.ImageUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepPerformanceSnapShotDialog
extends Dialog {
    private static Class<?> PKG = Spoon.class;
    private static final int DATA_CHOICE_WRITTEN = 0;
    private static final int DATA_CHOICE_READ = 1;
    private static final int DATA_CHOICE_INPUT = 2;
    private static final int DATA_CHOICE_OUTPUT = 3;
    private static final int DATA_CHOICE_UPDATED = 4;
    private static final int DATA_CHOICE_REJECTED = 5;
    private static final int DATA_CHOICE_INPUT_BUFFER_SIZE = 6;
    private static final int DATA_CHOICE_OUTPUT_BUFFER_SIZE = 7;
    private static String[] dataChoices = new String[]{BaseMessages.getString(PKG, (String)"StepPerformanceSnapShotDialog.Written", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StepPerformanceSnapShotDialog.Read", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StepPerformanceSnapShotDialog.Input", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StepPerformanceSnapShotDialog.Output", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StepPerformanceSnapShotDialog.Updated", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StepPerformanceSnapShotDialog.Rejected", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StepPerformanceSnapShotDialog.InputBufferSize", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StepPerformanceSnapShotDialog.OutputBufferSize", (String[])new String[0])};
    private Shell parent;
    private Shell shell;
    private Map<String, List<StepPerformanceSnapShot>> stepPerformanceSnapShots;
    private Display display;
    private String[] steps;
    private PropsUI props;
    private org.eclipse.swt.widgets.List stepsList;
    private Canvas canvas;
    private Image image;
    private long timeDifference;
    private String title;
    private org.eclipse.swt.widgets.List dataList;

    public StepPerformanceSnapShotDialog(Shell parent, String title, Map<String, List<StepPerformanceSnapShot>> stepPerformanceSnapShots, long timeDifference) {
        super(parent);
        this.parent = parent;
        this.display = parent.getDisplay();
        this.props = PropsUI.getInstance();
        this.timeDifference = timeDifference;
        this.title = title;
        this.stepPerformanceSnapShots = stepPerformanceSnapShots;
        Set<String> stepsSet = stepPerformanceSnapShots.keySet();
        this.steps = stepsSet.toArray(new String[stepsSet.size()]);
        Arrays.sort(this.steps);
    }

    public void open() {
        this.shell = new Shell(this.parent, 3312);
        this.props.setLook((Control)this.shell);
        this.shell.setText(BaseMessages.getString(PKG, (String)"StepPerformanceSnapShotDialog.Title", (String[])new String[0]));
        this.shell.setImage(GUIResource.getInstance().getImageLogoSmall());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.dataList = new org.eclipse.swt.widgets.List((Composite)this.shell, 19202);
        this.props.setLook((Control)this.dataList);
        this.dataList.setItems(dataChoices);
        this.dataList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (StepPerformanceSnapShotDialog.this.dataList.getSelectionCount() > 1 && StepPerformanceSnapShotDialog.this.stepsList.getSelectionCount() > 1) {
                    StepPerformanceSnapShotDialog.this.stepsList.setSelection(StepPerformanceSnapShotDialog.this.stepsList.getSelectionIndices()[0]);
                }
                StepPerformanceSnapShotDialog.this.updateGraph();
            }
        });
        FormData fdDataList = new FormData();
        fdDataList.left = new FormAttachment(0, 0);
        fdDataList.right = new FormAttachment(this.props.getMiddlePct() / 2, 4);
        fdDataList.top = new FormAttachment(0, 0);
        fdDataList.bottom = new FormAttachment(30, 0);
        this.dataList.setLayoutData((Object)fdDataList);
        this.stepsList = new org.eclipse.swt.widgets.List((Composite)this.shell, 19202);
        this.props.setLook((Control)this.stepsList);
        this.stepsList.setItems(this.steps);
        this.stepsList.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (StepPerformanceSnapShotDialog.this.dataList.getSelectionCount() > 1 && StepPerformanceSnapShotDialog.this.stepsList.getSelectionCount() > 1) {
                    StepPerformanceSnapShotDialog.this.dataList.setSelection(StepPerformanceSnapShotDialog.this.dataList.getSelectionIndices()[0]);
                }
                StepPerformanceSnapShotDialog.this.updateGraph();
            }
        });
        FormData fdStepsList = new FormData();
        fdStepsList.left = new FormAttachment(0, 0);
        fdStepsList.right = new FormAttachment(this.props.getMiddlePct() / 2, 4);
        fdStepsList.top = new FormAttachment((Control)this.dataList, 4);
        fdStepsList.bottom = new FormAttachment(100, 4);
        this.stepsList.setLayoutData((Object)fdStepsList);
        this.canvas = new Canvas((Composite)this.shell, 0);
        this.props.setLook((Control)this.canvas);
        FormData fdCanvas = new FormData();
        fdCanvas.left = new FormAttachment(this.props.getMiddlePct() / 2, 0);
        fdCanvas.right = new FormAttachment(100, 0);
        fdCanvas.top = new FormAttachment(0, 0);
        fdCanvas.bottom = new FormAttachment(100, 0);
        this.canvas.setLayoutData((Object)fdCanvas);
        this.shell.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent event) {
                StepPerformanceSnapShotDialog.this.updateGraph();
            }
        });
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent event) {
                if (StepPerformanceSnapShotDialog.this.image != null) {
                    StepPerformanceSnapShotDialog.this.image.dispose();
                }
            }
        });
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent event) {
                if (StepPerformanceSnapShotDialog.this.image != null) {
                    event.gc.drawImage(StepPerformanceSnapShotDialog.this.image, 0, 0);
                }
            }
        });
        Timer timer = new Timer("step performance snapshot dialog Timer");
        timer.schedule(new TimerTask(){

            public void run() {
                StepPerformanceSnapShotDialog.this.updateGraph();
            }
        }, 0L, 5000L);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
    }

    private void updateGraph() {
        this.display.asyncExec(new Runnable(){

            public void run() {
                if (!StepPerformanceSnapShotDialog.this.shell.isDisposed() && !StepPerformanceSnapShotDialog.this.canvas.isDisposed()) {
                    StepPerformanceSnapShotDialog.this.updateCanvas();
                }
            }
        });
    }

    private void updateCanvas() {
        int[] dataIndices;
        Rectangle bounds = this.canvas.getBounds();
        if (bounds.width <= 0 || bounds.height <= 0) {
            return;
        }
        DefaultCategoryDataset dataset = new DefaultCategoryDataset();
        String[] selectedSteps = this.stepsList.getSelection();
        if (selectedSteps == null || selectedSteps.length == 0) {
            selectedSteps = new String[]{this.steps[0]};
            this.stepsList.select(0);
        }
        if ((dataIndices = this.dataList.getSelectionIndices()) == null || dataIndices.length == 0) {
            dataIndices = new int[]{0};
            this.dataList.select(0);
        }
        boolean multiStep = this.stepsList.getSelectionCount() > 1;
        boolean multiData = this.dataList.getSelectionCount() > 1;
        boolean calcMoving = !multiStep && !multiData;
        ArrayList<Double> movingList = new ArrayList<Double>();
        int movingSize = 10;
        double movingTotal = 0.0;
        int totalTimeInSeconds = 0;
        for (int t = 0; t < selectedSteps.length; ++t) {
            String stepNameCopy = selectedSteps[t];
            List<StepPerformanceSnapShot> snapShotList = this.stepPerformanceSnapShots.get(stepNameCopy);
            if (snapShotList == null || snapShotList.size() <= 1) continue;
            totalTimeInSeconds = (int)Math.round((double)(snapShotList.get(snapShotList.size() - 1).getDate().getTime() - snapShotList.get(0).getDate().getTime()) / 1000.0);
            for (int i = 0; i < snapShotList.size(); ++i) {
                StepPerformanceSnapShot snapShot = snapShotList.get(i);
                if (snapShot.getTimeDifference() == 0L) continue;
                double factor = 1000.0 / (double)snapShot.getTimeDifference();
                for (int d = 0; d < dataIndices.length; ++d) {
                    String dataType = multiStep ? stepNameCopy : dataChoices[dataIndices[d]];
                    String xLabel = Integer.toString(Math.round((long)i * this.timeDifference / 1000L));
                    Double metric = null;
                    switch (dataIndices[d]) {
                        case 2: {
                            metric = (double)snapShot.getLinesInput() * factor;
                            break;
                        }
                        case 3: {
                            metric = (double)snapShot.getLinesOutput() * factor;
                            break;
                        }
                        case 1: {
                            metric = (double)snapShot.getLinesRead() * factor;
                            break;
                        }
                        case 0: {
                            metric = (double)snapShot.getLinesWritten() * factor;
                            break;
                        }
                        case 4: {
                            metric = (double)snapShot.getLinesUpdated() * factor;
                            break;
                        }
                        case 5: {
                            metric = (double)snapShot.getLinesRejected() * factor;
                            break;
                        }
                        case 6: {
                            metric = snapShot.getInputBufferSize();
                            break;
                        }
                        case 7: {
                            metric = snapShot.getOutputBufferSize();
                        }
                    }
                    if (metric == null) continue;
                    dataset.addValue((Number)metric, (Comparable)((Object)dataType), (Comparable)((Object)xLabel));
                    if (!calcMoving) continue;
                    movingTotal += metric.doubleValue();
                    movingList.add(metric);
                    if (movingList.size() > movingSize) {
                        movingTotal -= ((Double)movingList.get(0)).doubleValue();
                        movingList.remove(0);
                    }
                    double movingAverage = movingTotal / (double)movingList.size();
                    dataset.addValue(movingAverage, (Comparable)((Object)(dataType + "(Avg)")), (Comparable)((Object)xLabel));
                }
            }
        }
        String chartTitle = this.title;
        chartTitle = multiStep ? chartTitle + " (" + dataChoices[dataIndices[0]] + ")" : chartTitle + " (" + selectedSteps[0] + ")";
        JFreeChart chart = ChartFactory.createLineChart((String)chartTitle, (String)BaseMessages.getString(PKG, (String)"StepPerformanceSnapShotDialog.TimeInSeconds.Label", (String[])new String[]{Integer.toString(totalTimeInSeconds), Long.toString(this.timeDifference)}), (String)BaseMessages.getString(PKG, (String)"StepPerformanceSnapShotDialog.RowsPerSecond.Label", (String[])new String[0]), (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
        chart.setBackgroundPaint((Paint)Color.white);
        CategoryPlot plot = (CategoryPlot)chart.getPlot();
        plot.setBackgroundPaint((Paint)Color.white);
        plot.setForegroundAlpha(0.5f);
        plot.setRangeGridlinesVisible(true);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        CategoryAxis domainAxis = plot.getDomainAxis();
        domainAxis.setTickLabelsVisible(false);
        LineAndShapeRenderer renderer = (LineAndShapeRenderer)plot.getRenderer();
        renderer.setBaseShapesVisible(true);
        renderer.setDrawOutlines(true);
        renderer.setUseFillPaint(true);
        renderer.setBaseFillPaint((Paint)Color.white);
        renderer.setSeriesStroke(0, (Stroke)new BasicStroke(1.5f));
        renderer.setSeriesOutlineStroke(0, (Stroke)new BasicStroke(1.5f));
        renderer.setSeriesStroke(1, (Stroke)new BasicStroke(2.5f));
        renderer.setSeriesOutlineStroke(1, (Stroke)new BasicStroke(2.5f));
        renderer.setSeriesShape(0, (Shape)new Ellipse2D.Double(-3.0, -3.0, 6.0, 6.0));
        BufferedImage bufferedImage = chart.createBufferedImage(bounds.width, bounds.height);
        ImageData imageData = ImageUtil.convertToSWT(bufferedImage);
        if (this.image != null) {
            this.image.dispose();
        }
        this.image = new Image((Device)this.display, imageData);
        this.canvas.redraw();
    }

    public Shell getShell() {
        return this.parent;
    }

    public void setShell(Shell shell) {
        this.parent = shell;
    }

    public Map<String, List<StepPerformanceSnapShot>> getStepPerformanceSnapShots() {
        return this.stepPerformanceSnapShots;
    }

    public void setStepPerformanceSnapShots(Map<String, List<StepPerformanceSnapShot>> stepPerformanceSnapShots) {
        this.stepPerformanceSnapShots = stepPerformanceSnapShots;
    }
}

