/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.spoon.wizards;

import java.util.List;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.spoon.wizards.CopyTableWizard;
import org.pentaho.di.ui.spoon.wizards.CopyTableWizardPage2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyTableWizardPage1
extends WizardPage {
    private static Class<?> PKG = CopyTableWizard.class;
    private org.eclipse.swt.widgets.List wSourceDB;
    private org.eclipse.swt.widgets.List wTargetDB;
    private FormData fdSourceDB;
    private FormData fdTargetDB;
    private PropsUI props = PropsUI.getInstance();
    private List<DatabaseMeta> databases;

    public CopyTableWizardPage1(String arg, PropsUI props, List<DatabaseMeta> databases) {
        this(arg, databases);
    }

    public CopyTableWizardPage1(String arg, List<DatabaseMeta> databases) {
        super(arg);
        this.databases = databases;
        this.setTitle(BaseMessages.getString(PKG, (String)"CopyTableWizardPage1.Dialog.Title", (String[])new String[0]));
        this.setDescription(BaseMessages.getString(PKG, (String)"CopyTableWizardPage1.Dialog.Description", (String[])new String[0]));
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        DatabaseMeta dbInfo;
        int i;
        int margin = 4;
        Composite composite = new Composite(parent, 0);
        this.props.setLook((Control)composite);
        FormLayout compLayout = new FormLayout();
        compLayout.marginHeight = 5;
        compLayout.marginWidth = 5;
        composite.setLayout((Layout)compLayout);
        this.wSourceDB = new org.eclipse.swt.widgets.List(composite, 2820);
        this.props.setLook((Control)this.wSourceDB);
        for (i = 0; i < this.databases.size(); ++i) {
            dbInfo = this.databases.get(i);
            this.wSourceDB.add(dbInfo.getName());
        }
        this.fdSourceDB = new FormData();
        this.fdSourceDB.top = new FormAttachment(0, 0);
        this.fdSourceDB.left = new FormAttachment(0, 0);
        this.fdSourceDB.bottom = new FormAttachment(100, 0);
        this.fdSourceDB.right = new FormAttachment(50, 0);
        this.wSourceDB.setLayoutData((Object)this.fdSourceDB);
        this.wSourceDB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CopyTableWizardPage1.this.setPageComplete(false);
            }
        });
        this.wTargetDB = new org.eclipse.swt.widgets.List(composite, 2820);
        this.props.setLook((Control)this.wTargetDB);
        for (i = 0; i < this.databases.size(); ++i) {
            dbInfo = this.databases.get(i);
            this.wTargetDB.add(dbInfo.getName());
        }
        this.fdTargetDB = new FormData();
        this.fdTargetDB.top = new FormAttachment(0, 0);
        this.fdTargetDB.left = new FormAttachment(50, margin);
        this.fdTargetDB.bottom = new FormAttachment(100, 0);
        this.fdTargetDB.right = new FormAttachment(100, 0);
        this.wTargetDB.setLayoutData((Object)this.fdTargetDB);
        this.wTargetDB.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CopyTableWizardPage1.this.setPageComplete(false);
            }
        });
        this.setControl((Control)composite);
    }

    public boolean canFlipToNextPage() {
        DatabaseMeta source = this.getSourceDatabase();
        DatabaseMeta target = this.getTargetDatabase();
        if (source == null && target == null) {
            this.setErrorMessage(BaseMessages.getString(PKG, (String)"CopyTableWizardPage1.SourceAndTargetIsNull.DialogMessage", (String[])new String[0]));
            return false;
        }
        if (source == null && target != null) {
            this.setErrorMessage(BaseMessages.getString(PKG, (String)"CopyTableWizardPage1.SourceIsNull.DialogMessage", (String[])new String[0]));
            return false;
        }
        if (source != null && target == null) {
            this.setErrorMessage(BaseMessages.getString(PKG, (String)"CopyTableWizardPage1.TargetIsNull.DialogMessage", (String[])new String[0]));
            return false;
        }
        if (source != null && target != null && source.equals((Object)target)) {
            this.setErrorMessage(BaseMessages.getString(PKG, (String)"CopyTableWizardPage1.SourceAndTargetIsSame.DialogMessage", (String[])new String[0]));
            return false;
        }
        this.setErrorMessage(null);
        this.setMessage(BaseMessages.getString(PKG, (String)"CopyTableWizardPage1.GoOnNext.DialogMessage", (String[])new String[0]));
        return true;
    }

    public DatabaseMeta getSourceDatabase() {
        if (this.wSourceDB.getSelection().length == 1) {
            String sourceDbName = this.wSourceDB.getSelection()[0];
            return DatabaseMeta.findDatabase(this.databases, (String)sourceDbName);
        }
        return null;
    }

    public DatabaseMeta getTargetDatabase() {
        if (this.wTargetDB.getSelection().length == 1) {
            String targetDbName = this.wTargetDB.getSelection()[0];
            return DatabaseMeta.findDatabase(this.databases, (String)targetDbName);
        }
        return null;
    }

    public IWizardPage getNextPage() {
        CopyTableWizardPage2 page2 = (CopyTableWizardPage2)super.getNextPage();
        if (page2.getInputData()) {
            page2.getData();
            return page2;
        }
        return this;
    }
}

