/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.step;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.SourceToTargetMapping;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.laf.BasePropertyHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.database.dialog.DatabaseDialog;
import org.pentaho.di.ui.core.dialog.EnterMappingDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.spoon.XulSpoonResourceBundle;
import org.pentaho.di.ui.spoon.XulSpoonSettingsManager;
import org.pentaho.di.ui.trans.step.StepTableDataObject;
import org.pentaho.di.ui.trans.step.TableItemInsertListener;
import org.pentaho.di.ui.trans.step.TableItemInsertXulListener;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.XulRunner;
import org.pentaho.ui.xul.XulSettingsManager;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.components.XulLabel;
import org.pentaho.ui.xul.components.XulMenuList;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.containers.XulTree;
import org.pentaho.ui.xul.containers.XulTreeRow;
import org.pentaho.ui.xul.dom.Element;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.impl.XulEventHandler;
import org.pentaho.ui.xul.swt.SwtBindingFactory;
import org.pentaho.ui.xul.swt.SwtXulLoader;
import org.pentaho.ui.xul.swt.SwtXulRunner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseStepXulDialog
extends AbstractXulEventHandler {
    private static Class<?> PKG = StepInterface.class;
    public static final LoggingObjectInterface loggingObject = new SimpleLoggingObject("Step dialog", LoggingObjectType.STEPDIALOG, null);
    protected static VariableSpace variables = new Variables();
    protected String stepname;
    protected XulLabel wlStepname;
    protected XulTextbox wStepname;
    protected XulButton wOK;
    protected XulButton wGet;
    protected XulButton wPreview;
    protected XulButton wSQL;
    protected XulButton wCreate;
    protected XulButton wCancel;
    protected Listener lsOK;
    protected Listener lsGet;
    protected Listener lsPreview;
    protected Listener lsSQL;
    protected Listener lsCreate;
    protected Listener lsCancel;
    protected TransMeta transMeta;
    protected Shell parentShell;
    protected Listener lsResize;
    protected boolean changed;
    protected boolean backupChanged;
    protected BaseStepMeta baseStepMeta;
    protected PropsUI props;
    protected Repository repository;
    protected StepMeta stepMeta;
    protected LogChannel log;
    protected static final int BUTTON_ALIGNMENT_CENTER = 0;
    protected static final int BUTTON_ALIGNMENT_LEFT = 1;
    protected static final int BUTTON_ALIGNMENT_RIGHT = 2;
    protected static int buttonAlignment = 0;
    protected DatabaseDialog databaseDialog;
    private String xulFile;
    private XulDomContainer container;
    private XulRunner runner;
    protected XulDialog xulDialog;
    protected Shell dialogShell;
    protected BindingFactory bf = new SwtBindingFactory();

    public BaseStepXulDialog(String xulFile, Shell parent, BaseStepMeta baseStepMeta, TransMeta transMeta, String stepname) {
        this.log = new LogChannel((Object)baseStepMeta);
        this.transMeta = transMeta;
        this.stepname = stepname;
        this.stepMeta = transMeta.findStep(stepname);
        this.baseStepMeta = baseStepMeta;
        this.backupChanged = baseStepMeta.hasChanged();
        this.props = PropsUI.getInstance();
        this.xulFile = xulFile;
        this.parentShell = parent;
        try {
            this.initializeXul();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.log.logError("Error initializing (" + stepname + ") step dialog", (Throwable)e);
            throw new IllegalStateException("Cannot load dialog due to error in initialization", e);
        }
    }

    public BaseStepXulDialog(String xulFile, Shell parent, int nr, BaseStepMeta in, TransMeta tr) {
        this(xulFile, parent, in, tr, null);
    }

    private void initializeXul() throws XulException {
        SwtXulLoader loader = new SwtXulLoader();
        loader.registerClassLoader((Object)((Object)((Object)this)).getClass().getClassLoader());
        loader.setSettingsManager((XulSettingsManager)XulSpoonSettingsManager.getInstance());
        loader.setOuterContext((Object)this.parentShell);
        this.container = loader.loadXul(this.xulFile, (Object)new XulSpoonResourceBundle(this.getClassForMessages()));
        this.bf.setDocument(this.container.getDocumentRoot());
        for (XulEventHandler h : this.getEventHandlers()) {
            this.container.addEventHandler(h);
        }
        this.runner = new SwtXulRunner();
        this.runner.addContainer(this.container);
        this.xulDialog = (XulDialog)this.container.getDocumentRoot().getRootElement();
        this.dialogShell = (Shell)this.xulDialog.getRootObject();
        this.runner.initialize();
    }

    protected BindingFactory getBindingFactory() {
        return this.bf;
    }

    protected List<XulEventHandler> getEventHandlers() {
        return Collections.singletonList(this);
    }

    public String getName() {
        return "handler";
    }

    public String open() {
        this.xulDialog.show();
        return this.stepname;
    }

    public void close() {
        this.xulDialog.hide();
    }

    public abstract void onAccept();

    public abstract void onCancel();

    protected abstract Class<?> getClassForMessages();

    public void setShellImage(Shell shell, StepMetaInterface stepMetaInterface) {
        try {
            String id = PluginRegistry.getInstance().getPluginId(StepPluginType.class, (Object)stepMetaInterface);
            if (this.getShell() != null && id != null) {
                this.getShell().setImage(GUIResource.getInstance().getImagesSteps().get(id));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void dispose() {
        Shell shell = (Shell)this.xulDialog.getRootObject();
        if (!shell.isDisposed()) {
            WindowProperty winprop = new WindowProperty(shell);
            this.props.setScreen(winprop);
            ((Composite)this.xulDialog.getManagedObject()).dispose();
            shell.dispose();
        }
    }

    public Shell getShell() {
        return this.dialogShell;
    }

    public void setSize() {
        BaseStepXulDialog.setSize(this.dialogShell);
    }

    protected static int getButtonAlignment() {
        String buttonAlign = BasePropertyHandler.getProperty((String)"Button_Position", (String)"center").toLowerCase();
        if ("center".equals(buttonAlign)) {
            return 0;
        }
        if ("left".equals(buttonAlign)) {
            return 1;
        }
        return 2;
    }

    public void addDatabases(XulMenuList<?> wConnection) {
        this.addDatabases(wConnection, null);
    }

    public void addDatabases(XulMenuList wConnection, Class<? extends DatabaseInterface> databaseType) {
        ArrayList<String> databases = new ArrayList<String>();
        for (int i = 0; i < this.transMeta.nrDatabases(); ++i) {
            DatabaseMeta ci = this.transMeta.getDatabase(i);
            if (databaseType != null && !ci.getDatabaseInterface().getClass().equals(databaseType)) continue;
            databases.add(ci.getName());
        }
        wConnection.setElements(databases);
    }

    public void selectDatabase(XulMenuList wConnection, String name) {
        wConnection.setSelectedItem((Object)wConnection);
    }

    protected DatabaseDialog getDatabaseDialog(Shell shell) {
        if (this.databaseDialog == null) {
            this.databaseDialog = new DatabaseDialog(shell);
        }
        return this.databaseDialog;
    }

    public void storeScreenSize() {
        this.props.setScreen(new WindowProperty(this.dialogShell));
    }

    public Repository getRepository() {
        return this.repository;
    }

    public void setRepository(Repository repository) {
        this.repository = repository;
    }

    public static void setSize(Shell shell) {
        BaseStepXulDialog.setSize(shell, -1, -1, true);
    }

    public static void setSize(Shell shell, int minWidth, int minHeight, boolean packIt) {
        PropsUI props = PropsUI.getInstance();
        WindowProperty winprop = props.getScreen(shell.getText());
        if (winprop != null) {
            winprop.setShell(shell, minWidth, minHeight);
        } else {
            if (packIt) {
                shell.pack();
            } else {
                shell.layout();
            }
            winprop = new WindowProperty(shell);
            winprop.setShell(shell, minWidth, minHeight);
            Rectangle shellBounds = shell.getBounds();
            Monitor monitor = shell.getDisplay().getPrimaryMonitor();
            if (shell.getParent() != null) {
                monitor = shell.getParent().getMonitor();
            }
            Rectangle monitorClientArea = monitor.getClientArea();
            int middleX = monitorClientArea.x + (monitorClientArea.width - shellBounds.width) / 2;
            int middleY = monitorClientArea.y + (monitorClientArea.height - shellBounds.height) / 2;
            shell.setLocation(middleX, middleY);
        }
    }

    public static final void getFieldsFromPrevious(RowMetaInterface row, XulTree tableView, int keyColumn, int[] nameColumn, int[] dataTypeColumn, int lengthColumn, int precisionColumn, TableItemInsertListener listener) {
        if (row == null || row.size() == 0) {
            return;
        }
        Table table = ((TableViewer)tableView.getManagedObject()).getTable();
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < table.getItemCount(); ++i) {
            TableItem tableItem = table.getItem(i);
            String key = tableItem.getText(keyColumn);
            if (Const.isEmpty((String)key) || keys.indexOf(key) >= 0) continue;
            keys.add(key);
        }
        int choice = 0;
        if (keys.size() > 0) {
            Shell shell = ((TableViewer)tableView.getManagedObject()).getTable().getShell();
            MessageDialog md = new MessageDialog(shell, BaseMessages.getString(PKG, (String)"BaseStepDialog.GetFieldsChoice.Title", (String[])new String[0]), null, BaseMessages.getString(PKG, (String)"BaseStepDialog.GetFieldsChoice.Message", (String[])new String[]{"" + keys.size(), "" + row.size()}), 4, new String[]{BaseMessages.getString(PKG, (String)"BaseStepDialog.AddNew", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BaseStepDialog.Add", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BaseStepDialog.ClearAndAdd", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BaseStepDialog.Cancel", (String[])new String[0])}, 0);
            MessageDialog.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
            int idx = md.open();
            choice = idx & 0xFF;
        }
        if (choice == 3 || choice == 255) {
            return;
        }
        if (choice == 2) {
            tableView.getRootChildren().removeAll();
        }
        for (int i = 0; i < row.size(); ++i) {
            int c;
            ValueMetaInterface v = row.getValueMeta(i);
            boolean add = true;
            if (choice == 0 && keys.indexOf(v.getName()) >= 0) {
                add = false;
            }
            if (!add) continue;
            XulTreeRow tRow = tableView.getRootChildren().addNewRow();
            for (c = 0; c < nameColumn.length; ++c) {
                tRow.addCellText(nameColumn[c], Const.NVL((String)v.getName(), (String)""));
            }
            if (dataTypeColumn != null) {
                for (c = 0; c < dataTypeColumn.length; ++c) {
                    tRow.addCellText(dataTypeColumn[c], v.getTypeDesc());
                }
            }
            if (lengthColumn > 0 && v.getLength() >= 0) {
                tRow.addCellText(lengthColumn, Integer.toString(v.getLength()));
            }
            if (precisionColumn > 0 && v.getPrecision() >= 0) {
                tRow.addCellText(precisionColumn, Integer.toString(v.getPrecision()));
            }
            if (listener == null || listener.tableItemInserted(table.getItem(tRow.getParent().getParent().getChildNodes().indexOf(tRow.getParent())), v)) continue;
            tRow.getParent().getParent().removeChild((Element)tRow.getParent());
        }
    }

    public static final void getFieldsFromPrevious(ComboVar comboVar, TransMeta transMeta, StepMeta stepMeta) {
        String selectedField = null;
        int indexField = -1;
        try {
            RowMetaInterface r = transMeta.getPrevStepFields(stepMeta);
            selectedField = comboVar.getText();
            comboVar.removeAll();
            if (r != null && !r.isEmpty()) {
                r.getFieldNames();
                comboVar.setItems(r.getFieldNames());
                indexField = r.indexOfValue(selectedField);
            }
            if (indexField > -1) {
                comboVar.select(indexField);
            } else if (selectedField != null) {
                comboVar.setText(selectedField);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(comboVar.getShell(), BaseMessages.getString(PKG, (String)"BaseStepDialog.FailedToGetFieldsPrevious.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BaseStepDialog.FailedToGetFieldsPrevious.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    public static final void generateFieldMapping(Shell shell, RowMetaInterface sourceFields, RowMetaInterface targetFields, List<SourceToTargetMapping> fieldMapping) throws KettleException {
        String[] source = sourceFields.getFieldNames();
        int i = 0;
        while (i < source.length) {
            ValueMetaInterface v = sourceFields.getValueMeta(i);
            int n = i++;
            source[n] = source[n] + "            (" + v.getOrigin() + ")";
        }
        String[] target = targetFields.getFieldNames();
        EnterMappingDialog dialog = new EnterMappingDialog(shell, source, target, fieldMapping);
        List<SourceToTargetMapping> newMapping = dialog.open();
        if (newMapping != null) {
            fieldMapping.clear();
            fieldMapping.addAll(newMapping);
        }
    }

    public boolean isBasic() {
        return this.log.isBasic();
    }

    public boolean isDetailed() {
        return this.log.isDetailed();
    }

    public boolean isDebug() {
        return this.log.isDebug();
    }

    public boolean isRowLevel() {
        return this.log.isRowLevel();
    }

    public void logMinimal(String message) {
        this.log.logMinimal(message);
    }

    public void logMinimal(String message, Object ... arguments) {
        this.log.logMinimal(message, arguments);
    }

    public void logBasic(String message) {
        this.log.logBasic(message);
    }

    public void logBasic(String message, Object ... arguments) {
        this.log.logBasic(message, arguments);
    }

    public void logDetailed(String message) {
        this.log.logDetailed(message);
    }

    public void logDetailed(String message, Object ... arguments) {
        this.log.logDetailed(message, arguments);
    }

    public void logDebug(String message) {
        this.log.logDebug(message);
    }

    public void logDebug(String message, Object ... arguments) {
        this.log.logDebug(message, arguments);
    }

    public void logRowlevel(String message) {
        this.log.logRowlevel(message);
    }

    public void logRowlevel(String message, Object ... arguments) {
        this.log.logRowlevel(message, arguments);
    }

    public void logError(String message) {
        this.log.logError(message);
    }

    public void logError(String message, Throwable e) {
        this.log.logError(message, e);
    }

    public void logError(String message, Object ... arguments) {
        this.log.logError(message, arguments);
    }

    public static void getFieldsFromPrevious(RowMetaInterface row, XulTree tableView, List<Object> fields, StepTableDataObject field, TableItemInsertXulListener listener) {
        if (row == null || row.size() == 0) {
            return;
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (Object entry : fields) {
            keys.add(((StepTableDataObject)entry).getName());
        }
        int choice = 0;
        if (keys.size() > 0) {
            Shell shell = ((TableViewer)tableView.getManagedObject()).getTable().getShell();
            MessageDialog md = new MessageDialog(shell, BaseMessages.getString(PKG, (String)"BaseStepDialog.GetFieldsChoice.Title", (String[])new String[0]), null, BaseMessages.getString(PKG, (String)"BaseStepDialog.GetFieldsChoice.Message", (String[])new String[]{"" + keys.size(), "" + row.size()}), 4, new String[]{BaseMessages.getString(PKG, (String)"BaseStepDialog.AddNew", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BaseStepDialog.Add", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BaseStepDialog.ClearAndAdd", (String[])new String[0]), BaseMessages.getString(PKG, (String)"BaseStepDialog.Cancel", (String[])new String[0])}, 0);
            MessageDialog.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
            int idx = md.open();
            choice = idx & 0xFF;
        }
        if (choice == 3 || choice == 255) {
            return;
        }
        if (choice == 2) {
            fields.clear();
        }
        for (int i = 0; i < row.size(); ++i) {
            ValueMetaInterface v = row.getValueMeta(i);
            if (choice == 0 && keys.indexOf(v.getName()) >= 0 || listener != null && !listener.tableItemInsertedFor(v)) continue;
            StepTableDataObject newField = field.createNew(v);
            fields.add(newField);
        }
    }

    static {
        buttonAlignment = BaseStepXulDialog.getButtonAlignment();
    }
}

