/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.step;

import java.util.List;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepErrorMeta;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepErrorMetaDialog
extends Dialog {
    private static Class<?> PKG = StepInterface.class;
    private StepErrorMeta stepErrorMeta;
    private List<StepMeta> targetSteps;
    private Composite composite;
    private Shell shell;
    private Text wSourceStep;
    private CCombo wTargetStep;
    private Button wEnabled;
    private TextVar wNrErrors;
    private TextVar wErrDesc;
    private TextVar wErrFields;
    private TextVar wErrCodes;
    private TextVar wMaxErrors;
    private TextVar wMaxPct;
    private TextVar wMinPctRows;
    private Button wOK;
    private Button wCancel;
    private ModifyListener lsMod;
    private PropsUI props;
    private int middle;
    private int margin;
    private StepErrorMeta originalStepErrorMeta;
    private boolean ok;
    private TransMeta transMeta;

    public StepErrorMetaDialog(Shell par, StepErrorMeta stepErrorMeta, TransMeta transMeta, List<StepMeta> targetSteps) {
        super(par, 0);
        this.stepErrorMeta = stepErrorMeta.clone();
        this.originalStepErrorMeta = stepErrorMeta;
        this.targetSteps = targetSteps;
        this.transMeta = transMeta;
        this.props = PropsUI.getInstance();
        this.ok = false;
    }

    public boolean open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StepErrorMetaDialog.this.stepErrorMeta.setChanged();
            }
        };
        this.middle = this.props.getMiddlePct();
        this.margin = 4;
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setText(BaseMessages.getString(PKG, (String)"BaseStepDialog.ErrorHandling.Title.Label", (String[])new String[0]));
        this.shell.setImage(GUIResource.getInstance().getImageTransGraph());
        this.shell.setLayout((Layout)formLayout);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(" &OK ");
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(" &Cancel ");
        Button[] buttons = new Button[]{this.wOK, this.wCancel};
        BaseStepDialog.positionBottomButtons((Composite)this.shell, buttons, this.margin, null);
        this.composite = new Composite((Composite)this.shell, 0);
        this.props.setLook((Control)this.composite);
        this.composite.setLayout((Layout)new FormLayout());
        Label wlSourceStep = new Label(this.composite, 131072);
        this.props.setLook((Control)wlSourceStep);
        wlSourceStep.setText(BaseMessages.getString(PKG, (String)"BaseStepDialog.ErrorHandling.StepName.Label", (String[])new String[0]));
        FormData fdlSourceStep = new FormData();
        fdlSourceStep.top = new FormAttachment(0, 0);
        fdlSourceStep.left = new FormAttachment(0, 0);
        fdlSourceStep.right = new FormAttachment(this.middle, -this.margin);
        wlSourceStep.setLayoutData((Object)fdlSourceStep);
        this.wSourceStep = new Text(this.composite, 18436);
        this.props.setLook((Control)this.wSourceStep);
        this.wSourceStep.addModifyListener(this.lsMod);
        FormData fdSourceStep = new FormData();
        fdSourceStep.top = new FormAttachment(0, 0);
        fdSourceStep.left = new FormAttachment(this.middle, 0);
        fdSourceStep.right = new FormAttachment(95, 0);
        this.wSourceStep.setLayoutData((Object)fdSourceStep);
        this.wSourceStep.setEnabled(false);
        Label wlTargetStep = new Label(this.composite, 131072);
        this.props.setLook((Control)wlTargetStep);
        wlTargetStep.setText(BaseMessages.getString(PKG, (String)"BaseStepDialog.ErrorHandling.TargetStep.Label", (String[])new String[0]));
        FormData fdlTargetStep = new FormData();
        fdlTargetStep.top = new FormAttachment((Control)this.wSourceStep, this.margin);
        fdlTargetStep.left = new FormAttachment(0, 0);
        fdlTargetStep.right = new FormAttachment(this.middle, -this.margin);
        wlTargetStep.setLayoutData((Object)fdlTargetStep);
        this.wTargetStep = new CCombo(this.composite, 18436);
        this.props.setLook((Control)this.wTargetStep);
        this.wTargetStep.addModifyListener(this.lsMod);
        FormData fdTargetStep = new FormData();
        fdTargetStep.top = new FormAttachment((Control)this.wSourceStep, this.margin);
        fdTargetStep.left = new FormAttachment(this.middle, 0);
        fdTargetStep.right = new FormAttachment(95, 0);
        this.wTargetStep.setLayoutData((Object)fdTargetStep);
        for (int i = 0; i < this.targetSteps.size(); ++i) {
            this.wTargetStep.add(this.targetSteps.get(i).getName());
        }
        Label wlEnabled = new Label(this.composite, 131072);
        this.props.setLook((Control)wlEnabled);
        wlEnabled.setText(BaseMessages.getString(PKG, (String)"BaseStepDialog.ErrorHandling.Enable.Label", (String[])new String[0]));
        FormData fdlEnabled = new FormData();
        fdlEnabled.top = new FormAttachment((Control)this.wTargetStep, this.margin);
        fdlEnabled.left = new FormAttachment(0, 0);
        fdlEnabled.right = new FormAttachment(this.middle, -this.margin);
        wlEnabled.setLayoutData((Object)fdlEnabled);
        this.wEnabled = new Button(this.composite, 32);
        this.props.setLook((Control)this.wEnabled);
        FormData fdEnabled = new FormData();
        fdEnabled.top = new FormAttachment((Control)this.wTargetStep, this.margin);
        fdEnabled.left = new FormAttachment(this.middle, 0);
        this.wEnabled.setLayoutData((Object)fdEnabled);
        Label wlNrErrors = new Label(this.composite, 131072);
        this.props.setLook((Control)wlNrErrors);
        wlNrErrors.setText(BaseMessages.getString(PKG, (String)"BaseStepDialog.ErrorHandling.NrErrField.Label", (String[])new String[0]));
        FormData fdlNrErrors = new FormData();
        fdlNrErrors.top = new FormAttachment((Control)this.wEnabled, this.margin * 2);
        fdlNrErrors.left = new FormAttachment(0, 0);
        fdlNrErrors.right = new FormAttachment(this.middle, -this.margin);
        wlNrErrors.setLayoutData((Object)fdlNrErrors);
        this.wNrErrors = new TextVar((VariableSpace)this.transMeta, this.composite, 18436);
        this.props.setLook((Control)this.wNrErrors);
        this.wNrErrors.addModifyListener(this.lsMod);
        FormData fdNrErrors = new FormData();
        fdNrErrors.top = new FormAttachment((Control)this.wEnabled, this.margin * 2);
        fdNrErrors.left = new FormAttachment(this.middle, 0);
        fdNrErrors.right = new FormAttachment(95, 0);
        this.wNrErrors.setLayoutData(fdNrErrors);
        Label wlErrDesc = new Label(this.composite, 131072);
        this.props.setLook((Control)wlErrDesc);
        wlErrDesc.setText(BaseMessages.getString(PKG, (String)"BaseStepDialog.ErrorHandling.ErrDescField.Label", (String[])new String[0]));
        FormData fdlErrDesc = new FormData();
        fdlErrDesc.top = new FormAttachment((Control)this.wNrErrors, this.margin);
        fdlErrDesc.left = new FormAttachment(0, 0);
        fdlErrDesc.right = new FormAttachment(this.middle, -this.margin);
        wlErrDesc.setLayoutData((Object)fdlErrDesc);
        this.wErrDesc = new TextVar((VariableSpace)this.transMeta, this.composite, 18436);
        this.props.setLook((Control)this.wErrDesc);
        this.wErrDesc.addModifyListener(this.lsMod);
        FormData fdErrDesc = new FormData();
        fdErrDesc.top = new FormAttachment((Control)this.wNrErrors, this.margin);
        fdErrDesc.left = new FormAttachment(this.middle, 0);
        fdErrDesc.right = new FormAttachment(95, 0);
        this.wErrDesc.setLayoutData(fdErrDesc);
        Label wlErrFields = new Label(this.composite, 131072);
        wlErrFields.setText(BaseMessages.getString(PKG, (String)"BaseStepDialog.ErrorHandling.ErrFieldName.Label", (String[])new String[0]));
        this.props.setLook((Control)wlErrFields);
        FormData fdlErrFields = new FormData();
        fdlErrFields.top = new FormAttachment((Control)this.wErrDesc, this.margin);
        fdlErrFields.left = new FormAttachment(0, 0);
        fdlErrFields.right = new FormAttachment(this.middle, -this.margin);
        wlErrFields.setLayoutData((Object)fdlErrFields);
        this.wErrFields = new TextVar((VariableSpace)this.transMeta, this.composite, 18436);
        this.props.setLook((Control)this.wErrFields);
        this.wErrFields.addModifyListener(this.lsMod);
        FormData fdErrFields = new FormData();
        fdErrFields.top = new FormAttachment((Control)this.wErrDesc, this.margin);
        fdErrFields.left = new FormAttachment(this.middle, 0);
        fdErrFields.right = new FormAttachment(95, 0);
        this.wErrFields.setLayoutData(fdErrFields);
        Label wlErrCodes = new Label(this.composite, 131072);
        wlErrCodes.setText(BaseMessages.getString(PKG, (String)"BaseStepDialog.ErrorHandling.ErrCodeFieldName.Label", (String[])new String[0]));
        this.props.setLook((Control)wlErrCodes);
        FormData fdlErrCodes = new FormData();
        fdlErrCodes.top = new FormAttachment((Control)this.wErrFields, this.margin);
        fdlErrCodes.left = new FormAttachment(0, 0);
        fdlErrCodes.right = new FormAttachment(this.middle, -this.margin);
        wlErrCodes.setLayoutData((Object)fdlErrCodes);
        this.wErrCodes = new TextVar((VariableSpace)this.transMeta, this.composite, 18436);
        this.props.setLook((Control)this.wErrCodes);
        this.wErrCodes.addModifyListener(this.lsMod);
        FormData fdErrCodes = new FormData();
        fdErrCodes.top = new FormAttachment((Control)this.wErrFields, this.margin);
        fdErrCodes.left = new FormAttachment(this.middle, 0);
        fdErrCodes.right = new FormAttachment(95, 0);
        this.wErrCodes.setLayoutData(fdErrCodes);
        Label wlMaxErrors = new Label(this.composite, 131072);
        wlMaxErrors.setText(BaseMessages.getString(PKG, (String)"BaseStepDialog.ErrorHandling.MaxErr.Label", (String[])new String[0]));
        this.props.setLook((Control)wlMaxErrors);
        FormData fdlMaxErrors = new FormData();
        fdlMaxErrors.top = new FormAttachment((Control)this.wErrCodes, this.margin);
        fdlMaxErrors.left = new FormAttachment(0, 0);
        fdlMaxErrors.right = new FormAttachment(this.middle, -this.margin);
        wlMaxErrors.setLayoutData((Object)fdlMaxErrors);
        this.wMaxErrors = new TextVar((VariableSpace)this.transMeta, this.composite, 18436);
        this.props.setLook((Control)this.wMaxErrors);
        this.wMaxErrors.addModifyListener(this.lsMod);
        FormData fdMaxErrors = new FormData();
        fdMaxErrors.top = new FormAttachment((Control)this.wErrCodes, this.margin);
        fdMaxErrors.left = new FormAttachment(this.middle, 0);
        fdMaxErrors.right = new FormAttachment(95, 0);
        this.wMaxErrors.setLayoutData(fdMaxErrors);
        Label wlMaxPct = new Label(this.composite, 131072);
        wlMaxPct.setText(BaseMessages.getString(PKG, (String)"BaseStepDialog.ErrorHandling.MaxPctErr.Label", (String[])new String[0]));
        this.props.setLook((Control)wlMaxPct);
        FormData fdlMaxPct = new FormData();
        fdlMaxPct.top = new FormAttachment((Control)this.wMaxErrors, this.margin);
        fdlMaxPct.left = new FormAttachment(0, 0);
        fdlMaxPct.right = new FormAttachment(this.middle, -this.margin);
        wlMaxPct.setLayoutData((Object)fdlMaxPct);
        this.wMaxPct = new TextVar((VariableSpace)this.transMeta, this.composite, 18436);
        this.props.setLook((Control)this.wMaxPct);
        this.wMaxPct.addModifyListener(this.lsMod);
        FormData fdMaxPct = new FormData();
        fdMaxPct.top = new FormAttachment((Control)this.wMaxErrors, this.margin);
        fdMaxPct.left = new FormAttachment(this.middle, 0);
        fdMaxPct.right = new FormAttachment(95, 0);
        this.wMaxPct.setLayoutData(fdMaxPct);
        Label wlMinPctRows = new Label(this.composite, 131072);
        wlMinPctRows.setText(BaseMessages.getString(PKG, (String)"BaseStepDialog.ErrorHandling.MinErr.Label", (String[])new String[0]));
        this.props.setLook((Control)wlMinPctRows);
        FormData fdlMinPctRows = new FormData();
        fdlMinPctRows.top = new FormAttachment((Control)this.wMaxPct, this.margin);
        fdlMinPctRows.left = new FormAttachment(0, 0);
        fdlMinPctRows.right = new FormAttachment(this.middle, -this.margin);
        wlMinPctRows.setLayoutData((Object)fdlMinPctRows);
        this.wMinPctRows = new TextVar((VariableSpace)this.transMeta, this.composite, 18436);
        this.props.setLook((Control)this.wMinPctRows);
        this.wMinPctRows.addModifyListener(this.lsMod);
        FormData fdMinPctRows = new FormData();
        fdMinPctRows.top = new FormAttachment((Control)this.wMaxPct, this.margin);
        fdMinPctRows.left = new FormAttachment(this.middle, 0);
        fdMinPctRows.right = new FormAttachment(95, 0);
        this.wMinPctRows.setLayoutData(fdMinPctRows);
        FormData fdComposite = new FormData();
        fdComposite.left = new FormAttachment(0, 0);
        fdComposite.top = new FormAttachment(0, 0);
        fdComposite.right = new FormAttachment(100, 0);
        fdComposite.bottom = new FormAttachment((Control)this.wOK, -this.margin);
        this.composite.setLayoutData((Object)fdComposite);
        this.wOK.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                StepErrorMetaDialog.this.ok();
            }
        });
        this.wCancel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                StepErrorMetaDialog.this.cancel();
            }
        });
        SelectionAdapter selAdapter = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                StepErrorMetaDialog.this.ok();
            }
        };
        this.wErrFields.addSelectionListener(selAdapter);
        this.wErrCodes.addSelectionListener(selAdapter);
        this.wNrErrors.addSelectionListener(selAdapter);
        this.wErrDesc.addSelectionListener(selAdapter);
        this.wMaxErrors.addSelectionListener(selAdapter);
        this.wMaxPct.addSelectionListener(selAdapter);
        this.wMinPctRows.addSelectionListener(selAdapter);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                StepErrorMetaDialog.this.cancel();
            }
        });
        this.getData();
        BaseStepDialog.setSize(this.shell);
        this.shell.open();
        Display display = parent.getDisplay();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.ok;
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    public void getData() {
        this.wSourceStep.setText(this.stepErrorMeta.getSourceStep() != null ? this.stepErrorMeta.getSourceStep().getName() : "");
        this.wTargetStep.setText(this.stepErrorMeta.getTargetStep() != null ? this.stepErrorMeta.getTargetStep().getName() : "");
        this.wEnabled.setSelection(this.stepErrorMeta.isEnabled());
        this.wNrErrors.setText(Const.NVL((String)this.stepErrorMeta.getNrErrorsValuename(), (String)""));
        this.wErrDesc.setText(Const.NVL((String)this.stepErrorMeta.getErrorDescriptionsValuename(), (String)""));
        this.wErrFields.setText(Const.NVL((String)this.stepErrorMeta.getErrorFieldsValuename(), (String)""));
        this.wErrCodes.setText(Const.NVL((String)this.stepErrorMeta.getErrorCodesValuename(), (String)""));
        this.wMaxErrors.setText(this.stepErrorMeta.getMaxErrors() != null ? this.stepErrorMeta.getMaxErrors() : "");
        this.wMaxPct.setText(this.stepErrorMeta.getMaxPercentErrors() != null ? this.stepErrorMeta.getMaxPercentErrors() : "");
        this.wMinPctRows.setText(this.stepErrorMeta.getMinPercentRows() != null ? this.stepErrorMeta.getMinPercentRows() : "");
        this.wSourceStep.setFocus();
    }

    private void cancel() {
        this.originalStepErrorMeta = null;
        this.dispose();
    }

    public void ok() {
        this.getInfo();
        this.originalStepErrorMeta.setTargetStep(this.stepErrorMeta.getTargetStep());
        this.originalStepErrorMeta.setEnabled(this.stepErrorMeta.isEnabled());
        this.originalStepErrorMeta.setNrErrorsValuename(this.stepErrorMeta.getNrErrorsValuename());
        this.originalStepErrorMeta.setErrorDescriptionsValuename(this.stepErrorMeta.getErrorDescriptionsValuename());
        this.originalStepErrorMeta.setErrorFieldsValuename(this.stepErrorMeta.getErrorFieldsValuename());
        this.originalStepErrorMeta.setErrorCodesValuename(this.stepErrorMeta.getErrorCodesValuename());
        this.originalStepErrorMeta.setMaxErrors(this.stepErrorMeta.getMaxErrors());
        this.originalStepErrorMeta.setMaxPercentErrors(this.stepErrorMeta.getMaxPercentErrors());
        this.originalStepErrorMeta.setMinPercentRows(this.stepErrorMeta.getMinPercentRows());
        this.originalStepErrorMeta.setChanged();
        this.ok = true;
        this.dispose();
    }

    private void getInfo() {
        this.stepErrorMeta.setTargetStep(StepMeta.findStep(this.targetSteps, (String)this.wTargetStep.getText()));
        this.stepErrorMeta.setEnabled(this.wEnabled.getSelection());
        this.stepErrorMeta.setNrErrorsValuename(this.wNrErrors.getText());
        this.stepErrorMeta.setErrorDescriptionsValuename(this.wErrDesc.getText());
        this.stepErrorMeta.setErrorFieldsValuename(this.wErrFields.getText());
        this.stepErrorMeta.setErrorCodesValuename(this.wErrCodes.getText());
        this.stepErrorMeta.setMaxErrors(this.wMaxErrors.getText());
        this.stepErrorMeta.setMaxPercentErrors(Const.replace((String)this.wMaxPct.getText(), (String)"%", (String)""));
        this.stepErrorMeta.setMinPercentRows(this.wMinPctRows.getText());
    }
}

