/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.aggregaterows;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.aggregaterows.AggregateRowsMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class AggregateRowsDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = AggregateRowsMeta.class;
    private Label wlFields;
    private TableView wFields;
    private FormData fdlFields;
    private FormData fdFields;
    private AggregateRowsMeta input;

    public AggregateRowsDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.input = (AggregateRowsMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AggregateRowsDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"AggregateRowsDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"AggregateRowsDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"AggregateRowsDialog.GetButton.Label", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wGet, this.wCancel}, margin, null);
        this.wlFields = new Label((Composite)this.shell, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"AggregateRowsDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFields);
        this.fdlFields = new FormData();
        this.fdlFields.left = new FormAttachment(0, 0);
        this.fdlFields.top = new FormAttachment((Control)this.wStepname, margin);
        this.wlFields.setLayoutData((Object)this.fdlFields);
        int FieldsCols = 3;
        int FieldsRows = this.input.getFieldName().length;
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"AggregateRowsDialog.ColumnInfo.Name", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AggregateRowsDialog.ColumnInfo.NewName", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"AggregateRowsDialog.ColumnInfo.AgrregateType", (String[])new String[0]), 2, AggregateRowsMeta.aggregateTypeDesc)};
        this.wFields = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 67586, colinf, FieldsRows, lsMod, this.props);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        this.fdFields.right = new FormAttachment(100, 0);
        this.fdFields.bottom = new FormAttachment((Control)this.wOK, -2 * margin);
        this.wFields.setLayoutData(this.fdFields);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                AggregateRowsDialog.this.cancel();
            }
        };
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                AggregateRowsDialog.this.get();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                AggregateRowsDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wGet.addListener(13, this.lsGet);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                AggregateRowsDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                AggregateRowsDialog.this.cancel();
            }
        });
        this.lsResize = new Listener(){

            public void handleEvent(Event event) {
                Point size = AggregateRowsDialog.this.shell.getSize();
                AggregateRowsDialog.this.wFields.setSize(size.x - 10, size.y - 50);
                ((AggregateRowsDialog)AggregateRowsDialog.this).wFields.table.setSize(size.x - 10, size.y - 50);
                AggregateRowsDialog.this.wFields.redraw();
            }
        };
        this.shell.addListener(11, this.lsResize);
        this.setSize();
        this.getData();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void getData() {
        TableItem ti;
        Table table = this.wFields.table;
        table.removeAll();
        for (int i = 0; i < this.input.getFieldName().length; ++i) {
            ti = new TableItem(table, 0);
            ti.setText(0, "" + (i + 1));
            if (this.input.getFieldName()[i] != null) {
                ti.setText(1, this.input.getFieldName()[i]);
            }
            if (this.input.getFieldNewName()[i] != null && !this.input.getFieldNewName()[i].equals(this.input.getFieldName()[i])) {
                ti.setText(2, this.input.getFieldNewName()[i]);
            }
            ti.setText(3, AggregateRowsMeta.aggregateTypeDesc[this.input.getAggregateType()[i]]);
        }
        if (table.getItemCount() == 0) {
            ti = new TableItem(table, 0);
            ti.setText(0, "001");
        }
        this.wStepname.selectAll();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        int nrfields = this.wFields.nrNonEmpty();
        this.stepname = this.wStepname.getText();
        this.input.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            this.input.getFieldName()[i] = item.getText(1);
            this.input.getFieldNewName()[i] = item.getText(2);
            if (this.input.getFieldNewName()[i] == null || this.input.getFieldNewName()[i].length() == 0) {
                this.input.getFieldNewName()[i] = this.input.getFieldName()[i];
            }
            this.input.getAggregateType()[i] = AggregateRowsMeta.getType((String)item.getText(3));
        }
        this.dispose();
    }

    private void get() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null && r.size() > 0) {
                BaseStepDialog.getFieldsFromPrevious(r, this.wFields, 1, new int[]{1, 2}, new int[0], -1, -1, null);
            } else {
                MessageBox mb = new MessageBox(this.shell, 34);
                mb.setMessage(BaseMessages.getString(PKG, (String)"AggregateRowsDialog.CouldNotRetrieveFields.DialogMessage", (String[])new String[]{Const.CR}));
                mb.setText(BaseMessages.getString(PKG, (String)"AggregateRowsDialog.CouldNotRetrieveFields.DialogTitle", (String[])new String[0]));
                mb.open();
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"AggregateRowsDialog.GetFieldsFailed.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"AggregateRowsDialog.GetFieldsFailed.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

