/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.calculator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.calculator.CalculatorMeta;
import org.pentaho.di.trans.steps.calculator.CalculatorMetaFunction;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class CalculatorDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = CalculatorMeta.class;
    private Label wlStepname;
    private Text wStepname;
    private FormData fdlStepname;
    private FormData fdStepname;
    private Label wlFields;
    private TableView wFields;
    private FormData fdlFields;
    private FormData fdFields;
    private CalculatorMeta currentMeta;
    private CalculatorMeta originalMeta;
    private Map<String, Integer> inputFields;
    private ColumnInfo[] colinf;

    public CalculatorDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.currentMeta = (CalculatorMeta)in;
        this.originalMeta = (CalculatorMeta)this.currentMeta.clone();
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.currentMeta);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CalculatorDialog.this.currentMeta.setChanged();
            }
        };
        this.changed = this.currentMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"CalculatorDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"System.Label.StepName", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wlFields = new Label((Composite)this.shell, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"CalculatorDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFields);
        this.fdlFields = new FormData();
        this.fdlFields.left = new FormAttachment(0, 0);
        this.fdlFields.top = new FormAttachment((Control)this.wStepname, margin);
        this.wlFields.setLayoutData((Object)this.fdlFields);
        int FieldsRows = this.currentMeta.getCalculation() != null ? this.currentMeta.getCalculation().length : 1;
        this.colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"CalculatorDialog.NewFieldColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CalculatorDialog.CalculationColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CalculatorDialog.FieldAColumn.Column", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CalculatorDialog.FieldBColumn.Column", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CalculatorDialog.FieldCColumn.Column", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CalculatorDialog.ValueTypeColumn.Column", (String[])new String[0]), 2, ValueMeta.getTypes()), new ColumnInfo(BaseMessages.getString(PKG, (String)"CalculatorDialog.LengthColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CalculatorDialog.PrecisionColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CalculatorDialog.RemoveColumn.Column", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0])}), new ColumnInfo(BaseMessages.getString(PKG, (String)"CalculatorDialog.ConversionMask.Column", (String[])new String[0]), 5, 6), new ColumnInfo(BaseMessages.getString(PKG, (String)"CalculatorDialog.DecimalSymbol.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CalculatorDialog.GroupingSymbol.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"CalculatorDialog.CurrencySymbol.Column", (String[])new String[0]), 1, false)};
        this.colinf[1].setSelectionAdapter((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EnterSelectionDialog esd = new EnterSelectionDialog(CalculatorDialog.this.shell, CalculatorMetaFunction.calcLongDesc, BaseMessages.getString((Class)PKG, (String)"CalculatorDialog.SelectCalculationType.Title", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"CalculatorDialog.SelectCalculationType.Message", (String[])new String[0]));
                String string = esd.open();
                if (string != null) {
                    TableView tv = (TableView)e.widget;
                    tv.setText(string, e.x, e.y);
                    CalculatorDialog.this.currentMeta.setChanged();
                }
            }
        });
        this.wFields = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 67586, this.colinf, FieldsRows, lsMod, this.props);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        this.fdFields.right = new FormAttachment(100, 0);
        this.fdFields.bottom = new FormAttachment(100, -50);
        this.wFields.setLayoutData(this.fdFields);
        Runnable runnable = new Runnable(){

            public void run() {
                StepMeta stepMeta = CalculatorDialog.this.transMeta.findStep(CalculatorDialog.this.stepname);
                if (stepMeta != null) {
                    try {
                        RowMetaInterface row = CalculatorDialog.this.transMeta.getPrevStepFields(stepMeta);
                        for (int i = 0; i < row.size(); ++i) {
                            CalculatorDialog.this.inputFields.put(row.getValueMeta(i).getName(), i);
                        }
                        CalculatorDialog.this.setComboBoxes();
                    }
                    catch (KettleException e) {
                        CalculatorDialog.this.logError(BaseMessages.getString((Class)PKG, (String)"CalculatorDialog.Log.UnableToFindInput", (String[])new String[0]));
                    }
                }
            }
        };
        new Thread(runnable).start();
        this.wFields.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                CalculatorDialog.this.shell.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        CalculatorDialog.this.setComboBoxes();
                    }
                });
            }
        });
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, null);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                CalculatorDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                CalculatorDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                CalculatorDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                CalculatorDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.currentMeta.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected void setComboBoxes() {
        final HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        this.shell.getDisplay().syncExec(new Runnable(){

            public void run() {
                int nrNonEmptyFields = CalculatorDialog.this.wFields.nrNonEmpty();
                for (int i = 0; i < nrNonEmptyFields; ++i) {
                    TableItem item = CalculatorDialog.this.wFields.getNonEmpty(i);
                    fields.put(item.getText(1), 1000000 + i);
                }
            }
        });
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.colinf[2].setComboValues(fieldNames);
        this.colinf[3].setComboValues(fieldNames);
        this.colinf[4].setComboValues(fieldNames);
    }

    public void getData() {
        this.wStepname.selectAll();
        if (this.currentMeta.getCalculation() != null) {
            for (int i = 0; i < this.currentMeta.getCalculation().length; ++i) {
                CalculatorMetaFunction fn = this.currentMeta.getCalculation()[i];
                TableItem item = this.wFields.table.getItem(i);
                item.setText(1, Const.NVL((String)fn.getFieldName(), (String)""));
                item.setText(2, Const.NVL((String)fn.getCalcTypeLongDesc(), (String)""));
                item.setText(3, Const.NVL((String)fn.getFieldA(), (String)""));
                item.setText(4, Const.NVL((String)fn.getFieldB(), (String)""));
                item.setText(5, Const.NVL((String)fn.getFieldC(), (String)""));
                item.setText(6, Const.NVL((String)ValueMeta.getTypeDesc((int)fn.getValueType()), (String)""));
                if (fn.getValueLength() >= 0) {
                    item.setText(7, "" + fn.getValueLength());
                }
                if (fn.getValuePrecision() >= 0) {
                    item.setText(8, "" + fn.getValuePrecision());
                }
                item.setText(9, fn.isRemovedFromResult() ? BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]));
                item.setText(10, Const.NVL((String)fn.getConversionMask(), (String)""));
                item.setText(11, Const.NVL((String)fn.getDecimalSymbol(), (String)""));
                item.setText(12, Const.NVL((String)fn.getGroupingSymbol(), (String)""));
                item.setText(13, Const.NVL((String)fn.getCurrencySymbol(), (String)""));
            }
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
    }

    private void cancel() {
        this.stepname = null;
        this.currentMeta.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        int nrNonEmptyFields = this.wFields.nrNonEmpty();
        this.currentMeta.allocate(nrNonEmptyFields);
        for (int i = 0; i < nrNonEmptyFields; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            String fieldName = item.getText(1);
            int calcType = CalculatorMetaFunction.getCalcFunctionType((String)item.getText(2));
            String fieldA = item.getText(3);
            String fieldB = item.getText(4);
            String fieldC = item.getText(5);
            int valueType = ValueMeta.getType((String)item.getText(6));
            int valueLength = Const.toInt((String)item.getText(7), (int)-1);
            int valuePrecision = Const.toInt((String)item.getText(8), (int)-1);
            boolean removed = BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]).equalsIgnoreCase(item.getText(9));
            String conversionMask = item.getText(10);
            String decimalSymbol = item.getText(11);
            String groupingSymbol = item.getText(12);
            String currencySymbol = item.getText(13);
            this.currentMeta.getCalculation()[i] = new CalculatorMetaFunction(fieldName, calcType, fieldA, fieldB, fieldC, valueType, valueLength, valuePrecision, removed, conversionMask, decimalSymbol, groupingSymbol, currencySymbol);
        }
        if (!this.originalMeta.equals((Object)this.currentMeta)) {
            this.currentMeta.setChanged();
            this.changed = this.currentMeta.hasChanged();
        }
        this.dispose();
    }
}

