/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.columnexists;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.columnexists.ColumnExistsMeta;
import org.pentaho.di.ui.core.database.dialog.DatabaseExplorerDialog;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class ColumnExistsDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = ColumnExistsMeta.class;
    private CCombo wConnection;
    private Label wlTableName;
    private CCombo wTableName;
    private FormData fdlTableName;
    private FormData fdTableName;
    private Label wlResult;
    private Text wResult;
    private FormData fdlResult;
    private FormData fdResult;
    private Label wlTablenameText;
    private TextVar wTablenameText;
    private FormData fdlTablenameText;
    private FormData fdTablenameText;
    private Label wlColumnName;
    private CCombo wColumnName;
    private FormData fdlColumnName;
    private FormData fdColumnName;
    private Label wlTablenameInField;
    private Button wTablenameInField;
    private FormData fdlTablenameInField;
    private FormData fdTablenameInField;
    private Label wlSchemaname;
    private TextVar wSchemaname;
    private FormData fdlSchemaname;
    private FormData fdSchemaname;
    private FormData fdbSchema;
    private Button wbSchema;
    private Button wbTable;
    private ColumnExistsMeta input;

    public ColumnExistsDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (ColumnExistsMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ColumnExistsDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ColumnExistsDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"ColumnExistsDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wStepname, middle, margin);
        if (this.input.getDatabase() == null && this.transMeta.nrDatabases() == 1) {
            this.wConnection.select(0);
        }
        this.wConnection.addModifyListener(lsMod);
        this.wlSchemaname = new Label((Composite)this.shell, 131072);
        this.wlSchemaname.setText(BaseMessages.getString(PKG, (String)"ColumnExistsDialog.Schemaname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSchemaname);
        this.fdlSchemaname = new FormData();
        this.fdlSchemaname.left = new FormAttachment(0, 0);
        this.fdlSchemaname.right = new FormAttachment(middle, -margin);
        this.fdlSchemaname.top = new FormAttachment((Control)this.wConnection, margin * 2);
        this.wlSchemaname.setLayoutData((Object)this.fdlSchemaname);
        this.wbSchema = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbSchema);
        this.wbSchema.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.fdbSchema = new FormData();
        this.fdbSchema.top = new FormAttachment((Control)this.wConnection, 2 * margin);
        this.fdbSchema.right = new FormAttachment(100, 0);
        this.wbSchema.setLayoutData((Object)this.fdbSchema);
        this.wbSchema.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnExistsDialog.this.getSchemaNames();
            }
        });
        this.wSchemaname = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wSchemaname);
        this.wSchemaname.setToolTipText(BaseMessages.getString(PKG, (String)"ColumnExistsDialog.Schemaname.Tooltip", (String[])new String[0]));
        this.wSchemaname.addModifyListener(lsMod);
        this.fdSchemaname = new FormData();
        this.fdSchemaname.left = new FormAttachment(middle, 0);
        this.fdSchemaname.top = new FormAttachment((Control)this.wConnection, margin * 2);
        this.fdSchemaname.right = new FormAttachment((Control)this.wbSchema, -margin);
        this.wSchemaname.setLayoutData(this.fdSchemaname);
        this.wlTablenameText = new Label((Composite)this.shell, 131072);
        this.wlTablenameText.setText(BaseMessages.getString(PKG, (String)"ColumnExistsDialog.TablenameTextField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTablenameText);
        this.fdlTablenameText = new FormData();
        this.fdlTablenameText.left = new FormAttachment(0, 0);
        this.fdlTablenameText.right = new FormAttachment(middle, -margin);
        this.fdlTablenameText.top = new FormAttachment((Control)this.wbSchema, margin);
        this.wlTablenameText.setLayoutData((Object)this.fdlTablenameText);
        this.wbTable = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbTable);
        this.wbTable.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        FormData fdbTable = new FormData();
        fdbTable.right = new FormAttachment(100, 0);
        fdbTable.top = new FormAttachment((Control)this.wbSchema, margin);
        this.wbTable.setLayoutData((Object)fdbTable);
        this.wbTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColumnExistsDialog.this.getTableName();
            }
        });
        this.wTablenameText = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.wTablenameText.setToolTipText(BaseMessages.getString(PKG, (String)"ColumnExistsDialog.TablenameTextField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wTablenameText);
        this.wTablenameText.addModifyListener(lsMod);
        this.fdTablenameText = new FormData();
        this.fdTablenameText.left = new FormAttachment(middle, 0);
        this.fdTablenameText.top = new FormAttachment((Control)this.wbSchema, margin);
        this.fdTablenameText.right = new FormAttachment((Control)this.wbTable, -margin);
        this.wTablenameText.setLayoutData(this.fdTablenameText);
        this.wlTablenameInField = new Label((Composite)this.shell, 131072);
        this.wlTablenameInField.setText(BaseMessages.getString(PKG, (String)"ColumnExistsDialog.TablenameInfield.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTablenameInField);
        this.fdlTablenameInField = new FormData();
        this.fdlTablenameInField.left = new FormAttachment(0, 0);
        this.fdlTablenameInField.top = new FormAttachment((Control)this.wTablenameText, margin);
        this.fdlTablenameInField.right = new FormAttachment(middle, -margin);
        this.wlTablenameInField.setLayoutData((Object)this.fdlTablenameInField);
        this.wTablenameInField = new Button((Composite)this.shell, 32);
        this.wTablenameInField.setToolTipText(BaseMessages.getString(PKG, (String)"ColumnExistsDialog.TablenameInfield.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wTablenameInField);
        this.fdTablenameInField = new FormData();
        this.fdTablenameInField.left = new FormAttachment(middle, 0);
        this.fdTablenameInField.top = new FormAttachment((Control)this.wTablenameText, margin);
        this.fdTablenameInField.right = new FormAttachment(100, 0);
        this.wTablenameInField.setLayoutData((Object)this.fdTablenameInField);
        SelectionAdapter lsSelR = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                ColumnExistsDialog.this.input.setChanged();
                ColumnExistsDialog.this.activeTablenameInField();
            }
        };
        this.wTablenameInField.addSelectionListener((SelectionListener)lsSelR);
        this.wlTableName = new Label((Composite)this.shell, 131072);
        this.wlTableName.setText(BaseMessages.getString(PKG, (String)"ColumnExistsDialog.TableName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTableName);
        this.fdlTableName = new FormData();
        this.fdlTableName.left = new FormAttachment(0, 0);
        this.fdlTableName.right = new FormAttachment(middle, -margin);
        this.fdlTableName.top = new FormAttachment((Control)this.wTablenameInField, margin * 2);
        this.wlTableName.setLayoutData((Object)this.fdlTableName);
        this.wTableName = new CCombo((Composite)this.shell, 2056);
        this.props.setLook((Control)this.wTableName);
        this.wTableName.addModifyListener(lsMod);
        this.fdTableName = new FormData();
        this.fdTableName.left = new FormAttachment(middle, 0);
        this.fdTableName.top = new FormAttachment((Control)this.wTablenameInField, margin * 2);
        this.fdTableName.right = new FormAttachment(100, -margin);
        this.wTableName.setLayoutData((Object)this.fdTableName);
        this.wTableName.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)ColumnExistsDialog.this.shell.getDisplay(), 1);
                ColumnExistsDialog.this.shell.setCursor(busy);
                ColumnExistsDialog.this.get();
                ColumnExistsDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.wlColumnName = new Label((Composite)this.shell, 131072);
        this.wlColumnName.setText(BaseMessages.getString(PKG, (String)"ColumnExistsDialog.ColumnName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlColumnName);
        this.fdlColumnName = new FormData();
        this.fdlColumnName.left = new FormAttachment(0, 0);
        this.fdlColumnName.right = new FormAttachment(middle, -margin);
        this.fdlColumnName.top = new FormAttachment((Control)this.wTableName, margin);
        this.wlColumnName.setLayoutData((Object)this.fdlColumnName);
        this.wColumnName = new CCombo((Composite)this.shell, 2056);
        this.props.setLook((Control)this.wColumnName);
        this.wColumnName.addModifyListener(lsMod);
        this.fdColumnName = new FormData();
        this.fdColumnName.left = new FormAttachment(middle, 0);
        this.fdColumnName.top = new FormAttachment((Control)this.wTableName, margin);
        this.fdColumnName.right = new FormAttachment(100, -margin);
        this.wColumnName.setLayoutData((Object)this.fdColumnName);
        this.wColumnName.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)ColumnExistsDialog.this.shell.getDisplay(), 1);
                ColumnExistsDialog.this.shell.setCursor(busy);
                ColumnExistsDialog.this.get();
                ColumnExistsDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.wlResult = new Label((Composite)this.shell, 131072);
        this.wlResult.setText(BaseMessages.getString(PKG, (String)"ColumnExistsDialog.ResultField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlResult);
        this.fdlResult = new FormData();
        this.fdlResult.left = new FormAttachment(0, 0);
        this.fdlResult.right = new FormAttachment(middle, -margin);
        this.fdlResult.top = new FormAttachment((Control)this.wColumnName, margin * 2);
        this.wlResult.setLayoutData((Object)this.fdlResult);
        this.wResult = new Text((Composite)this.shell, 18436);
        this.wResult.setToolTipText(BaseMessages.getString(PKG, (String)"ColumnExistsDialog.ResultField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wResult);
        this.wResult.addModifyListener(lsMod);
        this.fdResult = new FormData();
        this.fdResult.left = new FormAttachment(middle, 0);
        this.fdResult.top = new FormAttachment((Control)this.wColumnName, margin * 2);
        this.fdResult.right = new FormAttachment(100, 0);
        this.wResult.setLayoutData((Object)this.fdResult);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, (Control)this.wResult);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                ColumnExistsDialog.this.ok();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                ColumnExistsDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ColumnExistsDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                ColumnExistsDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.activeTablenameInField();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private void activeTablenameInField() {
        this.wlTableName.setEnabled(this.wTablenameInField.getSelection());
        this.wTableName.setEnabled(this.wTablenameInField.getSelection());
        this.wTablenameText.setEnabled(!this.wTablenameInField.getSelection());
        this.wlTablenameText.setEnabled(!this.wTablenameInField.getSelection());
    }

    public void getData() {
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"ColumnExistsDialog.Log.GettingKeyInfo", (String[])new String[0]));
        }
        if (this.input.getDatabase() != null) {
            this.wConnection.setText(this.input.getDatabase().getName());
        } else if (this.transMeta.nrDatabases() == 1) {
            this.wConnection.setText(this.transMeta.getDatabase(0).getName());
        }
        if (this.input.getSchemaname() != null) {
            this.wSchemaname.setText(this.input.getSchemaname());
        }
        if (this.input.getTablename() != null) {
            this.wTablenameText.setText(this.input.getTablename());
        }
        this.wTablenameInField.setSelection(this.input.isTablenameInField());
        if (this.input.getDynamicTablenameField() != null) {
            this.wTableName.setText(this.input.getDynamicTablenameField());
        }
        if (this.input.getDynamicColumnnameField() != null) {
            this.wColumnName.setText(this.input.getDynamicColumnnameField());
        }
        if (this.input.getResultFieldName() != null) {
            this.wResult.setText(this.input.getResultFieldName());
        }
        this.wStepname.selectAll();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.input.setDatabase(this.transMeta.findDatabase(this.wConnection.getText()));
        this.input.setSchemaname(this.wSchemaname.getText());
        this.input.setTablename(this.wTablenameText.getText());
        this.input.setTablenameInField(this.wTablenameInField.getSelection());
        this.input.setDynamicTablenameField(this.wTableName.getText());
        this.input.setDynamicColumnnameField(this.wColumnName.getText());
        this.input.setResultFieldName(this.wResult.getText());
        this.stepname = this.wStepname.getText();
        if (this.input.getDatabase() == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"ColumnExistsDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"ColumnExistsDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        this.dispose();
    }

    private void get() {
        try {
            String columnName = this.wColumnName.getText();
            String tableName = this.wTableName.getText();
            this.wColumnName.removeAll();
            this.wTableName.removeAll();
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null) {
                r.getFieldNames();
                for (int i = 0; i < r.getFieldNames().length; ++i) {
                    this.wTableName.add(r.getFieldNames()[i]);
                    this.wColumnName.add(r.getFieldNames()[i]);
                }
            }
            this.wColumnName.setText(columnName);
            this.wTableName.setText(tableName);
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"ColumnExistsDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ColumnExistsDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void getTableName() {
        int connr = this.wConnection.getSelectionIndex();
        if (connr >= 0) {
            DatabaseMeta inf = this.transMeta.getDatabase(connr);
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, inf, this.transMeta.getDatabases());
            std.setSelectedSchemaAndTable(this.wSchemaname.getText(), this.wTablenameText.getText());
            if (std.open()) {
                this.wSchemaname.setText(Const.NVL((String)std.getSchemaName(), (String)""));
                this.wTablenameText.setText(Const.NVL((String)std.getTableName(), (String)""));
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"ColumnExistsDialog.ConnectionError2.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
            mb.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getSchemaNames() {
        if (this.wSchemaname.isDisposed()) {
            return;
        }
        DatabaseMeta databaseMeta = this.transMeta.findDatabase(this.wConnection.getText());
        if (databaseMeta != null) {
            Database database = new Database(loggingObject, databaseMeta);
            database.shareVariablesWith((VariableSpace)this.transMeta);
            try {
                database.connect();
                String[] schemas = database.getSchemas();
                if (null != schemas && schemas.length > 0) {
                    EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, schemas = Const.sortStrings((String[])schemas), BaseMessages.getString(PKG, (String)"System.Dialog.AvailableSchemas.Title", (String[])new String[]{this.wConnection.getText()}), BaseMessages.getString(PKG, (String)"System.Dialog.AvailableSchemas.Message", (String[])new String[0]));
                    String d = dialog.open();
                    if (d != null) {
                        this.wSchemaname.setText(Const.NVL((String)d.toString(), (String)""));
                    }
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"System.Dialog.AvailableSchemas.Empty.Message", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.AvailableSchemas.Empty.Title", (String[])new String[0]));
                    mb.open();
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.AvailableSchemas.ConnectionError", (String[])new String[0]), e);
            }
            finally {
                if (database != null) {
                    database.disconnect();
                    database = null;
                }
            }
        }
    }
}

