/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.csvinput;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.ArrayList;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.provider.local.LocalFile;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPreviewFactory;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.csvinput.CsvInput;
import org.pentaho.di.trans.steps.csvinput.CsvInputMeta;
import org.pentaho.di.trans.steps.textfileinput.EncodingType;
import org.pentaho.di.trans.steps.textfileinput.InputFileMetaInterface;
import org.pentaho.di.trans.steps.textfileinput.TextFileInput;
import org.pentaho.di.trans.steps.textfileinput.TextFileInputField;
import org.pentaho.di.ui.core.dialog.EnterNumberDialog;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ComboValuesSelectionListener;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.dialog.TransPreviewProgressDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.steps.textfileinput.TextFileCSVImportProgressDialog;

public class CsvInputDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = CsvInput.class;
    private CsvInputMeta inputMeta;
    private TextVar wFilename;
    private CCombo wFilenameField;
    private Button wbbFilename;
    private Button wIncludeFilename;
    private TextVar wRowNumField;
    private Button wbDelimiter;
    private TextVar wDelimiter;
    private TextVar wEnclosure;
    private TextVar wBufferSize;
    private Button wLazyConversion;
    private Button wHeaderPresent;
    private FormData fdAddResult;
    private FormData fdlAddResult;
    private TableView wFields;
    private Label wlAddResult;
    private Button wAddResult;
    private boolean isReceivingInput;
    private Button wRunningInParallel;
    private Button wNewlinePossible;
    private ComboVar wEncoding;
    private boolean gotEncodings = false;
    private Label wlRunningInParallel;

    public CsvInputDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.inputMeta = (CsvInputMeta)in;
    }

    public String open() {
        FormData fdFilename;
        FormData fdlFilename;
        Label wlFilename;
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.inputMeta);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                CsvInputDialog.this.inputMeta.setChanged();
            }
        };
        this.changed = this.inputMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"CsvInputDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"CsvInputDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        Object lastControl = this.wStepname;
        boolean bl = this.isReceivingInput = this.transMeta.findNrPrevSteps(this.stepMeta) > 0;
        if (this.isReceivingInput) {
            RowMetaInterface previousFields;
            try {
                previousFields = this.transMeta.getPrevStepFields(this.stepMeta);
            }
            catch (KettleStepException e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"CsvInputDialog.ErrorDialog.UnableToGetInputFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CsvInputDialog.ErrorDialog.UnableToGetInputFields.Message", (String[])new String[0]), (Exception)((Object)e));
                previousFields = new RowMeta();
            }
            wlFilename = new Label((Composite)this.shell, 131072);
            wlFilename.setText(BaseMessages.getString(PKG, (String)this.inputMeta.getDescription("FILENAME_FIELD"), (String[])new String[0]));
            this.props.setLook((Control)wlFilename);
            fdlFilename = new FormData();
            fdlFilename.top = new FormAttachment((Control)lastControl, margin);
            fdlFilename.left = new FormAttachment(0, 0);
            fdlFilename.right = new FormAttachment(middle, -margin);
            wlFilename.setLayoutData((Object)fdlFilename);
            this.wFilenameField = new CCombo((Composite)this.shell, 18436);
            this.wFilenameField.setItems(previousFields.getFieldNames());
            this.props.setLook((Control)this.wFilenameField);
            this.wFilenameField.addModifyListener(lsMod);
            fdFilename = new FormData();
            fdFilename.top = new FormAttachment((Control)lastControl, margin);
            fdFilename.left = new FormAttachment(middle, 0);
            fdFilename.right = new FormAttachment(100, 0);
            this.wFilenameField.setLayoutData((Object)fdFilename);
            lastControl = this.wFilenameField;
            Label wlIncludeFilename = new Label((Composite)this.shell, 131072);
            wlIncludeFilename.setText(BaseMessages.getString(PKG, (String)this.inputMeta.getDescription("INCLUDE_FILENAME"), (String[])new String[0]));
            this.props.setLook((Control)wlIncludeFilename);
            FormData fdlIncludeFilename = new FormData();
            fdlIncludeFilename.top = new FormAttachment((Control)lastControl, margin);
            fdlIncludeFilename.left = new FormAttachment(0, 0);
            fdlIncludeFilename.right = new FormAttachment(middle, -margin);
            wlIncludeFilename.setLayoutData((Object)fdlIncludeFilename);
            this.wIncludeFilename = new Button((Composite)this.shell, 32);
            this.props.setLook((Control)this.wIncludeFilename);
            this.wFilenameField.addModifyListener(lsMod);
            FormData fdIncludeFilename = new FormData();
            fdIncludeFilename.top = new FormAttachment((Control)lastControl, margin);
            fdIncludeFilename.left = new FormAttachment(middle, 0);
            fdIncludeFilename.right = new FormAttachment(100, 0);
            this.wIncludeFilename.setLayoutData((Object)fdIncludeFilename);
            lastControl = this.wIncludeFilename;
        } else {
            this.wbbFilename = new Button((Composite)this.shell, 0x1000008);
            this.props.setLook((Control)this.wbbFilename);
            this.wbbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
            this.wbbFilename.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForFileOrDirAndAdd", (String[])new String[0]));
            FormData fdbFilename = new FormData();
            fdbFilename.top = new FormAttachment((Control)lastControl, margin);
            fdbFilename.right = new FormAttachment(100, 0);
            this.wbbFilename.setLayoutData((Object)fdbFilename);
            wlFilename = new Label((Composite)this.shell, 131072);
            wlFilename.setText(BaseMessages.getString(PKG, (String)this.inputMeta.getDescription("FILENAME"), (String[])new String[0]));
            this.props.setLook((Control)wlFilename);
            fdlFilename = new FormData();
            fdlFilename.top = new FormAttachment((Control)lastControl, margin);
            fdlFilename.left = new FormAttachment(0, 0);
            fdlFilename.right = new FormAttachment(middle, -margin);
            wlFilename.setLayoutData((Object)fdlFilename);
            this.wFilename = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
            this.props.setLook((Control)this.wFilename);
            this.wFilename.addModifyListener(lsMod);
            fdFilename = new FormData();
            fdFilename.top = new FormAttachment((Control)lastControl, margin);
            fdFilename.left = new FormAttachment(middle, 0);
            fdFilename.right = new FormAttachment((Control)this.wbbFilename, -margin);
            this.wFilename.setLayoutData(fdFilename);
            lastControl = this.wFilename;
        }
        Label wlDelimiter = new Label((Composite)this.shell, 131072);
        wlDelimiter.setText(BaseMessages.getString(PKG, (String)this.inputMeta.getDescription("DELIMITER"), (String[])new String[0]));
        this.props.setLook((Control)wlDelimiter);
        FormData fdlDelimiter = new FormData();
        fdlDelimiter.top = new FormAttachment((Control)lastControl, margin);
        fdlDelimiter.left = new FormAttachment(0, 0);
        fdlDelimiter.right = new FormAttachment(middle, -margin);
        wlDelimiter.setLayoutData((Object)fdlDelimiter);
        this.wbDelimiter = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbDelimiter);
        this.wbDelimiter.setText(BaseMessages.getString(PKG, (String)"CsvInputDialog.Delimiter.Button", (String[])new String[0]));
        FormData fdbDelimiter = new FormData();
        fdbDelimiter.top = new FormAttachment((Control)lastControl, margin);
        fdbDelimiter.right = new FormAttachment(100, 0);
        this.wbDelimiter.setLayoutData((Object)fdbDelimiter);
        this.wDelimiter = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wDelimiter);
        this.wDelimiter.addModifyListener(lsMod);
        FormData fdDelimiter = new FormData();
        fdDelimiter.top = new FormAttachment((Control)lastControl, margin);
        fdDelimiter.left = new FormAttachment(middle, 0);
        fdDelimiter.right = new FormAttachment((Control)this.wbDelimiter, -margin);
        this.wDelimiter.setLayoutData(fdDelimiter);
        lastControl = this.wDelimiter;
        Label wlEnclosure = new Label((Composite)this.shell, 131072);
        wlEnclosure.setText(BaseMessages.getString(PKG, (String)this.inputMeta.getDescription("ENCLOSURE"), (String[])new String[0]));
        this.props.setLook((Control)wlEnclosure);
        FormData fdlEnclosure = new FormData();
        fdlEnclosure.top = new FormAttachment((Control)lastControl, margin);
        fdlEnclosure.left = new FormAttachment(0, 0);
        fdlEnclosure.right = new FormAttachment(middle, -margin);
        wlEnclosure.setLayoutData((Object)fdlEnclosure);
        this.wEnclosure = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wEnclosure);
        this.wEnclosure.addModifyListener(lsMod);
        FormData fdEnclosure = new FormData();
        fdEnclosure.top = new FormAttachment((Control)lastControl, margin);
        fdEnclosure.left = new FormAttachment(middle, 0);
        fdEnclosure.right = new FormAttachment(100, 0);
        this.wEnclosure.setLayoutData(fdEnclosure);
        lastControl = this.wEnclosure;
        Label wlBufferSize = new Label((Composite)this.shell, 131072);
        wlBufferSize.setText(BaseMessages.getString(PKG, (String)this.inputMeta.getDescription("BUFFERSIZE"), (String[])new String[0]));
        this.props.setLook((Control)wlBufferSize);
        FormData fdlBufferSize = new FormData();
        fdlBufferSize.top = new FormAttachment((Control)lastControl, margin);
        fdlBufferSize.left = new FormAttachment(0, 0);
        fdlBufferSize.right = new FormAttachment(middle, -margin);
        wlBufferSize.setLayoutData((Object)fdlBufferSize);
        this.wBufferSize = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wBufferSize);
        this.wBufferSize.addModifyListener(lsMod);
        FormData fdBufferSize = new FormData();
        fdBufferSize.top = new FormAttachment((Control)lastControl, margin);
        fdBufferSize.left = new FormAttachment(middle, 0);
        fdBufferSize.right = new FormAttachment(100, 0);
        this.wBufferSize.setLayoutData(fdBufferSize);
        lastControl = this.wBufferSize;
        Label wlLazyConversion = new Label((Composite)this.shell, 131072);
        wlLazyConversion.setText(BaseMessages.getString(PKG, (String)this.inputMeta.getDescription("LAZY_CONVERSION"), (String[])new String[0]));
        this.props.setLook((Control)wlLazyConversion);
        FormData fdlLazyConversion = new FormData();
        fdlLazyConversion.top = new FormAttachment((Control)lastControl, margin);
        fdlLazyConversion.left = new FormAttachment(0, 0);
        fdlLazyConversion.right = new FormAttachment(middle, -margin);
        wlLazyConversion.setLayoutData((Object)fdlLazyConversion);
        this.wLazyConversion = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wLazyConversion);
        FormData fdLazyConversion = new FormData();
        fdLazyConversion.top = new FormAttachment((Control)lastControl, margin);
        fdLazyConversion.left = new FormAttachment(middle, 0);
        fdLazyConversion.right = new FormAttachment(100, 0);
        this.wLazyConversion.setLayoutData((Object)fdLazyConversion);
        lastControl = this.wLazyConversion;
        Label wlHeaderPresent = new Label((Composite)this.shell, 131072);
        wlHeaderPresent.setText(BaseMessages.getString(PKG, (String)this.inputMeta.getDescription("HEADER_PRESENT"), (String[])new String[0]));
        this.props.setLook((Control)wlHeaderPresent);
        FormData fdlHeaderPresent = new FormData();
        fdlHeaderPresent.top = new FormAttachment((Control)lastControl, margin);
        fdlHeaderPresent.left = new FormAttachment(0, 0);
        fdlHeaderPresent.right = new FormAttachment(middle, -margin);
        wlHeaderPresent.setLayoutData((Object)fdlHeaderPresent);
        this.wHeaderPresent = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wHeaderPresent);
        FormData fdHeaderPresent = new FormData();
        fdHeaderPresent.top = new FormAttachment((Control)lastControl, margin);
        fdHeaderPresent.left = new FormAttachment(middle, 0);
        fdHeaderPresent.right = new FormAttachment(100, 0);
        this.wHeaderPresent.setLayoutData((Object)fdHeaderPresent);
        lastControl = this.wHeaderPresent;
        this.wlAddResult = new Label((Composite)this.shell, 131072);
        this.wlAddResult.setText(BaseMessages.getString(PKG, (String)this.inputMeta.getDescription("ADD_FILENAME_RESULT"), (String[])new String[0]));
        this.props.setLook((Control)this.wlAddResult);
        this.fdlAddResult = new FormData();
        this.fdlAddResult.left = new FormAttachment(0, 0);
        this.fdlAddResult.top = new FormAttachment((Control)this.wHeaderPresent, margin);
        this.fdlAddResult.right = new FormAttachment(middle, -margin);
        this.wlAddResult.setLayoutData((Object)this.fdlAddResult);
        this.wAddResult = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wAddResult);
        this.wAddResult.setToolTipText(BaseMessages.getString(PKG, (String)this.inputMeta.getTooltip("ADD_FILENAME_RESULT"), (String[])new String[0]));
        this.fdAddResult = new FormData();
        this.fdAddResult.left = new FormAttachment(middle, 0);
        this.fdAddResult.top = new FormAttachment((Control)this.wHeaderPresent, margin);
        this.wAddResult.setLayoutData((Object)this.fdAddResult);
        lastControl = this.wAddResult;
        Label wlRowNumField = new Label((Composite)this.shell, 131072);
        wlRowNumField.setText(BaseMessages.getString(PKG, (String)this.inputMeta.getDescription("ROW_NUM_FIELD"), (String[])new String[0]));
        this.props.setLook((Control)wlRowNumField);
        FormData fdlRowNumField = new FormData();
        fdlRowNumField.top = new FormAttachment((Control)lastControl, margin);
        fdlRowNumField.left = new FormAttachment(0, 0);
        fdlRowNumField.right = new FormAttachment(middle, -margin);
        wlRowNumField.setLayoutData((Object)fdlRowNumField);
        this.wRowNumField = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wRowNumField);
        this.wRowNumField.addModifyListener(lsMod);
        FormData fdRowNumField = new FormData();
        fdRowNumField.top = new FormAttachment((Control)lastControl, margin);
        fdRowNumField.left = new FormAttachment(middle, 0);
        fdRowNumField.right = new FormAttachment(100, 0);
        this.wRowNumField.setLayoutData(fdRowNumField);
        lastControl = this.wRowNumField;
        this.wlRunningInParallel = new Label((Composite)this.shell, 131072);
        this.wlRunningInParallel.setText(BaseMessages.getString(PKG, (String)this.inputMeta.getDescription("PARALLEL"), (String[])new String[0]));
        this.props.setLook((Control)this.wlRunningInParallel);
        FormData fdlRunningInParallel = new FormData();
        fdlRunningInParallel.top = new FormAttachment((Control)lastControl, margin);
        fdlRunningInParallel.left = new FormAttachment(0, 0);
        fdlRunningInParallel.right = new FormAttachment(middle, -margin);
        this.wlRunningInParallel.setLayoutData((Object)fdlRunningInParallel);
        this.wRunningInParallel = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wRunningInParallel);
        FormData fdRunningInParallel = new FormData();
        fdRunningInParallel.top = new FormAttachment((Control)lastControl, margin);
        fdRunningInParallel.left = new FormAttachment(middle, 0);
        this.wRunningInParallel.setLayoutData((Object)fdRunningInParallel);
        lastControl = this.wRunningInParallel;
        Label wlNewlinePossible = new Label((Composite)this.shell, 131072);
        wlNewlinePossible.setText(BaseMessages.getString(PKG, (String)this.inputMeta.getDescription("NEWLINE_POSSIBLE"), (String[])new String[0]));
        this.props.setLook((Control)wlNewlinePossible);
        FormData fdlNewlinePossible = new FormData();
        fdlNewlinePossible.top = new FormAttachment((Control)lastControl, margin);
        fdlNewlinePossible.left = new FormAttachment(0, 0);
        fdlNewlinePossible.right = new FormAttachment(middle, -margin);
        wlNewlinePossible.setLayoutData((Object)fdlNewlinePossible);
        this.wNewlinePossible = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wNewlinePossible);
        FormData fdNewlinePossible = new FormData();
        fdNewlinePossible.top = new FormAttachment((Control)lastControl, margin);
        fdNewlinePossible.left = new FormAttachment(middle, 0);
        this.wNewlinePossible.setLayoutData((Object)fdNewlinePossible);
        this.wNewlinePossible.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                CsvInputDialog.this.setFlags();
            }
        });
        lastControl = this.wNewlinePossible;
        Label wlEncoding = new Label((Composite)this.shell, 131072);
        wlEncoding.setText(BaseMessages.getString(PKG, (String)this.inputMeta.getDescription("ENCODING"), (String[])new String[0]));
        this.props.setLook((Control)wlEncoding);
        FormData fdlEncoding = new FormData();
        fdlEncoding.top = new FormAttachment((Control)lastControl, margin);
        fdlEncoding.left = new FormAttachment(0, 0);
        fdlEncoding.right = new FormAttachment(middle, -margin);
        wlEncoding.setLayoutData((Object)fdlEncoding);
        this.wEncoding = new ComboVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wEncoding);
        this.wEncoding.addModifyListener(lsMod);
        FormData fdEncoding = new FormData();
        fdEncoding.top = new FormAttachment((Control)lastControl, margin);
        fdEncoding.left = new FormAttachment(middle, 0);
        fdEncoding.right = new FormAttachment(100, 0);
        this.wEncoding.setLayoutData(fdEncoding);
        lastControl = this.wEncoding;
        this.wEncoding.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)CsvInputDialog.this.shell.getDisplay(), 1);
                CsvInputDialog.this.shell.setCursor(busy);
                CsvInputDialog.this.setEncodings();
                CsvInputDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"System.Button.Preview", (String[])new String[0]));
        this.wPreview.setEnabled(!this.isReceivingInput);
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        this.wGet.setEnabled(!this.isReceivingInput);
        this.setButtonPositions(new Button[]{this.wOK, this.wGet, this.wPreview, this.wCancel}, margin, null);
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)this.inputMeta.getDescription("FIELD_NAME"), (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)this.inputMeta.getDescription("FIELD_TYPE"), (String[])new String[0]), 2, ValueMeta.getTypes(), true), new ColumnInfo(BaseMessages.getString(PKG, (String)this.inputMeta.getDescription("FIELD_FORMAT"), (String[])new String[0]), 5, 2), new ColumnInfo(BaseMessages.getString(PKG, (String)this.inputMeta.getDescription("FIELD_LENGTH"), (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)this.inputMeta.getDescription("FIELD_PRECISION"), (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)this.inputMeta.getDescription("FIELD_CURRENCY"), (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)this.inputMeta.getDescription("FIELD_DECIMAL"), (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)this.inputMeta.getDescription("FIELD_GROUP"), (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)this.inputMeta.getDescription("FIELD_TRIM_TYPE"), (String[])new String[0]), 2, ValueMeta.trimTypeDesc)};
        colinf[2].setComboValuesSelectionListener(new ComboValuesSelectionListener(){

            public String[] getComboValues(TableItem tableItem, int rowNr, int colNr) {
                String[] comboValues = new String[]{};
                int type = ValueMeta.getType((String)tableItem.getText(colNr - 1));
                switch (type) {
                    case 3: {
                        comboValues = Const.getDateFormats();
                        break;
                    }
                    case 1: 
                    case 5: 
                    case 6: {
                        comboValues = Const.getNumberFormats();
                        break;
                    }
                }
                return comboValues;
            }
        });
        this.wFields = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 65538, colinf, 1, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.top = new FormAttachment((Control)lastControl, margin * 2);
        fdFields.bottom = new FormAttachment((Control)this.wOK, -margin * 2);
        fdFields.left = new FormAttachment(0, 0);
        fdFields.right = new FormAttachment(100, 0);
        this.wFields.setLayoutData(fdFields);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                CsvInputDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                CsvInputDialog.this.ok();
            }
        };
        this.lsPreview = new Listener(){

            public void handleEvent(Event e) {
                CsvInputDialog.this.preview();
            }
        };
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                CsvInputDialog.this.getCSV();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.wPreview.addListener(13, this.lsPreview);
        this.wGet.addListener(13, this.lsGet);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                CsvInputDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        if (this.wFilename != null) {
            this.wFilename.addSelectionListener(this.lsDef);
        }
        if (this.wFilenameField != null) {
            this.wFilenameField.addSelectionListener((SelectionListener)this.lsDef);
        }
        this.wDelimiter.addSelectionListener(this.lsDef);
        this.wEnclosure.addSelectionListener(this.lsDef);
        this.wBufferSize.addSelectionListener(this.lsDef);
        this.wRowNumField.addSelectionListener(this.lsDef);
        this.wbDelimiter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent se) {
                Text t = CsvInputDialog.this.wDelimiter.getTextWidget();
                if (t != null) {
                    t.insert("\t");
                }
            }
        });
        if (this.wbbFilename != null) {
            this.wbbFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FileDialog dialog = new FileDialog(CsvInputDialog.this.shell, 4096);
                    dialog.setFilterExtensions(new String[]{"*.txt;*.csv", "*.csv", "*.txt", "*"});
                    if (CsvInputDialog.this.wFilename.getText() != null) {
                        String fname = CsvInputDialog.this.transMeta.environmentSubstitute(CsvInputDialog.this.wFilename.getText());
                        dialog.setFileName(fname);
                    }
                    dialog.setFilterNames(new String[]{BaseMessages.getString((Class)PKG, (String)"System.FileType.CSVFiles", (String[])new String[0]) + ", " + BaseMessages.getString((Class)PKG, (String)"System.FileType.TextFiles", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"System.FileType.CSVFiles", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"System.FileType.TextFiles", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"System.FileType.AllFiles", (String[])new String[0])});
                    if (dialog.open() != null) {
                        String str = dialog.getFilterPath() + System.getProperty("file.separator") + dialog.getFileName();
                        CsvInputDialog.this.wFilename.setText(str);
                    }
                }
            });
        }
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                CsvInputDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.inputMeta.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected void setFlags() {
        boolean parallelPossible = !this.wNewlinePossible.getSelection();
        this.wlRunningInParallel.setEnabled(parallelPossible);
        this.wRunningInParallel.setEnabled(parallelPossible);
        if (!parallelPossible) {
            this.wRunningInParallel.setSelection(false);
        }
    }

    private void setEncodings() {
        if (!this.gotEncodings) {
            this.gotEncodings = true;
            this.wEncoding.removeAll();
            ArrayList<Charset> values = new ArrayList<Charset>(Charset.availableCharsets().values());
            for (int i = 0; i < values.size(); ++i) {
                Charset charSet = (Charset)values.get(i);
                this.wEncoding.add(charSet.displayName());
            }
            String defEncoding = Const.getEnvironmentVariable((String)"file.encoding", (String)"UTF-8");
            int idx = Const.indexOfString((String)defEncoding, (String[])this.wEncoding.getItems());
            if (idx >= 0) {
                this.wEncoding.select(idx);
            }
        }
    }

    public void getData() {
        this.getData(this.inputMeta, true);
    }

    public void getData(CsvInputMeta inputMeta, boolean copyStepname) {
        if (copyStepname) {
            this.wStepname.setText(this.stepname);
        }
        if (this.isReceivingInput) {
            this.wFilenameField.setText(Const.NVL((String)inputMeta.getFilenameField(), (String)""));
            this.wIncludeFilename.setSelection(inputMeta.isIncludingFilename());
        } else {
            this.wFilename.setText(Const.NVL((String)inputMeta.getFilename(), (String)""));
        }
        this.wDelimiter.setText(Const.NVL((String)inputMeta.getDelimiter(), (String)""));
        this.wEnclosure.setText(Const.NVL((String)inputMeta.getEnclosure(), (String)""));
        this.wBufferSize.setText(Const.NVL((String)inputMeta.getBufferSize(), (String)""));
        this.wLazyConversion.setSelection(inputMeta.isLazyConversionActive());
        this.wHeaderPresent.setSelection(inputMeta.isHeaderPresent());
        this.wRunningInParallel.setSelection(inputMeta.isRunningInParallel());
        this.wNewlinePossible.setSelection(inputMeta.isNewlinePossibleInFields());
        this.wRowNumField.setText(Const.NVL((String)inputMeta.getRowNumField(), (String)""));
        this.wAddResult.setSelection(inputMeta.isAddResultFile());
        this.wEncoding.setText(Const.NVL((String)inputMeta.getEncoding(), (String)""));
        for (int i = 0; i < inputMeta.getInputFields().length; ++i) {
            TextFileInputField field = inputMeta.getInputFields()[i];
            TableItem item = new TableItem(this.wFields.table, 0);
            int colnr = 1;
            item.setText(colnr++, Const.NVL((String)field.getName(), (String)""));
            item.setText(colnr++, ValueMeta.getTypeDesc((int)field.getType()));
            item.setText(colnr++, Const.NVL((String)field.getFormat(), (String)""));
            item.setText(colnr++, field.getLength() >= 0 ? Integer.toString(field.getLength()) : "");
            item.setText(colnr++, field.getPrecision() >= 0 ? Integer.toString(field.getPrecision()) : "");
            item.setText(colnr++, Const.NVL((String)field.getCurrencySymbol(), (String)""));
            item.setText(colnr++, Const.NVL((String)field.getDecimalSymbol(), (String)""));
            item.setText(colnr++, Const.NVL((String)field.getGroupSymbol(), (String)""));
            item.setText(colnr++, Const.NVL((String)field.getTrimTypeDesc(), (String)""));
        }
        this.wFields.removeEmptyRows();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.setFlags();
        this.wStepname.selectAll();
    }

    private void cancel() {
        this.stepname = null;
        this.inputMeta.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(CsvInputMeta inputMeta) {
        if (this.isReceivingInput) {
            inputMeta.setFilenameField(this.wFilenameField.getText());
            inputMeta.setIncludingFilename(this.wIncludeFilename.getSelection());
        } else {
            inputMeta.setFilename(this.wFilename.getText());
        }
        inputMeta.setDelimiter(this.wDelimiter.getText());
        inputMeta.setEnclosure(this.wEnclosure.getText());
        inputMeta.setBufferSize(this.wBufferSize.getText());
        inputMeta.setLazyConversionActive(this.wLazyConversion.getSelection());
        inputMeta.setHeaderPresent(this.wHeaderPresent.getSelection());
        inputMeta.setRowNumField(this.wRowNumField.getText());
        inputMeta.setAddResultFile(this.wAddResult.getSelection());
        inputMeta.setRunningInParallel(this.wRunningInParallel.getSelection());
        inputMeta.setNewlinePossibleInFields(this.wNewlinePossible.getSelection());
        inputMeta.setEncoding(this.wEncoding.getText());
        int nrNonEmptyFields = this.wFields.nrNonEmpty();
        inputMeta.allocate(nrNonEmptyFields);
        for (int i = 0; i < nrNonEmptyFields; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            inputMeta.getInputFields()[i] = new TextFileInputField();
            int colnr = 1;
            inputMeta.getInputFields()[i].setName(item.getText(colnr++));
            inputMeta.getInputFields()[i].setType(ValueMeta.getType((String)item.getText(colnr++)));
            inputMeta.getInputFields()[i].setFormat(item.getText(colnr++));
            inputMeta.getInputFields()[i].setLength(Const.toInt((String)item.getText(colnr++), (int)-1));
            inputMeta.getInputFields()[i].setPrecision(Const.toInt((String)item.getText(colnr++), (int)-1));
            inputMeta.getInputFields()[i].setCurrencySymbol(item.getText(colnr++));
            inputMeta.getInputFields()[i].setDecimalSymbol(item.getText(colnr++));
            inputMeta.getInputFields()[i].setGroupSymbol(item.getText(colnr++));
            inputMeta.getInputFields()[i].setTrimType(ValueMeta.getTrimTypeByDesc((String)item.getText(colnr++)));
        }
        this.wFields.removeEmptyRows();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        inputMeta.setChanged();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.getInfo(this.inputMeta);
        this.stepname = this.wStepname.getText();
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getCSV() {
        InputStream inputStream = null;
        try {
            int i;
            CsvInputMeta meta = new CsvInputMeta();
            this.getInfo(meta);
            String filename = this.transMeta.environmentSubstitute(meta.getFilename());
            String delimiter = this.transMeta.environmentSubstitute(meta.getDelimiter());
            FileObject fileObject = KettleVFS.getFileObject((String)filename);
            if (!(fileObject instanceof LocalFile)) {
                throw new KettleException(BaseMessages.getString(PKG, (String)"CsvInput.Log.OnlyLocalFilesAreSupported", (String[])new String[0]));
            }
            this.wFields.table.removeAll();
            inputStream = KettleVFS.getInputStream((FileObject)fileObject);
            InputStreamReader reader = Const.isEmpty((String)meta.getEncoding()) ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, meta.getEncoding());
            EncodingType encodingType = EncodingType.guessEncodingType((String)reader.getEncoding());
            String line = TextFileInput.getLine((LogChannelInterface)this.log, (InputStreamReader)reader, (EncodingType)encodingType, (int)2, (StringBuilder)new StringBuilder(1000));
            String[] fieldNames = CsvInput.guessStringsFromLine((LogChannelInterface)this.log, (String)line, (String)delimiter, (String)meta.getEnclosure(), (String)meta.getEscapeCharacter());
            if (!meta.isHeaderPresent()) {
                DecimalFormat df = new DecimalFormat("000");
                for (int i2 = 0; i2 < fieldNames.length; ++i2) {
                    fieldNames[i2] = "Field_" + df.format(i2);
                }
            } else if (!Const.isEmpty((String)meta.getEnclosure())) {
                for (int i3 = 0; i3 < fieldNames.length; ++i3) {
                    if (!fieldNames[i3].startsWith(meta.getEnclosure()) || !fieldNames[i3].endsWith(meta.getEnclosure()) || fieldNames[i3].length() <= 1) continue;
                    fieldNames[i3] = fieldNames[i3].substring(1, fieldNames[i3].length() - 1);
                }
            }
            for (i = 0; i < fieldNames.length; ++i) {
                fieldNames[i] = Const.trim((String)fieldNames[i]);
            }
            for (i = 0; i < fieldNames.length; ++i) {
                TableItem item = new TableItem(this.wFields.table, 0);
                item.setText(1, fieldNames[i]);
                item.setText(2, ValueMeta.getTypeDesc((int)2));
            }
            this.wFields.removeEmptyRows();
            this.wFields.setRowNums();
            this.wFields.optWidth(true);
            String shellText = BaseMessages.getString(PKG, (String)"CsvInputDialog.LinesToSample.DialogTitle", (String[])new String[0]);
            String lineText = BaseMessages.getString(PKG, (String)"CsvInputDialog.LinesToSample.DialogMessage", (String[])new String[0]);
            EnterNumberDialog end = new EnterNumberDialog(this.shell, 100, shellText, lineText);
            int samples = end.open();
            if (samples >= 0) {
                this.getInfo(meta);
                TextFileCSVImportProgressDialog pd = new TextFileCSVImportProgressDialog(this.shell, (InputFileMetaInterface)meta, this.transMeta, reader, samples, true);
                String message = pd.open();
                if (message != null) {
                    this.wFields.removeAll();
                    this.getData(meta, false);
                    this.wFields.removeEmptyRows();
                    this.wFields.setRowNums();
                    this.wFields.optWidth(true);
                    EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"CsvInputDialog.ScanResults.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CsvInputDialog.ScanResults.DialogMessage", (String[])new String[0]), message, true);
                    etd.setReadOnly();
                    etd.open();
                }
            }
        }
        catch (IOException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"CsvInputDialog.IOError.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CsvInputDialog.IOError.DialogMessage", (String[])new String[0]), e);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CsvInputDialog.ErrorGettingFileDesc.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception e) {}
        }
    }

    private void preview() {
        CsvInputMeta oneMeta = new CsvInputMeta();
        this.getInfo(oneMeta);
        TransMeta previewMeta = TransPreviewFactory.generatePreviewTransformation((VariableSpace)this.transMeta, (StepMetaInterface)oneMeta, (String)this.wStepname.getText());
        this.transMeta.getVariable("Internal.Transformation.Filename.Directory");
        previewMeta.getVariable("Internal.Transformation.Filename.Directory");
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"CsvInputDialog.PreviewSize.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CsvInputDialog.PreviewSize.DialogMessage", (String[])new String[0]));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            TransPreviewProgressDialog progressDialog = new TransPreviewProgressDialog(this.shell, previewMeta, new String[]{this.wStepname.getText()}, new int[]{previewSize});
            progressDialog.open();
            Trans trans = progressDialog.getTrans();
            String loggingText = progressDialog.getLoggingText();
            if (!progressDialog.isCancelled() && trans.getResult() != null && trans.getResult().getNrErrors() > 0L) {
                EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                etd.setReadOnly();
                etd.open();
            }
            PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, (VariableSpace)this.transMeta, 0, this.wStepname.getText(), progressDialog.getPreviewRowsMeta(this.wStepname.getText()), progressDialog.getPreviewRows(this.wStepname.getText()), loggingText);
            prd.open();
        }
    }
}

