/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.datagrid;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPreviewFactory;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.datagrid.DataGridMeta;
import org.pentaho.di.ui.core.dialog.EnterNumberDialog;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.dialog.TransPreviewProgressDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class DataGridDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = DataGridMeta.class;
    private CTabFolder wTabFolder;
    private CTabItem wMetaTab;
    private CTabItem wDataTab;
    private Composite wMetaComp;
    private Composite wDataComp;
    private TableView wFields;
    private TableView wData;
    private DataGridMeta input;
    private DataGridMeta dataGridMeta;
    private ModifyListener lsMod;

    public DataGridDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (DataGridMeta)in;
        this.dataGridMeta = (DataGridMeta)this.input.clone();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        this.lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DataGridDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"DataGridDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"System.Label.StepName", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(this.lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wMetaTab = new CTabItem(this.wTabFolder, 0);
        this.wMetaTab.setText(BaseMessages.getString(PKG, (String)"DataGridDialog.Meta.Label", (String[])new String[0]));
        this.wMetaComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)this.wMetaComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        this.wMetaComp.setLayout((Layout)fileLayout);
        int FieldsRows = this.input.getFieldName().length;
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"DataGridDialog.Name.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DataGridDialog.Type.Column", (String[])new String[0]), 2, ValueMeta.getTypes()), new ColumnInfo(BaseMessages.getString(PKG, (String)"DataGridDialog.Format.Column", (String[])new String[0]), 2, Const.getDateFormats()), new ColumnInfo(BaseMessages.getString(PKG, (String)"DataGridDialog.Length.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DataGridDialog.Precision.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DataGridDialog.Currency.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DataGridDialog.Decimal.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"DataGridDialog.Group.Column", (String[])new String[0]), 1, false)};
        this.wFields = new TableView((VariableSpace)this.transMeta, this.wMetaComp, 67586, colinf, FieldsRows, this.lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment(0, 0);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment(100, 0);
        this.wFields.setLayoutData(fdFields);
        this.wMetaComp.layout();
        this.wMetaTab.setControl((Control)this.wMetaComp);
        this.wDataTab = new CTabItem(this.wTabFolder, 0);
        this.wDataTab.setText(BaseMessages.getString(PKG, (String)"DataGridDialog.Data.Label", (String[])new String[0]));
        this.wDataComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)this.wDataComp);
        FormLayout filesettingLayout = new FormLayout();
        filesettingLayout.marginWidth = 3;
        filesettingLayout.marginHeight = 3;
        this.wDataComp.setLayout((Layout)fileLayout);
        this.addDataGrid(false);
        FormData fdDataComp = new FormData();
        fdDataComp.left = new FormAttachment(0, 0);
        fdDataComp.top = new FormAttachment(0, 0);
        fdDataComp.right = new FormAttachment(100, 0);
        fdDataComp.bottom = new FormAttachment(100, 0);
        this.wDataComp.setLayoutData((Object)fdDataComp);
        this.wDataComp.layout();
        this.wDataTab.setControl((Control)this.wDataComp);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)this.wStepname, margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment(100, -50);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"System.Button.Preview", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wPreview, this.wCancel}, margin, (Control)this.wTabFolder);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                DataGridDialog.this.ok();
            }
        };
        this.lsPreview = new Listener(){

            public void handleEvent(Event e) {
                DataGridDialog.this.preview();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                DataGridDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wPreview.addListener(13, this.lsPreview);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                DataGridDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                DataGridDialog.this.cancel();
            }
        });
        this.lsResize = new Listener(){

            public void handleEvent(Event event) {
                Point size = DataGridDialog.this.shell.getSize();
                DataGridDialog.this.wFields.setSize(size.x - 10, size.y - 50);
                ((DataGridDialog)DataGridDialog.this).wFields.table.setSize(size.x - 10, size.y - 50);
                DataGridDialog.this.wFields.redraw();
            }
        };
        this.shell.addListener(11, this.lsResize);
        this.getData();
        this.wTabFolder.setSelection(0);
        this.wTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DataGridDialog.this.addDataGrid(true);
            }
        });
        this.setSize();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private void addDataGrid(boolean refresh) {
        if (refresh) {
            this.getMetaInfo(this.dataGridMeta);
        }
        this.getMetaData();
        if (refresh) {
            this.getDataInfo(this.dataGridMeta);
            for (Control control : this.wDataComp.getChildren()) {
                control.dispose();
            }
        }
        ColumnInfo[] columns = new ColumnInfo[this.dataGridMeta.getFieldName().length];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = new ColumnInfo(this.dataGridMeta.getFieldName()[i], 1, false, false);
        }
        List lines = this.dataGridMeta.getDataLines();
        this.wData = new TableView((VariableSpace)this.transMeta, this.wDataComp, 0, columns, lines.size(), this.lsMod, this.props);
        this.wData.setSortable(false);
        for (int i = 0; i < lines.size(); ++i) {
            List line = (List)lines.get(i);
            TableItem item = this.wData.table.getItem(i);
            for (int f = 0; f < line.size(); ++f) {
                item.setText(f + 1, Const.NVL((String)((String)line.get(f)), (String)""));
            }
        }
        this.wData.setRowNums();
        this.wData.optWidth(true);
        FormData fdData = new FormData();
        fdData.left = new FormAttachment(0, 0);
        fdData.top = new FormAttachment(0, 0);
        fdData.right = new FormAttachment(100, 0);
        fdData.bottom = new FormAttachment(100, 0);
        this.wData.setLayoutData(fdData);
        this.wTabFolder.layout(true, true);
    }

    public void getData() {
        this.getMetaData();
        this.addDataGrid(false);
    }

    private void getMetaData() {
        int nrfields = this.input.getFieldName().length;
        if (nrfields > this.wFields.table.getItemCount()) {
            nrfields = this.wFields.table.getItemCount();
        }
        for (int i = 0; i < nrfields; ++i) {
            if (this.input.getFieldName()[i] == null) continue;
            TableItem item = this.wFields.table.getItem(i);
            int col = 1;
            item.setText(col++, this.input.getFieldName()[i]);
            String type = this.input.getFieldType()[i];
            String format = this.input.getFieldFormat()[i];
            String length = this.input.getFieldLength()[i] < 0 ? "" : "" + this.input.getFieldLength()[i];
            String prec = this.input.getFieldPrecision()[i] < 0 ? "" : "" + this.input.getFieldPrecision()[i];
            String curr = this.input.getCurrency()[i];
            String group = this.input.getGroup()[i];
            String decim = this.input.getDecimal()[i];
            item.setText(col++, Const.NVL((String)type, (String)""));
            item.setText(col++, Const.NVL((String)format, (String)""));
            item.setText(col++, Const.NVL((String)length, (String)""));
            item.setText(col++, Const.NVL((String)prec, (String)""));
            item.setText(col++, Const.NVL((String)curr, (String)""));
            item.setText(col++, Const.NVL((String)decim, (String)""));
            item.setText(col++, Const.NVL((String)group, (String)""));
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wStepname.selectAll();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        this.getInfo(this.input);
        this.dispose();
    }

    private void getInfo(DataGridMeta meta) {
        this.getMetaInfo(meta);
        this.getDataInfo(meta);
    }

    private void getMetaInfo(DataGridMeta meta) {
        int nrfields = this.wFields.nrNonEmpty();
        meta.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            int col = 1;
            meta.getFieldName()[i] = item.getText(col++);
            meta.getFieldType()[i] = item.getText(col++);
            meta.getFieldFormat()[i] = item.getText(col++);
            String slength = item.getText(col++);
            String sprec = item.getText(col++);
            meta.getCurrency()[i] = item.getText(col++);
            meta.getDecimal()[i] = item.getText(col++);
            meta.getGroup()[i] = item.getText(col++);
            try {
                meta.getFieldLength()[i] = Integer.parseInt(slength);
            }
            catch (Exception e) {
                meta.getFieldLength()[i] = -1;
            }
            try {
                this.input.getFieldPrecision()[i] = Integer.parseInt(sprec);
                continue;
            }
            catch (Exception e) {
                meta.getFieldPrecision()[i] = -1;
            }
        }
    }

    private void getDataInfo(DataGridMeta meta) {
        ArrayList data = new ArrayList();
        int nrLines = this.wData.table.getItemCount();
        int nrFields = meta.getFieldName().length;
        for (int i = 0; i < nrLines; ++i) {
            ArrayList<String> line = new ArrayList<String>();
            TableItem item = this.wData.table.getItem(i);
            for (int f = 0; f < nrFields; ++f) {
                line.add(item.getText(f + 1));
            }
            data.add(line);
        }
        meta.setDataLines(data);
    }

    private void preview() {
        DataGridMeta oneMeta = new DataGridMeta();
        this.getInfo(oneMeta);
        TransMeta previewMeta = TransPreviewFactory.generatePreviewTransformation((VariableSpace)this.transMeta, (StepMetaInterface)oneMeta, (String)this.wStepname.getText());
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"DataGridDialog.EnterPreviewSize.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DataGridDialog.EnterPreviewSize.Message", (String[])new String[0]));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            TransPreviewProgressDialog progressDialog = new TransPreviewProgressDialog(this.shell, previewMeta, new String[]{this.wStepname.getText()}, new int[]{previewSize});
            progressDialog.open();
            Trans trans = progressDialog.getTrans();
            String loggingText = progressDialog.getLoggingText();
            if (!progressDialog.isCancelled() && trans.getResult() != null && trans.getResult().getNrErrors() > 0L) {
                EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                etd.setReadOnly();
                etd.open();
            }
            PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, (VariableSpace)this.transMeta, 0, this.wStepname.getText(), progressDialog.getPreviewRowsMeta(this.wStepname.getText()), progressDialog.getPreviewRows(this.wStepname.getText()), loggingText);
            prd.open();
        }
    }
}

