/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.dynamicsqlrow;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.dynamicsqlrow.DynamicSQLRowMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.StyledTextComp;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.steps.tableinput.SQLValuesHighlight;

public class DynamicSQLRowDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = DynamicSQLRowMeta.class;
    private boolean gotPreviousFields = false;
    private CCombo wConnection;
    private Label wlSQL;
    private StyledTextComp wSQL;
    private FormData fdlSQL;
    private FormData fdSQL;
    private Label wlLimit;
    private Text wLimit;
    private FormData fdlLimit;
    private FormData fdLimit;
    private Label wlOuter;
    private Button wOuter;
    private FormData fdlOuter;
    private FormData fdOuter;
    private Label wluseVars;
    private Button wuseVars;
    private FormData fdluseVars;
    private FormData fduseVars;
    private Label wlPosition;
    private FormData fdlPosition;
    private Label wlSQLFieldName;
    private CCombo wSQLFieldName;
    private FormData fdlSQLFieldName;
    private FormData fdSQLFieldName;
    private Label wlqueryOnlyOnChange;
    private Button wqueryOnlyOnChange;
    private FormData fdlqueryOnlyOnChange;
    private FormData fdqueryOnlyOnChange;
    private DynamicSQLRowMeta input;

    public DynamicSQLRowDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.input = (DynamicSQLRowMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DynamicSQLRowDialog.this.input.setChanged();
            }
        };
        this.backupChanged = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"DynamicSQLRowDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"DynamicSQLRowDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wStepname, middle, margin);
        if (this.input.getDatabaseMeta() == null && this.transMeta.nrDatabases() == 1) {
            this.wConnection.select(0);
        }
        this.wConnection.addModifyListener(lsMod);
        this.wlSQLFieldName = new Label((Composite)this.shell, 131072);
        this.wlSQLFieldName.setText(BaseMessages.getString(PKG, (String)"DynamicSQLRowDialog.SQLFieldName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSQLFieldName);
        this.fdlSQLFieldName = new FormData();
        this.fdlSQLFieldName.left = new FormAttachment(0, 0);
        this.fdlSQLFieldName.right = new FormAttachment(middle, -margin);
        this.fdlSQLFieldName.top = new FormAttachment((Control)this.wConnection, 2 * margin);
        this.wlSQLFieldName.setLayoutData((Object)this.fdlSQLFieldName);
        this.wSQLFieldName = new CCombo((Composite)this.shell, 2056);
        this.wSQLFieldName.setEditable(true);
        this.props.setLook((Control)this.wSQLFieldName);
        this.wSQLFieldName.addModifyListener(lsMod);
        this.fdSQLFieldName = new FormData();
        this.fdSQLFieldName.left = new FormAttachment(middle, 0);
        this.fdSQLFieldName.top = new FormAttachment((Control)this.wConnection, 2 * margin);
        this.fdSQLFieldName.right = new FormAttachment(100, -margin);
        this.wSQLFieldName.setLayoutData((Object)this.fdSQLFieldName);
        this.wSQLFieldName.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)DynamicSQLRowDialog.this.shell.getDisplay(), 1);
                DynamicSQLRowDialog.this.shell.setCursor(busy);
                DynamicSQLRowDialog.this.get();
                DynamicSQLRowDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, null);
        this.wlLimit = new Label((Composite)this.shell, 131072);
        this.wlLimit.setText(BaseMessages.getString(PKG, (String)"DynamicSQLRowDialog.Limit.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlLimit);
        this.fdlLimit = new FormData();
        this.fdlLimit.left = new FormAttachment(0, 0);
        this.fdlLimit.right = new FormAttachment(middle, -margin);
        this.fdlLimit.top = new FormAttachment((Control)this.wSQLFieldName, margin);
        this.wlLimit.setLayoutData((Object)this.fdlLimit);
        this.wLimit = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wLimit);
        this.wLimit.addModifyListener(lsMod);
        this.fdLimit = new FormData();
        this.fdLimit.left = new FormAttachment(middle, 0);
        this.fdLimit.right = new FormAttachment(100, 0);
        this.fdLimit.top = new FormAttachment((Control)this.wSQLFieldName, margin);
        this.wLimit.setLayoutData((Object)this.fdLimit);
        this.wlOuter = new Label((Composite)this.shell, 131072);
        this.wlOuter.setText(BaseMessages.getString(PKG, (String)"DynamicSQLRowDialog.Outerjoin.Label", (String[])new String[0]));
        this.wlOuter.setToolTipText(BaseMessages.getString(PKG, (String)"DynamicSQLRowDialog.Outerjoin.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wlOuter);
        this.fdlOuter = new FormData();
        this.fdlOuter.left = new FormAttachment(0, 0);
        this.fdlOuter.right = new FormAttachment(middle, -margin);
        this.fdlOuter.top = new FormAttachment((Control)this.wLimit, margin);
        this.wlOuter.setLayoutData((Object)this.fdlOuter);
        this.wOuter = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wOuter);
        this.wOuter.setToolTipText(this.wlOuter.getToolTipText());
        this.fdOuter = new FormData();
        this.fdOuter.left = new FormAttachment(middle, 0);
        this.fdOuter.top = new FormAttachment((Control)this.wLimit, margin);
        this.wOuter.setLayoutData((Object)this.fdOuter);
        this.wOuter.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DynamicSQLRowDialog.this.input.setChanged();
            }
        });
        this.wluseVars = new Label((Composite)this.shell, 131072);
        this.wluseVars.setText(BaseMessages.getString(PKG, (String)"DynamicSQLRowDialog.useVarsjoin.Label", (String[])new String[0]));
        this.wluseVars.setToolTipText(BaseMessages.getString(PKG, (String)"DynamicSQLRowDialog.useVarsjoin.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wluseVars);
        this.fdluseVars = new FormData();
        this.fdluseVars.left = new FormAttachment(0, 0);
        this.fdluseVars.right = new FormAttachment(middle, -margin);
        this.fdluseVars.top = new FormAttachment((Control)this.wOuter, margin);
        this.wluseVars.setLayoutData((Object)this.fdluseVars);
        this.wuseVars = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wuseVars);
        this.wuseVars.setToolTipText(this.wluseVars.getToolTipText());
        this.fduseVars = new FormData();
        this.fduseVars.left = new FormAttachment(middle, 0);
        this.fduseVars.top = new FormAttachment((Control)this.wOuter, margin);
        this.wuseVars.setLayoutData((Object)this.fduseVars);
        this.wuseVars.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DynamicSQLRowDialog.this.input.setChanged();
            }
        });
        this.wlqueryOnlyOnChange = new Label((Composite)this.shell, 131072);
        this.wlqueryOnlyOnChange.setText(BaseMessages.getString(PKG, (String)"DynamicSQLRowDialog.queryOnlyOnChangejoin.Label", (String[])new String[0]));
        this.wlqueryOnlyOnChange.setToolTipText(BaseMessages.getString(PKG, (String)"DynamicSQLRowDialog.queryOnlyOnChangejoin.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wlqueryOnlyOnChange);
        this.fdlqueryOnlyOnChange = new FormData();
        this.fdlqueryOnlyOnChange.left = new FormAttachment(0, 0);
        this.fdlqueryOnlyOnChange.right = new FormAttachment(middle, -margin);
        this.fdlqueryOnlyOnChange.top = new FormAttachment((Control)this.wuseVars, margin);
        this.wlqueryOnlyOnChange.setLayoutData((Object)this.fdlqueryOnlyOnChange);
        this.wqueryOnlyOnChange = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wqueryOnlyOnChange);
        this.wqueryOnlyOnChange.setToolTipText(this.wlqueryOnlyOnChange.getToolTipText());
        this.fdqueryOnlyOnChange = new FormData();
        this.fdqueryOnlyOnChange.left = new FormAttachment(middle, 0);
        this.fdqueryOnlyOnChange.top = new FormAttachment((Control)this.wuseVars, margin);
        this.wqueryOnlyOnChange.setLayoutData((Object)this.fdqueryOnlyOnChange);
        this.wqueryOnlyOnChange.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DynamicSQLRowDialog.this.input.setChanged();
            }
        });
        this.wlSQL = new Label((Composite)this.shell, 0);
        this.wlSQL.setText(BaseMessages.getString(PKG, (String)"DynamicSQLRowDialog.SQL.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSQL);
        this.fdlSQL = new FormData();
        this.fdlSQL.left = new FormAttachment(0, 0);
        this.fdlSQL.top = new FormAttachment((Control)this.wqueryOnlyOnChange, margin);
        this.wlSQL.setLayoutData((Object)this.fdlSQL);
        this.wSQL = new StyledTextComp((VariableSpace)this.transMeta, (Composite)this.shell, 19202, "");
        this.props.setLook((Control)this.wSQL, 1);
        this.fdSQL = new FormData();
        this.fdSQL.left = new FormAttachment(0, 0);
        this.fdSQL.top = new FormAttachment((Control)this.wlSQL, margin);
        this.fdSQL.right = new FormAttachment(100, -2 * margin);
        this.fdSQL.bottom = new FormAttachment((Control)this.wOK, -4 * margin);
        this.wSQL.setLayoutData(this.fdSQL);
        this.wSQL.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                DynamicSQLRowDialog.this.setPosition();
            }
        });
        this.wSQL.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                DynamicSQLRowDialog.this.setPosition();
            }

            public void keyReleased(KeyEvent e) {
                DynamicSQLRowDialog.this.setPosition();
            }
        });
        this.wSQL.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DynamicSQLRowDialog.this.setPosition();
            }

            public void focusLost(FocusEvent e) {
                DynamicSQLRowDialog.this.setPosition();
            }
        });
        this.wSQL.addMouseListener(new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                DynamicSQLRowDialog.this.setPosition();
            }

            public void mouseDown(MouseEvent e) {
                DynamicSQLRowDialog.this.setPosition();
            }

            public void mouseUp(MouseEvent e) {
                DynamicSQLRowDialog.this.setPosition();
            }
        });
        this.wSQL.addModifyListener(lsMod);
        this.wSQL.addLineStyleListener(new SQLValuesHighlight());
        this.wlPosition = new Label((Composite)this.shell, 0);
        this.props.setLook((Control)this.wlPosition);
        this.fdlPosition = new FormData();
        this.fdlPosition.left = new FormAttachment(0, 0);
        this.fdlPosition.top = new FormAttachment((Control)this.wSQL, margin);
        this.fdlPosition.right = new FormAttachment(100, 0);
        this.wlPosition.setLayoutData((Object)this.fdlPosition);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                DynamicSQLRowDialog.this.ok();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                DynamicSQLRowDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                DynamicSQLRowDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wLimit.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                DynamicSQLRowDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.input.setChanged(this.backupChanged);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void setPosition() {
        String scr = this.wSQL.getText();
        int linenr = this.wSQL.getLineAtOffset(this.wSQL.getCaretOffset()) + 1;
        int posnr = this.wSQL.getCaretOffset();
        int colnr = 0;
        while (posnr > 0 && scr.charAt(posnr - 1) != '\n' && scr.charAt(posnr - 1) != '\r') {
            --posnr;
            ++colnr;
        }
        this.wlPosition.setText(BaseMessages.getString(PKG, (String)"DynamicSQLRowDialog.Position.Label", (String[])new String[]{"" + linenr, "" + colnr}));
    }

    public void getData() {
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"DynamicSQLRowDialog.Log.GettingKeyInfo", (String[])new String[0]));
        }
        this.wSQL.setText(Const.NVL((String)this.input.getSql(), (String)""));
        this.wLimit.setText("" + this.input.getRowLimit());
        this.wOuter.setSelection(this.input.isOuterJoin());
        this.wuseVars.setSelection(this.input.isVariableReplace());
        if (this.input.getSQLFieldName() != null) {
            this.wSQLFieldName.setText(this.input.getSQLFieldName());
        }
        this.wqueryOnlyOnChange.setSelection(this.input.isQueryOnlyOnChange());
        if (this.input.getDatabaseMeta() != null) {
            this.wConnection.setText(this.input.getDatabaseMeta().getName());
        } else if (this.transMeta.nrDatabases() == 1) {
            this.wConnection.setText(this.transMeta.getDatabase(0).getName());
        }
        this.wStepname.selectAll();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.input.setRowLimit(Const.toInt((String)this.wLimit.getText(), (int)0));
        this.input.setSql(this.wSQL.getText());
        this.input.setSQLFieldName(this.wSQLFieldName.getText());
        this.input.setOuterJoin(this.wOuter.getSelection());
        this.input.setVariableReplace(this.wuseVars.getSelection());
        this.input.setQueryOnlyOnChange(this.wqueryOnlyOnChange.getSelection());
        this.input.setDatabaseMeta(this.transMeta.findDatabase(this.wConnection.getText()));
        this.stepname = this.wStepname.getText();
        if (this.transMeta.findDatabase(this.wConnection.getText()) == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"DynamicSQLRowDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"DynamicSQLRowDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        this.dispose();
    }

    private void get() {
        if (!this.gotPreviousFields) {
            this.gotPreviousFields = true;
            try {
                String sqlfield = this.wSQLFieldName.getText();
                this.wSQLFieldName.removeAll();
                RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
                if (r != null) {
                    this.wSQLFieldName.removeAll();
                    this.wSQLFieldName.setItems(r.getFieldNames());
                }
                if (sqlfield != null) {
                    this.wSQLFieldName.setText(sqlfield);
                }
            }
            catch (KettleException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"DynamicSQLRowDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"DynamicSQLRowDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
        }
    }
}

