/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.execprocess;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.execprocess.ExecProcessMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class ExecProcessDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = ExecProcessMeta.class;
    private Label wlProcess;
    private CCombo wProcess;
    private FormData fdlProcess;
    private FormData fdProcess;
    private Label wlResult;
    private TextVar wResult;
    private FormData fdlResult;
    private FormData fdResult;
    private Label wlExitValue;
    private TextVar wExitValue;
    private FormData fdlExitValue;
    private FormData fdExitValue;
    private Label wlError;
    private TextVar wError;
    private FormData fdlError;
    private FormData fdError;
    private Group wOutputFields;
    private FormData fdOutputFields;
    private Label wlFailWhenNotSuccess;
    private Button wFailWhenNotSuccess;
    private FormData fdlFailWhenNotSuccess;
    private FormData fdFailWhenNotSuccess;
    private ExecProcessMeta input;
    private boolean gotPreviousFields = false;

    public ExecProcessDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (ExecProcessMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ExecProcessDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ExecProcessDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"ExecProcessDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wlProcess = new Label((Composite)this.shell, 131072);
        this.wlProcess.setText(BaseMessages.getString(PKG, (String)"ExecProcessDialog.Process.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlProcess);
        this.fdlProcess = new FormData();
        this.fdlProcess.left = new FormAttachment(0, 0);
        this.fdlProcess.right = new FormAttachment(middle, -margin);
        this.fdlProcess.top = new FormAttachment((Control)this.wStepname, margin);
        this.wlProcess.setLayoutData((Object)this.fdlProcess);
        this.wProcess = new CCombo((Composite)this.shell, 2056);
        this.wProcess.setEditable(true);
        this.props.setLook((Control)this.wProcess);
        this.wProcess.addModifyListener(lsMod);
        this.fdProcess = new FormData();
        this.fdProcess.left = new FormAttachment(middle, 0);
        this.fdProcess.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdProcess.right = new FormAttachment(100, -margin);
        this.wProcess.setLayoutData((Object)this.fdProcess);
        this.wProcess.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)ExecProcessDialog.this.shell.getDisplay(), 1);
                ExecProcessDialog.this.shell.setCursor(busy);
                ExecProcessDialog.this.get();
                ExecProcessDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.wlFailWhenNotSuccess = new Label((Composite)this.shell, 131072);
        this.wlFailWhenNotSuccess.setText(BaseMessages.getString(PKG, (String)"ExecProcessDialog.FailWhenNotSuccess.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFailWhenNotSuccess);
        this.fdlFailWhenNotSuccess = new FormData();
        this.fdlFailWhenNotSuccess.left = new FormAttachment(0, 0);
        this.fdlFailWhenNotSuccess.top = new FormAttachment((Control)this.wProcess, margin);
        this.fdlFailWhenNotSuccess.right = new FormAttachment(middle, -margin);
        this.wlFailWhenNotSuccess.setLayoutData((Object)this.fdlFailWhenNotSuccess);
        this.wFailWhenNotSuccess = new Button((Composite)this.shell, 32);
        this.wFailWhenNotSuccess.setToolTipText(BaseMessages.getString(PKG, (String)"ExecProcessDialog.FailWhenNotSuccess.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wFailWhenNotSuccess);
        this.fdFailWhenNotSuccess = new FormData();
        this.fdFailWhenNotSuccess.left = new FormAttachment(middle, 0);
        this.fdFailWhenNotSuccess.top = new FormAttachment((Control)this.wProcess, margin);
        this.fdFailWhenNotSuccess.right = new FormAttachment(100, 0);
        this.wFailWhenNotSuccess.setLayoutData((Object)this.fdFailWhenNotSuccess);
        this.wFailWhenNotSuccess.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecProcessDialog.this.input.setChanged();
            }
        });
        this.wOutputFields = new Group((Composite)this.shell, 32);
        this.props.setLook((Control)this.wOutputFields);
        this.wOutputFields.setText(BaseMessages.getString(PKG, (String)"ExecProcessDialog.OutputFields.Label", (String[])new String[0]));
        FormLayout OutputFieldsgroupLayout = new FormLayout();
        OutputFieldsgroupLayout.marginWidth = 10;
        OutputFieldsgroupLayout.marginHeight = 10;
        this.wOutputFields.setLayout((Layout)OutputFieldsgroupLayout);
        this.wlResult = new Label((Composite)this.wOutputFields, 131072);
        this.wlResult.setText(BaseMessages.getString(PKG, (String)"ExecProcessDialog.ResultField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlResult);
        this.fdlResult = new FormData();
        this.fdlResult.left = new FormAttachment(0, 0);
        this.fdlResult.right = new FormAttachment(middle, -margin);
        this.fdlResult.top = new FormAttachment((Control)this.wFailWhenNotSuccess, margin * 2);
        this.wlResult.setLayoutData((Object)this.fdlResult);
        this.wResult = new TextVar((VariableSpace)this.transMeta, (Composite)this.wOutputFields, 18436);
        this.wResult.setToolTipText(BaseMessages.getString(PKG, (String)"ExecProcessDialog.ResultField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wResult);
        this.wResult.addModifyListener(lsMod);
        this.fdResult = new FormData();
        this.fdResult.left = new FormAttachment(middle, 0);
        this.fdResult.top = new FormAttachment((Control)this.wFailWhenNotSuccess, margin * 2);
        this.fdResult.right = new FormAttachment(100, 0);
        this.wResult.setLayoutData(this.fdResult);
        this.wlError = new Label((Composite)this.wOutputFields, 131072);
        this.wlError.setText(BaseMessages.getString(PKG, (String)"ExecProcessDialog.ErrorField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlError);
        this.fdlError = new FormData();
        this.fdlError.left = new FormAttachment(0, 0);
        this.fdlError.right = new FormAttachment(middle, -margin);
        this.fdlError.top = new FormAttachment((Control)this.wResult, margin);
        this.wlError.setLayoutData((Object)this.fdlError);
        this.wError = new TextVar((VariableSpace)this.transMeta, (Composite)this.wOutputFields, 18436);
        this.wError.setToolTipText(BaseMessages.getString(PKG, (String)"ExecProcessDialog.ErrorField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wError);
        this.wError.addModifyListener(lsMod);
        this.fdError = new FormData();
        this.fdError.left = new FormAttachment(middle, 0);
        this.fdError.top = new FormAttachment((Control)this.wResult, margin);
        this.fdError.right = new FormAttachment(100, 0);
        this.wError.setLayoutData(this.fdError);
        this.wlExitValue = new Label((Composite)this.wOutputFields, 131072);
        this.wlExitValue.setText(BaseMessages.getString(PKG, (String)"ExecProcessDialog.ExitValueField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlExitValue);
        this.fdlExitValue = new FormData();
        this.fdlExitValue.left = new FormAttachment(0, 0);
        this.fdlExitValue.right = new FormAttachment(middle, -margin);
        this.fdlExitValue.top = new FormAttachment((Control)this.wError, margin);
        this.wlExitValue.setLayoutData((Object)this.fdlExitValue);
        this.wExitValue = new TextVar((VariableSpace)this.transMeta, (Composite)this.wOutputFields, 18436);
        this.wExitValue.setToolTipText(BaseMessages.getString(PKG, (String)"ExecProcessDialog.ExitValueField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wExitValue);
        this.wExitValue.addModifyListener(lsMod);
        this.fdExitValue = new FormData();
        this.fdExitValue.left = new FormAttachment(middle, 0);
        this.fdExitValue.top = new FormAttachment((Control)this.wError, margin);
        this.fdExitValue.right = new FormAttachment(100, 0);
        this.wExitValue.setLayoutData(this.fdExitValue);
        this.fdOutputFields = new FormData();
        this.fdOutputFields.left = new FormAttachment(0, margin);
        this.fdOutputFields.top = new FormAttachment((Control)this.wFailWhenNotSuccess, 2 * margin);
        this.fdOutputFields.right = new FormAttachment(100, -margin);
        this.wOutputFields.setLayoutData((Object)this.fdOutputFields);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, (Control)this.wOutputFields);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                ExecProcessDialog.this.ok();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                ExecProcessDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ExecProcessDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                ExecProcessDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void getData() {
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"ExecProcessDialog.Log.GettingKeyInfo", (String[])new String[0]));
        }
        if (this.input.getProcessField() != null) {
            this.wProcess.setText(this.input.getProcessField());
        }
        if (this.input.getResultFieldName() != null) {
            this.wResult.setText(this.input.getResultFieldName());
        }
        if (this.input.getErrorFieldName() != null) {
            this.wError.setText(this.input.getErrorFieldName());
        }
        if (this.input.getExitValueFieldName() != null) {
            this.wExitValue.setText(this.input.getExitValueFieldName());
        }
        this.wFailWhenNotSuccess.setSelection(this.input.isFailWhenNotSuccess());
        this.wStepname.selectAll();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.input.setProcessField(this.wProcess.getText());
        this.input.setResultFieldName(this.wResult.getText());
        this.input.setErrorFieldName(this.wError.getText());
        this.input.setExitValueFieldName(this.wExitValue.getText());
        this.input.setFailWhentNoSuccess(this.wFailWhenNotSuccess.getSelection());
        this.stepname = this.wStepname.getText();
        this.dispose();
    }

    private void get() {
        if (!this.gotPreviousFields) {
            try {
                String fieldvalue = this.wProcess.getText();
                this.wProcess.removeAll();
                RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
                if (r != null) {
                    this.wProcess.setItems(r.getFieldNames());
                }
                if (fieldvalue != null) {
                    this.wProcess.setText(fieldvalue);
                }
                this.gotPreviousFields = true;
            }
            catch (KettleException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"ExecProcessDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ExecProcessDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
        }
    }
}

