/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.fieldschangesequence;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.fieldschangesequence.FieldsChangeSequenceMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.step.TableItemInsertListener;

public class FieldsChangeSequenceDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = FieldsChangeSequenceMeta.class;
    private FieldsChangeSequenceMeta input;
    private Label wlStart;
    private TextVar wStart;
    private FormData fdlStart;
    private FormData fdStart;
    private Label wlIncrement;
    private TextVar wIncrement;
    private FormData fdlIncrement;
    private FormData fdIncrement;
    private Label wlFields;
    private TableView wFields;
    private FormData fdlFields;
    private FormData fdFields;
    private Label wlResult;
    private Text wResult;
    private FormData fdlResult;
    private FormData fdResult;
    private Map<String, Integer> inputFields;
    private ColumnInfo[] colinf;
    public static final String STRING_CHANGE_SEQUENCE_WARNING_PARAMETER = "ChangeSequenceSortWarning";

    public FieldsChangeSequenceDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.input = (FieldsChangeSequenceMeta)in;
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FieldsChangeSequenceDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"FieldsChangeSequenceDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"FieldsChangeSequenceDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wlResult = new Label((Composite)this.shell, 131072);
        this.wlResult.setText(BaseMessages.getString(PKG, (String)"FieldsChangeSequenceDialog.Result.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlResult);
        this.fdlResult = new FormData();
        this.fdlResult.left = new FormAttachment(0, 0);
        this.fdlResult.right = new FormAttachment(middle, -margin);
        this.fdlResult.top = new FormAttachment((Control)this.wStepname, 2 * margin);
        this.wlResult.setLayoutData((Object)this.fdlResult);
        this.wResult = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wResult);
        this.wResult.addModifyListener(lsMod);
        this.fdResult = new FormData();
        this.fdResult.left = new FormAttachment(middle, 0);
        this.fdResult.top = new FormAttachment((Control)this.wStepname, 2 * margin);
        this.fdResult.right = new FormAttachment(100, 0);
        this.wResult.setLayoutData((Object)this.fdResult);
        this.wlStart = new Label((Composite)this.shell, 131072);
        this.wlStart.setText(BaseMessages.getString(PKG, (String)"FieldsChangeSequenceDialog.Start.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStart);
        this.fdlStart = new FormData();
        this.fdlStart.left = new FormAttachment(0, 0);
        this.fdlStart.right = new FormAttachment(middle, -margin);
        this.fdlStart.top = new FormAttachment((Control)this.wResult, margin);
        this.wlStart.setLayoutData((Object)this.fdlStart);
        this.wStart = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wStart);
        this.fdStart = new FormData();
        this.fdStart.left = new FormAttachment(middle, 0);
        this.fdStart.top = new FormAttachment((Control)this.wResult, margin);
        this.fdStart.right = new FormAttachment(100, 0);
        this.wStart.setLayoutData(this.fdStart);
        this.wlIncrement = new Label((Composite)this.shell, 131072);
        this.wlIncrement.setText(BaseMessages.getString(PKG, (String)"FieldsChangeSequenceDialog.Increment.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlIncrement);
        this.fdlIncrement = new FormData();
        this.fdlIncrement.left = new FormAttachment(0, 0);
        this.fdlIncrement.right = new FormAttachment(middle, -margin);
        this.fdlIncrement.top = new FormAttachment((Control)this.wStart, margin);
        this.wlIncrement.setLayoutData((Object)this.fdlIncrement);
        this.wIncrement = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wIncrement);
        this.fdIncrement = new FormData();
        this.fdIncrement.left = new FormAttachment(middle, 0);
        this.fdIncrement.top = new FormAttachment((Control)this.wStart, margin);
        this.fdIncrement.right = new FormAttachment(100, 0);
        this.wIncrement.setLayoutData(this.fdIncrement);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wGet, this.wCancel}, margin, null);
        this.wlFields = new Label((Composite)this.shell, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"FieldsChangeSequenceDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFields);
        this.fdlFields = new FormData();
        this.fdlFields.left = new FormAttachment(0, 0);
        this.fdlFields.top = new FormAttachment((Control)this.wIncrement, margin);
        this.wlFields.setLayoutData((Object)this.fdlFields);
        boolean FieldsCols = true;
        int FieldsRows = this.input.getFieldName().length;
        this.colinf = new ColumnInfo[1];
        this.colinf[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"FieldsChangeSequenceDialog.Fieldname.Column", (String[])new String[0]), 2, new String[]{""}, false);
        this.wFields = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 67586, this.colinf, FieldsRows, lsMod, this.props);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        this.fdFields.right = new FormAttachment(100, 0);
        this.fdFields.bottom = new FormAttachment((Control)this.wOK, -2 * margin);
        this.wFields.setLayoutData(this.fdFields);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                FieldsChangeSequenceDialog.this.cancel();
            }
        };
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                FieldsChangeSequenceDialog.this.get();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                FieldsChangeSequenceDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.wGet.addListener(13, this.lsGet);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                FieldsChangeSequenceDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                FieldsChangeSequenceDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        Runnable runnable = new Runnable(){

            public void run() {
                StepMeta stepMeta = FieldsChangeSequenceDialog.this.transMeta.findStep(FieldsChangeSequenceDialog.this.stepname);
                if (stepMeta != null) {
                    try {
                        RowMetaInterface row = FieldsChangeSequenceDialog.this.transMeta.getPrevStepFields(stepMeta);
                        if (row != null) {
                            for (int i = 0; i < row.size(); ++i) {
                                FieldsChangeSequenceDialog.this.inputFields.put(row.getValueMeta(i).getName(), new Integer(i));
                            }
                            FieldsChangeSequenceDialog.this.setComboBoxes();
                        }
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                if (!FieldsChangeSequenceDialog.this.wFields.isDisposed()) {
                                    for (int i = 0; i < ((FieldsChangeSequenceDialog)FieldsChangeSequenceDialog.this).wFields.table.getItemCount(); ++i) {
                                        TableItem it = ((FieldsChangeSequenceDialog)FieldsChangeSequenceDialog.this).wFields.table.getItem(i);
                                        if (Const.isEmpty((String)it.getText(1)) || FieldsChangeSequenceDialog.this.inputFields.containsKey(it.getText(1))) continue;
                                        it.setBackground(GUIResource.getInstance().getColorRed());
                                    }
                                }
                            }
                        });
                    }
                    catch (KettleException e) {
                        FieldsChangeSequenceDialog.this.logError(BaseMessages.getString((Class)PKG, (String)"FieldsChangeSequenceDialog.ErrorGettingPreviousFields", (String[])new String[]{e.getMessage()}));
                    }
                }
            }
        };
        new Thread(runnable).start();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.colinf[0].setComboValues(fieldNames);
    }

    private void get() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null) {
                TableItemInsertListener insertListener = new TableItemInsertListener(){

                    public boolean tableItemInserted(TableItem tableItem, ValueMetaInterface v) {
                        tableItem.setText(2, BaseMessages.getString((Class)PKG, (String)"System.Combo.Yes", (String[])new String[0]));
                        return true;
                    }
                };
                BaseStepDialog.getFieldsFromPrevious(r, this.wFields, 1, new int[]{1}, new int[0], -1, -1, insertListener);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    public void getData() {
        this.wStart.setText(Const.NVL((String)this.input.getStart(), (String)"1"));
        this.wIncrement.setText(Const.NVL((String)this.input.getIncrement(), (String)"1"));
        this.wResult.setText(Const.NVL((String)this.input.getResultFieldName(), (String)"result"));
        Table table = this.wFields.table;
        if (this.input.getFieldName().length > 0) {
            table.removeAll();
        }
        for (int i = 0; i < this.input.getFieldName().length; ++i) {
            TableItem ti = new TableItem(table, 0);
            ti.setText(0, "" + (i + 1));
            ti.setText(1, this.input.getFieldName()[i]);
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wStepname.selectAll();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        this.input.setStart(this.wStart.getText());
        this.input.setIncrement(this.wIncrement.getText());
        this.input.setResultFieldName(this.wResult.getText());
        int nrfields = this.wFields.nrNonEmpty();
        this.input.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            TableItem ti = this.wFields.getNonEmpty(i);
            this.input.getFieldName()[i] = ti.getText(1);
        }
        if ("Y".equalsIgnoreCase(this.props.getCustomParameter(STRING_CHANGE_SEQUENCE_WARNING_PARAMETER, "Y"))) {
            MessageDialogWithToggle md = new MessageDialogWithToggle(this.shell, BaseMessages.getString(PKG, (String)"FieldsChangeSequenceDialog.InputNeedSort.DialogTitle", (String[])new String[0]), null, BaseMessages.getString(PKG, (String)"FieldsChangeSequenceDialog.InputNeedSort.DialogMessage", (String[])new String[]{Const.CR}) + Const.CR, 4, new String[]{BaseMessages.getString(PKG, (String)"FieldsChangeSequenceDialog.InputNeedSort.Option1", (String[])new String[0])}, 0, BaseMessages.getString(PKG, (String)"FieldsChangeSequenceDialog.InputNeedSort.Option2", (String[])new String[0]), "N".equalsIgnoreCase(this.props.getCustomParameter(STRING_CHANGE_SEQUENCE_WARNING_PARAMETER, "Y")));
            MessageDialogWithToggle.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
            md.open();
            this.props.setCustomParameter(STRING_CHANGE_SEQUENCE_WARNING_PARAMETER, md.getToggleState() ? "N" : "Y");
            this.props.saveProps();
        }
        this.dispose();
    }
}

