/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.fixedinput;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPreviewFactory;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.fixedinput.FixedFileInputField;
import org.pentaho.di.trans.steps.fixedinput.FixedInputMeta;
import org.pentaho.di.ui.core.dialog.EnterNumberDialog;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ComboValuesSelectionListener;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.dialog.TransPreviewProgressDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.steps.fixedinput.FixedFileImportWizardPage1;
import org.pentaho.di.ui.trans.steps.fixedinput.FixedFileImportWizardPage2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedInputDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = FixedInputMeta.class;
    private FixedInputMeta inputMeta;
    private TextVar wFilename;
    private Button wbbFilename;
    private TextVar wLineWidth;
    private Button wLineFeedPresent;
    private TextVar wBufferSize;
    private Button wLazyConversion;
    private Button wHeaderPresent;
    private ComboVar wEncoding;
    private TableView wFields;
    private Button wRunningInParallel;
    private Label wlFileType;
    private CCombo wFileType;
    private Label wlAddResult;
    private Button wAddResult;
    private FormData fdlAddResult;
    private FormData fdAddResult;
    private List<FixedFileInputField> fields;
    private boolean gotEncodings;

    public FixedInputDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.inputMeta = (FixedInputMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.inputMeta);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FixedInputDialog.this.inputMeta.setChanged();
            }
        };
        this.changed = this.inputMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"FixedInputDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"FixedInputDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        Object lastControl = this.wStepname;
        this.wbbFilename = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbbFilename);
        this.wbbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.wbbFilename.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForFileOrDirAndAdd", (String[])new String[0]));
        FormData fdbFilename = new FormData();
        fdbFilename.top = new FormAttachment((Control)lastControl, margin);
        fdbFilename.right = new FormAttachment(100, 0);
        this.wbbFilename.setLayoutData((Object)fdbFilename);
        Label wlFilename = new Label((Composite)this.shell, 131072);
        wlFilename.setText(BaseMessages.getString(PKG, (String)"FixedInputDialog.Filename.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFilename);
        FormData fdlFilename = new FormData();
        fdlFilename.top = new FormAttachment((Control)lastControl, margin);
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.right = new FormAttachment(middle, -margin);
        wlFilename.setLayoutData((Object)fdlFilename);
        this.wFilename = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wFilename);
        this.wFilename.addModifyListener(lsMod);
        FormData fdFilename = new FormData();
        fdFilename.top = new FormAttachment((Control)lastControl, margin);
        fdFilename.left = new FormAttachment(middle, 0);
        fdFilename.right = new FormAttachment((Control)this.wbbFilename, -margin);
        this.wFilename.setLayoutData(fdFilename);
        lastControl = this.wFilename;
        Label wlLineWidth = new Label((Composite)this.shell, 131072);
        wlLineWidth.setText(BaseMessages.getString(PKG, (String)"FixedInputDialog.LineWidth.Label", (String[])new String[0]));
        this.props.setLook((Control)wlLineWidth);
        FormData fdlLineWidth = new FormData();
        fdlLineWidth.top = new FormAttachment((Control)lastControl, margin);
        fdlLineWidth.left = new FormAttachment(0, 0);
        fdlLineWidth.right = new FormAttachment(middle, -margin);
        wlLineWidth.setLayoutData((Object)fdlLineWidth);
        this.wLineWidth = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wLineWidth);
        this.wLineWidth.addModifyListener(lsMod);
        FormData fdLineWidth = new FormData();
        fdLineWidth.top = new FormAttachment((Control)lastControl, margin);
        fdLineWidth.left = new FormAttachment(middle, 0);
        fdLineWidth.right = new FormAttachment(100, 0);
        this.wLineWidth.setLayoutData(fdLineWidth);
        lastControl = this.wLineWidth;
        Label wlLineFeedPresent = new Label((Composite)this.shell, 131072);
        wlLineFeedPresent.setText(BaseMessages.getString(PKG, (String)"FixedInputDialog.LineFeedPresent.Label", (String[])new String[0]));
        this.props.setLook((Control)wlLineFeedPresent);
        FormData fdlLineFeedPresent = new FormData();
        fdlLineFeedPresent.top = new FormAttachment((Control)lastControl, margin);
        fdlLineFeedPresent.left = new FormAttachment(0, 0);
        fdlLineFeedPresent.right = new FormAttachment(middle, -margin);
        wlLineFeedPresent.setLayoutData((Object)fdlLineFeedPresent);
        this.wLineFeedPresent = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wLineFeedPresent);
        FormData fdLineFeedPresent = new FormData();
        fdLineFeedPresent.top = new FormAttachment((Control)lastControl, margin);
        fdLineFeedPresent.left = new FormAttachment(middle, 0);
        fdLineFeedPresent.right = new FormAttachment(100, 0);
        this.wLineFeedPresent.setLayoutData((Object)fdLineFeedPresent);
        lastControl = this.wLineFeedPresent;
        Label wlBufferSize = new Label((Composite)this.shell, 131072);
        wlBufferSize.setText(BaseMessages.getString(PKG, (String)"FixedInputDialog.BufferSize.Label", (String[])new String[0]));
        this.props.setLook((Control)wlBufferSize);
        FormData fdlBufferSize = new FormData();
        fdlBufferSize.top = new FormAttachment((Control)lastControl, margin);
        fdlBufferSize.left = new FormAttachment(0, 0);
        fdlBufferSize.right = new FormAttachment(middle, -margin);
        wlBufferSize.setLayoutData((Object)fdlBufferSize);
        this.wBufferSize = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wBufferSize);
        this.wBufferSize.addModifyListener(lsMod);
        FormData fdBufferSize = new FormData();
        fdBufferSize.top = new FormAttachment((Control)lastControl, margin);
        fdBufferSize.left = new FormAttachment(middle, 0);
        fdBufferSize.right = new FormAttachment(100, 0);
        this.wBufferSize.setLayoutData(fdBufferSize);
        lastControl = this.wBufferSize;
        Label wlLazyConversion = new Label((Composite)this.shell, 131072);
        wlLazyConversion.setText(BaseMessages.getString(PKG, (String)"FixedInputDialog.LazyConversion.Label", (String[])new String[0]));
        this.props.setLook((Control)wlLazyConversion);
        FormData fdlLazyConversion = new FormData();
        fdlLazyConversion.top = new FormAttachment((Control)lastControl, margin);
        fdlLazyConversion.left = new FormAttachment(0, 0);
        fdlLazyConversion.right = new FormAttachment(middle, -margin);
        wlLazyConversion.setLayoutData((Object)fdlLazyConversion);
        this.wLazyConversion = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wLazyConversion);
        FormData fdLazyConversion = new FormData();
        fdLazyConversion.top = new FormAttachment((Control)lastControl, margin);
        fdLazyConversion.left = new FormAttachment(middle, 0);
        fdLazyConversion.right = new FormAttachment(100, 0);
        this.wLazyConversion.setLayoutData((Object)fdLazyConversion);
        lastControl = this.wLazyConversion;
        Label wlHeaderPresent = new Label((Composite)this.shell, 131072);
        wlHeaderPresent.setText(BaseMessages.getString(PKG, (String)"FixedInputDialog.HeaderPresent.Label", (String[])new String[0]));
        this.props.setLook((Control)wlHeaderPresent);
        FormData fdlHeaderPresent = new FormData();
        fdlHeaderPresent.top = new FormAttachment((Control)lastControl, margin);
        fdlHeaderPresent.left = new FormAttachment(0, 0);
        fdlHeaderPresent.right = new FormAttachment(middle, -margin);
        wlHeaderPresent.setLayoutData((Object)fdlHeaderPresent);
        this.wHeaderPresent = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wHeaderPresent);
        FormData fdHeaderPresent = new FormData();
        fdHeaderPresent.top = new FormAttachment((Control)lastControl, margin);
        fdHeaderPresent.left = new FormAttachment(middle, 0);
        fdHeaderPresent.right = new FormAttachment(100, 0);
        this.wHeaderPresent.setLayoutData((Object)fdHeaderPresent);
        lastControl = this.wHeaderPresent;
        Label wlRunningInParallel = new Label((Composite)this.shell, 131072);
        wlRunningInParallel.setText(BaseMessages.getString(PKG, (String)"FixedInputDialog.RunningInParallel.Label", (String[])new String[0]));
        this.props.setLook((Control)wlRunningInParallel);
        FormData fdlRunningInParallel = new FormData();
        fdlRunningInParallel.top = new FormAttachment((Control)lastControl, margin);
        fdlRunningInParallel.left = new FormAttachment(0, 0);
        fdlRunningInParallel.right = new FormAttachment(middle, -margin);
        wlRunningInParallel.setLayoutData((Object)fdlRunningInParallel);
        this.wRunningInParallel = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wRunningInParallel);
        FormData fdRunningInParallel = new FormData();
        fdRunningInParallel.top = new FormAttachment((Control)lastControl, margin);
        fdRunningInParallel.left = new FormAttachment(middle, 0);
        this.wRunningInParallel.setLayoutData((Object)fdRunningInParallel);
        this.wlFileType = new Label((Composite)this.shell, 131072);
        this.wlFileType.setText(BaseMessages.getString(PKG, (String)"FixedInputDialog.FileType.Label", (String[])new String[0]));
        this.wlFileType.setToolTipText(BaseMessages.getString(PKG, (String)"FixedInputDialog.FileType.ToolTip", (String[])new String[0]));
        this.props.setLook((Control)this.wlFileType);
        FormData fdlFileType = new FormData();
        fdlFileType.top = new FormAttachment((Control)lastControl, margin);
        fdlFileType.left = new FormAttachment((Control)this.wRunningInParallel, margin * 2);
        this.wlFileType.setLayoutData((Object)fdlFileType);
        this.wFileType = new CCombo((Composite)this.shell, 2056);
        this.wFileType.setToolTipText(BaseMessages.getString(PKG, (String)"FixedInputDialog.FileType.ToolTip", (String[])new String[0]));
        this.props.setLook((Control)this.wFileType);
        this.wFileType.setItems(FixedInputMeta.fileTypeDesc);
        FormData fdFileType = new FormData();
        fdFileType.top = new FormAttachment((Control)lastControl, margin);
        fdFileType.left = new FormAttachment((Control)this.wlFileType, margin);
        fdFileType.right = new FormAttachment(100, 0);
        this.wFileType.setLayoutData((Object)fdFileType);
        lastControl = this.wFileType;
        this.wRunningInParallel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FixedInputDialog.this.enableFields();
            }
        });
        Label wlEncoding = new Label((Composite)this.shell, 131072);
        wlEncoding.setText(BaseMessages.getString(PKG, (String)"FixedInputDialog.Encoding.Label", (String[])new String[0]));
        this.props.setLook((Control)wlEncoding);
        FormData fdlEncoding = new FormData();
        fdlEncoding.left = new FormAttachment(0, 0);
        fdlEncoding.top = new FormAttachment((Control)lastControl, margin);
        fdlEncoding.right = new FormAttachment(middle, -margin);
        wlEncoding.setLayoutData((Object)fdlEncoding);
        this.wEncoding = new ComboVar((VariableSpace)this.transMeta, (Composite)this.shell, 2056);
        this.wEncoding.setEditable(true);
        this.props.setLook((Control)this.wEncoding);
        this.wEncoding.addModifyListener(lsMod);
        FormData fdEncoding = new FormData();
        fdEncoding.left = new FormAttachment(middle, 0);
        fdEncoding.top = new FormAttachment((Control)lastControl, margin);
        fdEncoding.right = new FormAttachment(100, 0);
        this.wEncoding.setLayoutData(fdEncoding);
        lastControl = this.wEncoding;
        this.wEncoding.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)FixedInputDialog.this.shell.getDisplay(), 1);
                FixedInputDialog.this.shell.setCursor(busy);
                FixedInputDialog.this.setEncodings();
                FixedInputDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.wlAddResult = new Label((Composite)this.shell, 131072);
        this.wlAddResult.setText(BaseMessages.getString(PKG, (String)"FixedInputDialog.AddResult.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAddResult);
        this.fdlAddResult = new FormData();
        this.fdlAddResult.left = new FormAttachment(0, 0);
        this.fdlAddResult.top = new FormAttachment((Control)lastControl, margin);
        this.fdlAddResult.right = new FormAttachment(middle, -margin);
        this.wlAddResult.setLayoutData((Object)this.fdlAddResult);
        this.wAddResult = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wAddResult);
        this.wAddResult.setToolTipText(BaseMessages.getString(PKG, (String)"FixedInputDialog.AddResult.Tooltip", (String[])new String[0]));
        this.fdAddResult = new FormData();
        this.fdAddResult.left = new FormAttachment(middle, 0);
        this.fdAddResult.top = new FormAttachment((Control)lastControl, margin);
        this.wAddResult.setLayoutData((Object)this.fdAddResult);
        lastControl = this.wAddResult;
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"System.Button.Preview", (String[])new String[0]));
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wGet, this.wPreview, this.wCancel}, margin, null);
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"FixedInputDialog.NameColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FixedInputDialog.TypeColumn.Column", (String[])new String[0]), 2, ValueMeta.getTypes(), true), new ColumnInfo(BaseMessages.getString(PKG, (String)"FixedInputDialog.FormatColumn.Column", (String[])new String[0]), 5, 2), new ColumnInfo(BaseMessages.getString(PKG, (String)"FixedInputDialog.WidthColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FixedInputDialog.LengthColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FixedInputDialog.PrecisionColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FixedInputDialog.CurrencyColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FixedInputDialog.DecimalColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FixedInputDialog.GroupColumn.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"FixedInputDialog.TrimColumn.Column", (String[])new String[0]), 2, ValueMeta.trimTypeDesc)};
        colinf[2].setComboValuesSelectionListener(new ComboValuesSelectionListener(){

            public String[] getComboValues(TableItem tableItem, int rowNr, int colNr) {
                String[] comboValues = new String[]{};
                int type = ValueMeta.getType((String)tableItem.getText(colNr - 1));
                switch (type) {
                    case 3: {
                        comboValues = Const.getDateFormats();
                        break;
                    }
                    case 1: 
                    case 5: 
                    case 6: {
                        comboValues = Const.getNumberFormats();
                        break;
                    }
                }
                return comboValues;
            }
        });
        this.wFields = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 65538, colinf, 1, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.top = new FormAttachment((Control)lastControl, margin * 2);
        fdFields.bottom = new FormAttachment((Control)this.wOK, -margin * 2);
        fdFields.left = new FormAttachment(0, 0);
        fdFields.right = new FormAttachment(100, 0);
        this.wFields.setLayoutData(fdFields);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                FixedInputDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                FixedInputDialog.this.ok();
            }
        };
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                FixedInputDialog.this.getFixed();
            }
        };
        this.lsPreview = new Listener(){

            public void handleEvent(Event e) {
                FixedInputDialog.this.preview();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.wPreview.addListener(13, this.lsPreview);
        this.wGet.addListener(13, this.lsGet);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                FixedInputDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wFilename.addSelectionListener(this.lsDef);
        this.wLineWidth.addSelectionListener(this.lsDef);
        this.wBufferSize.addSelectionListener(this.lsDef);
        this.wbbFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(FixedInputDialog.this.shell, 4096);
                dialog.setFilterExtensions(new String[]{"*.txt", "*"});
                if (FixedInputDialog.this.wFilename.getText() != null) {
                    String fname = FixedInputDialog.this.transMeta.environmentSubstitute(FixedInputDialog.this.wFilename.getText());
                    dialog.setFileName(fname);
                }
                dialog.setFilterNames(new String[]{BaseMessages.getString((Class)PKG, (String)"System.FileType.TextFiles", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"System.FileType.AllFiles", (String[])new String[0])});
                if (dialog.open() != null) {
                    String str = dialog.getFilterPath() + System.getProperty("file.separator") + dialog.getFileName();
                    FixedInputDialog.this.wFilename.setText(str);
                }
            }
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                FixedInputDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.inputMeta.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private void setEncodings() {
        if (!this.gotEncodings) {
            this.gotEncodings = true;
            this.wEncoding.removeAll();
            ArrayList<Charset> values = new ArrayList<Charset>(Charset.availableCharsets().values());
            for (int i = 0; i < values.size(); ++i) {
                Charset charSet = (Charset)values.get(i);
                this.wEncoding.add(charSet.displayName());
            }
            String defEncoding = Const.getEnvironmentVariable((String)"file.encoding", (String)"UTF-8");
            int idx = Const.indexOfString((String)defEncoding, (String[])this.wEncoding.getItems());
            if (idx >= 0) {
                this.wEncoding.select(idx);
            }
        }
    }

    protected void enableFields() {
        boolean enabled = this.wRunningInParallel.getSelection();
        this.wlFileType.setVisible(enabled);
        this.wlFileType.setEnabled(enabled);
        this.wFileType.setVisible(enabled);
        this.wFileType.setEnabled(enabled);
    }

    public void getData() {
        this.wStepname.setText(this.stepname);
        this.wFilename.setText(Const.NVL((String)this.inputMeta.getFilename(), (String)""));
        this.wLineWidth.setText(Const.NVL((String)this.inputMeta.getLineWidth(), (String)""));
        this.wLineFeedPresent.setSelection(this.inputMeta.isLineFeedPresent());
        this.wBufferSize.setText(Const.NVL((String)this.inputMeta.getBufferSize(), (String)""));
        this.wLazyConversion.setSelection(this.inputMeta.isLazyConversionActive());
        this.wHeaderPresent.setSelection(this.inputMeta.isHeaderPresent());
        this.wRunningInParallel.setSelection(this.inputMeta.isRunningInParallel());
        this.wFileType.setText(this.inputMeta.getFileTypeDesc());
        this.wEncoding.setText(Const.NVL((String)this.inputMeta.getEncoding(), (String)""));
        this.wAddResult.setSelection(this.inputMeta.isAddResultFile());
        for (int i = 0; i < this.inputMeta.getFieldDefinition().length; ++i) {
            TableItem item = new TableItem(this.wFields.table, 0);
            int colnr = 1;
            FixedFileInputField field = this.inputMeta.getFieldDefinition()[i];
            item.setText(colnr++, Const.NVL((String)field.getName(), (String)""));
            item.setText(colnr++, ValueMeta.getTypeDesc((int)field.getType()));
            item.setText(colnr++, Const.NVL((String)field.getFormat(), (String)""));
            item.setText(colnr++, field.getWidth() >= 0 ? Integer.toString(field.getWidth()) : "");
            item.setText(colnr++, field.getLength() >= 0 ? Integer.toString(field.getLength()) : "");
            item.setText(colnr++, field.getPrecision() >= 0 ? Integer.toString(field.getPrecision()) : "");
            item.setText(colnr++, Const.NVL((String)field.getCurrency(), (String)""));
            item.setText(colnr++, Const.NVL((String)field.getDecimal(), (String)""));
            item.setText(colnr++, Const.NVL((String)field.getGrouping(), (String)""));
            item.setText(colnr++, ValueMeta.getTrimTypeCode((int)field.getTrimType()));
        }
        this.wFields.removeEmptyRows();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.enableFields();
        this.wStepname.selectAll();
    }

    private void cancel() {
        this.stepname = null;
        this.inputMeta.setChanged(this.backupChanged);
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        this.getInfo(this.inputMeta);
        this.dispose();
    }

    private void getInfo(FixedInputMeta fixedInputMeta) {
        fixedInputMeta.setFilename(this.wFilename.getText());
        fixedInputMeta.setLineWidth(this.wLineWidth.getText());
        fixedInputMeta.setBufferSize(this.wBufferSize.getText());
        fixedInputMeta.setLazyConversionActive(this.wLazyConversion.getSelection());
        fixedInputMeta.setHeaderPresent(this.wHeaderPresent.getSelection());
        fixedInputMeta.setLineFeedPresent(this.wLineFeedPresent.getSelection());
        fixedInputMeta.setRunningInParallel(this.wRunningInParallel.getSelection());
        fixedInputMeta.setFileType(FixedInputMeta.getFileType((String)this.wFileType.getText()));
        fixedInputMeta.setEncoding(this.wEncoding.getText());
        fixedInputMeta.setAddResultFile(this.wAddResult.getSelection());
        int nrNonEmptyFields = this.wFields.nrNonEmpty();
        fixedInputMeta.allocate(nrNonEmptyFields);
        for (int i = 0; i < nrNonEmptyFields; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            int colnr = 1;
            FixedFileInputField field = new FixedFileInputField();
            field.setName(item.getText(colnr++));
            field.setType(ValueMeta.getType((String)item.getText(colnr++)));
            field.setFormat(item.getText(colnr++));
            field.setWidth(Const.toInt((String)item.getText(colnr++), (int)-1));
            field.setLength(Const.toInt((String)item.getText(colnr++), (int)-1));
            field.setPrecision(Const.toInt((String)item.getText(colnr++), (int)-1));
            field.setCurrency(item.getText(colnr++));
            field.setDecimal(item.getText(colnr++));
            field.setGrouping(item.getText(colnr++));
            field.setTrimType(ValueMeta.getTrimTypeByDesc((String)item.getText(colnr++)));
            fixedInputMeta.getFieldDefinition()[i] = field;
        }
        this.wFields.removeEmptyRows();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        fixedInputMeta.setChanged();
    }

    private void preview() {
        FixedInputMeta oneMeta = new FixedInputMeta();
        this.getInfo(oneMeta);
        TransMeta previewMeta = TransPreviewFactory.generatePreviewTransformation((VariableSpace)this.transMeta, (StepMetaInterface)oneMeta, (String)this.wStepname.getText());
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"FixedInputDialog.PreviewSize.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FixedInputDialog.PreviewSize.DialogMessage", (String[])new String[0]));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            TransPreviewProgressDialog progressDialog = new TransPreviewProgressDialog(this.shell, previewMeta, new String[]{this.wStepname.getText()}, new int[]{previewSize});
            progressDialog.open();
            Trans trans = progressDialog.getTrans();
            String loggingText = progressDialog.getLoggingText();
            if (!progressDialog.isCancelled() && trans.getResult() != null && trans.getResult().getNrErrors() > 0L) {
                EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                etd.setReadOnly();
                etd.open();
            }
            PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, (VariableSpace)this.transMeta, 0, this.wStepname.getText(), progressDialog.getPreviewRowsMeta(this.wStepname.getText()), progressDialog.getPreviewRows(this.wStepname.getText()), loggingText);
            prd.open();
        }
    }

    private void getFixed() {
        FixedInputMeta info = new FixedInputMeta();
        this.getInfo(info);
        Shell sh = new Shell(this.shell, 3312);
        try {
            List<String> rows = this.getFirst(info, 50);
            this.fields = new ArrayList<FixedFileInputField>();
            this.fields.addAll(Arrays.asList(info.getFieldDefinition()));
            if (this.fields.isEmpty()) {
                FixedFileInputField field = new FixedFileInputField();
                field.setName("Field1");
                field.setType(2);
                field.setTrimType(0);
                field.setWidth(Const.toInt((String)info.getLineWidth(), (int)80));
                field.setLength(-1);
                field.setPrecision(-1);
                this.fields.add(field);
            } else if (info.hasChanged()) {
                int width = 0;
                ArrayList<FixedFileInputField> reuse = new ArrayList<FixedFileInputField>();
                for (FixedFileInputField field : this.fields) {
                    if ((width += field.getWidth()) <= Const.toInt((String)info.getLineWidth(), (int)width)) {
                        reuse.add(field);
                        continue;
                    }
                    width -= field.getWidth();
                }
                int lineWidth = Const.toInt((String)info.getLineWidth(), (int)width);
                FixedFileInputField lastField = (FixedFileInputField)reuse.get(reuse.size() - 1);
                if (width > lineWidth) {
                    width = lineWidth;
                }
                int lastWidth = Const.toInt((String)info.getLineWidth(), (int)width) - (width - lastField.getWidth());
                lastField.setWidth(lastWidth);
                this.fields = reuse;
            }
            FixedFileImportWizardPage1 page1 = new FixedFileImportWizardPage1("1", this.props, rows, this.fields);
            page1.createControl((Composite)sh);
            FixedFileImportWizardPage2 page2 = new FixedFileImportWizardPage2("2", this.props, rows, this.fields);
            page2.createControl((Composite)sh);
            Wizard wizard = new Wizard(){

                public boolean performFinish() {
                    FixedInputDialog.this.wFields.clearAll(false);
                    for (int i = 0; i < FixedInputDialog.this.fields.size(); ++i) {
                        FixedFileInputField field = (FixedFileInputField)FixedInputDialog.this.fields.get(i);
                        if (field.getWidth() <= 0) continue;
                        TableItem item = new TableItem(((FixedInputDialog)FixedInputDialog.this).wFields.table, 0);
                        item.setText(1, field.getName());
                        item.setText(2, "" + ValueMeta.getTypeDesc((int)field.getType()));
                        item.setText(3, "" + field.getFormat());
                        item.setText(4, "" + field.getWidth());
                        item.setText(5, field.getLength() < 0 ? "" : "" + field.getLength());
                        item.setText(6, field.getPrecision() < 0 ? "" : "" + field.getPrecision());
                        item.setText(7, "" + field.getCurrency());
                        item.setText(8, "" + field.getDecimal());
                        item.setText(9, "" + field.getGrouping());
                    }
                    int size = ((FixedInputDialog)FixedInputDialog.this).wFields.table.getItemCount();
                    if (size == 0) {
                        new TableItem(((FixedInputDialog)FixedInputDialog.this).wFields.table, 0);
                    }
                    FixedInputDialog.this.wFields.removeEmptyRows();
                    FixedInputDialog.this.wFields.setRowNums();
                    FixedInputDialog.this.wFields.optWidth(true);
                    FixedInputDialog.this.inputMeta.setChanged();
                    return true;
                }
            };
            wizard.addPage((IWizardPage)page1);
            wizard.addPage((IWizardPage)page2);
            WizardDialog wd = new WizardDialog(this.shell, (IWizard)wizard);
            WizardDialog.setDefaultImage((Image)GUIResource.getInstance().getImageWizard());
            wd.setMinimumPageSize(700, 375);
            wd.updateSize();
            wd.open();
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"FixedInputDialog.ErrorShowingFixedWizard.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FixedInputDialog.ErrorShowingFixedWizard.DialogMessage", (String[])new String[0]), e);
        }
    }

    private List<String> getFirst(FixedInputMeta meta, int limit) throws IOException, KettleValueException {
        ArrayList<String> lines = new ArrayList<String>();
        FixedInputMeta oneMeta = new FixedInputMeta();
        this.getInfo(oneMeta);
        int lineWidth = Integer.parseInt(oneMeta.getLineWidth());
        if (lineWidth <= 0) {
            throw new IOException("The width of a line can not be 0 or less.");
        }
        oneMeta.allocate(1);
        FixedFileInputField field = new FixedFileInputField();
        field.setName("Field1");
        field.setType(2);
        field.setWidth(lineWidth);
        oneMeta.getFieldDefinition()[0] = field;
        TransMeta previewMeta = TransPreviewFactory.generatePreviewTransformation((VariableSpace)this.transMeta, (StepMetaInterface)oneMeta, (String)this.wStepname.getText());
        TransPreviewProgressDialog progressDialog = new TransPreviewProgressDialog(this.shell, previewMeta, new String[]{this.wStepname.getText()}, new int[]{limit});
        progressDialog.open();
        Trans trans = progressDialog.getTrans();
        String loggingText = progressDialog.getLoggingText();
        if (!progressDialog.isCancelled() && trans.getResult() != null && trans.getResult().getNrErrors() > 0L) {
            EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
            etd.setReadOnly();
            etd.open();
        }
        RowMetaInterface previewRowsMeta = progressDialog.getPreviewRowsMeta(this.wStepname.getText());
        List<Object[]> previewRowsData = progressDialog.getPreviewRows(this.wStepname.getText());
        for (int i = 0; i < previewRowsData.size(); ++i) {
            String line = previewRowsMeta.getString(previewRowsData.get(i), 0);
            lines.add(line);
        }
        return lines;
    }
}

