/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.fixedinput;

import java.util.List;
import java.util.Vector;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ScrollBar;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.trans.steps.fixedinput.FixedFileInputField;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.gui.GUIResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixedTableDraw
extends Canvas {
    private Display display;
    private Color bg;
    private Color black;
    private Color red;
    private Color blue;
    private Color lgray;
    private Point offset;
    private ScrollBar hori;
    private ScrollBar vert;
    private Image dummy_image;
    private GC dummy_gc;
    private int maxlen;
    private int fontheight;
    private int fontwidth;
    private Image cache_image;
    private int prev_fromx;
    private int prev_tox;
    private int prev_fromy;
    private int prev_toy;
    private List<FixedFileInputField> fields;
    private List<String> rows;
    private static final int LEFT = 50;
    private static final int TOP = 30;
    private static final int MARGIN = 10;
    private int potential_click;
    private WizardPage wPage;
    private String prevfieldname;

    public FixedTableDraw(Composite parent, PropsUI props, WizardPage wPage, List<FixedFileInputField> fields) {
        super(parent, 262912);
        this.wPage = wPage;
        this.fields = fields;
        this.prevfieldname = "";
        this.potential_click = -1;
        this.cache_image = null;
        this.prev_fromx = -1;
        this.prev_tox = -1;
        this.prev_fromy = -1;
        this.prev_toy = -1;
        this.display = parent.getDisplay();
        this.bg = GUIResource.getInstance().getColorBackground();
        this.fontheight = props.getGridFont().getHeight();
        this.black = GUIResource.getInstance().getColorBlack();
        this.red = GUIResource.getInstance().getColorRed();
        this.blue = GUIResource.getInstance().getColorBlue();
        this.lgray = GUIResource.getInstance().getColorLightGray();
        this.hori = this.getHorizontalBar();
        this.vert = this.getVerticalBar();
        this.dummy_image = new Image((Device)this.display, 1, 1);
        this.dummy_gc = new GC((Drawable)this.dummy_image);
        String teststring = "ABCDEF";
        this.fontwidth = Math.round(this.dummy_gc.textExtent((String)teststring).x / teststring.length());
        this.setBackground(this.bg);
        this.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                FixedTableDraw.this.paintControl(e);
            }
        });
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent arg0) {
                FixedTableDraw.this.dummy_gc.dispose();
                FixedTableDraw.this.dummy_image.dispose();
                if (FixedTableDraw.this.cache_image != null) {
                    FixedTableDraw.this.cache_image.dispose();
                }
            }
        });
        this.hori.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FixedTableDraw.this.redraw();
            }
        });
        this.vert.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FixedTableDraw.this.redraw();
            }
        });
        this.hori.setThumb(100);
        this.vert.setThumb(100);
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                Point offset = FixedTableDraw.this.getOffset();
                int posx = (int)Math.round((double)(e.x - 50 - 10 - offset.x) / (double)FixedTableDraw.this.fontwidth);
                if (posx > 0) {
                    FixedTableDraw.this.potential_click = posx;
                    FixedTableDraw.this.redraw();
                }
            }

            public void mouseUp(MouseEvent e) {
                if (FixedTableDraw.this.potential_click > 0) {
                    FixedTableDraw.this.setMarker(FixedTableDraw.this.potential_click);
                    FixedTableDraw.this.potential_click = -1;
                    FixedTableDraw.this.redraw();
                }
            }
        });
        this.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                FixedFileInputField field;
                if (e == null || FixedTableDraw.this.offset == null || FixedTableDraw.this.fontwidth == 0) {
                    return;
                }
                int posx = (int)Math.round((double)(e.x - 50 - 10 - ((FixedTableDraw)FixedTableDraw.this).offset.x) / (double)FixedTableDraw.this.fontwidth);
                if (FixedTableDraw.this.potential_click >= 0 && posx > 0) {
                    FixedTableDraw.this.potential_click = posx;
                    FixedTableDraw.this.redraw();
                }
                if ((field = FixedTableDraw.this.getFieldOnPosition(posx)) != null && !field.getName().equalsIgnoreCase(FixedTableDraw.this.prevfieldname)) {
                    FixedTableDraw.this.setToolTipText(field.getName() + " is a " + ValueMeta.getTypeDesc((int)field.getType()) + ".  The width is " + field.getWidth());
                    FixedTableDraw.this.prevfieldname = field.getName();
                }
            }
        });
    }

    private FixedFileInputField getFieldOnPosition(int x) {
        int position = 0;
        for (int i = 0; i < this.fields.size(); ++i) {
            FixedFileInputField field = this.fields.get(i);
            int width = field.getWidth();
            if (position <= x && position + width > x) {
                return field;
            }
            position += width;
        }
        return null;
    }

    private int getFieldPosition(FixedFileInputField look) {
        int position = 0;
        for (FixedFileInputField field : this.fields) {
            if (field.equals((Object)look)) {
                return position;
            }
            int width = field.getWidth();
            position += width;
        }
        return -1;
    }

    private void setMarker(int x) {
        FixedFileInputField field;
        int idx = -1;
        int highest_smaller = -1;
        int position = 0;
        for (int i = 0; i < this.fields.size() && idx < 0; ++i) {
            field = this.fields.get(i);
            int width = field.getWidth();
            if (position == this.potential_click) {
                idx = i;
            }
            if (highest_smaller < 0 && position + width >= x) {
                highest_smaller = i;
            }
            position += width;
        }
        if (idx < 0) {
            if (highest_smaller >= 0) {
                FixedFileInputField prevfield = this.fields.get(highest_smaller);
                int prevPosition = this.getFieldPosition(prevfield);
                int newlength = prevfield.getWidth() - (x - prevPosition);
                FixedFileInputField field2 = new FixedFileInputField();
                field2.setName(this.getNewFieldname());
                field2.setWidth(newlength);
                this.fields.add(highest_smaller + 1, field2);
                prevfield.setWidth(x - prevPosition);
            }
        } else if (highest_smaller >= 0) {
            FixedFileInputField prevfield = this.fields.get(highest_smaller);
            field = this.fields.get(idx);
            prevfield.setWidth(prevfield.getWidth() + field.getWidth());
            this.fields.remove(idx);
        }
        this.wPage.setPageComplete(this.wPage.canFlipToNextPage());
    }

    private String getNewFieldname() {
        int nr = 1;
        String name = "Field" + nr;
        while (this.fieldExists(name)) {
            name = "Field" + ++nr;
        }
        return name;
    }

    private boolean fieldExists(String name) {
        for (FixedFileInputField field : this.fields) {
            if (!name.equalsIgnoreCase(field.getName())) continue;
            return true;
        }
        return false;
    }

    public void setRows(List<String> rows) {
        this.rows = rows;
        this.maxlen = this.getMaxLength();
        this.redraw();
    }

    public void paintControl(PaintEvent e) {
        GC gc;
        this.offset = this.getOffset();
        if (this.offset == null) {
            return;
        }
        Point area = this.getArea();
        Point max = this.getMaximum();
        Point thumb = this.getThumb(area, max);
        this.hori.setThumb(thumb.x);
        this.vert.setThumb(thumb.y);
        int fromy = -this.offset.y / (this.fontheight + 2);
        int toy = fromy + area.y / (this.fontheight + 2);
        int fromx = -this.offset.x / this.fontwidth;
        int tox = fromx + area.x / this.fontwidth;
        Image image = new Image((Device)this.display, area.x, area.y);
        if (fromx != this.prev_fromx || fromy != this.prev_fromy || tox != this.prev_tox || toy != this.prev_toy) {
            int numsize;
            String number;
            int i;
            if (this.cache_image != null) {
                this.cache_image.dispose();
                this.cache_image = null;
            }
            this.cache_image = new Image((Device)this.display, area.x, area.y);
            gc = new GC((Drawable)this.cache_image);
            int linepos = 25;
            gc.setBackground(this.bg);
            gc.fillRectangle(50, 30, area.x, area.y);
            gc.setForeground(this.black);
            for (i = fromy; i < this.rows.size() && i < toy; ++i) {
                String str = this.rows.get(i);
                for (int p = fromx; p < str.length() && p < tox; ++p) {
                    gc.drawText("" + str.charAt(p), 60 + p * this.fontwidth + this.offset.x, 30 + i * (this.fontheight + 2) + this.offset.y, true);
                }
                if (str.length() >= tox) continue;
                gc.setForeground(this.red);
                gc.setBackground(this.red);
                int x_oval = 60 + str.length() * this.fontwidth + this.offset.x;
                int y_oval = 30 + i * (this.fontheight + 2) + this.offset.y;
                gc.drawOval(x_oval, y_oval, this.fontwidth, this.fontheight);
                gc.fillOval(x_oval, y_oval, this.fontwidth, this.fontheight);
                gc.setForeground(this.black);
                gc.setBackground(this.bg);
            }
            gc.setBackground(this.lgray);
            gc.fillRectangle(60, 0, area.x, linepos + 1);
            gc.setBackground(this.bg);
            gc.drawLine(60, linepos, area.x, linepos);
            for (i = fromx; i < this.maxlen + 10 && i < tox + 10; ++i) {
                number = "" + i;
                numsize = number.length() * this.fontwidth;
                if (i > 0 && i % 10 == 0) {
                    gc.drawText("" + i, 60 + i * this.fontwidth - numsize / 2 + this.offset.x, linepos - 10 - this.fontheight, true);
                }
                if (i > 0 && i % 5 == 0) {
                    gc.drawLine(60 + i * this.fontwidth + this.offset.x, linepos, 60 + i * this.fontwidth + this.offset.x, linepos - 5);
                    continue;
                }
                gc.drawLine(60 + i * this.fontwidth + this.offset.x, linepos, 60 + i * this.fontwidth + this.offset.x, linepos - 3);
            }
            gc.setBackground(this.lgray);
            gc.fillRectangle(0, 30, 50, area.y);
            gc.drawLine(50, 30, 50, area.y);
            for (i = fromy; i < this.rows.size() && i < toy; ++i) {
                number = "" + (i + 1);
                numsize = number.length() * this.fontwidth;
                gc.drawText(number, 45 - numsize, 30 + i * (this.fontheight + 2) + this.offset.y, true);
                gc.drawLine(50, 30 + (i + 1) * (this.fontheight + 2) + this.offset.y, 45, 30 + (i + 1) * (this.fontheight + 2) + this.offset.y);
            }
            gc.dispose();
        }
        gc = new GC((Drawable)image);
        gc.drawImage(this.cache_image, 0, 0);
        gc.setForeground(this.red);
        gc.setBackground(this.red);
        int position = 0;
        for (FixedFileInputField field : this.fields) {
            int x = position;
            if (x >= fromx && x <= tox) {
                this.drawMarker(gc, x, area.y);
            }
            position += field.getWidth();
        }
        if (this.potential_click >= 0) {
            gc.setForeground(this.blue);
            gc.setBackground(this.blue);
            this.drawMarker(gc, this.potential_click, area.y);
        }
        e.gc.drawImage(image, 0, 0);
        gc.dispose();
        image.dispose();
    }

    private void drawMarker(GC gc, int x, int maxy) {
        int[] triangle = new int[]{60 + x * this.fontwidth + this.offset.x, 26, 60 + x * this.fontwidth + this.offset.x + 3, 31, 60 + x * this.fontwidth + this.offset.x - 3, 31};
        gc.fillPolygon(triangle);
        gc.drawPolygon(triangle);
        gc.drawLine(60 + x * this.fontwidth + this.offset.x, 31, 60 + x * this.fontwidth + this.offset.x, maxy);
    }

    private Point getOffset() {
        Point area = this.getArea();
        Point max = this.getMaximum();
        Point thumb = this.getThumb(area, max);
        Point offset = this.getOffset(thumb, area);
        return offset;
    }

    private Point getThumb(Point area, Point max) {
        Point thumb = new Point(0, 0);
        thumb.x = max.x <= area.x ? 100 : Math.round(100 * area.x / max.x);
        thumb.y = max.y <= area.y ? 100 : Math.round(100 * area.y / max.y);
        return thumb;
    }

    private Point getOffset(Point thumb, Point area) {
        Point p = new Point(0, 0);
        Point sel = new Point(this.hori.getSelection(), this.vert.getSelection());
        if (thumb.x == 0 || thumb.y == 0) {
            return p;
        }
        p.x = Math.round(-sel.x * area.x / thumb.x);
        p.y = Math.round(-sel.y * area.y / thumb.y);
        return p;
    }

    private Point getMaximum() {
        int maxx = 0;
        int maxy = (this.rows.size() + 10) * (this.fontheight + 2);
        for (int i = 0; i < this.rows.size(); ++i) {
            String str = this.rows.get(i);
            int len = (str.length() + 10) * this.fontwidth;
            if (maxx >= len) continue;
            maxx = len;
        }
        return new Point(maxx, maxy);
    }

    private int getMaxLength() {
        int maxx = 0;
        for (int i = 0; i < this.rows.size(); ++i) {
            String str = this.rows.get(i);
            int len = str.length();
            if (maxx >= len) continue;
            maxx = len;
        }
        return maxx;
    }

    private Point getArea() {
        Rectangle rect = this.getClientArea();
        Point area = new Point(rect.width, rect.height);
        return area;
    }

    public List<FixedFileInputField> getFields() {
        return this.fields;
    }

    public void setFields(List<FixedFileInputField> fields) {
        this.fields = fields;
    }

    public void clearFields() {
        this.fields = new Vector<FixedFileInputField>();
    }
}

