/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.flattener;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.flattener.FlattenerMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class FlattenerDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = FlattenerMeta.class;
    private Label wlFields;
    private TableView wFields;
    private FormData fdlFields;
    private FormData fdFields;
    private Label wlField;
    private CCombo wField;
    private FormData fdlField;
    private FormData fdField;
    private boolean gotPreviousFields = false;
    private FlattenerMeta input;

    public FlattenerDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (FlattenerMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FlattenerDialog.this.input.setChanged();
            }
        };
        this.backupChanged = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"FlattenerDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"FlattenerDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wlField = new Label((Composite)this.shell, 131072);
        this.wlField.setText(BaseMessages.getString(PKG, (String)"FlattenerDialog.FlattenField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlField);
        this.fdlField = new FormData();
        this.fdlField.left = new FormAttachment(0, 0);
        this.fdlField.right = new FormAttachment(middle, -margin);
        this.fdlField.top = new FormAttachment((Control)this.wStepname, margin);
        this.wlField.setLayoutData((Object)this.fdlField);
        this.wField = new CCombo((Composite)this.shell, 2056);
        this.props.setLook((Control)this.wField);
        this.wField.addModifyListener(lsMod);
        this.fdField = new FormData();
        this.fdField.left = new FormAttachment(middle, 0);
        this.fdField.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdField.right = new FormAttachment(100, 0);
        this.wField.setLayoutData((Object)this.fdField);
        this.wField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)FlattenerDialog.this.shell.getDisplay(), 1);
                FlattenerDialog.this.shell.setCursor(busy);
                FlattenerDialog.this.getFields();
                FlattenerDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.wlFields = new Label((Composite)this.shell, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"FlattenerDialog.TargetField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFields);
        this.fdlFields = new FormData();
        this.fdlFields.left = new FormAttachment(0, 0);
        this.fdlFields.top = new FormAttachment((Control)this.wField, margin);
        this.wlFields.setLayoutData((Object)this.fdlFields);
        int nrKeyCols = 1;
        int nrKeyRows = this.input.getTargetField() != null ? this.input.getTargetField().length : 1;
        ColumnInfo[] ciKey = new ColumnInfo[nrKeyCols];
        ciKey[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"FlattenerDialog.ColumnInfo.TargetField", (String[])new String[0]), 1, false);
        this.wFields = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 68354, ciKey, nrKeyRows, lsMod, this.props);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        this.fdFields.right = new FormAttachment(100, -margin);
        this.fdFields.bottom = new FormAttachment(100, -50);
        this.wFields.setLayoutData(this.fdFields);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, null);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                FlattenerDialog.this.ok();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                FlattenerDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                FlattenerDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                FlattenerDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.input.setChanged(this.backupChanged);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private void getFields() {
        if (!this.gotPreviousFields) {
            try {
                String field = this.wField.getText();
                RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
                if (r != null) {
                    this.wField.setItems(r.getFieldNames());
                }
                if (field != null) {
                    this.wField.setText(field);
                }
            }
            catch (KettleException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"FlattenerDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FlattenerDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
            this.gotPreviousFields = true;
        }
    }

    public void getData() {
        if (this.log.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"FlattenerDialog.Log.GettingKeyInfo", (String[])new String[0]));
        }
        if (this.input.getFieldName() != null) {
            this.wField.setText(this.input.getFieldName());
        }
        if (this.input.getTargetField() != null) {
            for (int i = 0; i < this.input.getTargetField().length; ++i) {
                TableItem item = this.wFields.table.getItem(i);
                if (this.input.getTargetField()[i] == null) continue;
                item.setText(1, this.input.getTargetField()[i]);
            }
        }
        this.wStepname.selectAll();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
    }

    private void cancel() {
        this.stepname = null;
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        int nrTargets = this.wFields.nrNonEmpty();
        this.input.setFieldName(this.wField.getText());
        this.input.allocate(nrTargets);
        for (int i = 0; i < nrTargets; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            this.input.getTargetField()[i] = item.getText(1);
        }
        this.stepname = this.wStepname.getText();
        this.dispose();
    }
}

