/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.fuzzymatch;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.step.errorhandling.StreamInterface;
import org.pentaho.di.trans.steps.fuzzymatch.FuzzyMatchMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class FuzzyMatchDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = FuzzyMatchMeta.class;
    private Label wlStep;
    private CCombo wStep;
    private FormData fdlStep;
    private FormData fdStep;
    private Label wlAlgorithm;
    private CCombo wAlgorithm;
    private FormData fdlAlgorithm;
    private FormData fdAlgorithm;
    private ComboVar wMainStreamField;
    private FormData fdMainStreamField;
    private Label wlMainStreamField;
    private FormData fdlMainStreamField;
    private ComboVar wLookupField;
    private FormData fdLookupField;
    private Label wlLookupField;
    private FormData fdlLookupField;
    private Group wLookupGroup;
    private FormData fdLookupGroup;
    private Group wMainStreamGroup;
    private FormData fdMainStreamGroup;
    private Group wSettingsGroup;
    private FormData fdSettingsGroup;
    private Group wOutputFieldsGroup;
    private FormData fdOutputFieldsGroup;
    private ColumnInfo[] ciReturn;
    private Label wlReturn;
    private TableView wReturn;
    private FormData fdlReturn;
    private FormData fdReturn;
    private Label wlmatchField;
    private TextVar wmatchField;
    private FormData fdlmatchField;
    private FormData fdmatchField;
    private Label wlvalueField;
    private TextVar wvalueField;
    private FormData fdlvalueField;
    private FormData fdvalueField;
    private Label wlcaseSensitive;
    private Button wcaseSensitive;
    private FormData fdlcaseSensitive;
    private FormData fdcaseSensitive;
    private Label wlgetCloserValue;
    private Button wgetCloserValue;
    private FormData fdlgetCloserValue;
    private FormData fdgetCloserValue;
    private Label wlminValue;
    private TextVar wminValue;
    private FormData fdminValue;
    private FormData fdlminValue;
    private Label wlmaxValue;
    private TextVar wmaxValue;
    private FormData fdmaxValue;
    private FormData fdlmaxValue;
    private Label wlseparator;
    private TextVar wseparator;
    private FormData fdseparator;
    private FormData fdlseparator;
    private CTabFolder wTabFolder;
    private FormData fdTabFolder;
    private Composite wGeneralComp;
    private FormData fdGeneralComp;
    private CTabItem wGeneralTab;
    private CTabItem wFieldsTab;
    private Composite wFieldsComp;
    private FormData fdFieldsComp;
    private Button wGetLU;
    private Listener lsGetLU;
    private FuzzyMatchMeta input;
    private boolean gotPreviousFields = false;
    private boolean gotLookupFields = false;

    public FuzzyMatchDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (FuzzyMatchMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FuzzyMatchDialog.this.input.setChanged();
            }
        };
        SelectionAdapter lsSelection = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FuzzyMatchDialog.this.input.setChanged();
                FuzzyMatchDialog.this.setComboBoxesLookup();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wGeneralTab = new CTabItem(this.wTabFolder, 0);
        this.wGeneralTab.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.General.Tab", (String[])new String[0]));
        this.wGeneralComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)this.wGeneralComp);
        FormLayout GeneralLayout = new FormLayout();
        GeneralLayout.marginWidth = 3;
        GeneralLayout.marginHeight = 3;
        this.wGeneralComp.setLayout((Layout)GeneralLayout);
        this.wLookupGroup = new Group(this.wGeneralComp, 32);
        this.props.setLook((Control)this.wLookupGroup);
        this.wLookupGroup.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.Group.Lookup.Label", (String[])new String[0]));
        FormLayout LookupgroupLayout = new FormLayout();
        LookupgroupLayout.marginWidth = 10;
        LookupgroupLayout.marginHeight = 10;
        this.wLookupGroup.setLayout((Layout)LookupgroupLayout);
        this.wlStep = new Label((Composite)this.wLookupGroup, 131072);
        this.wlStep.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.SourceStep.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStep);
        this.fdlStep = new FormData();
        this.fdlStep.left = new FormAttachment(0, 0);
        this.fdlStep.right = new FormAttachment(middle, -margin);
        this.fdlStep.top = new FormAttachment((Control)this.wStepname, margin);
        this.wlStep.setLayoutData((Object)this.fdlStep);
        this.wStep = new CCombo((Composite)this.wLookupGroup, 18436);
        this.props.setLook((Control)this.wStep);
        List steps = this.transMeta.findPreviousSteps(this.transMeta.findStep(this.stepname), true);
        for (StepMeta stepMeta : steps) {
            this.wStep.add(stepMeta.getName());
        }
        this.wStep.addModifyListener(lsMod);
        this.wStep.addSelectionListener((SelectionListener)lsSelection);
        this.fdStep = new FormData();
        this.fdStep.left = new FormAttachment(middle, 0);
        this.fdStep.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdStep.right = new FormAttachment(100, 0);
        this.wStep.setLayoutData((Object)this.fdStep);
        this.wlLookupField = new Label((Composite)this.wLookupGroup, 131072);
        this.wlLookupField.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.wlLookupField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlLookupField);
        this.fdlLookupField = new FormData();
        this.fdlLookupField.left = new FormAttachment(0, 0);
        this.fdlLookupField.top = new FormAttachment((Control)this.wStep, margin);
        this.fdlLookupField.right = new FormAttachment(middle, -2 * margin);
        this.wlLookupField.setLayoutData((Object)this.fdlLookupField);
        this.wLookupField = new ComboVar((VariableSpace)this.transMeta, (Composite)this.wLookupGroup, 2056);
        this.wLookupField.setEditable(true);
        this.props.setLook((Control)this.wLookupField);
        this.wLookupField.addModifyListener(lsMod);
        this.fdLookupField = new FormData();
        this.fdLookupField.left = new FormAttachment(middle, 0);
        this.fdLookupField.top = new FormAttachment((Control)this.wStep, margin);
        this.fdLookupField.right = new FormAttachment(100, -margin);
        this.wLookupField.setLayoutData(this.fdLookupField);
        this.wLookupField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                FuzzyMatchDialog.this.setLookupField();
            }
        });
        this.fdLookupGroup = new FormData();
        this.fdLookupGroup.left = new FormAttachment(0, margin);
        this.fdLookupGroup.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdLookupGroup.right = new FormAttachment(100, -margin);
        this.wLookupGroup.setLayoutData((Object)this.fdLookupGroup);
        this.wMainStreamGroup = new Group(this.wGeneralComp, 32);
        this.props.setLook((Control)this.wMainStreamGroup);
        this.wMainStreamGroup.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.Group.MainStreamGroup.Label", (String[])new String[0]));
        FormLayout MainStreamgroupLayout = new FormLayout();
        MainStreamgroupLayout.marginWidth = 10;
        MainStreamgroupLayout.marginHeight = 10;
        this.wMainStreamGroup.setLayout((Layout)MainStreamgroupLayout);
        this.wlMainStreamField = new Label((Composite)this.wMainStreamGroup, 131072);
        this.wlMainStreamField.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.wlMainStreamField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlMainStreamField);
        this.fdlMainStreamField = new FormData();
        this.fdlMainStreamField.left = new FormAttachment(0, 0);
        this.fdlMainStreamField.top = new FormAttachment((Control)this.wLookupGroup, margin);
        this.fdlMainStreamField.right = new FormAttachment(middle, -2 * margin);
        this.wlMainStreamField.setLayoutData((Object)this.fdlMainStreamField);
        this.wMainStreamField = new ComboVar((VariableSpace)this.transMeta, (Composite)this.wMainStreamGroup, 2056);
        this.wMainStreamField.setEditable(true);
        this.props.setLook((Control)this.wMainStreamField);
        this.wMainStreamField.addModifyListener(lsMod);
        this.fdMainStreamField = new FormData();
        this.fdMainStreamField.left = new FormAttachment(middle, 0);
        this.fdMainStreamField.top = new FormAttachment((Control)this.wLookupGroup, margin);
        this.fdMainStreamField.right = new FormAttachment(100, -margin);
        this.wMainStreamField.setLayoutData(this.fdMainStreamField);
        this.wMainStreamField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                FuzzyMatchDialog.this.setMainStreamField();
            }
        });
        this.fdMainStreamGroup = new FormData();
        this.fdMainStreamGroup.left = new FormAttachment(0, margin);
        this.fdMainStreamGroup.top = new FormAttachment((Control)this.wLookupGroup, margin);
        this.fdMainStreamGroup.right = new FormAttachment(100, -margin);
        this.wMainStreamGroup.setLayoutData((Object)this.fdMainStreamGroup);
        this.wSettingsGroup = new Group(this.wGeneralComp, 32);
        this.props.setLook((Control)this.wSettingsGroup);
        this.wSettingsGroup.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.Group.SettingsGroup.Label", (String[])new String[0]));
        FormLayout SettingsgroupLayout = new FormLayout();
        SettingsgroupLayout.marginWidth = 10;
        SettingsgroupLayout.marginHeight = 10;
        this.wSettingsGroup.setLayout((Layout)SettingsgroupLayout);
        this.wlAlgorithm = new Label((Composite)this.wSettingsGroup, 131072);
        this.wlAlgorithm.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.Algorithm.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAlgorithm);
        this.fdlAlgorithm = new FormData();
        this.fdlAlgorithm.left = new FormAttachment(0, 0);
        this.fdlAlgorithm.right = new FormAttachment(middle, -margin);
        this.fdlAlgorithm.top = new FormAttachment((Control)this.wMainStreamGroup, margin);
        this.wlAlgorithm.setLayoutData((Object)this.fdlAlgorithm);
        this.wAlgorithm = new CCombo((Composite)this.wSettingsGroup, 2056);
        this.props.setLook((Control)this.wAlgorithm);
        this.wAlgorithm.addModifyListener(lsMod);
        this.fdAlgorithm = new FormData();
        this.fdAlgorithm.left = new FormAttachment(middle, 0);
        this.fdAlgorithm.top = new FormAttachment((Control)this.wMainStreamGroup, margin);
        this.fdAlgorithm.right = new FormAttachment(100, -margin);
        this.wAlgorithm.setLayoutData((Object)this.fdAlgorithm);
        this.wAlgorithm.setItems(FuzzyMatchMeta.algorithmDesc);
        this.wAlgorithm.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FuzzyMatchDialog.this.activeAlgorithm();
            }
        });
        this.wlcaseSensitive = new Label((Composite)this.wSettingsGroup, 131072);
        this.wlcaseSensitive.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.caseSensitive.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlcaseSensitive);
        this.fdlcaseSensitive = new FormData();
        this.fdlcaseSensitive.left = new FormAttachment(0, 0);
        this.fdlcaseSensitive.top = new FormAttachment((Control)this.wAlgorithm, margin);
        this.fdlcaseSensitive.right = new FormAttachment(middle, -2 * margin);
        this.wlcaseSensitive.setLayoutData((Object)this.fdlcaseSensitive);
        this.wcaseSensitive = new Button((Composite)this.wSettingsGroup, 32);
        this.props.setLook((Control)this.wcaseSensitive);
        this.wcaseSensitive.setToolTipText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.caseSensitive.Tooltip", (String[])new String[0]));
        this.fdcaseSensitive = new FormData();
        this.fdcaseSensitive.left = new FormAttachment(middle, 0);
        this.fdcaseSensitive.top = new FormAttachment((Control)this.wAlgorithm, margin);
        this.wcaseSensitive.setLayoutData((Object)this.fdcaseSensitive);
        SelectionAdapter lcaseSensitive = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                FuzzyMatchDialog.this.input.setChanged();
            }
        };
        this.wcaseSensitive.addSelectionListener((SelectionListener)lcaseSensitive);
        this.wlgetCloserValue = new Label((Composite)this.wSettingsGroup, 131072);
        this.wlgetCloserValue.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.getCloserValue.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlgetCloserValue);
        this.fdlgetCloserValue = new FormData();
        this.fdlgetCloserValue.left = new FormAttachment(0, 0);
        this.fdlgetCloserValue.top = new FormAttachment((Control)this.wcaseSensitive, margin);
        this.fdlgetCloserValue.right = new FormAttachment(middle, -2 * margin);
        this.wlgetCloserValue.setLayoutData((Object)this.fdlgetCloserValue);
        this.wgetCloserValue = new Button((Composite)this.wSettingsGroup, 32);
        this.props.setLook((Control)this.wgetCloserValue);
        this.wgetCloserValue.setToolTipText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.getCloserValue.Tooltip", (String[])new String[0]));
        this.fdgetCloserValue = new FormData();
        this.fdgetCloserValue.left = new FormAttachment(middle, 0);
        this.fdgetCloserValue.top = new FormAttachment((Control)this.wcaseSensitive, margin);
        this.wgetCloserValue.setLayoutData((Object)this.fdgetCloserValue);
        SelectionAdapter lgetCloserValue = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                FuzzyMatchDialog.this.activegetCloserValue();
                FuzzyMatchDialog.this.input.setChanged();
            }
        };
        this.wgetCloserValue.addSelectionListener((SelectionListener)lgetCloserValue);
        this.wlminValue = new Label((Composite)this.wSettingsGroup, 131072);
        this.wlminValue.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.minValue.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlminValue);
        this.fdlminValue = new FormData();
        this.fdlminValue.left = new FormAttachment(0, 0);
        this.fdlminValue.top = new FormAttachment((Control)this.wgetCloserValue, margin);
        this.fdlminValue.right = new FormAttachment(middle, -margin);
        this.wlminValue.setLayoutData((Object)this.fdlminValue);
        this.wminValue = new TextVar((VariableSpace)this.transMeta, (Composite)this.wSettingsGroup, 18436);
        this.props.setLook((Control)this.wminValue);
        this.wminValue.setToolTipText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.minValue.Tooltip", (String[])new String[0]));
        this.wminValue.addModifyListener(lsMod);
        this.fdminValue = new FormData();
        this.fdminValue.left = new FormAttachment(middle, 0);
        this.fdminValue.top = new FormAttachment((Control)this.wgetCloserValue, margin);
        this.fdminValue.right = new FormAttachment(100, 0);
        this.wminValue.setLayoutData(this.fdminValue);
        this.wlmaxValue = new Label((Composite)this.wSettingsGroup, 131072);
        this.wlmaxValue.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.maxValue.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlmaxValue);
        this.fdlmaxValue = new FormData();
        this.fdlmaxValue.left = new FormAttachment(0, 0);
        this.fdlmaxValue.top = new FormAttachment((Control)this.wminValue, margin);
        this.fdlmaxValue.right = new FormAttachment(middle, -margin);
        this.wlmaxValue.setLayoutData((Object)this.fdlmaxValue);
        this.wmaxValue = new TextVar((VariableSpace)this.transMeta, (Composite)this.wSettingsGroup, 18436);
        this.props.setLook((Control)this.wmaxValue);
        this.wmaxValue.setToolTipText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.maxValue.Tooltip", (String[])new String[0]));
        this.wmaxValue.addModifyListener(lsMod);
        this.fdmaxValue = new FormData();
        this.fdmaxValue.left = new FormAttachment(middle, 0);
        this.fdmaxValue.top = new FormAttachment((Control)this.wminValue, margin);
        this.fdmaxValue.right = new FormAttachment(100, 0);
        this.wmaxValue.setLayoutData(this.fdmaxValue);
        this.wlseparator = new Label((Composite)this.wSettingsGroup, 131072);
        this.wlseparator.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.separator.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlseparator);
        this.fdlseparator = new FormData();
        this.fdlseparator.left = new FormAttachment(0, 0);
        this.fdlseparator.top = new FormAttachment((Control)this.wmaxValue, margin);
        this.fdlseparator.right = new FormAttachment(middle, -margin);
        this.wlseparator.setLayoutData((Object)this.fdlseparator);
        this.wseparator = new TextVar((VariableSpace)this.transMeta, (Composite)this.wSettingsGroup, 18436);
        this.props.setLook((Control)this.wseparator);
        this.wseparator.addModifyListener(lsMod);
        this.fdseparator = new FormData();
        this.fdseparator.left = new FormAttachment(middle, 0);
        this.fdseparator.top = new FormAttachment((Control)this.wmaxValue, margin);
        this.fdseparator.right = new FormAttachment(100, 0);
        this.wseparator.setLayoutData(this.fdseparator);
        this.fdSettingsGroup = new FormData();
        this.fdSettingsGroup.left = new FormAttachment(0, margin);
        this.fdSettingsGroup.top = new FormAttachment((Control)this.wMainStreamGroup, margin);
        this.fdSettingsGroup.right = new FormAttachment(100, -margin);
        this.wSettingsGroup.setLayoutData((Object)this.fdSettingsGroup);
        this.fdGeneralComp = new FormData();
        this.fdGeneralComp.left = new FormAttachment(0, 0);
        this.fdGeneralComp.top = new FormAttachment(0, 0);
        this.fdGeneralComp.right = new FormAttachment(100, 0);
        this.fdGeneralComp.bottom = new FormAttachment(100, 0);
        this.wGeneralComp.setLayoutData((Object)this.fdGeneralComp);
        this.wGeneralComp.layout();
        this.wGeneralTab.setControl((Control)this.wGeneralComp);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, null);
        this.wFieldsTab = new CTabItem(this.wTabFolder, 0);
        this.wFieldsTab.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.Fields.Tab", (String[])new String[0]));
        this.wFieldsComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)this.wFieldsComp);
        FormLayout FieldsLayout = new FormLayout();
        FieldsLayout.marginWidth = 3;
        FieldsLayout.marginHeight = 3;
        this.wFieldsComp.setLayout((Layout)FieldsLayout);
        this.wOutputFieldsGroup = new Group(this.wFieldsComp, 32);
        this.props.setLook((Control)this.wOutputFieldsGroup);
        this.wOutputFieldsGroup.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.Group.OutputFieldsGroup.Label", (String[])new String[0]));
        FormLayout OutputFieldsgroupLayout = new FormLayout();
        OutputFieldsgroupLayout.marginWidth = 10;
        OutputFieldsgroupLayout.marginHeight = 10;
        this.wOutputFieldsGroup.setLayout((Layout)OutputFieldsgroupLayout);
        this.wlmatchField = new Label((Composite)this.wOutputFieldsGroup, 131072);
        this.wlmatchField.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.MatchField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlmatchField);
        this.fdlmatchField = new FormData();
        this.fdlmatchField.left = new FormAttachment(0, 0);
        this.fdlmatchField.top = new FormAttachment((Control)this.wSettingsGroup, margin);
        this.fdlmatchField.right = new FormAttachment(middle, -margin);
        this.wlmatchField.setLayoutData((Object)this.fdlmatchField);
        this.wmatchField = new TextVar((VariableSpace)this.transMeta, (Composite)this.wOutputFieldsGroup, 18436);
        this.props.setLook((Control)this.wmatchField);
        this.wmatchField.addModifyListener(lsMod);
        this.fdmatchField = new FormData();
        this.fdmatchField.left = new FormAttachment(middle, 0);
        this.fdmatchField.top = new FormAttachment((Control)this.wSettingsGroup, margin);
        this.fdmatchField.right = new FormAttachment(100, 0);
        this.wmatchField.setLayoutData(this.fdmatchField);
        this.wlvalueField = new Label((Composite)this.wOutputFieldsGroup, 131072);
        this.wlvalueField.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.valueField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlvalueField);
        this.fdlvalueField = new FormData();
        this.fdlvalueField.left = new FormAttachment(0, 0);
        this.fdlvalueField.top = new FormAttachment((Control)this.wmatchField, margin);
        this.fdlvalueField.right = new FormAttachment(middle, -margin);
        this.wlvalueField.setLayoutData((Object)this.fdlvalueField);
        this.wvalueField = new TextVar((VariableSpace)this.transMeta, (Composite)this.wOutputFieldsGroup, 18436);
        this.props.setLook((Control)this.wvalueField);
        this.wvalueField.setToolTipText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.valueField.Tooltip", (String[])new String[0]));
        this.wvalueField.addModifyListener(lsMod);
        this.fdvalueField = new FormData();
        this.fdvalueField.left = new FormAttachment(middle, 0);
        this.fdvalueField.top = new FormAttachment((Control)this.wmatchField, margin);
        this.fdvalueField.right = new FormAttachment(100, 0);
        this.wvalueField.setLayoutData(this.fdvalueField);
        this.fdOutputFieldsGroup = new FormData();
        this.fdOutputFieldsGroup.left = new FormAttachment(0, margin);
        this.fdOutputFieldsGroup.top = new FormAttachment((Control)this.wSettingsGroup, margin);
        this.fdOutputFieldsGroup.right = new FormAttachment(100, -margin);
        this.wOutputFieldsGroup.setLayoutData((Object)this.fdOutputFieldsGroup);
        this.wlReturn = new Label(this.wFieldsComp, 0);
        this.wlReturn.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.ReturnFields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlReturn);
        this.fdlReturn = new FormData();
        this.fdlReturn.left = new FormAttachment(0, 0);
        this.fdlReturn.top = new FormAttachment((Control)this.wOutputFieldsGroup, margin);
        this.wlReturn.setLayoutData((Object)this.fdlReturn);
        this.wGetLU = new Button(this.wFieldsComp, 8);
        this.wGetLU.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.GetLookupFields.Button", (String[])new String[0]));
        FormData fdlu = new FormData();
        fdlu.top = new FormAttachment((Control)this.wlReturn, margin);
        fdlu.right = new FormAttachment(100, 0);
        this.wGetLU.setLayoutData((Object)fdlu);
        int UpInsCols = 2;
        int UpInsRows = this.input.getValue() != null ? this.input.getValue().length : 1;
        this.ciReturn = new ColumnInfo[UpInsCols];
        this.ciReturn[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.ColumnInfo.FieldReturn", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.ColumnInfo.NewName", (String[])new String[0]), 1, false);
        this.wReturn = new TableView((VariableSpace)this.transMeta, this.wFieldsComp, 68354, this.ciReturn, UpInsRows, lsMod, this.props);
        this.fdReturn = new FormData();
        this.fdReturn.left = new FormAttachment(0, 0);
        this.fdReturn.top = new FormAttachment((Control)this.wlReturn, margin);
        this.fdReturn.right = new FormAttachment((Control)this.wGetLU, -margin);
        this.fdReturn.bottom = new FormAttachment(100, -3 * margin);
        this.wReturn.setLayoutData(this.fdReturn);
        this.fdFieldsComp = new FormData();
        this.fdFieldsComp.left = new FormAttachment(0, 0);
        this.fdFieldsComp.top = new FormAttachment(0, 0);
        this.fdFieldsComp.right = new FormAttachment(100, 0);
        this.fdFieldsComp.bottom = new FormAttachment(100, 0);
        this.wFieldsComp.setLayoutData((Object)this.fdFieldsComp);
        this.wFieldsComp.layout();
        this.wFieldsTab.setControl((Control)this.wFieldsComp);
        this.fdTabFolder = new FormData();
        this.fdTabFolder.left = new FormAttachment(0, 0);
        this.fdTabFolder.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdTabFolder.right = new FormAttachment(100, 0);
        this.fdTabFolder.bottom = new FormAttachment((Control)this.wOK, -margin);
        this.wTabFolder.setLayoutData((Object)this.fdTabFolder);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                FuzzyMatchDialog.this.ok();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                FuzzyMatchDialog.this.cancel();
            }
        };
        this.lsGetLU = new Listener(){

            public void handleEvent(Event e) {
                FuzzyMatchDialog.this.getlookup();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wCancel.addListener(13, this.lsCancel);
        this.wGetLU.addListener(13, this.lsGetLU);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                FuzzyMatchDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                FuzzyMatchDialog.this.cancel();
            }
        });
        this.wTabFolder.setSelection(0);
        this.setSize();
        this.getData();
        this.setComboBoxesLookup();
        this.activeAlgorithm();
        this.activegetCloserValue();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void getData() {
        if (this.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.Log.GettingKeyInfo", (String[])new String[0]));
        }
        this.wAlgorithm.setText(FuzzyMatchMeta.getAlgorithmTypeDesc((int)this.input.getAlgorithmType()));
        if (this.input.getMainStreamField() != null) {
            this.wMainStreamField.setText(this.input.getMainStreamField());
        }
        if (this.input.getLookupField() != null) {
            this.wLookupField.setText(this.input.getLookupField());
        }
        this.wcaseSensitive.setSelection(this.input.isCaseSensitive());
        this.wgetCloserValue.setSelection(this.input.isGetCloserValue());
        if (this.input.getMinimalValue() != null) {
            this.wminValue.setText(this.input.getMinimalValue());
        }
        if (this.input.getMaximalValue() != null) {
            this.wmaxValue.setText(this.input.getMaximalValue());
        }
        if (this.input.getOutputMatchField() != null) {
            this.wmatchField.setText(this.input.getOutputMatchField());
        }
        if (this.input.getOutputValueField() != null) {
            this.wvalueField.setText(this.input.getOutputValueField());
        }
        if (this.input.getSeparator() != null) {
            this.wseparator.setText(this.input.getSeparator());
        }
        if (this.input.getValue() != null) {
            for (int i = 0; i < this.input.getValue().length; ++i) {
                TableItem item = this.wReturn.table.getItem(i);
                if (this.input.getValue()[i] != null) {
                    item.setText(1, this.input.getValue()[i]);
                }
                if (this.input.getValueName()[i] == null || this.input.getValueName()[i].equals(this.input.getValue()[i])) continue;
                item.setText(2, this.input.getValueName()[i]);
            }
        }
        StreamInterface infoStream = (StreamInterface)this.input.getStepIOMeta().getInfoStreams().get(0);
        this.wStep.setText(Const.NVL((String)infoStream.getStepname(), (String)""));
        this.wStepname.selectAll();
        this.wReturn.setRowNums();
        this.wReturn.optWidth(true);
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.input.setMainStreamField(this.wMainStreamField.getText());
        this.input.setLookupField(this.wLookupField.getText());
        this.input.setAlgorithmType(FuzzyMatchMeta.getAlgorithmTypeByDesc((String)this.wAlgorithm.getText()));
        this.input.setCaseSensitive(this.wcaseSensitive.getSelection());
        this.input.setGetCloserValue(this.wgetCloserValue.getSelection());
        this.input.setMaximalValue(this.wmaxValue.getText());
        this.input.setMinimalValue(this.wminValue.getText());
        this.input.setOutputMatchField(this.wmatchField.getText());
        this.input.setOutputValueField(this.wvalueField.getText());
        this.input.setSeparator(this.wseparator.getText());
        int nrvalues = this.wReturn.nrNonEmpty();
        this.input.allocate(nrvalues);
        if (this.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.Log.FoundFields", (String[])new String[]{nrvalues + ""}));
        }
        for (int i = 0; i < nrvalues; ++i) {
            TableItem item = this.wReturn.getNonEmpty(i);
            this.input.getValue()[i] = item.getText(1);
            this.input.getValueName()[i] = item.getText(2);
            if (this.input.getValueName()[i] != null && this.input.getValueName()[i].length() != 0) continue;
            this.input.getValueName()[i] = this.input.getValue()[i];
        }
        StreamInterface infoStream = (StreamInterface)this.input.getStepIOMeta().getInfoStreams().get(0);
        infoStream.setStepMeta(this.transMeta.findStep(this.wStep.getText()));
        if (infoStream.getStepMeta() == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            if (Const.isEmpty((String)this.wStep.getText())) {
                mb.setMessage(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.NotStepSpecified.DialogMessage", (String[])new String[]{this.wStep.getText()}));
            } else {
                mb.setMessage(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.StepCanNotFound.DialogMessage", (String[])new String[]{this.wStep.getText()}));
            }
            mb.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.StepCanNotFound.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        this.stepname = this.wStepname.getText();
        this.dispose();
    }

    private void setMainStreamField() {
        if (!this.gotPreviousFields) {
            String field = this.wMainStreamField.getText();
            try {
                this.wMainStreamField.removeAll();
                RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
                if (r != null) {
                    this.wMainStreamField.setItems(r.getFieldNames());
                }
            }
            catch (KettleException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
            if (field != null) {
                this.wMainStreamField.setText(field);
            }
            this.gotPreviousFields = true;
        }
    }

    private void setLookupField() {
        if (!this.gotLookupFields) {
            String field = this.wLookupField.getText();
            try {
                this.wLookupField.removeAll();
                RowMetaInterface r = this.transMeta.getStepFields(this.wStep.getText());
                if (r != null) {
                    this.wLookupField.setItems(r.getFieldNames());
                }
            }
            catch (KettleException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.FailedToGetLookupFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.FailedToGetLookupFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
            if (field != null) {
                this.wLookupField.setText(field);
            }
            this.gotLookupFields = true;
        }
    }

    private void activegetCloserValue() {
        boolean enableRange = (FuzzyMatchMeta.getAlgorithmTypeByDesc((String)this.wAlgorithm.getText()) == 0 || FuzzyMatchMeta.getAlgorithmTypeByDesc((String)this.wAlgorithm.getText()) == 2 || FuzzyMatchMeta.getAlgorithmTypeByDesc((String)this.wAlgorithm.getText()) == 1 || FuzzyMatchMeta.getAlgorithmTypeByDesc((String)this.wAlgorithm.getText()) == 3 || FuzzyMatchMeta.getAlgorithmTypeByDesc((String)this.wAlgorithm.getText()) == 4 || FuzzyMatchMeta.getAlgorithmTypeByDesc((String)this.wAlgorithm.getText()) == 5) && !this.wgetCloserValue.getSelection();
        this.wlseparator.setEnabled(enableRange);
        this.wseparator.setEnabled(enableRange);
        this.wlvalueField.setEnabled(this.wgetCloserValue.getSelection());
        this.wvalueField.setEnabled(this.wgetCloserValue.getSelection());
        this.activeAddFields();
    }

    private void activeAddFields() {
        boolean activate = this.wgetCloserValue.getSelection() || FuzzyMatchMeta.getAlgorithmTypeByDesc((String)this.wAlgorithm.getText()) == 7 || FuzzyMatchMeta.getAlgorithmTypeByDesc((String)this.wAlgorithm.getText()) == 8 || FuzzyMatchMeta.getAlgorithmTypeByDesc((String)this.wAlgorithm.getText()) == 9 || FuzzyMatchMeta.getAlgorithmTypeByDesc((String)this.wAlgorithm.getText()) == 6;
        this.wlReturn.setEnabled(activate);
        this.wReturn.setEnabled(activate);
        this.wGetLU.setEnabled(activate);
    }

    private void activeAlgorithm() {
        boolean enable = FuzzyMatchMeta.getAlgorithmTypeByDesc((String)this.wAlgorithm.getText()) == 0 || FuzzyMatchMeta.getAlgorithmTypeByDesc((String)this.wAlgorithm.getText()) == 2 || FuzzyMatchMeta.getAlgorithmTypeByDesc((String)this.wAlgorithm.getText()) == 1 || FuzzyMatchMeta.getAlgorithmTypeByDesc((String)this.wAlgorithm.getText()) == 3 || FuzzyMatchMeta.getAlgorithmTypeByDesc((String)this.wAlgorithm.getText()) == 4 || FuzzyMatchMeta.getAlgorithmTypeByDesc((String)this.wAlgorithm.getText()) == 5;
        this.wlgetCloserValue.setEnabled(enable);
        this.wgetCloserValue.setEnabled(enable);
        this.wlminValue.setEnabled(enable);
        this.wminValue.setEnabled(enable);
        this.wlmaxValue.setEnabled(enable);
        this.wmaxValue.setEnabled(enable);
        if (FuzzyMatchMeta.getAlgorithmTypeByDesc((String)this.wAlgorithm.getText()) == 3 || FuzzyMatchMeta.getAlgorithmTypeByDesc((String)this.wAlgorithm.getText()) == 4 || FuzzyMatchMeta.getAlgorithmTypeByDesc((String)this.wAlgorithm.getText()) == 5) {
            if (Const.toDouble((String)this.transMeta.environmentSubstitute(this.wminValue.getText()), (double)0.0) > 1.0) {
                this.wminValue.setText(String.valueOf(1));
            }
            if (Const.toDouble((String)this.transMeta.environmentSubstitute(this.wmaxValue.getText()), (double)0.0) > 1.0) {
                this.wmaxValue.setText(String.valueOf(1));
            }
        }
        boolean enableCaseSensitive = FuzzyMatchMeta.getAlgorithmTypeByDesc((String)this.wAlgorithm.getText()) == 0 || FuzzyMatchMeta.getAlgorithmTypeByDesc((String)this.wAlgorithm.getText()) == 1;
        this.wlcaseSensitive.setEnabled(enableCaseSensitive);
        this.wcaseSensitive.setEnabled(enableCaseSensitive);
        this.activegetCloserValue();
    }

    private void getlookup() {
        try {
            String stepFrom = this.wStep.getText();
            if (!Const.isEmpty((String)stepFrom)) {
                RowMetaInterface r = this.transMeta.getStepFields(stepFrom);
                if (r != null && !r.isEmpty()) {
                    BaseStepDialog.getFieldsFromPrevious(r, this.wReturn, 1, new int[]{1}, new int[]{4}, -1, -1, null);
                } else {
                    MessageBox mb = new MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.CouldNotFindFields.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.CouldNotFindFields.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.StepNameRequired.DialogMessage", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.StepNameRequired.DialogTitle", (String[])new String[0]));
                mb.open();
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"FuzzyMatchDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    protected void setComboBoxesLookup() {
        Runnable fieldLoader = new Runnable(){

            public void run() {
                StepMeta lookupStepMeta = FuzzyMatchDialog.this.transMeta.findStep(FuzzyMatchDialog.this.wStep.getText());
                if (lookupStepMeta != null) {
                    try {
                        RowMetaInterface row = FuzzyMatchDialog.this.transMeta.getStepFields(lookupStepMeta);
                        HashMap<String, Integer> lookupFields = new HashMap<String, Integer>();
                        for (int i = 0; i < row.size(); ++i) {
                            lookupFields.put(row.getValueMeta(i).getName(), i);
                        }
                        HashMap<String, Integer> fields = new HashMap<String, Integer>();
                        fields.putAll(lookupFields);
                        Set keySet = fields.keySet();
                        ArrayList entries = new ArrayList(keySet);
                        String[] fieldNames = entries.toArray(new String[entries.size()]);
                        Const.sortStrings((String[])fieldNames);
                        FuzzyMatchDialog.this.ciReturn[0].setComboValues(fieldNames);
                    }
                    catch (KettleException e) {
                        FuzzyMatchDialog.this.logError("It was not possible to retrieve the list of fields for step [" + FuzzyMatchDialog.this.wStep.getText() + "]!");
                    }
                }
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }
}

