/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.joinrows;

import java.util.List;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Condition;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.joinrows.JoinRowsMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ConditionEditor;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class JoinRowsDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = JoinRowsMeta.class;
    private Label wlSortDir;
    private Button wbSortDir;
    private TextVar wSortDir;
    private FormData fdlSortDir;
    private FormData fdbSortDir;
    private FormData fdSortDir;
    private Label wlPrefix;
    private Text wPrefix;
    private FormData fdlPrefix;
    private FormData fdPrefix;
    private Label wlCache;
    private Text wCache;
    private FormData fdlCache;
    private FormData fdCache;
    private Label wlMainStep;
    private CCombo wMainStep;
    private FormData fdlMainStep;
    private FormData fdMainStep;
    private Label wlCondition;
    private ConditionEditor wCondition;
    private FormData fdlCondition;
    private FormData fdCondition;
    private JoinRowsMeta input;
    private Condition condition;
    private Condition backupCondition;

    public JoinRowsDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (JoinRowsMeta)in;
        this.condition = this.input.getCondition();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JoinRowsDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        this.backupCondition = (Condition)this.condition.clone();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"JoinRowsDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"JoinRowsDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wlSortDir = new Label((Composite)this.shell, 131072);
        this.wlSortDir.setText(BaseMessages.getString(PKG, (String)"JoinRowsDialog.TempDir.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSortDir);
        this.fdlSortDir = new FormData();
        this.fdlSortDir.left = new FormAttachment(0, 0);
        this.fdlSortDir.right = new FormAttachment(middle, -margin);
        this.fdlSortDir.top = new FormAttachment((Control)this.wStepname, margin);
        this.wlSortDir.setLayoutData((Object)this.fdlSortDir);
        this.wbSortDir = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbSortDir);
        this.wbSortDir.setText(BaseMessages.getString(PKG, (String)"JoinRowsDialog.Browse.Button", (String[])new String[0]));
        this.fdbSortDir = new FormData();
        this.fdbSortDir.right = new FormAttachment(100, 0);
        this.fdbSortDir.top = new FormAttachment((Control)this.wStepname, margin);
        this.wbSortDir.setLayoutData((Object)this.fdbSortDir);
        this.wSortDir = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.wSortDir.setText(BaseMessages.getString(PKG, (String)"JoinRowsDialog.Temp.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wSortDir);
        this.wSortDir.addModifyListener(lsMod);
        this.fdSortDir = new FormData();
        this.fdSortDir.left = new FormAttachment(middle, 0);
        this.fdSortDir.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdSortDir.right = new FormAttachment((Control)this.wbSortDir, -margin);
        this.wSortDir.setLayoutData(this.fdSortDir);
        this.wbSortDir.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                DirectoryDialog dd = new DirectoryDialog(JoinRowsDialog.this.shell, 0);
                dd.setFilterPath(JoinRowsDialog.this.wSortDir.getText());
                String dir = dd.open();
                if (dir != null) {
                    JoinRowsDialog.this.wSortDir.setText(dir);
                }
            }
        });
        this.wSortDir.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JoinRowsDialog.this.wSortDir.setToolTipText(JoinRowsDialog.this.transMeta.environmentSubstitute(JoinRowsDialog.this.wSortDir.getText()));
            }
        });
        this.wlPrefix = new Label((Composite)this.shell, 131072);
        this.wlPrefix.setText(BaseMessages.getString(PKG, (String)"JoinRowsDialog.TempFilePrefix.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlPrefix);
        this.fdlPrefix = new FormData();
        this.fdlPrefix.left = new FormAttachment(0, 0);
        this.fdlPrefix.right = new FormAttachment(middle, -margin);
        this.fdlPrefix.top = new FormAttachment((Control)this.wbSortDir, margin * 2);
        this.wlPrefix.setLayoutData((Object)this.fdlPrefix);
        this.wPrefix = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wPrefix);
        this.wPrefix.addModifyListener(lsMod);
        this.fdPrefix = new FormData();
        this.fdPrefix.left = new FormAttachment(middle, 0);
        this.fdPrefix.top = new FormAttachment((Control)this.wbSortDir, margin * 2);
        this.fdPrefix.right = new FormAttachment(100, 0);
        this.wPrefix.setLayoutData((Object)this.fdPrefix);
        this.wPrefix.setText(BaseMessages.getString(PKG, (String)"JoinRowsDialog.Prefix.Label", (String[])new String[0]));
        this.wlCache = new Label((Composite)this.shell, 131072);
        this.wlCache.setText(BaseMessages.getString(PKG, (String)"JoinRowsDialog.Cache.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCache);
        this.fdlCache = new FormData();
        this.fdlCache.left = new FormAttachment(0, 0);
        this.fdlCache.right = new FormAttachment(middle, -margin);
        this.fdlCache.top = new FormAttachment((Control)this.wPrefix, margin * 2);
        this.wlCache.setLayoutData((Object)this.fdlCache);
        this.wCache = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wCache);
        this.wCache.addModifyListener(lsMod);
        this.fdCache = new FormData();
        this.fdCache.left = new FormAttachment(middle, 0);
        this.fdCache.top = new FormAttachment((Control)this.wPrefix, margin * 2);
        this.fdCache.right = new FormAttachment(100, 0);
        this.wCache.setLayoutData((Object)this.fdCache);
        this.wlMainStep = new Label((Composite)this.shell, 131072);
        this.wlMainStep.setText(BaseMessages.getString(PKG, (String)"JoinRowsDialog.MainStep.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlMainStep);
        this.fdlMainStep = new FormData();
        this.fdlMainStep.left = new FormAttachment(0, 0);
        this.fdlMainStep.right = new FormAttachment(middle, -margin);
        this.fdlMainStep.top = new FormAttachment((Control)this.wCache, margin);
        this.wlMainStep.setLayoutData((Object)this.fdlMainStep);
        this.wMainStep = new CCombo((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wMainStep);
        List prevSteps = this.transMeta.findPreviousSteps(this.transMeta.findStep(this.stepname));
        for (StepMeta stepMeta : prevSteps) {
            this.wMainStep.add(stepMeta.getName());
        }
        this.wMainStep.addModifyListener(lsMod);
        this.fdMainStep = new FormData();
        this.fdMainStep.left = new FormAttachment(middle, 0);
        this.fdMainStep.top = new FormAttachment((Control)this.wCache, margin);
        this.fdMainStep.right = new FormAttachment(100, 0);
        this.wMainStep.setLayoutData((Object)this.fdMainStep);
        this.wlCondition = new Label((Composite)this.shell, 0);
        this.wlCondition.setText(BaseMessages.getString(PKG, (String)"JoinRowsDialog.Condition.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCondition);
        this.fdlCondition = new FormData();
        this.fdlCondition.left = new FormAttachment(0, 0);
        this.fdlCondition.top = new FormAttachment((Control)this.wMainStep, margin);
        this.wlCondition.setLayoutData((Object)this.fdlCondition);
        RowMetaInterface inputfields = null;
        try {
            inputfields = this.transMeta.getPrevStepFields(this.stepname);
        }
        catch (KettleException ke) {
            inputfields = new RowMeta();
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"JoinRowsDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"JoinRowsDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, null);
        this.wCondition = new ConditionEditor((Composite)this.shell, 2048, this.condition, inputfields);
        this.fdCondition = new FormData();
        this.fdCondition.left = new FormAttachment(0, 0);
        this.fdCondition.top = new FormAttachment((Control)this.wlCondition, margin);
        this.fdCondition.right = new FormAttachment(100, 0);
        this.fdCondition.bottom = new FormAttachment((Control)this.wOK, -2 * margin);
        this.wCondition.setLayoutData(this.fdCondition);
        this.wCondition.addModifyListener(lsMod);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                JoinRowsDialog.this.ok();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                JoinRowsDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                JoinRowsDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wSortDir.addSelectionListener(this.lsDef);
        this.wPrefix.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                JoinRowsDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void getData() {
        if (this.input.getPrefix() != null) {
            this.wPrefix.setText(this.input.getPrefix());
        }
        if (this.input.getDirectory() != null) {
            this.wSortDir.setText(this.input.getDirectory());
        }
        this.wCache.setText("" + this.input.getCacheSize());
        if (this.input.getLookupStepname() != null) {
            this.wMainStep.setText(this.input.getLookupStepname());
        }
        this.wStepname.selectAll();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.input.setCondition(this.backupCondition);
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        if (this.wCondition.getLevel() > 0) {
            this.wCondition.goUp();
        } else {
            this.stepname = this.wStepname.getText();
            this.input.setPrefix(this.wPrefix.getText());
            this.input.setDirectory(this.wSortDir.getText());
            this.input.setCacheSize(Const.toInt((String)this.wCache.getText(), (int)-1));
            this.input.setMainStep(this.transMeta.findStep(this.wMainStep.getText()));
            this.dispose();
        }
    }
}

