/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.luciddbbulkloader;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.SQLStatement;
import org.pentaho.di.core.SourceToTargetMapping;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.luciddbbulkloader.LucidDBBulkLoaderMeta;
import org.pentaho.di.ui.core.database.dialog.DatabaseExplorerDialog;
import org.pentaho.di.ui.core.database.dialog.SQLEditor;
import org.pentaho.di.ui.core.dialog.EnterMappingDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.step.TableItemInsertListener;

public class LucidDBBulkLoaderDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = LucidDBBulkLoaderMeta.class;
    private CCombo wConnection;
    private Label wlSchema;
    private TextVar wSchema;
    private FormData fdlSchema;
    private FormData fdSchema;
    private Label wlTable;
    private Button wbTable;
    private TextVar wTable;
    private FormData fdlTable;
    private FormData fdbTable;
    private FormData fdTable;
    private Label wlFifoPath;
    private Button wbFifoPath;
    private TextVar wFifoPath;
    private FormData fdlFifoPath;
    private FormData fdbFifoPath;
    private FormData fdFifoPath;
    private Label wlFifoServer;
    private TextVar wFifoServer;
    private FormData fdlFifoServer;
    private FormData fdFifoServer;
    private Label wlReturn;
    private TableView wReturn;
    private FormData fdlReturn;
    private FormData fdReturn;
    private Button wGetLU;
    private FormData fdGetLU;
    private Listener lsGetLU;
    private Label wlMaxErrors;
    private TextVar wMaxErrors;
    private FormData fdlMaxErrors;
    private FormData fdMaxErrors;
    private Button wDoMapping;
    private FormData fdDoMapping;
    private LucidDBBulkLoaderMeta input;

    public LucidDBBulkLoaderDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (LucidDBBulkLoaderMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                LucidDBBulkLoaderDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wStepname, middle, margin);
        if (this.input.getDatabaseMeta() == null && this.transMeta.nrDatabases() == 1) {
            this.wConnection.select(0);
        }
        this.wConnection.addModifyListener(lsMod);
        this.wlSchema = new Label((Composite)this.shell, 131072);
        this.wlSchema.setText(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.TargetSchema.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSchema);
        this.fdlSchema = new FormData();
        this.fdlSchema.left = new FormAttachment(0, 0);
        this.fdlSchema.right = new FormAttachment(middle, -margin);
        this.fdlSchema.top = new FormAttachment((Control)this.wConnection, margin * 2);
        this.wlSchema.setLayoutData((Object)this.fdlSchema);
        this.wSchema = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wSchema);
        this.wSchema.addModifyListener(lsMod);
        this.fdSchema = new FormData();
        this.fdSchema.left = new FormAttachment(middle, 0);
        this.fdSchema.top = new FormAttachment((Control)this.wConnection, margin * 2);
        this.fdSchema.right = new FormAttachment(100, 0);
        this.wSchema.setLayoutData(this.fdSchema);
        this.wlTable = new Label((Composite)this.shell, 131072);
        this.wlTable.setText(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.TargetTable.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTable);
        this.fdlTable = new FormData();
        this.fdlTable.left = new FormAttachment(0, 0);
        this.fdlTable.right = new FormAttachment(middle, -margin);
        this.fdlTable.top = new FormAttachment((Control)this.wSchema, margin);
        this.wlTable.setLayoutData((Object)this.fdlTable);
        this.wbTable = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbTable);
        this.wbTable.setText(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.Browse.Button", (String[])new String[0]));
        this.fdbTable = new FormData();
        this.fdbTable.right = new FormAttachment(100, 0);
        this.fdbTable.top = new FormAttachment((Control)this.wSchema, margin);
        this.wbTable.setLayoutData((Object)this.fdbTable);
        this.wTable = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wTable);
        this.wTable.addModifyListener(lsMod);
        this.fdTable = new FormData();
        this.fdTable.left = new FormAttachment(middle, 0);
        this.fdTable.top = new FormAttachment((Control)this.wSchema, margin);
        this.fdTable.right = new FormAttachment((Control)this.wbTable, -margin);
        this.wTable.setLayoutData(this.fdTable);
        this.wlMaxErrors = new Label((Composite)this.shell, 131072);
        this.wlMaxErrors.setText(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.MaxErrors.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlMaxErrors);
        this.fdlMaxErrors = new FormData();
        this.fdlMaxErrors.left = new FormAttachment(0, 0);
        this.fdlMaxErrors.top = new FormAttachment((Control)this.wTable, margin);
        this.fdlMaxErrors.right = new FormAttachment(middle, -margin);
        this.wlMaxErrors.setLayoutData((Object)this.fdlMaxErrors);
        this.wMaxErrors = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wMaxErrors);
        this.wMaxErrors.addModifyListener(lsMod);
        this.fdMaxErrors = new FormData();
        this.fdMaxErrors.left = new FormAttachment(middle, 0);
        this.fdMaxErrors.top = new FormAttachment((Control)this.wTable, margin);
        this.fdMaxErrors.right = new FormAttachment(100, 0);
        this.wMaxErrors.setLayoutData(this.fdMaxErrors);
        this.wlFifoPath = new Label((Composite)this.shell, 131072);
        this.wlFifoPath.setText(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.FifoPath.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFifoPath);
        this.fdlFifoPath = new FormData();
        this.fdlFifoPath.left = new FormAttachment(0, 0);
        this.fdlFifoPath.right = new FormAttachment(middle, -margin);
        this.fdlFifoPath.top = new FormAttachment((Control)this.wMaxErrors, margin);
        this.wlFifoPath.setLayoutData((Object)this.fdlFifoPath);
        this.wbFifoPath = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbFifoPath);
        this.wbFifoPath.setText(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.Browse.Button", (String[])new String[0]));
        this.fdbFifoPath = new FormData();
        this.fdbFifoPath.right = new FormAttachment(100, 0);
        this.fdbFifoPath.top = new FormAttachment((Control)this.wMaxErrors, margin);
        this.wbFifoPath.setLayoutData((Object)this.fdbFifoPath);
        this.wFifoPath = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wFifoPath);
        this.wFifoPath.addModifyListener(lsMod);
        this.fdFifoPath = new FormData();
        this.fdFifoPath.left = new FormAttachment(middle, 0);
        this.fdFifoPath.top = new FormAttachment((Control)this.wMaxErrors, margin);
        this.fdFifoPath.right = new FormAttachment((Control)this.wbFifoPath, -margin);
        this.wFifoPath.setLayoutData(this.fdFifoPath);
        this.wlFifoServer = new Label((Composite)this.shell, 131072);
        this.wlFifoServer.setText(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.FifoServer.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFifoServer);
        this.fdlFifoServer = new FormData();
        this.fdlFifoServer.left = new FormAttachment(0, 0);
        this.fdlFifoServer.right = new FormAttachment(middle, -margin);
        this.fdlFifoServer.top = new FormAttachment((Control)this.wFifoPath, margin * 2);
        this.wlFifoServer.setLayoutData((Object)this.fdlFifoServer);
        this.wFifoServer = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wFifoServer);
        this.wFifoServer.addModifyListener(lsMod);
        this.fdFifoServer = new FormData();
        this.fdFifoServer.left = new FormAttachment(middle, 0);
        this.fdFifoServer.top = new FormAttachment((Control)this.wFifoPath, margin * 2);
        this.fdFifoServer.right = new FormAttachment(100, 0);
        this.wFifoServer.setLayoutData(this.fdFifoServer);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString((String)"System.Button.OK"));
        this.wSQL = new Button((Composite)this.shell, 8);
        this.wSQL.setText(BaseMessages.getString((String)"System.Button.SQL"));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString((String)"System.Button.Cancel"));
        this.setButtonPositions(new Button[]{this.wOK, this.wSQL, this.wCancel}, margin, null);
        this.wlReturn = new Label((Composite)this.shell, 0);
        this.wlReturn.setText(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlReturn);
        this.fdlReturn = new FormData();
        this.fdlReturn.left = new FormAttachment(0, 0);
        this.fdlReturn.top = new FormAttachment((Control)this.wFifoServer, margin);
        this.wlReturn.setLayoutData((Object)this.fdlReturn);
        int UpInsCols = 3;
        int UpInsRows = this.input.getFieldTable() != null ? this.input.getFieldTable().length : 1;
        ColumnInfo[] ciReturn = new ColumnInfo[UpInsCols];
        ciReturn[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.ColumnInfo.TableField", (String[])new String[0]), 1, false);
        ciReturn[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.ColumnInfo.StreamField", (String[])new String[0]), 1, false);
        ciReturn[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.ColumnInfo.FormatOK", (String[])new String[0]), 2, new String[]{"Y", "N"}, true);
        this.wReturn = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 68354, ciReturn, UpInsRows, lsMod, this.props);
        this.wGetLU = new Button((Composite)this.shell, 8);
        this.wGetLU.setText(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.GetFields.Label", (String[])new String[0]));
        this.fdGetLU = new FormData();
        this.fdGetLU.top = new FormAttachment((Control)this.wlReturn, margin);
        this.fdGetLU.right = new FormAttachment(100, 0);
        this.wGetLU.setLayoutData((Object)this.fdGetLU);
        this.wDoMapping = new Button((Composite)this.shell, 8);
        this.wDoMapping.setText(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.EditMapping.Label", (String[])new String[0]));
        this.fdDoMapping = new FormData();
        this.fdDoMapping.top = new FormAttachment((Control)this.wGetLU, margin);
        this.fdDoMapping.right = new FormAttachment(100, 0);
        this.wDoMapping.setLayoutData((Object)this.fdDoMapping);
        this.wDoMapping.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                LucidDBBulkLoaderDialog.this.generateMappings();
            }
        });
        this.fdReturn = new FormData();
        this.fdReturn.left = new FormAttachment(0, 0);
        this.fdReturn.top = new FormAttachment((Control)this.wlReturn, margin);
        this.fdReturn.right = new FormAttachment((Control)this.wGetLU, -margin);
        this.fdReturn.bottom = new FormAttachment((Control)this.wOK, -2 * margin);
        this.wReturn.setLayoutData(this.fdReturn);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                LucidDBBulkLoaderDialog.this.ok();
            }
        };
        this.lsGetLU = new Listener(){

            public void handleEvent(Event e) {
                LucidDBBulkLoaderDialog.this.getUpdate();
            }
        };
        this.lsSQL = new Listener(){

            public void handleEvent(Event e) {
                LucidDBBulkLoaderDialog.this.create();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                LucidDBBulkLoaderDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wGetLU.addListener(13, this.lsGetLU);
        this.wSQL.addListener(13, this.lsSQL);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                LucidDBBulkLoaderDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wSchema.addSelectionListener(this.lsDef);
        this.wFifoPath.addSelectionListener(this.lsDef);
        this.wFifoServer.addSelectionListener(this.lsDef);
        this.wTable.addSelectionListener(this.lsDef);
        this.wMaxErrors.addSelectionListener(this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                LucidDBBulkLoaderDialog.this.cancel();
            }
        });
        this.wbTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                LucidDBBulkLoaderDialog.this.getTableName();
            }
        });
        this.setSize();
        this.getData();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void getData() {
        this.logDebug(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.Log.GettingKeyInfo", (String[])new String[0]));
        this.wMaxErrors.setText("" + this.input.getMaxErrors());
        if (this.input.getFieldTable() != null) {
            for (int i = 0; i < this.input.getFieldTable().length; ++i) {
                TableItem item = this.wReturn.table.getItem(i);
                if (this.input.getFieldTable()[i] != null) {
                    item.setText(1, this.input.getFieldTable()[i]);
                }
                if (this.input.getFieldStream()[i] != null) {
                    item.setText(2, this.input.getFieldStream()[i]);
                }
                item.setText(3, this.input.getFieldFormatOk()[i] ? "Y" : "N");
            }
        }
        if (this.input.getDatabaseMeta() != null) {
            this.wConnection.setText(this.input.getDatabaseMeta().getName());
        } else if (this.transMeta.nrDatabases() == 1) {
            this.wConnection.setText(this.transMeta.getDatabase(0).getName());
        }
        if (this.input.getSchemaName() != null) {
            this.wSchema.setText(this.input.getSchemaName());
        }
        if (this.input.getTableName() != null) {
            this.wTable.setText(this.input.getTableName());
        }
        if (this.input.getFifoDirectory() != null) {
            this.wFifoPath.setText(this.input.getFifoDirectory());
        }
        if (this.input.getFifoServerName() != null) {
            this.wFifoServer.setText(this.input.getFifoServerName());
        }
        this.wStepname.selectAll();
        this.wReturn.setRowNums();
        this.wReturn.optWidth(true);
    }

    private void generateMappings() {
        EnterMappingDialog d;
        RowMetaInterface targetFields;
        RowMetaInterface sourceFields;
        try {
            sourceFields = this.transMeta.getPrevStepFields(this.stepMeta);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.DoMapping.UnableToFindSourceFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.DoMapping.UnableToFindSourceFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        this.input.setDatabaseMeta(this.transMeta.findDatabase(this.wConnection.getText()));
        this.input.setTableName(this.transMeta.environmentSubstitute(this.wTable.getText()));
        StepMetaInterface stepMetaInterface = this.stepMeta.getStepMetaInterface();
        try {
            targetFields = stepMetaInterface.getRequiredFields((VariableSpace)this.transMeta);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.DoMapping.UnableToFindTargetFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.DoMapping.UnableToFindTargetFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        String[] inputNames = new String[sourceFields.size()];
        for (int i = 0; i < sourceFields.size(); ++i) {
            ValueMetaInterface value = sourceFields.getValueMeta(i);
            inputNames[i] = value.getName() + "            (" + value.getOrigin() + ")";
        }
        List<SourceToTargetMapping> mappings = new ArrayList<SourceToTargetMapping>();
        StringBuffer missingSourceFields = new StringBuffer();
        StringBuffer missingTargetFields = new StringBuffer();
        int nrFields = this.wReturn.nrNonEmpty();
        for (int i = 0; i < nrFields; ++i) {
            int targetIndex;
            TableItem item = this.wReturn.getNonEmpty(i);
            String source = item.getText(2);
            String target = item.getText(1);
            int sourceIndex = sourceFields.indexOfValue(source);
            if (sourceIndex < 0) {
                missingSourceFields.append(Const.CR + "   " + source + " --> " + target);
            }
            if ((targetIndex = targetFields.indexOfValue(target)) < 0) {
                missingTargetFields.append(Const.CR + "   " + source + " --> " + target);
            }
            if (sourceIndex < 0 || targetIndex < 0) continue;
            SourceToTargetMapping mapping = new SourceToTargetMapping(sourceIndex, targetIndex);
            mappings.add(mapping);
        }
        if (missingSourceFields.length() > 0 || missingTargetFields.length() > 0) {
            String message = "";
            if (missingSourceFields.length() > 0) {
                message = message + BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.DoMapping.SomeSourceFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            if (missingTargetFields.length() > 0) {
                message = message + BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.DoMapping.SomeTargetFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            message = message + Const.CR;
            message = message + BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.DoMapping.SomeFieldsNotFoundContinue", (String[])new String[0]) + Const.CR;
            MessageDialog.setDefaultImage((Image)GUIResource.getInstance().getImageSpoon());
            boolean goOn = MessageDialog.openConfirm((Shell)this.shell, (String)BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.DoMapping.SomeFieldsNotFoundTitle", (String[])new String[0]), (String)message);
            if (!goOn) {
                return;
            }
        }
        if ((mappings = (d = new EnterMappingDialog(this.shell, sourceFields.getFieldNames(), targetFields.getFieldNames(), mappings)).open()) != null) {
            this.wReturn.table.removeAll();
            this.wReturn.table.setItemCount(mappings.size());
            for (int i = 0; i < mappings.size(); ++i) {
                SourceToTargetMapping mapping = mappings.get(i);
                TableItem item = this.wReturn.table.getItem(i);
                item.setText(2, sourceFields.getValueMeta(mapping.getSourcePosition()).getName());
                item.setText(1, targetFields.getValueMeta(mapping.getTargetPosition()).getName());
            }
            this.wReturn.setRowNums();
            this.wReturn.optWidth(true);
        }
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(LucidDBBulkLoaderMeta inf) {
        int nrfields = this.wReturn.nrNonEmpty();
        inf.allocate(nrfields);
        inf.setMaxErrors(Const.toInt((String)this.wMaxErrors.getText(), (int)0));
        this.logDebug(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.Log.FoundFields", (String[])new String[]{"" + nrfields}));
        for (int i = 0; i < nrfields; ++i) {
            TableItem item = this.wReturn.getNonEmpty(i);
            inf.getFieldTable()[i] = item.getText(1);
            inf.getFieldStream()[i] = item.getText(2);
            inf.getFieldFormatOk()[i] = "Y".equalsIgnoreCase(item.getText(3));
        }
        inf.setSchemaName(this.wSchema.getText());
        inf.setTableName(this.wTable.getText());
        inf.setDatabaseMeta(this.transMeta.findDatabase(this.wConnection.getText()));
        inf.setFifoDirectory(this.wFifoPath.getText());
        inf.setFifoServerName(this.wFifoServer.getText());
        this.stepname = this.wStepname.getText();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.getInfo(this.input);
        if (this.input.getDatabaseMeta() == null) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
        this.dispose();
    }

    private void getTableName() {
        DatabaseMeta inf = null;
        int connr = this.wConnection.getSelectionIndex();
        if (connr >= 0) {
            inf = this.transMeta.getDatabase(connr);
        }
        if (inf != null) {
            this.logDebug(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.Log.LookingAtConnection", (String[])new String[0]) + inf.toString());
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, inf, this.transMeta.getDatabases());
            std.setSelectedSchemaAndTable(this.wSchema.getText(), this.wTable.getText());
            if (std.open()) {
                this.wSchema.setText(Const.NVL((String)std.getSchemaName(), (String)""));
                this.wTable.setText(Const.NVL((String)std.getTableName(), (String)""));
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.InvalidConnection.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.InvalidConnection.DialogTitle", (String[])new String[0]));
            mb.open();
        }
    }

    private void getUpdate() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null) {
                TableItemInsertListener listener = new TableItemInsertListener(){

                    public boolean tableItemInserted(TableItem tableItem, ValueMetaInterface v) {
                        if (v.getType() == 3) {
                            tableItem.setText(3, "Y");
                        } else {
                            tableItem.setText(3, "Y");
                        }
                        return true;
                    }
                };
                BaseStepDialog.getFieldsFromPrevious(r, this.wReturn, 1, new int[]{1, 2}, new int[0], -1, -1, listener);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void create() {
        try {
            LucidDBBulkLoaderMeta info = new LucidDBBulkLoaderMeta();
            this.getInfo(info);
            String name = this.stepname;
            StepMeta stepMeta = new StepMeta(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.StepMeta.Title", (String[])new String[0]), name, (StepMetaInterface)info);
            RowMetaInterface prev = this.transMeta.getPrevStepFields(this.stepname);
            SQLStatement sql = info.getSQLStatements(this.transMeta, stepMeta, prev);
            if (!sql.hasError()) {
                if (sql.hasSQL()) {
                    SQLEditor sqledit = new SQLEditor((VariableSpace)this.transMeta, this.shell, 0, info.getDatabaseMeta(), this.transMeta.getDbCache(), sql.getSQL());
                    sqledit.open();
                } else {
                    MessageBox mb = new MessageBox(this.shell, 34);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.NoSQLNeeds.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.NoSQLNeeds.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(sql.getError());
                mb.setText(BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.SQLError.DialogTitle", (String[])new String[0]));
                mb.open();
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.CouldNotBuildSQL.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"LucidDBBulkLoaderDialog.CouldNotBuildSQL.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

