/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.memgroupby;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.memgroupby.MemoryGroupByMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class MemoryGroupByDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = MemoryGroupByMeta.class;
    private Label wlGroup;
    private TableView wGroup;
    private FormData fdlGroup;
    private FormData fdGroup;
    private Label wlAgg;
    private TableView wAgg;
    private FormData fdlAgg;
    private FormData fdAgg;
    private Label wlAlwaysAddResult;
    private Button wAlwaysAddResult;
    private FormData fdlAlwaysAddResult;
    private FormData fdAlwaysAddResult;
    private Button wGet;
    private Button wGetAgg;
    private FormData fdGet;
    private FormData fdGetAgg;
    private Listener lsGet;
    private Listener lsGetAgg;
    private MemoryGroupByMeta input;
    private ColumnInfo[] ciKey;
    private ColumnInfo[] ciReturn;
    private Map<String, Integer> inputFields;

    public MemoryGroupByDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (MemoryGroupByMeta)in;
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MemoryGroupByDialog.this.input.setChanged();
            }
        };
        this.backupChanged = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wlAlwaysAddResult = new Label((Composite)this.shell, 131072);
        this.wlAlwaysAddResult.setText(BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.AlwaysAddResult.Label", (String[])new String[0]));
        this.wlAlwaysAddResult.setToolTipText(BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.AlwaysAddResult.ToolTip", (String[])new String[0]));
        this.props.setLook((Control)this.wlAlwaysAddResult);
        this.fdlAlwaysAddResult = new FormData();
        this.fdlAlwaysAddResult.left = new FormAttachment(0, 0);
        this.fdlAlwaysAddResult.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdlAlwaysAddResult.right = new FormAttachment(middle, -margin);
        this.wlAlwaysAddResult.setLayoutData((Object)this.fdlAlwaysAddResult);
        this.wAlwaysAddResult = new Button((Composite)this.shell, 32);
        this.wAlwaysAddResult.setToolTipText(BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.AlwaysAddResult.ToolTip", (String[])new String[0]));
        this.props.setLook((Control)this.wAlwaysAddResult);
        this.fdAlwaysAddResult = new FormData();
        this.fdAlwaysAddResult.left = new FormAttachment(middle, 0);
        this.fdAlwaysAddResult.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdAlwaysAddResult.right = new FormAttachment(100, 0);
        this.wAlwaysAddResult.setLayoutData((Object)this.fdAlwaysAddResult);
        this.wlGroup = new Label((Composite)this.shell, 0);
        this.wlGroup.setText(BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.Group.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlGroup);
        this.fdlGroup = new FormData();
        this.fdlGroup.left = new FormAttachment(0, 0);
        this.fdlGroup.top = new FormAttachment((Control)this.wAlwaysAddResult, margin);
        this.wlGroup.setLayoutData((Object)this.fdlGroup);
        int nrKeyCols = 1;
        int nrKeyRows = this.input.getGroupField() != null ? this.input.getGroupField().length : 1;
        this.ciKey = new ColumnInfo[nrKeyCols];
        this.ciKey[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.ColumnInfo.GroupField", (String[])new String[0]), 2, new String[]{""}, false);
        this.wGroup = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 68354, this.ciKey, nrKeyRows, lsMod, this.props);
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.GetFields.Button", (String[])new String[0]));
        this.fdGet = new FormData();
        this.fdGet.top = new FormAttachment((Control)this.wlGroup, margin);
        this.fdGet.right = new FormAttachment(100, 0);
        this.wGet.setLayoutData((Object)this.fdGet);
        this.fdGroup = new FormData();
        this.fdGroup.left = new FormAttachment(0, 0);
        this.fdGroup.top = new FormAttachment((Control)this.wlGroup, margin);
        this.fdGroup.right = new FormAttachment((Control)this.wGet, -margin);
        this.fdGroup.bottom = new FormAttachment(45, 0);
        this.wGroup.setLayoutData(this.fdGroup);
        this.wlAgg = new Label((Composite)this.shell, 0);
        this.wlAgg.setText(BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.Aggregates.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAgg);
        this.fdlAgg = new FormData();
        this.fdlAgg.left = new FormAttachment(0, 0);
        this.fdlAgg.top = new FormAttachment((Control)this.wGroup, margin);
        this.wlAgg.setLayoutData((Object)this.fdlAgg);
        int UpInsCols = 4;
        int UpInsRows = this.input.getAggregateField() != null ? this.input.getAggregateField().length : 1;
        this.ciReturn = new ColumnInfo[UpInsCols];
        this.ciReturn[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.ColumnInfo.Name", (String[])new String[0]), 1, false);
        this.ciReturn[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.ColumnInfo.Subject", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciReturn[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.ColumnInfo.Type", (String[])new String[0]), 2, MemoryGroupByMeta.typeGroupLongDesc);
        this.ciReturn[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.ColumnInfo.Value", (String[])new String[0]), 1, false);
        this.ciReturn[3].setToolTip(BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.ColumnInfo.Value.Tooltip", (String[])new String[0]));
        this.ciReturn[3].setUsingVariables(true);
        this.wAgg = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 68354, this.ciReturn, UpInsRows, lsMod, this.props);
        this.wGetAgg = new Button((Composite)this.shell, 8);
        this.wGetAgg.setText(BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.GetLookupFields.Button", (String[])new String[0]));
        this.fdGetAgg = new FormData();
        this.fdGetAgg.top = new FormAttachment((Control)this.wlAgg, margin);
        this.fdGetAgg.right = new FormAttachment(100, 0);
        this.wGetAgg.setLayoutData((Object)this.fdGetAgg);
        Runnable runnable = new Runnable(){

            public void run() {
                StepMeta stepMeta = MemoryGroupByDialog.this.transMeta.findStep(MemoryGroupByDialog.this.stepname);
                if (stepMeta != null) {
                    try {
                        RowMetaInterface row = MemoryGroupByDialog.this.transMeta.getPrevStepFields(stepMeta);
                        for (int i = 0; i < row.size(); ++i) {
                            MemoryGroupByDialog.this.inputFields.put(row.getValueMeta(i).getName(), i);
                        }
                        MemoryGroupByDialog.this.setComboBoxes();
                    }
                    catch (KettleException e) {
                        MemoryGroupByDialog.this.logError(BaseMessages.getString((Class)PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                    }
                }
            }
        };
        new Thread(runnable).start();
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, null);
        this.fdAgg = new FormData();
        this.fdAgg.left = new FormAttachment(0, 0);
        this.fdAgg.top = new FormAttachment((Control)this.wlAgg, margin);
        this.fdAgg.right = new FormAttachment((Control)this.wGetAgg, -margin);
        this.fdAgg.bottom = new FormAttachment((Control)this.wOK, -margin);
        this.wAgg.setLayoutData(this.fdAgg);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                MemoryGroupByDialog.this.ok();
            }
        };
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                MemoryGroupByDialog.this.get();
            }
        };
        this.lsGetAgg = new Listener(){

            public void handleEvent(Event e) {
                MemoryGroupByDialog.this.getAgg();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                MemoryGroupByDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wGet.addListener(13, this.lsGet);
        this.wGetAgg.addListener(13, this.lsGetAgg);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                MemoryGroupByDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                MemoryGroupByDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.input.setChanged(this.backupChanged);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.ciKey[0].setComboValues(fieldNames);
        this.ciReturn[1].setComboValues(fieldNames);
    }

    public void getData() {
        TableItem item;
        int i;
        this.logDebug(BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.Log.GettingKeyInfo", (String[])new String[0]));
        this.wAlwaysAddResult.setSelection(this.input.isAlwaysGivingBackOneRow());
        if (this.input.getGroupField() != null) {
            for (i = 0; i < this.input.getGroupField().length; ++i) {
                item = this.wGroup.table.getItem(i);
                if (this.input.getGroupField()[i] == null) continue;
                item.setText(1, this.input.getGroupField()[i]);
            }
        }
        if (this.input.getAggregateField() != null) {
            for (i = 0; i < this.input.getAggregateField().length; ++i) {
                item = this.wAgg.table.getItem(i);
                if (this.input.getAggregateField()[i] != null) {
                    item.setText(1, this.input.getAggregateField()[i]);
                }
                if (this.input.getSubjectField()[i] != null) {
                    item.setText(2, this.input.getSubjectField()[i]);
                }
                item.setText(3, Const.NVL((String)MemoryGroupByMeta.getTypeDescLong((int)this.input.getAggregateType()[i]), (String)""));
                if (this.input.getValueField()[i] == null) continue;
                item.setText(4, this.input.getValueField()[i]);
            }
        }
        this.wStepname.selectAll();
        this.wGroup.setRowNums();
        this.wGroup.optWidth(true);
        this.wAgg.setRowNums();
        this.wAgg.optWidth(true);
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void ok() {
        TableItem item;
        int i;
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        int sizegroup = this.wGroup.nrNonEmpty();
        int nrfields = this.wAgg.nrNonEmpty();
        this.input.setAlwaysGivingBackOneRow(this.wAlwaysAddResult.getSelection());
        this.input.allocate(sizegroup, nrfields);
        for (i = 0; i < sizegroup; ++i) {
            item = this.wGroup.getNonEmpty(i);
            this.input.getGroupField()[i] = item.getText(1);
        }
        for (i = 0; i < nrfields; ++i) {
            item = this.wAgg.getNonEmpty(i);
            this.input.getAggregateField()[i] = item.getText(1);
            this.input.getSubjectField()[i] = item.getText(2);
            this.input.getAggregateType()[i] = MemoryGroupByMeta.getType((String)item.getText(3));
            this.input.getValueField()[i] = item.getText(4);
        }
        this.stepname = this.wStepname.getText();
        this.dispose();
    }

    private void get() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null && !r.isEmpty()) {
                BaseStepDialog.getFieldsFromPrevious(r, this.wGroup, 1, new int[]{1}, new int[0], -1, -1, null);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void getAgg() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null && !r.isEmpty()) {
                BaseStepDialog.getFieldsFromPrevious(r, this.wAgg, 1, new int[]{1, 2}, new int[0], -1, -1, null);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"MemoryGroupByDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

