/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.pentahoreporting;

import java.math.BigDecimal;
import java.util.Date;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.pentahoreporting.PentahoReportingOutput;
import org.pentaho.di.trans.steps.pentahoreporting.PentahoReportingOutputMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.step.TableItemInsertListener;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.parameters.ParameterDefinitionEntry;
import org.pentaho.reporting.engine.classic.core.parameters.ReportParameterDefinition;

public class PentahoReportingOutputDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = PentahoReportingOutput.class;
    private Label wlInput;
    private Combo wInput;
    private Label wlOutput;
    private Combo wOutput;
    private Label wlProcessor;
    private List wProcessor;
    private PentahoReportingOutputMeta input;
    private TableView wFields;
    private static String lastFilename;

    public PentahoReportingOutputDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (PentahoReportingOutputMeta)in;
        this.transMeta = transMeta;
        this.stepname = sname != null ? sname : BaseMessages.getString(PKG, (String)"PentahoReportingOutputDialog.DefaultStepName", (String[])new String[0]);
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                PentahoReportingOutputDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"PentahoReportingOutputDialog.Shell.Text", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"PentahoReportingOutputDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wlInput = new Label((Composite)this.shell, 131072);
        this.wlInput.setText(BaseMessages.getString(PKG, (String)"PentahoReportingOutputDialog.InputFilename.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlInput);
        FormData fdlInput = new FormData();
        fdlInput.left = new FormAttachment(0, 0);
        fdlInput.top = new FormAttachment((Control)this.wStepname, margin + 5);
        fdlInput.right = new FormAttachment(middle, -margin);
        this.wlInput.setLayoutData((Object)fdlInput);
        this.wInput = new Combo((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wInput);
        this.wInput.addModifyListener(lsMod);
        FormData fdInput = new FormData();
        fdInput.left = new FormAttachment(middle, 0);
        fdInput.top = new FormAttachment((Control)this.wStepname, margin + 5);
        fdInput.right = new FormAttachment(100, 0);
        this.wInput.setLayoutData((Object)fdInput);
        String[] fieldNames = new String[]{};
        try {
            fieldNames = Const.sortStrings((String[])this.transMeta.getPrevStepFields(this.stepMeta).getFieldNames());
        }
        catch (KettleException e) {
            this.log.logError("Unexpected error getting fields from previous steps...", (Throwable)e);
        }
        this.wInput.setItems(fieldNames);
        this.wlOutput = new Label((Composite)this.shell, 131072);
        this.wlOutput.setText(BaseMessages.getString(PKG, (String)"PentahoReportingOutputDialog.OutputFilename.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlOutput);
        FormData fdlOutput = new FormData();
        fdlOutput.left = new FormAttachment(0, 0);
        fdlOutput.top = new FormAttachment((Control)this.wInput, margin + 5);
        fdlOutput.right = new FormAttachment(middle, -margin);
        this.wlOutput.setLayoutData((Object)fdlOutput);
        this.wOutput = new Combo((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wOutput);
        this.wOutput.addModifyListener(lsMod);
        FormData fdOutput = new FormData();
        fdOutput.left = new FormAttachment(middle, 0);
        fdOutput.top = new FormAttachment((Control)this.wInput, margin + 5);
        fdOutput.right = new FormAttachment(100, 0);
        this.wOutput.setLayoutData((Object)fdOutput);
        this.wOutput.setItems(fieldNames);
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"PentahoReportingOutput.Column.ParameterName", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"PentahoReportingOutput.Column.FieldName", (String[])new String[0]), 2, fieldNames, true)};
        this.wFields = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 67586, colinf, 1, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.top = new FormAttachment((Control)this.wOutput, margin * 2);
        fdFields.bottom = new FormAttachment((Control)this.wOutput, 250);
        fdFields.left = new FormAttachment(0, 0);
        fdFields.right = new FormAttachment(100, 0);
        this.wFields.setLayoutData(fdFields);
        this.wlProcessor = new Label((Composite)this.shell, 131072);
        this.wlProcessor.setText(BaseMessages.getString(PKG, (String)"PentahoReportingOutputDialog.Processor.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlProcessor);
        FormData fdlProcessor = new FormData();
        fdlProcessor.left = new FormAttachment(0, 0);
        fdlProcessor.top = new FormAttachment((Control)this.wFields, margin + 5);
        fdlProcessor.right = new FormAttachment(middle, -margin);
        this.wlProcessor.setLayoutData((Object)fdlProcessor);
        this.wProcessor = new List((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wProcessor);
        FormData fdProcessor = new FormData();
        fdProcessor.left = new FormAttachment(middle, 0);
        fdProcessor.top = new FormAttachment((Control)this.wFields, margin + 5);
        fdProcessor.right = new FormAttachment(100, 0);
        this.wProcessor.setLayoutData((Object)fdProcessor);
        this.wProcessor.setItems(PentahoReportingOutputMeta.ProcessorType.getDescriptions());
        this.wProcessor.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PentahoReportingOutputDialog.this.input.setChanged();
            }
        });
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString((String)"System.Button.OK"));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString((String)"System.Button.Cancel"));
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"PentahoReportingOutputDialog.Button.GetParameters", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wGet, this.wCancel}, margin, (Control)this.wProcessor);
        this.wOK.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PentahoReportingOutputDialog.this.ok();
            }
        });
        this.wCancel.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PentahoReportingOutputDialog.this.cancel();
            }
        });
        this.wGet.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                PentahoReportingOutputDialog.this.get();
            }
        });
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                PentahoReportingOutputDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wInput.addSelectionListener((SelectionListener)this.lsDef);
        this.wOutput.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                PentahoReportingOutputDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void getData() {
        this.wInput.setText(Const.NVL((String)this.input.getInputFileField(), (String)""));
        this.wOutput.setText(Const.NVL((String)this.input.getOutputFileField(), (String)""));
        for (String name : this.input.getParameterFieldMap().keySet()) {
            String field = (String)this.input.getParameterFieldMap().get(name);
            TableItem item = new TableItem(this.wFields.table, 0);
            item.setText(1, name);
            item.setText(2, field);
        }
        this.wFields.removeEmptyRows();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wProcessor.select(this.input.getOutputProcessorType().ordinal());
        this.wStepname.selectAll();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        this.stepname = this.wStepname.getText();
        this.input.getParameterFieldMap().clear();
        for (int i = 0; i < this.wFields.nrNonEmpty(); ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            String name = item.getText(1);
            String field = item.getText(2);
            if (Const.isEmpty((String)name) || Const.isEmpty((String)field)) continue;
            this.input.getParameterFieldMap().put(name, field);
        }
        this.input.setInputFileField(this.wInput.getText());
        this.input.setOutputFileField(this.wOutput.getText());
        this.input.setOutputProcessorType(PentahoReportingOutputMeta.ProcessorType.values()[this.wProcessor.getSelectionIndex()]);
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void get() {
        Cursor busy = new Cursor((Device)this.shell.getDisplay(), 1);
        Runnable runnable = new Runnable(){

            public void run() {
                PentahoReportingOutput.performPentahoReportingBoot((LogChannelInterface)PentahoReportingOutputDialog.this.log, PentahoReportingOutputDialog.this.input.getClass());
            }
        };
        Thread thread = new Thread(runnable);
        thread.start();
        try {
            String sourceFilename;
            FileDialog dialog = new FileDialog(this.shell, 4096);
            dialog.setText(BaseMessages.getString(PKG, (String)"PentahoReportingOutputDialog.ExtractParameters.FileDialog", (String[])new String[0]));
            dialog.setFilterExtensions(new String[]{"*.prpt;*.PRPT", "*"});
            if (lastFilename != null) {
                dialog.setFileName(lastFilename);
            }
            dialog.setFilterNames(new String[]{BaseMessages.getString(PKG, (String)"PentahoReportingOutputDialog.PentahoReportingFiles", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.FileType.AllFiles", (String[])new String[0])});
            if (dialog.open() == null) {
                return;
            }
            thread.join();
            lastFilename = sourceFilename = dialog.getFilterPath() + System.getProperty("file.separator") + dialog.getFileName();
            this.shell.setCursor(busy);
            MasterReport report = PentahoReportingOutput.loadMasterReport((String)sourceFilename);
            ReportParameterDefinition definition = report.getParameterDefinition();
            RowMeta r = new RowMeta();
            for (int i = 0; i < definition.getParameterCount(); ++i) {
                ParameterDefinitionEntry entry = definition.getParameterDefinition(i);
                ValueMeta valueMeta = new ValueMeta(entry.getName(), 2);
                valueMeta.setComments(this.getParameterDefinitionEntryTypeDescription(entry));
                r.addValueMeta((ValueMetaInterface)valueMeta);
            }
            this.shell.setCursor(null);
            BaseStepDialog.getFieldsFromPrevious((RowMetaInterface)r, this.wFields, 1, new int[]{1}, new int[0], -1, -1, new TableItemInsertListener(){

                public boolean tableItemInserted(TableItem item, ValueMetaInterface valueMeta) {
                    item.setText(2, valueMeta.getComments());
                    return true;
                }
            });
        }
        catch (Exception e) {
            this.shell.setCursor(null);
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"PentahoReportingOutputDialog.ErrorReadingParameters.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"PentahoReportingOutputDialog.ErrorReadingParameters.Message", (String[])new String[0]), e);
        }
        finally {
            this.shell.setCursor(null);
            busy.dispose();
        }
    }

    private String getParameterDefinitionEntryTypeDescription(ParameterDefinitionEntry entry) {
        Class clazz = entry.getValueType();
        String extra = " (";
        String namespace = entry.getParameterAttributeNamespaces()[0];
        String[] attributes = entry.getParameterAttributeNames(namespace);
        for (int i = 0; i < attributes.length; ++i) {
            if (i > 0) {
                extra = extra + ", ";
            }
            String attr = entry.getParameterAttribute(namespace, attributes[i], null);
            extra = extra + attributes[i] + "=" + attr;
        }
        extra = extra + ")";
        String type = clazz.equals(String.class) ? BaseMessages.getString(PKG, (String)"PentahoReportingOutputDialog.ParameterType.String", (String[])new String[0]) : (clazz.equals(new String[0].getClass()) ? BaseMessages.getString(PKG, (String)"PentahoReportingOutputDialog.ParameterType.StringArray", (String[])new String[0]) : (clazz.equals(Date.class) ? BaseMessages.getString(PKG, (String)"PentahoReportingOutputDialog.ParameterType.Date", (String[])new String[0]) : (clazz.equals(Byte.TYPE) || clazz.equals(Byte.class) ? BaseMessages.getString(PKG, (String)"PentahoReportingOutputDialog.ParameterType.Integer", (String[])new String[0]) : (clazz.equals(Short.class) || clazz.equals(Short.TYPE) ? BaseMessages.getString(PKG, (String)"PentahoReportingOutputDialog.ParameterType.Integer", (String[])new String[0]) : (clazz.equals(Integer.class) || clazz.equals(Integer.TYPE) ? BaseMessages.getString(PKG, (String)"PentahoReportingOutputDialog.ParameterType.Integer", (String[])new String[0]) : (clazz.equals(Long.class) || clazz.equals(Long.TYPE) ? BaseMessages.getString(PKG, (String)"PentahoReportingOutputDialog.ParameterType.Integer", (String[])new String[0]) : (clazz.equals(Double.class) || clazz.equals(Double.TYPE) ? BaseMessages.getString(PKG, (String)"PentahoReportingOutputDialog.ParameterType.Number", (String[])new String[0]) : (clazz.equals(Float.class) || clazz.equals(Float.TYPE) ? BaseMessages.getString(PKG, (String)"PentahoReportingOutputDialog.ParameterType.Number", (String[])new String[0]) : (clazz.equals(Number.class) ? BaseMessages.getString(PKG, (String)"PentahoReportingOutputDialog.ParameterType.Numeric", (String[])new String[0]) : (clazz.equals(Boolean.class) || clazz.equals(Boolean.TYPE) ? BaseMessages.getString(PKG, (String)"PentahoReportingOutputDialog.ParameterType.Boolean", (String[])new String[0]) : (clazz.equals(BigDecimal.class) ? BaseMessages.getString(PKG, (String)"PentahoReportingOutputDialog.ParameterType.BigNumber", (String[])new String[0]) : (clazz.equals(new byte[0].getClass()) ? BaseMessages.getString(PKG, (String)"PentahoReportingOutputDialog.ParameterType.Binary", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"PentahoReportingOutputDialog.ParameterType.Unknown", (String[])new String[]{entry.getValueType().getSimpleName()})))))))))))));
        if (attributes.length == 0) {
            return type;
        }
        return type + extra;
    }
}

