/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.rowgenerator;

import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPreviewFactory;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.rowgenerator.RowGeneratorMeta;
import org.pentaho.di.ui.core.dialog.EnterNumberDialog;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.dialog.TransPreviewProgressDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class RowGeneratorDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = RowGeneratorMeta.class;
    private Label wlLimit;
    private TextVar wLimit;
    private FormData fdlLimit;
    private FormData fdLimit;
    private Label wlFields;
    private TableView wFields;
    private FormData fdlFields;
    private FormData fdFields;
    private RowGeneratorMeta input;

    public RowGeneratorDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (RowGeneratorMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RowGeneratorDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"RowGeneratorDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"System.Label.StepName", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wlLimit = new Label((Composite)this.shell, 131072);
        this.wlLimit.setText(BaseMessages.getString(PKG, (String)"RowGeneratorDialog.Limit.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlLimit);
        this.fdlLimit = new FormData();
        this.fdlLimit.left = new FormAttachment(0, 0);
        this.fdlLimit.right = new FormAttachment(middle, -margin);
        this.fdlLimit.top = new FormAttachment((Control)this.wStepname, margin);
        this.wlLimit.setLayoutData((Object)this.fdlLimit);
        this.wLimit = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wLimit);
        this.wLimit.addModifyListener(lsMod);
        this.fdLimit = new FormData();
        this.fdLimit.left = new FormAttachment(middle, 0);
        this.fdLimit.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdLimit.right = new FormAttachment(100, 0);
        this.wLimit.setLayoutData(this.fdLimit);
        this.wlFields = new Label((Composite)this.shell, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"RowGeneratorDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFields);
        this.fdlFields = new FormData();
        this.fdlFields.left = new FormAttachment(0, 0);
        this.fdlFields.top = new FormAttachment((Control)this.wLimit, margin);
        this.wlFields.setLayoutData((Object)this.fdlFields);
        int FieldsRows = this.input.getFieldName().length;
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"System.Column.Name", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"System.Column.Type", (String[])new String[0]), 2, ValueMeta.getTypes()), new ColumnInfo(BaseMessages.getString(PKG, (String)"System.Column.Format", (String[])new String[0]), 5, 2), new ColumnInfo(BaseMessages.getString(PKG, (String)"System.Column.Length", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"System.Column.Precision", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"System.Column.Currency", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"System.Column.Decimal", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"System.Column.Group", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"System.Column.Value", (String[])new String[0]), 1, false)};
        this.wFields = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 67586, colinf, FieldsRows, lsMod, this.props);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        this.fdFields.right = new FormAttachment(100, 0);
        this.fdFields.bottom = new FormAttachment(100, -50);
        this.wFields.setLayoutData(this.fdFields);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"System.Button.Preview", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wPreview, this.wCancel}, margin, null);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                RowGeneratorDialog.this.ok();
            }
        };
        this.lsPreview = new Listener(){

            public void handleEvent(Event e) {
                RowGeneratorDialog.this.preview();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                RowGeneratorDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wPreview.addListener(13, this.lsPreview);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                RowGeneratorDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wLimit.addSelectionListener(this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                RowGeneratorDialog.this.cancel();
            }
        });
        this.lsResize = new Listener(){

            public void handleEvent(Event event) {
                Point size = RowGeneratorDialog.this.shell.getSize();
                RowGeneratorDialog.this.wFields.setSize(size.x - 10, size.y - 50);
                ((RowGeneratorDialog)RowGeneratorDialog.this).wFields.table.setSize(size.x - 10, size.y - 50);
                RowGeneratorDialog.this.wFields.redraw();
            }
        };
        this.shell.addListener(11, this.lsResize);
        this.setSize();
        this.getData();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void getData() {
        if (this.isDebug()) {
            this.logDebug("getting fields info...");
        }
        this.wLimit.setText(this.input.getRowLimit());
        for (int i = 0; i < this.input.getFieldName().length; ++i) {
            if (this.input.getFieldName()[i] == null) continue;
            TableItem item = this.wFields.table.getItem(i);
            int col = 1;
            item.setText(col++, this.input.getFieldName()[i]);
            String type = this.input.getFieldType()[i];
            String format = this.input.getFieldFormat()[i];
            String length = this.input.getFieldLength()[i] < 0 ? "" : "" + this.input.getFieldLength()[i];
            String prec = this.input.getFieldPrecision()[i] < 0 ? "" : "" + this.input.getFieldPrecision()[i];
            String curr = this.input.getCurrency()[i];
            String group = this.input.getGroup()[i];
            String decim = this.input.getDecimal()[i];
            String def = this.input.getValue()[i];
            item.setText(col++, Const.NVL((String)type, (String)""));
            item.setText(col++, Const.NVL((String)format, (String)""));
            item.setText(col++, Const.NVL((String)length, (String)""));
            item.setText(col++, Const.NVL((String)prec, (String)""));
            item.setText(col++, Const.NVL((String)curr, (String)""));
            item.setText(col++, Const.NVL((String)decim, (String)""));
            item.setText(col++, Const.NVL((String)group, (String)""));
            item.setText(col++, Const.NVL((String)def, (String)""));
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wStepname.selectAll();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        try {
            this.getInfo(new RowGeneratorMeta());
            this.getInfo(this.input);
            this.dispose();
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RowGeneratorDialog.Illegal.Dialog.Settings.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RowGeneratorDialog.Illegal.Dialog.Settings.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    private void getInfo(RowGeneratorMeta meta) throws KettleException {
        meta.setRowLimit(this.wLimit.getText());
        int nrfields = this.wFields.nrNonEmpty();
        meta.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            meta.getFieldName()[i] = item.getText(1);
            meta.getFieldType()[i] = item.getText(2);
            meta.getFieldFormat()[i] = item.getText(3);
            String slength = item.getText(4);
            String sprec = item.getText(5);
            meta.getCurrency()[i] = item.getText(6);
            meta.getDecimal()[i] = item.getText(7);
            meta.getGroup()[i] = item.getText(8);
            meta.getValue()[i] = item.getText(9);
            meta.getFieldLength()[i] = Const.toInt((String)slength, (int)-1);
            meta.getFieldPrecision()[i] = Const.toInt((String)sprec, (int)-1);
        }
    }

    private void preview() {
        RowGeneratorMeta oneMeta = new RowGeneratorMeta();
        try {
            this.getInfo(oneMeta);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RowGeneratorDialog.Illegal.Dialog.Settings.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RowGeneratorDialog.Illegal.Dialog.Settings.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        TransMeta previewMeta = TransPreviewFactory.generatePreviewTransformation((VariableSpace)this.transMeta, (StepMetaInterface)oneMeta, (String)this.wStepname.getText());
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"System.Dialog.EnterPreviewSize.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.EnterPreviewSize.Message", (String[])new String[0]));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            TransPreviewProgressDialog progressDialog = new TransPreviewProgressDialog(this.shell, previewMeta, new String[]{this.wStepname.getText()}, new int[]{previewSize});
            progressDialog.open();
            Trans trans = progressDialog.getTrans();
            String loggingText = progressDialog.getLoggingText();
            if (!progressDialog.isCancelled() && trans.getResult() != null && trans.getResult().getNrErrors() > 0L) {
                EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                etd.setReadOnly();
                etd.open();
            }
            PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, (VariableSpace)this.transMeta, 0, this.wStepname.getText(), progressDialog.getPreviewRowsMeta(this.wStepname.getText()), progressDialog.getPreviewRows(this.wStepname.getText()), loggingText);
            prd.open();
        }
    }
}

