/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.singlethreader;

import java.io.IOException;
import org.apache.commons.vfs.FileObject;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.ObjectLocationSpecificationMethod;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.gui.SpoonFactory;
import org.pentaho.di.core.gui.SpoonInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryElementMetaInterface;
import org.pentaho.di.repository.RepositoryObject;
import org.pentaho.di.repository.RepositoryObjectType;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.singlethreader.SingleThreaderMeta;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.LabelTextVar;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.repository.dialog.SelectObjectDialog;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public class SingleThreaderDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = SingleThreaderMeta.class;
    private SingleThreaderMeta singleThreaderMeta;
    private Group gTransGroup;
    private Button radioFilename;
    private Button wbbFilename;
    private TextVar wFilename;
    private Button radioByName;
    private TextVar wTransname;
    private TextVar wDirectory;
    private Button wbTrans;
    private Button radioByReference;
    private Button wbByReference;
    private TextVar wByReference;
    private Button wEditTrans;
    private LabelTextVar wBatchSize;
    private LabelTextVar wInjectStep;
    private Button wGetInjectStep;
    private LabelTextVar wRetrieveStep;
    private Button wGetRetrieveStep;
    private TableView wParameters;
    private TransMeta mappingTransMeta = null;
    protected boolean transModified;
    private ModifyListener lsMod;
    private int middle;
    private int margin;
    private ObjectId referenceObjectId;
    private ObjectLocationSpecificationMethod specificationMethod;
    private Group gParametersGroup;
    private Button wPassParams;
    private Button wbGetParams;
    private LabelTextVar wBatchTime;

    public SingleThreaderDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.singleThreaderMeta = (SingleThreaderMeta)in;
        this.transModified = false;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.singleThreaderMeta);
        this.lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SingleThreaderDialog.this.singleThreaderMeta.setChanged();
            }
        };
        this.changed = this.singleThreaderMeta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.Shell.Title", (String[])new String[0]));
        this.middle = this.props.getMiddlePct();
        this.margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(this.middle, -this.margin);
        this.fdlStepname.top = new FormAttachment(0, this.margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(this.lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(this.middle, 0);
        this.fdStepname.top = new FormAttachment(0, this.margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.gTransGroup = new Group((Composite)this.shell, 16);
        this.gTransGroup.setText(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.TransGroup.Label", (String[])new String[0]));
        this.gTransGroup.setBackground(this.shell.getBackground());
        FormLayout transGroupLayout = new FormLayout();
        transGroupLayout.marginLeft = this.margin * 2;
        transGroupLayout.marginTop = this.margin * 2;
        transGroupLayout.marginRight = this.margin * 2;
        transGroupLayout.marginBottom = this.margin * 2;
        this.gTransGroup.setLayout((Layout)transGroupLayout);
        this.radioFilename = new Button((Composite)this.gTransGroup, 16);
        this.props.setLook((Control)this.radioFilename);
        this.radioFilename.setSelection(false);
        this.radioFilename.setText(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.RadioFile.Label", (String[])new String[0]));
        this.radioFilename.setToolTipText(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.RadioFile.Tooltip", (String[])new String[]{Const.CR}));
        FormData fdFileRadio = new FormData();
        fdFileRadio.left = new FormAttachment(0, 0);
        fdFileRadio.right = new FormAttachment(100, 0);
        fdFileRadio.top = new FormAttachment(0, 0);
        this.radioFilename.setLayoutData((Object)fdFileRadio);
        this.radioFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SingleThreaderDialog.this.specificationMethod = ObjectLocationSpecificationMethod.FILENAME;
                SingleThreaderDialog.this.setRadioButtons();
            }
        });
        this.wbbFilename = new Button((Composite)this.gTransGroup, 0x1000008);
        this.props.setLook((Control)this.wbbFilename);
        this.wbbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.wbbFilename.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForFileOrDirAndAdd", (String[])new String[0]));
        FormData fdbFilename = new FormData();
        fdbFilename.right = new FormAttachment(100, 0);
        fdbFilename.top = new FormAttachment((Control)this.radioFilename, this.margin);
        this.wbbFilename.setLayoutData((Object)fdbFilename);
        this.wbbFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SingleThreaderDialog.this.selectFileTrans();
            }
        });
        this.wFilename = new TextVar((VariableSpace)this.transMeta, (Composite)this.gTransGroup, 18436);
        this.props.setLook((Control)this.wFilename);
        this.wFilename.addModifyListener(this.lsMod);
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment(0, 25);
        fdFilename.right = new FormAttachment((Control)this.wbbFilename, -this.margin);
        fdFilename.top = new FormAttachment((Control)this.wbbFilename, 0, 0x1000000);
        this.wFilename.setLayoutData(fdFilename);
        this.wFilename.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SingleThreaderDialog.this.specificationMethod = ObjectLocationSpecificationMethod.FILENAME;
                SingleThreaderDialog.this.setRadioButtons();
            }
        });
        this.radioByName = new Button((Composite)this.gTransGroup, 16);
        this.props.setLook((Control)this.radioByName);
        this.radioByName.setSelection(false);
        this.radioByName.setText(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.RadioRep.Label", (String[])new String[0]));
        this.radioByName.setToolTipText(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.RadioRep.Tooltip", (String[])new String[]{Const.CR}));
        FormData fdRepRadio = new FormData();
        fdRepRadio.left = new FormAttachment(0, 0);
        fdRepRadio.right = new FormAttachment(100, 0);
        fdRepRadio.top = new FormAttachment((Control)this.wbbFilename, 2 * this.margin);
        this.radioByName.setLayoutData((Object)fdRepRadio);
        this.radioByName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SingleThreaderDialog.this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME;
                SingleThreaderDialog.this.setRadioButtons();
            }
        });
        this.wbTrans = new Button((Composite)this.gTransGroup, 0x1000008);
        this.props.setLook((Control)this.wbTrans);
        this.wbTrans.setText(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.Select.Button", (String[])new String[0]));
        this.wbTrans.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForFileOrDirAndAdd", (String[])new String[0]));
        FormData fdbTrans = new FormData();
        fdbTrans.right = new FormAttachment(100, 0);
        fdbTrans.top = new FormAttachment((Control)this.radioByName, 2 * this.margin);
        this.wbTrans.setLayoutData((Object)fdbTrans);
        this.wbTrans.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SingleThreaderDialog.this.selectRepositoryTrans();
            }
        });
        this.wDirectory = new TextVar((VariableSpace)this.transMeta, (Composite)this.gTransGroup, 18436);
        this.props.setLook((Control)this.wDirectory);
        this.wDirectory.addModifyListener(this.lsMod);
        FormData fdTransDir = new FormData();
        fdTransDir.left = new FormAttachment(this.middle + (100 - this.middle) / 2, 0);
        fdTransDir.right = new FormAttachment((Control)this.wbTrans, -this.margin);
        fdTransDir.top = new FormAttachment((Control)this.wbTrans, 0, 0x1000000);
        this.wDirectory.setLayoutData(fdTransDir);
        this.wDirectory.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SingleThreaderDialog.this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME;
                SingleThreaderDialog.this.setRadioButtons();
            }
        });
        this.wTransname = new TextVar((VariableSpace)this.transMeta, (Composite)this.gTransGroup, 18436);
        this.props.setLook((Control)this.wTransname);
        this.wTransname.addModifyListener(this.lsMod);
        FormData fdTransName = new FormData();
        fdTransName.left = new FormAttachment(0, 25);
        fdTransName.right = new FormAttachment((Control)this.wDirectory, -this.margin);
        fdTransName.top = new FormAttachment((Control)this.wbTrans, 0, 0x1000000);
        this.wTransname.setLayoutData(fdTransName);
        this.wTransname.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SingleThreaderDialog.this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME;
                SingleThreaderDialog.this.setRadioButtons();
            }
        });
        this.radioByReference = new Button((Composite)this.gTransGroup, 16);
        this.props.setLook((Control)this.radioByReference);
        this.radioByReference.setSelection(false);
        this.radioByReference.setText(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.RadioRepByReference.Label", (String[])new String[0]));
        this.radioByReference.setToolTipText(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.RadioRepByReference.Tooltip", (String[])new String[]{Const.CR}));
        FormData fdRadioByReference = new FormData();
        fdRadioByReference.left = new FormAttachment(0, 0);
        fdRadioByReference.right = new FormAttachment(100, 0);
        fdRadioByReference.top = new FormAttachment((Control)this.wTransname, 2 * this.margin);
        this.radioByReference.setLayoutData((Object)fdRadioByReference);
        this.radioByReference.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SingleThreaderDialog.this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE;
                SingleThreaderDialog.this.setRadioButtons();
            }
        });
        this.wbByReference = new Button((Composite)this.gTransGroup, 0x1000008);
        this.props.setLook((Control)this.wbByReference);
        this.wbByReference.setImage(GUIResource.getInstance().getImageTransGraph());
        this.wbByReference.setToolTipText(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.SelectTrans.Tooltip", (String[])new String[0]));
        FormData fdbByReference = new FormData();
        fdbByReference.top = new FormAttachment((Control)this.radioByReference, this.margin);
        fdbByReference.right = new FormAttachment(100, 0);
        this.wbByReference.setLayoutData((Object)fdbByReference);
        this.wbByReference.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SingleThreaderDialog.this.selectTransformationByReference();
            }
        });
        this.wByReference = new TextVar((VariableSpace)this.transMeta, (Composite)this.gTransGroup, 18444);
        this.props.setLook((Control)this.wByReference);
        this.wByReference.addModifyListener(this.lsMod);
        FormData fdByReference = new FormData();
        fdByReference.top = new FormAttachment((Control)this.radioByReference, this.margin);
        fdByReference.left = new FormAttachment(0, 25);
        fdByReference.right = new FormAttachment((Control)this.wbByReference, -this.margin);
        this.wByReference.setLayoutData(fdByReference);
        this.wByReference.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SingleThreaderDialog.this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE;
                SingleThreaderDialog.this.setRadioButtons();
            }
        });
        this.wEditTrans = new Button((Composite)this.gTransGroup, 0x1000008);
        this.props.setLook((Control)this.wEditTrans);
        this.wEditTrans.setText(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.Edit.Button", (String[])new String[0]));
        this.wEditTrans.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForFileOrDirAndAdd", (String[])new String[0]));
        FormData fdEditTrans = new FormData();
        fdEditTrans.left = new FormAttachment(0, 0);
        fdEditTrans.right = new FormAttachment(100, 0);
        fdEditTrans.top = new FormAttachment((Control)this.wByReference, 3 * this.margin);
        this.wEditTrans.setLayoutData((Object)fdEditTrans);
        this.wEditTrans.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SingleThreaderDialog.this.editTrans();
            }
        });
        FormData fdTransGroup = new FormData();
        fdTransGroup.left = new FormAttachment(0, 0);
        fdTransGroup.top = new FormAttachment((Control)this.wStepname, 2 * this.margin);
        fdTransGroup.right = new FormAttachment(100, 0);
        this.gTransGroup.setLayoutData((Object)fdTransGroup);
        this.wGetInjectStep = new Button((Composite)this.shell, 8);
        this.wGetInjectStep.setText(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.Button.Get", (String[])new String[0]));
        FormData fdGetInjectStep = new FormData();
        fdGetInjectStep.top = new FormAttachment((Control)this.gTransGroup, this.margin);
        fdGetInjectStep.right = new FormAttachment(100, 0);
        this.wGetInjectStep.setLayoutData((Object)fdGetInjectStep);
        this.wGetInjectStep.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    SingleThreaderDialog.this.loadTransformation();
                    String stepname = SingleThreaderDialog.this.mappingTransMeta == null ? "" : Const.NVL((String)SingleThreaderDialog.getInjectorStep(SingleThreaderDialog.this.mappingTransMeta), (String)"");
                    SingleThreaderDialog.this.wInjectStep.setText(stepname);
                }
                catch (Exception e) {
                    new ErrorDialog(SingleThreaderDialog.this.shell, BaseMessages.getString((Class)PKG, (String)"SingleThreaderDialog.ErrorLoadingTransformation.DialogTitle", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"SingleThreaderDialog.ErrorLoadingTransformation.DialogMessage", (String[])new String[0]), e);
                }
            }
        });
        this.wInjectStep = new LabelTextVar((VariableSpace)this.transMeta, (Composite)this.shell, BaseMessages.getString(PKG, (String)"SingleThreaderDialog.InjectStep.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SingleThreaderDialog.InjectStep.Tooltip", (String[])new String[0]));
        FormData fdInjectStep = new FormData();
        fdInjectStep.left = new FormAttachment(0, 0);
        fdInjectStep.top = new FormAttachment((Control)this.gTransGroup, 2 * this.margin);
        fdInjectStep.right = new FormAttachment((Control)this.wGetInjectStep, -this.margin);
        this.wInjectStep.setLayoutData(fdInjectStep);
        this.wGetRetrieveStep = new Button((Composite)this.shell, 8);
        this.wGetRetrieveStep.setText(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.Button.Get", (String[])new String[0]));
        FormData fdGetRetrieveStep = new FormData();
        fdGetRetrieveStep.top = new FormAttachment((Control)this.wInjectStep, 2 * this.margin);
        fdGetRetrieveStep.right = new FormAttachment(100, 0);
        this.wGetRetrieveStep.setLayoutData((Object)fdGetRetrieveStep);
        this.wGetRetrieveStep.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    SingleThreaderDialog.this.loadTransformation();
                    if (SingleThreaderDialog.this.mappingTransMeta != null) {
                        String[] stepNames = SingleThreaderDialog.this.mappingTransMeta.getStepNames();
                        EnterSelectionDialog d = new EnterSelectionDialog(SingleThreaderDialog.this.shell, stepNames, BaseMessages.getString((Class)PKG, (String)"SingleThreaderDialog.SelectStep.Title", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"SingleThreaderDialog.SelectStep.Message", (String[])new String[0]));
                        String step = d.open();
                        if (step != null) {
                            SingleThreaderDialog.this.wRetrieveStep.setText(step);
                        }
                    }
                }
                catch (Exception e) {
                    new ErrorDialog(SingleThreaderDialog.this.shell, BaseMessages.getString((Class)PKG, (String)"SingleThreaderDialog.ErrorLoadingTransformation.DialogTitle", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"SingleThreaderDialog.ErrorLoadingTransformation.DialogMessage", (String[])new String[0]), e);
                }
            }
        });
        this.wRetrieveStep = new LabelTextVar((VariableSpace)this.transMeta, (Composite)this.shell, BaseMessages.getString(PKG, (String)"SingleThreaderDialog.RetrieveStep.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SingleThreaderDialog.RetrieveStep.Tooltip", (String[])new String[0]));
        FormData fdRetrieveStep = new FormData();
        fdRetrieveStep.left = new FormAttachment(0, 0);
        fdRetrieveStep.top = new FormAttachment((Control)this.wInjectStep, this.margin);
        fdRetrieveStep.right = new FormAttachment((Control)this.wGetRetrieveStep, -this.margin);
        this.wRetrieveStep.setLayoutData(fdRetrieveStep);
        this.wBatchSize = new LabelTextVar((VariableSpace)this.transMeta, (Composite)this.shell, BaseMessages.getString(PKG, (String)"SingleThreaderDialog.BatchSize.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SingleThreaderDialog.BatchSize.Tooltip", (String[])new String[0]));
        FormData fdBatchSize = new FormData();
        fdBatchSize.left = new FormAttachment(0, 0);
        fdBatchSize.top = new FormAttachment((Control)this.wRetrieveStep, this.margin);
        fdBatchSize.right = new FormAttachment((Control)this.wGetRetrieveStep, -this.margin);
        this.wBatchSize.setLayoutData(fdBatchSize);
        this.wBatchTime = new LabelTextVar((VariableSpace)this.transMeta, (Composite)this.shell, BaseMessages.getString(PKG, (String)"SingleThreaderDialog.BatchTime.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SingleThreaderDialog.BatchTime.Tooltip", (String[])new String[0]));
        FormData fdBatchTime = new FormData();
        fdBatchTime.left = new FormAttachment(0, 0);
        fdBatchTime.top = new FormAttachment((Control)this.wBatchSize, this.margin);
        fdBatchTime.right = new FormAttachment((Control)this.wGetRetrieveStep, -this.margin);
        this.wBatchTime.setLayoutData(fdBatchTime);
        this.gParametersGroup = new Group((Composite)this.shell, 16);
        this.gParametersGroup.setText(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.ParamGroup.Label", (String[])new String[0]));
        this.gParametersGroup.setBackground(this.shell.getBackground());
        FormLayout paramGroupLayout = new FormLayout();
        paramGroupLayout.marginLeft = this.margin * 2;
        paramGroupLayout.marginTop = this.margin * 2;
        paramGroupLayout.marginRight = this.margin * 2;
        paramGroupLayout.marginBottom = this.margin * 2;
        this.gParametersGroup.setLayout((Layout)paramGroupLayout);
        Label wlPassParams = new Label((Composite)this.gParametersGroup, 131072);
        wlPassParams.setText(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.PassAllParameters.Label", (String[])new String[0]));
        this.props.setLook((Control)wlPassParams);
        FormData fdlPassParams = new FormData();
        fdlPassParams.left = new FormAttachment(0, 0);
        fdlPassParams.top = new FormAttachment(0, 0);
        fdlPassParams.right = new FormAttachment(this.middle, -this.margin);
        wlPassParams.setLayoutData((Object)fdlPassParams);
        this.wPassParams = new Button((Composite)this.gParametersGroup, 32);
        this.props.setLook((Control)this.wPassParams);
        FormData fdPassParams = new FormData();
        fdPassParams.left = new FormAttachment(this.middle, 0);
        fdPassParams.top = new FormAttachment(0, 0);
        fdPassParams.right = new FormAttachment(100, 0);
        this.wPassParams.setLayoutData((Object)fdPassParams);
        this.wbGetParams = new Button((Composite)this.gParametersGroup, 8);
        this.wbGetParams.setText(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.GetParameters.Button.Label", (String[])new String[0]));
        FormData fdGetParams = new FormData();
        fdGetParams.top = new FormAttachment((Control)this.wPassParams, this.margin);
        fdGetParams.right = new FormAttachment(100, 0);
        this.wbGetParams.setLayoutData((Object)fdGetParams);
        this.wbGetParams.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                SingleThreaderDialog.this.getParameters();
            }
        });
        int parameterRows = this.singleThreaderMeta.getParameters() != null ? this.singleThreaderMeta.getParameters().length : 0;
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.Parameters.Parameter.Label", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.Parameters.Value.Label", (String[])new String[0]), 1, false)};
        colinf[1].setUsingVariables(true);
        this.wParameters = new TableView((VariableSpace)this.transMeta, (Composite)this.gParametersGroup, 67586, colinf, parameterRows, this.lsMod, this.props);
        FormData fdParameters = new FormData();
        fdParameters.left = new FormAttachment(0, 0);
        fdParameters.top = new FormAttachment((Control)this.wPassParams, this.margin);
        fdParameters.right = new FormAttachment((Control)this.wbGetParams, -this.margin);
        fdParameters.bottom = new FormAttachment(100, 0);
        this.wParameters.setLayoutData(fdParameters);
        FormData fdParametersComp = new FormData();
        fdParametersComp.left = new FormAttachment(0, 0);
        fdParametersComp.top = new FormAttachment((Control)this.wBatchTime, 0);
        fdParametersComp.right = new FormAttachment(100, 0);
        fdParametersComp.bottom = new FormAttachment(100, -50);
        this.gParametersGroup.setLayoutData((Object)fdParametersComp);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, this.margin, (Control)this.gParametersGroup);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                SingleThreaderDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                SingleThreaderDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SingleThreaderDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wFilename.addSelectionListener(this.lsDef);
        this.wTransname.addSelectionListener(this.lsDef);
        this.wBatchSize.addSelectionListener(this.lsDef);
        this.wBatchTime.addSelectionListener(this.lsDef);
        this.wInjectStep.addSelectionListener(this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                SingleThreaderDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.singleThreaderMeta.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected void selectTransformationByReference() {
        if (this.repository != null) {
            SelectObjectDialog sod = new SelectObjectDialog(this.shell, this.repository, true, false);
            sod.open();
            RepositoryElementMetaInterface repositoryObject = sod.getRepositoryObject();
            if (repositoryObject != null) {
                this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE;
                this.getByReferenceData(repositoryObject);
                this.referenceObjectId = repositoryObject.getObjectId();
                this.setRadioButtons();
            }
        }
    }

    private void selectRepositoryTrans() {
        try {
            SelectObjectDialog sod = new SelectObjectDialog(this.shell, this.repository);
            String transName = sod.open();
            RepositoryDirectoryInterface repdir = sod.getDirectory();
            if (transName != null && repdir != null) {
                this.loadRepositoryTrans(transName, repdir);
                this.wTransname.setText(this.mappingTransMeta.getName());
                this.wDirectory.setText(this.mappingTransMeta.getRepositoryDirectory().getPath());
                this.wFilename.setText("");
                this.radioByName.setSelection(true);
                this.radioFilename.setSelection(false);
                this.specificationMethod = ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME;
                this.setRadioButtons();
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SingleThreaderDialog.ErrorSelectingObject.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SingleThreaderDialog.ErrorSelectingObject.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void loadRepositoryTrans(String transName, RepositoryDirectoryInterface repdir) throws KettleException {
        this.mappingTransMeta = this.repository.loadTransformation(this.transMeta.environmentSubstitute(transName), repdir, null, true, null);
        this.mappingTransMeta.clearChanged();
    }

    private void selectFileTrans() {
        String curFile = this.wFilename.getText();
        FileObject root = null;
        try {
            root = KettleVFS.getFileObject((String)(curFile != null ? curFile : Const.getUserHomeDirectory()));
            VfsFileChooserDialog vfsFileChooser = Spoon.getInstance().getVfsFileChooserDialog(root.getParent(), root);
            FileObject file = vfsFileChooser.open(this.shell, null, Const.STRING_TRANS_FILTER_EXT, Const.getTransformationFilterNames(), 0);
            if (file == null) {
                return;
            }
            String fname = null;
            fname = file.getURL().getFile();
            if (fname != null) {
                this.loadFileTrans(fname);
                this.wFilename.setText(this.mappingTransMeta.getFilename());
                this.wTransname.setText(Const.NVL((String)this.mappingTransMeta.getName(), (String)""));
                this.wDirectory.setText("");
                this.specificationMethod = ObjectLocationSpecificationMethod.FILENAME;
                this.setRadioButtons();
            }
        }
        catch (IOException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SingleThreaderDialog.ErrorLoadingTransformation.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SingleThreaderDialog.ErrorLoadingTransformation.DialogMessage", (String[])new String[0]), e);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SingleThreaderDialog.ErrorLoadingTransformation.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SingleThreaderDialog.ErrorLoadingTransformation.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    private void loadFileTrans(String fname) throws KettleException {
        this.mappingTransMeta = new TransMeta(this.transMeta.environmentSubstitute(fname));
        this.mappingTransMeta.clearChanged();
    }

    private void editTrans() {
        try {
            this.loadTransformation();
            SpoonInterface spoon = SpoonFactory.getInstance();
            if (spoon != null) {
                spoon.addTransGraph(this.mappingTransMeta);
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SingleThreaderDialog.ErrorShowingTransformation.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SingleThreaderDialog.ErrorShowingTransformation.Message", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    private void loadTransformation() throws KettleException {
        switch (this.specificationMethod) {
            case FILENAME: {
                this.loadFileTrans(this.wFilename.getText());
                break;
            }
            case REPOSITORY_BY_NAME: {
                String realDirectory = this.transMeta.environmentSubstitute(this.wDirectory.getText());
                String realTransname = this.transMeta.environmentSubstitute(this.wTransname.getText());
                if (Const.isEmpty((String)realDirectory) || Const.isEmpty((String)realTransname)) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.Exception.NoValidMappingDetailsFound", (String[])new String[0]));
                }
                RepositoryDirectoryInterface repdir = this.repository.findDirectory(realDirectory);
                if (repdir == null) {
                    throw new KettleException(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.Exception.UnableToFindRepositoryDirectory)", (String[])new String[0]));
                }
                this.loadRepositoryTrans(realTransname, repdir);
                break;
            }
            case REPOSITORY_BY_REFERENCE: {
                this.mappingTransMeta = this.repository.loadTransformation(this.referenceObjectId, null);
                this.mappingTransMeta.clearChanged();
            }
        }
        this.wInjectStep.setText(SingleThreaderDialog.getInjectorStep(this.mappingTransMeta));
    }

    public void setActive() {
        this.radioByName.setEnabled(this.repository != null);
        this.radioByReference.setEnabled(this.repository != null);
        this.wFilename.setEnabled(this.radioFilename.getSelection());
        this.wbbFilename.setEnabled(this.radioFilename.getSelection());
        this.wTransname.setEnabled(this.repository != null && this.radioByName.getSelection());
        this.wDirectory.setEnabled(this.repository != null && this.radioByName.getSelection());
        this.wbTrans.setEnabled(this.repository != null && this.radioByName.getSelection());
        this.wByReference.setEnabled(this.repository != null && this.radioByReference.getSelection());
        this.wbByReference.setEnabled(this.repository != null && this.radioByReference.getSelection());
    }

    protected void setRadioButtons() {
        this.radioFilename.setSelection(this.specificationMethod == ObjectLocationSpecificationMethod.FILENAME);
        this.radioByName.setSelection(this.specificationMethod == ObjectLocationSpecificationMethod.REPOSITORY_BY_NAME);
        this.radioByReference.setSelection(this.specificationMethod == ObjectLocationSpecificationMethod.REPOSITORY_BY_REFERENCE);
        this.setActive();
    }

    private void getByReferenceData(RepositoryElementMetaInterface transInf) {
        String path = transInf.getRepositoryDirectory().getPath();
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        path = path + transInf.getName();
        this.wByReference.setText(path);
    }

    public void getData() {
        this.wStepname.selectAll();
        this.specificationMethod = this.singleThreaderMeta.getSpecificationMethod();
        switch (this.specificationMethod) {
            case FILENAME: {
                this.wFilename.setText(Const.NVL((String)this.singleThreaderMeta.getFileName(), (String)""));
                break;
            }
            case REPOSITORY_BY_NAME: {
                this.wDirectory.setText(Const.NVL((String)this.singleThreaderMeta.getDirectoryPath(), (String)""));
                this.wTransname.setText(Const.NVL((String)this.singleThreaderMeta.getTransName(), (String)""));
                break;
            }
            case REPOSITORY_BY_REFERENCE: {
                this.referenceObjectId = this.singleThreaderMeta.getTransObjectId();
                this.wByReference.setText("");
                try {
                    if (this.repository == null) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)"SingleThreaderDialog.Exception.NotConnectedToRepository.Message", (String[])new String[0]));
                    }
                    RepositoryObject transInf = this.repository.getObjectInformation(this.singleThreaderMeta.getTransObjectId(), RepositoryObjectType.TRANSFORMATION);
                    if (transInf == null) break;
                    this.getByReferenceData((RepositoryElementMetaInterface)transInf);
                    break;
                }
                catch (KettleException e) {
                    new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SingleThreaderDialog.Exception.UnableToReferenceObjectId.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SingleThreaderDialog.Exception.UnableToReferenceObjectId.Message", (String[])new String[0]), (Exception)((Object)e));
                }
            }
        }
        this.setRadioButtons();
        this.wBatchSize.setText(Const.NVL((String)this.singleThreaderMeta.getBatchSize(), (String)""));
        this.wBatchTime.setText(Const.NVL((String)this.singleThreaderMeta.getBatchTime(), (String)""));
        this.wInjectStep.setText(Const.NVL((String)this.singleThreaderMeta.getInjectStep(), (String)""));
        this.wRetrieveStep.setText(Const.NVL((String)this.singleThreaderMeta.getRetrieveStep(), (String)""));
        if (this.singleThreaderMeta.getParameters() != null) {
            for (int i = 0; i < this.singleThreaderMeta.getParameters().length; ++i) {
                TableItem ti = this.wParameters.table.getItem(i);
                if (Const.isEmpty((String)this.singleThreaderMeta.getParameters()[i])) continue;
                ti.setText(1, Const.NVL((String)this.singleThreaderMeta.getParameters()[i], (String)""));
                ti.setText(2, Const.NVL((String)this.singleThreaderMeta.getParameterValues()[i], (String)""));
            }
            this.wParameters.removeEmptyRows();
            this.wParameters.setRowNums();
            this.wParameters.optWidth(true);
        }
        this.wPassParams.setSelection(this.singleThreaderMeta.isPassingAllParameters());
        try {
            this.loadTransformation();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String getInjectorStep(TransMeta mappingTransMeta) {
        for (StepMeta stepMeta : mappingTransMeta.getSteps()) {
            if (!stepMeta.getStepID().equals("Injector") && !stepMeta.getStepID().equals("MappingInput")) continue;
            return stepMeta.getName();
        }
        return "";
    }

    private void cancel() {
        this.stepname = null;
        this.singleThreaderMeta.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(SingleThreaderMeta meta) throws KettleException {
        String param;
        int i;
        this.loadTransformation();
        meta.setSpecificationMethod(this.specificationMethod);
        switch (this.specificationMethod) {
            case FILENAME: {
                meta.setFileName(this.wFilename.getText());
                meta.setDirectoryPath(null);
                meta.setTransName(null);
                meta.setTransObjectId(null);
                break;
            }
            case REPOSITORY_BY_NAME: {
                meta.setDirectoryPath(this.wDirectory.getText());
                meta.setTransName(this.wTransname.getText());
                meta.setFileName(null);
                meta.setTransObjectId(null);
                break;
            }
            case REPOSITORY_BY_REFERENCE: {
                meta.setFileName(null);
                meta.setDirectoryPath(null);
                meta.setTransName(null);
                meta.setTransObjectId(this.referenceObjectId);
            }
        }
        meta.setBatchSize(this.wBatchSize.getText());
        meta.setBatchTime(this.wBatchTime.getText());
        meta.setInjectStep(this.wInjectStep.getText());
        meta.setRetrieveStep(this.wRetrieveStep.getText());
        int nritems = this.wParameters.nrNonEmpty();
        int nr = 0;
        for (i = 0; i < nritems; ++i) {
            param = this.wParameters.getNonEmpty(i).getText(1);
            if (Const.isEmpty((String)param)) continue;
            ++nr;
        }
        meta.setParameters(new String[nr]);
        meta.setParameterValues(new String[nr]);
        nr = 0;
        for (i = 0; i < nritems; ++i) {
            param = this.wParameters.getNonEmpty(i).getText(1);
            String value = this.wParameters.getNonEmpty(i).getText(2);
            meta.getParameters()[nr] = param;
            meta.getParameterValues()[nr] = Const.NVL((String)value, (String)"");
            ++nr;
        }
        meta.setPassingAllParameters(this.wPassParams.getSelection());
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        try {
            this.getInfo(this.singleThreaderMeta);
            this.loadTransformation();
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SingleThreaderDialog.ErrorLoadingSpecifiedTransformation.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SingleThreaderDialog.ErrorLoadingSpecifiedTransformation.Message", (String[])new String[0]), (Exception)((Object)e));
        }
        this.dispose();
    }

    protected void getParameters() {
        try {
            SingleThreaderMeta jet = new SingleThreaderMeta();
            this.getInfo(jet);
            TransMeta mappingTransMeta = SingleThreaderMeta.loadSingleThreadedTransMeta((SingleThreaderMeta)jet, (Repository)this.repository, (VariableSpace)this.transMeta);
            String[] parameters = mappingTransMeta.listParameters();
            String[] existing = this.wParameters.getItems(1);
            for (int i = 0; i < parameters.length; ++i) {
                if (Const.indexOfString((String)parameters[i], (String[])existing) >= 0) continue;
                TableItem item = new TableItem(this.wParameters.table, 0);
                item.setText(1, parameters[i]);
            }
            this.wParameters.removeEmptyRows();
            this.wParameters.setRowNums();
            this.wParameters.optWidth(true);
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SingleThreaderDialog.Exception.UnableToLoadTransformation.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SingleThreaderDialog.Exception.UnableToLoadTransformation.Message", (String[])new String[0]), e);
        }
    }
}

