/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.stringoperations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.stringoperations.StringOperationsMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.gui.GUIResource;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.step.TableItemInsertListener;

public class StringOperationsDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = StringOperationsMeta.class;
    private Label wlKey;
    private TableView wFields;
    private FormData fdlKey;
    private FormData fdKey;
    private StringOperationsMeta input;
    private Map<String, Integer> inputFields;
    private ColumnInfo[] ciKey;

    public StringOperationsDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.input = (StringOperationsMeta)in;
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StringOperationsDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"StringOperationsDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"StringOperationsDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wlKey = new Label((Composite)this.shell, 0);
        this.wlKey.setText(BaseMessages.getString(PKG, (String)"StringOperationsDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlKey);
        this.fdlKey = new FormData();
        this.fdlKey.left = new FormAttachment(0, 0);
        this.fdlKey.top = new FormAttachment((Control)this.wStepname, 2 * margin);
        this.wlKey.setLayoutData((Object)this.fdlKey);
        int nrFieldCols = 11;
        int nrFieldRows = this.input.getFieldInStream() != null ? this.input.getFieldInStream().length : 1;
        this.ciKey = new ColumnInfo[nrFieldCols];
        this.ciKey[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StringOperationsDialog.ColumnInfo.InStreamField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciKey[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StringOperationsDialog.ColumnInfo.OutStreamField", (String[])new String[0]), 1, false);
        this.ciKey[2] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StringOperationsDialog.ColumnInfo.Trim", (String[])new String[0]), 2, StringOperationsMeta.trimTypeDesc, true);
        this.ciKey[3] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StringOperationsDialog.ColumnInfo.LowerUpper", (String[])new String[0]), 2, StringOperationsMeta.lowerUpperDesc, true);
        this.ciKey[4] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StringOperationsDialog.ColumnInfo.Padding", (String[])new String[0]), 2, StringOperationsMeta.paddingDesc, true);
        this.ciKey[5] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StringOperationsDialog.ColumnInfo.CharPad", (String[])new String[0]), 1, false);
        this.ciKey[6] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StringOperationsDialog.ColumnInfo.LenPad", (String[])new String[0]), 1, false);
        this.ciKey[7] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StringOperationsDialog.ColumnInfo.InitCap", (String[])new String[0]), 2, StringOperationsMeta.initCapDesc);
        this.ciKey[8] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StringOperationsDialog.ColumnInfo.MaskXML", (String[])new String[0]), 2, StringOperationsMeta.maskXMLDesc);
        this.ciKey[9] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StringOperationsDialog.ColumnInfo.Digits", (String[])new String[0]), 2, StringOperationsMeta.digitsDesc);
        this.ciKey[10] = new ColumnInfo(BaseMessages.getString(PKG, (String)"StringOperationsDialog.ColumnInfo.RemoveSpecialCharacters", (String[])new String[0]), 2, StringOperationsMeta.removeSpecialCharactersDesc);
        this.ciKey[1].setToolTip(BaseMessages.getString(PKG, (String)"StringOperationsDialog.ColumnInfo.OutStreamField.Tooltip", (String[])new String[0]));
        this.ciKey[1].setUsingVariables(true);
        this.ciKey[4].setUsingVariables(true);
        this.ciKey[5].setUsingVariables(true);
        this.ciKey[6].setUsingVariables(true);
        this.ciKey[7].setUsingVariables(true);
        this.wFields = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 68354, this.ciKey, nrFieldRows, lsMod, this.props);
        this.fdKey = new FormData();
        this.fdKey.left = new FormAttachment(0, 0);
        this.fdKey.top = new FormAttachment((Control)this.wlKey, margin);
        this.fdKey.right = new FormAttachment(100, -margin);
        this.fdKey.bottom = new FormAttachment(100, -30);
        this.wFields.setLayoutData(this.fdKey);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"StringOperationsDialog.GetFields.Button", (String[])new String[0]));
        this.fdGet = new FormData();
        this.fdGet.right = new FormAttachment(100, 0);
        this.fdGet.top = new FormAttachment((Control)this.wStepname, 3 * middle);
        this.wGet.setLayoutData((Object)this.fdGet);
        this.setButtonPositions(new Button[]{this.wOK, this.wGet, this.wCancel}, margin, null);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                StringOperationsDialog.this.ok();
            }
        };
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                StringOperationsDialog.this.get();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                StringOperationsDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wGet.addListener(13, this.lsGet);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                StringOperationsDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                StringOperationsDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        Runnable runnable = new Runnable(){

            public void run() {
                StepMeta stepMeta = StringOperationsDialog.this.transMeta.findStep(StringOperationsDialog.this.stepname);
                if (stepMeta != null) {
                    try {
                        RowMetaInterface row = StringOperationsDialog.this.transMeta.getPrevStepFields(stepMeta);
                        if (row != null) {
                            for (int i = 0; i < row.size(); ++i) {
                                StringOperationsDialog.this.inputFields.put(row.getValueMeta(i).getName(), new Integer(i));
                            }
                            StringOperationsDialog.this.setComboBoxes();
                        }
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                if (!StringOperationsDialog.this.wFields.isDisposed()) {
                                    for (int i = 0; i < ((StringOperationsDialog)StringOperationsDialog.this).wFields.table.getItemCount(); ++i) {
                                        TableItem it = ((StringOperationsDialog)StringOperationsDialog.this).wFields.table.getItem(i);
                                        if (Const.isEmpty((String)it.getText(1)) || StringOperationsDialog.this.inputFields.containsKey(it.getText(1))) continue;
                                        it.setBackground(GUIResource.getInstance().getColorRed());
                                    }
                                }
                            }
                        });
                    }
                    catch (KettleException e) {
                        StringOperationsDialog.this.logError("Error getting fields from incoming stream!", e);
                    }
                }
            }
        };
        new Thread(runnable).start();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected void setComboBoxes() {
        Set<String> keySet = this.inputFields.keySet();
        ArrayList<String> entries = new ArrayList<String>(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.ciKey[0].setComboValues(fieldNames);
    }

    public void getData() {
        if (this.input.getFieldInStream() != null) {
            for (int i = 0; i < this.input.getFieldInStream().length; ++i) {
                TableItem item = this.wFields.table.getItem(i);
                if (this.input.getFieldInStream()[i] != null) {
                    item.setText(1, this.input.getFieldInStream()[i]);
                }
                if (this.input.getFieldOutStream()[i] != null) {
                    item.setText(2, this.input.getFieldOutStream()[i]);
                }
                item.setText(3, StringOperationsMeta.getTrimTypeDesc((int)this.input.getTrimType()[i]));
                item.setText(4, StringOperationsMeta.getLowerUpperDesc((int)this.input.getLowerUpper()[i]));
                item.setText(5, StringOperationsMeta.getPaddingDesc((int)this.input.getPaddingType()[i]));
                if (this.input.getPadChar()[i] != null) {
                    item.setText(6, this.input.getPadChar()[i]);
                }
                if (this.input.getPadLen()[i] != null) {
                    item.setText(7, this.input.getPadLen()[i]);
                }
                item.setText(8, StringOperationsMeta.getInitCapDesc((int)this.input.getInitCap()[i]));
                item.setText(9, StringOperationsMeta.getMaskXMLDesc((int)this.input.getMaskXML()[i]));
                item.setText(10, StringOperationsMeta.getDigitsDesc((int)this.input.getDigits()[i]));
                item.setText(11, StringOperationsMeta.getRemoveSpecialCharactersDesc((int)this.input.getRemoveSpecialCharacters()[i]));
            }
        }
        this.wStepname.selectAll();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void getInfo(StringOperationsMeta inf) {
        int nrkeys = this.wFields.nrNonEmpty();
        inf.allocate(nrkeys);
        if (this.isDebug()) {
            this.logDebug(BaseMessages.getString(PKG, (String)"StringOperationsDialog.Log.FoundFields", (String[])new String[]{String.valueOf(nrkeys)}));
        }
        for (int i = 0; i < nrkeys; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            inf.getFieldInStream()[i] = item.getText(1);
            inf.getFieldOutStream()[i] = item.getText(2);
            inf.getTrimType()[i] = StringOperationsMeta.getTrimTypeByDesc((String)item.getText(3));
            inf.getLowerUpper()[i] = StringOperationsMeta.getLowerUpperByDesc((String)item.getText(4));
            inf.getPaddingType()[i] = StringOperationsMeta.getPaddingByDesc((String)item.getText(5));
            inf.getPadChar()[i] = item.getText(6);
            inf.getPadLen()[i] = item.getText(7);
            inf.getInitCap()[i] = StringOperationsMeta.getInitCapByDesc((String)item.getText(8));
            inf.getMaskXML()[i] = StringOperationsMeta.getMaskXMLByDesc((String)item.getText(9));
            inf.getDigits()[i] = StringOperationsMeta.getDigitsByDesc((String)item.getText(10));
            inf.getRemoveSpecialCharacters()[i] = StringOperationsMeta.getRemoveSpecialCharactersByDesc((String)item.getText(11));
        }
        this.stepname = this.wStepname.getText();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.getInfo(this.input);
        this.dispose();
    }

    private void get() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null) {
                TableItemInsertListener listener = new TableItemInsertListener(){

                    public boolean tableItemInserted(TableItem tableItem, ValueMetaInterface v) {
                        if (v.getType() == 2) {
                            tableItem.setText(3, BaseMessages.getString((Class)PKG, (String)"StringOperationsMeta.TrimType.None", (String[])new String[0]));
                            tableItem.setText(4, BaseMessages.getString((Class)PKG, (String)"StringOperationsMeta.LowerUpper.None", (String[])new String[0]));
                            tableItem.setText(5, BaseMessages.getString((Class)PKG, (String)"StringOperationsMeta.Padding.None", (String[])new String[0]));
                            tableItem.setText(8, BaseMessages.getString((Class)PKG, (String)"System.Combo.No", (String[])new String[0]));
                            tableItem.setText(9, BaseMessages.getString((Class)PKG, (String)"StringOperationsMeta.MaskXML.None", (String[])new String[0]));
                            tableItem.setText(10, BaseMessages.getString((Class)PKG, (String)"StringOperationsMeta.Digits.None", (String[])new String[0]));
                            tableItem.setText(11, BaseMessages.getString((Class)PKG, (String)"StringOperationsMeta.RemoveSpecialCharacters.None", (String[])new String[0]));
                            return true;
                        }
                        return false;
                    }
                };
                BaseStepDialog.getFieldsFromPrevious(r, this.wFields, 1, new int[]{1}, new int[0], -1, -1, listener);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"StringOperationsDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"StringOperationsDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

