/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.syslog;

import java.net.InetAddress;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entries.syslog.SyslogDefs;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.syslog.SyslogMessageMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.LabelTextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.snmp4j.UserTarget;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.UdpAddress;

public class SyslogMessageDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = SyslogMessageMeta.class;
    private Label wlMessageField;
    private CCombo wMessageField;
    private FormData fdlMessageField;
    private FormData fdMessageField;
    private Group wSettingsGroup;
    private FormData fdSettingsGroup;
    private SyslogMessageMeta input;
    private Group wLogSettings;
    private FormData fdLogSettings;
    private FormData fdPort;
    private LabelTextVar wPort;
    private FormData fdFacility;
    private CCombo wFacility;
    private Label wlPriority;
    private FormData fdlPriority;
    private FormData fdPriority;
    private CCombo wPriority;
    private Button wTest;
    private FormData fdTest;
    private Listener lsTest;
    private LabelTextVar wServerName;
    private FormData fdServerName;
    private Label wlFacility;
    private FormData fdlFacility;
    private Label wlAddTimestamp;
    private FormData fdlAddTimestamp;
    private Button wAddTimestamp;
    private FormData fdAddTimestamp;
    private Label wlAddHostName;
    private FormData fdlAddHostName;
    private Button wAddHostName;
    private FormData fdAddHostName;
    private Label wlDatePattern;
    private FormData fdlDatePattern;
    private FormData fdDatePattern;
    private ComboVar wDatePattern;
    private boolean gotPreviousFields = false;

    public SyslogMessageDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (SyslogMessageMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SyslogMessageDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"SyslogMessageDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"SyslogMessageDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wSettingsGroup = new Group((Composite)this.shell, 32);
        this.props.setLook((Control)this.wSettingsGroup);
        this.wSettingsGroup.setText(BaseMessages.getString(PKG, (String)"SyslogMessageDialog.wSettingsGroup.Label", (String[])new String[0]));
        FormLayout settingGroupLayout = new FormLayout();
        settingGroupLayout.marginWidth = 10;
        settingGroupLayout.marginHeight = 10;
        this.wSettingsGroup.setLayout((Layout)settingGroupLayout);
        this.wServerName = new LabelTextVar((VariableSpace)this.transMeta, (Composite)this.wSettingsGroup, BaseMessages.getString(PKG, (String)"SyslogMessageDialog.Server.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SyslogMessageDialog.Server.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wServerName);
        this.wServerName.addModifyListener(lsMod);
        this.fdServerName = new FormData();
        this.fdServerName.left = new FormAttachment(0, 0);
        this.fdServerName.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdServerName.right = new FormAttachment(100, 0);
        this.wServerName.setLayoutData(this.fdServerName);
        this.wPort = new LabelTextVar((VariableSpace)this.transMeta, (Composite)this.wSettingsGroup, BaseMessages.getString(PKG, (String)"SyslogMessageDialog.Port.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SyslogMessageDialog.Port.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wPort);
        this.wPort.addModifyListener(lsMod);
        this.fdPort = new FormData();
        this.fdPort.left = new FormAttachment(0, 0);
        this.fdPort.top = new FormAttachment((Control)this.wServerName, margin);
        this.fdPort.right = new FormAttachment(100, 0);
        this.wPort.setLayoutData(this.fdPort);
        this.wTest = new Button((Composite)this.wSettingsGroup, 8);
        this.wTest.setText(BaseMessages.getString(PKG, (String)"SyslogMessageDialog.TestConnection.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wTest);
        this.fdTest = new FormData();
        this.wTest.setToolTipText(BaseMessages.getString(PKG, (String)"SyslogMessageDialog.TestConnection.Tooltip", (String[])new String[0]));
        this.fdTest.top = new FormAttachment((Control)this.wPort, 2 * margin);
        this.fdTest.right = new FormAttachment(100, 0);
        this.wTest.setLayoutData((Object)this.fdTest);
        this.fdSettingsGroup = new FormData();
        this.fdSettingsGroup.left = new FormAttachment(0, margin);
        this.fdSettingsGroup.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdSettingsGroup.right = new FormAttachment(100, -margin);
        this.wSettingsGroup.setLayoutData((Object)this.fdSettingsGroup);
        this.wLogSettings = new Group((Composite)this.shell, 32);
        this.props.setLook((Control)this.wLogSettings);
        this.wLogSettings.setText(BaseMessages.getString(PKG, (String)"SyslogMessageDialog.LogSettings.Group.Label", (String[])new String[0]));
        FormLayout LogSettingsgroupLayout = new FormLayout();
        LogSettingsgroupLayout.marginWidth = 10;
        LogSettingsgroupLayout.marginHeight = 10;
        this.wLogSettings.setLayout((Layout)LogSettingsgroupLayout);
        this.wlFacility = new Label((Composite)this.wLogSettings, 131072);
        this.wlFacility.setText(BaseMessages.getString(PKG, (String)"SyslogMessageDialog.Facility.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFacility);
        this.fdlFacility = new FormData();
        this.fdlFacility.left = new FormAttachment(0, margin);
        this.fdlFacility.right = new FormAttachment(middle, -margin);
        this.fdlFacility.top = new FormAttachment((Control)this.wSettingsGroup, margin);
        this.wlFacility.setLayoutData((Object)this.fdlFacility);
        this.wFacility = new CCombo((Composite)this.wLogSettings, 2060);
        this.wFacility.setItems(SyslogDefs.FACILITYS);
        this.props.setLook((Control)this.wFacility);
        this.fdFacility = new FormData();
        this.fdFacility.left = new FormAttachment(middle, margin);
        this.fdFacility.top = new FormAttachment((Control)this.wSettingsGroup, margin);
        this.fdFacility.right = new FormAttachment(100, 0);
        this.wFacility.setLayoutData((Object)this.fdFacility);
        this.wFacility.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.wlPriority = new Label((Composite)this.wLogSettings, 131072);
        this.wlPriority.setText(BaseMessages.getString(PKG, (String)"SyslogMessageDialog.Priority.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlPriority);
        this.fdlPriority = new FormData();
        this.fdlPriority.left = new FormAttachment(0, margin);
        this.fdlPriority.right = new FormAttachment(middle, -margin);
        this.fdlPriority.top = new FormAttachment((Control)this.wFacility, margin);
        this.wlPriority.setLayoutData((Object)this.fdlPriority);
        this.wPriority = new CCombo((Composite)this.wLogSettings, 2060);
        this.wPriority.setItems(SyslogDefs.PRIORITYS);
        this.props.setLook((Control)this.wPriority);
        this.fdPriority = new FormData();
        this.fdPriority.left = new FormAttachment(middle, margin);
        this.fdPriority.top = new FormAttachment((Control)this.wFacility, margin);
        this.fdPriority.right = new FormAttachment(100, 0);
        this.wPriority.setLayoutData((Object)this.fdPriority);
        this.wPriority.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.wlAddHostName = new Label((Composite)this.wLogSettings, 131072);
        this.wlAddHostName.setText(BaseMessages.getString(PKG, (String)"SyslogMessageDialog.AddHostName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAddHostName);
        this.fdlAddHostName = new FormData();
        this.fdlAddHostName.left = new FormAttachment(0, 0);
        this.fdlAddHostName.top = new FormAttachment((Control)this.wPriority, margin);
        this.fdlAddHostName.right = new FormAttachment(middle, -margin);
        this.wlAddHostName.setLayoutData((Object)this.fdlAddHostName);
        this.wAddHostName = new Button((Composite)this.wLogSettings, 32);
        this.props.setLook((Control)this.wAddHostName);
        this.wAddHostName.setToolTipText(BaseMessages.getString(PKG, (String)"SyslogMessageDialog.AddHostName.Tooltip", (String[])new String[0]));
        this.fdAddHostName = new FormData();
        this.fdAddHostName.left = new FormAttachment(middle, margin);
        this.fdAddHostName.top = new FormAttachment((Control)this.wPriority, margin);
        this.fdAddHostName.right = new FormAttachment(100, 0);
        this.wAddHostName.setLayoutData((Object)this.fdAddHostName);
        this.wAddHostName.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SyslogMessageDialog.this.input.setChanged();
            }
        });
        this.wlAddTimestamp = new Label((Composite)this.wLogSettings, 131072);
        this.wlAddTimestamp.setText(BaseMessages.getString(PKG, (String)"SyslogMessageDialog.AddTimestamp.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAddTimestamp);
        this.fdlAddTimestamp = new FormData();
        this.fdlAddTimestamp.left = new FormAttachment(0, 0);
        this.fdlAddTimestamp.top = new FormAttachment((Control)this.wAddHostName, margin);
        this.fdlAddTimestamp.right = new FormAttachment(middle, -margin);
        this.wlAddTimestamp.setLayoutData((Object)this.fdlAddTimestamp);
        this.wAddTimestamp = new Button((Composite)this.wLogSettings, 32);
        this.props.setLook((Control)this.wAddTimestamp);
        this.wAddTimestamp.setToolTipText(BaseMessages.getString(PKG, (String)"SyslogMessageDialog.AddTimestamp.Tooltip", (String[])new String[0]));
        this.fdAddTimestamp = new FormData();
        this.fdAddTimestamp.left = new FormAttachment(middle, margin);
        this.fdAddTimestamp.top = new FormAttachment((Control)this.wAddHostName, margin);
        this.fdAddTimestamp.right = new FormAttachment(100, 0);
        this.wAddTimestamp.setLayoutData((Object)this.fdAddTimestamp);
        this.wAddTimestamp.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SyslogMessageDialog.this.activeAddTimestamp();
                SyslogMessageDialog.this.input.setChanged();
            }
        });
        this.wlDatePattern = new Label((Composite)this.wLogSettings, 131072);
        this.wlDatePattern.setText(BaseMessages.getString(PKG, (String)"SyslogMessageDialog.DatePattern.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlDatePattern);
        this.fdlDatePattern = new FormData();
        this.fdlDatePattern.left = new FormAttachment(0, margin);
        this.fdlDatePattern.right = new FormAttachment(middle, -margin);
        this.fdlDatePattern.top = new FormAttachment((Control)this.wAddTimestamp, margin);
        this.wlDatePattern.setLayoutData((Object)this.fdlDatePattern);
        this.wDatePattern = new ComboVar((VariableSpace)this.transMeta, (Composite)this.wLogSettings, 2060);
        this.wDatePattern.setItems(Const.getDateFormats());
        this.props.setLook((Control)this.wDatePattern);
        this.fdDatePattern = new FormData();
        this.fdDatePattern.left = new FormAttachment(middle, margin);
        this.fdDatePattern.top = new FormAttachment((Control)this.wAddTimestamp, margin);
        this.fdDatePattern.right = new FormAttachment(100, 0);
        this.wDatePattern.setLayoutData(this.fdDatePattern);
        this.wDatePattern.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
            }
        });
        this.wlMessageField = new Label((Composite)this.wLogSettings, 131072);
        this.wlMessageField.setText(BaseMessages.getString(PKG, (String)"SyslogMessageDialog.MessageNameField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlMessageField);
        this.fdlMessageField = new FormData();
        this.fdlMessageField.left = new FormAttachment(0, margin);
        this.fdlMessageField.right = new FormAttachment(middle, -margin);
        this.fdlMessageField.top = new FormAttachment((Control)this.wDatePattern, margin);
        this.wlMessageField.setLayoutData((Object)this.fdlMessageField);
        this.wMessageField = new CCombo((Composite)this.wLogSettings, 2056);
        this.props.setLook((Control)this.wMessageField);
        this.wMessageField.setEditable(true);
        this.wMessageField.addModifyListener(lsMod);
        this.fdMessageField = new FormData();
        this.fdMessageField.left = new FormAttachment(middle, margin);
        this.fdMessageField.top = new FormAttachment((Control)this.wDatePattern, margin);
        this.fdMessageField.right = new FormAttachment(100, 0);
        this.wMessageField.setLayoutData((Object)this.fdMessageField);
        this.wMessageField.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                SyslogMessageDialog.this.get();
            }
        });
        this.fdLogSettings = new FormData();
        this.fdLogSettings.left = new FormAttachment(0, margin);
        this.fdLogSettings.top = new FormAttachment((Control)this.wSettingsGroup, margin);
        this.fdLogSettings.right = new FormAttachment(100, -margin);
        this.wLogSettings.setLayoutData((Object)this.fdLogSettings);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, (Control)this.wLogSettings);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                SyslogMessageDialog.this.ok();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                SyslogMessageDialog.this.cancel();
            }
        };
        this.lsTest = new Listener(){

            public void handleEvent(Event e) {
                SyslogMessageDialog.this.test();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wCancel.addListener(13, this.lsCancel);
        this.wTest.addListener(13, this.lsTest);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                SyslogMessageDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                SyslogMessageDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.activeAddTimestamp();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void getData() {
        if (this.input.getMessageFieldName() != null) {
            this.wMessageField.setText(this.input.getMessageFieldName());
        }
        if (this.input.getServerName() != null) {
            this.wServerName.setText(this.input.getServerName());
        }
        if (this.input.getPort() != null) {
            this.wPort.setText(this.input.getPort());
        }
        if (this.input.getFacility() != null) {
            this.wFacility.setText(this.input.getFacility());
        }
        if (this.input.getPriority() != null) {
            this.wPriority.setText(this.input.getPriority());
        }
        if (this.input.getDatePattern() != null) {
            this.wDatePattern.setText(this.input.getDatePattern());
        }
        this.wAddTimestamp.setSelection(this.input.isAddTimestamp());
        this.wAddHostName.setSelection(this.input.isAddHostName());
        this.wStepname.selectAll();
    }

    private void activeAddTimestamp() {
        this.wlDatePattern.setEnabled(this.wAddTimestamp.getSelection());
        this.wDatePattern.setEnabled(this.wAddTimestamp.getSelection());
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.input.setServerName(this.wServerName.getText());
        this.input.setPort(this.wPort.getText());
        this.input.setFacility(this.wFacility.getText());
        this.input.setPriority(this.wPriority.getText());
        this.input.setMessageFieldName(this.wMessageField.getText());
        this.input.addTimestamp(this.wAddTimestamp.getSelection());
        this.input.addHostName(this.wAddHostName.getSelection());
        this.input.setDatePattern(this.wDatePattern.getText());
        this.stepname = this.wStepname.getText();
        this.dispose();
    }

    private void get() {
        if (!this.gotPreviousFields) {
            this.gotPreviousFields = true;
            try {
                String source = this.wMessageField.getText();
                this.wMessageField.removeAll();
                RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
                if (r != null) {
                    this.wMessageField.setItems(r.getFieldNames());
                    if (source != null) {
                        this.wMessageField.setText(source);
                    }
                }
            }
            catch (KettleException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"SyslogMessageDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"SyslogMessageDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
        }
    }

    private void test() {
        MessageBox mb;
        boolean testOK = false;
        String errMsg = null;
        String hostname = this.transMeta.environmentSubstitute(this.wServerName.getText());
        int nrPort = Const.toInt((String)this.transMeta.environmentSubstitute("" + this.wPort.getText()), (int)514);
        try {
            UdpAddress udpAddress = new UdpAddress(InetAddress.getByName(hostname), nrPort);
            UserTarget usertarget = new UserTarget();
            usertarget.setAddress((Address)udpAddress);
            testOK = usertarget.getAddress().isValid();
            if (!testOK) {
                errMsg = BaseMessages.getString(PKG, (String)"SyslogMessageDialog.CanNotGetAddress", (String[])new String[]{hostname});
            }
        }
        catch (Exception e) {
            errMsg = e.getMessage();
        }
        if (testOK) {
            mb = new MessageBox(this.shell, 34);
            mb.setMessage(BaseMessages.getString(PKG, (String)"SyslogMessageDialog.Connected.OK", (String[])new String[]{hostname}) + Const.CR);
            mb.setText(BaseMessages.getString(PKG, (String)"SyslogMessageDialog.Connected.Title.Ok", (String[])new String[0]));
            mb.open();
        } else {
            mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"SyslogMessageDialog.Connected.NOK.ConnectionBad", (String[])new String[]{hostname}) + Const.CR + errMsg + Const.CR);
            mb.setText(BaseMessages.getString(PKG, (String)"SyslogMessageDialog.Connected.Title.Bad", (String[])new String[0]));
            mb.open();
        }
    }
}

