/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.valuemapper;

import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.valuemapper.ValueMapperMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class ValueMapperDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = ValueMapperMeta.class;
    private Label wlStepname;
    private Text wStepname;
    private FormData fdlStepname;
    private FormData fdStepname;
    private Label wlFieldname;
    private CCombo wFieldname;
    private FormData fdlFieldname;
    private FormData fdFieldname;
    private Label wlTargetFieldname;
    private Text wTargetFieldname;
    private FormData fdlTargetFieldname;
    private FormData fdTargetFieldname;
    private Label wlNonMatchDefault;
    private Text wNonMatchDefault;
    private FormData fdlNonMatchDefault;
    private FormData fdNonMatchDefault;
    private Label wlFields;
    private TableView wFields;
    private FormData fdlFields;
    private FormData fdFields;
    private ValueMapperMeta input;
    private boolean gotPreviousFields = false;

    public ValueMapperDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (ValueMapperMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ValueMapperDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ValueMapperDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"ValueMapperDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wlFieldname = new Label((Composite)this.shell, 131072);
        this.wlFieldname.setText(BaseMessages.getString(PKG, (String)"ValueMapperDialog.FieldnameToUser.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFieldname);
        this.fdlFieldname = new FormData();
        this.fdlFieldname.left = new FormAttachment(0, 0);
        this.fdlFieldname.right = new FormAttachment(middle, -margin);
        this.fdlFieldname.top = new FormAttachment((Control)this.wStepname, margin);
        this.wlFieldname.setLayoutData((Object)this.fdlFieldname);
        this.wFieldname = new CCombo((Composite)this.shell, 2056);
        this.props.setLook((Control)this.wFieldname);
        this.wFieldname.addModifyListener(lsMod);
        this.fdFieldname = new FormData();
        this.fdFieldname.left = new FormAttachment(middle, 0);
        this.fdFieldname.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdFieldname.right = new FormAttachment(100, 0);
        this.wFieldname.setLayoutData((Object)this.fdFieldname);
        this.wFieldname.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                Cursor busy = new Cursor((Device)ValueMapperDialog.this.shell.getDisplay(), 1);
                ValueMapperDialog.this.shell.setCursor(busy);
                ValueMapperDialog.this.getFields();
                ValueMapperDialog.this.shell.setCursor(null);
                busy.dispose();
            }
        });
        this.wlTargetFieldname = new Label((Composite)this.shell, 131072);
        this.wlTargetFieldname.setText(BaseMessages.getString(PKG, (String)"ValueMapperDialog.TargetFieldname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTargetFieldname);
        this.fdlTargetFieldname = new FormData();
        this.fdlTargetFieldname.left = new FormAttachment(0, 0);
        this.fdlTargetFieldname.right = new FormAttachment(middle, -margin);
        this.fdlTargetFieldname.top = new FormAttachment((Control)this.wFieldname, margin);
        this.wlTargetFieldname.setLayoutData((Object)this.fdlTargetFieldname);
        this.wTargetFieldname = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wTargetFieldname);
        this.wTargetFieldname.addModifyListener(lsMod);
        this.fdTargetFieldname = new FormData();
        this.fdTargetFieldname.left = new FormAttachment(middle, 0);
        this.fdTargetFieldname.top = new FormAttachment((Control)this.wFieldname, margin);
        this.fdTargetFieldname.right = new FormAttachment(100, 0);
        this.wTargetFieldname.setLayoutData((Object)this.fdTargetFieldname);
        this.wlNonMatchDefault = new Label((Composite)this.shell, 131072);
        this.wlNonMatchDefault.setText(BaseMessages.getString(PKG, (String)"ValueMapperDialog.NonMatchDefault.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlNonMatchDefault);
        this.fdlNonMatchDefault = new FormData();
        this.fdlNonMatchDefault.left = new FormAttachment(0, 0);
        this.fdlNonMatchDefault.right = new FormAttachment(middle, -margin);
        this.fdlNonMatchDefault.top = new FormAttachment((Control)this.wTargetFieldname, margin);
        this.wlNonMatchDefault.setLayoutData((Object)this.fdlNonMatchDefault);
        this.wNonMatchDefault = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wNonMatchDefault);
        this.wNonMatchDefault.addModifyListener(lsMod);
        this.fdNonMatchDefault = new FormData();
        this.fdNonMatchDefault.left = new FormAttachment(middle, 0);
        this.fdNonMatchDefault.top = new FormAttachment((Control)this.wTargetFieldname, margin);
        this.fdNonMatchDefault.right = new FormAttachment(100, 0);
        this.wNonMatchDefault.setLayoutData((Object)this.fdNonMatchDefault);
        this.wlFields = new Label((Composite)this.shell, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"ValueMapperDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFields);
        this.fdlFields = new FormData();
        this.fdlFields.left = new FormAttachment(0, 0);
        this.fdlFields.top = new FormAttachment((Control)this.wNonMatchDefault, margin);
        this.wlFields.setLayoutData((Object)this.fdlFields);
        int FieldsCols = 2;
        int FieldsRows = this.input.getSourceValue().length;
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"ValueMapperDialog.Fields.Column.SourceValue", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"ValueMapperDialog.Fields.Column.TargetValue", (String[])new String[0]), 1, false)};
        this.wFields = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 67586, colinf, FieldsRows, lsMod, this.props);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        this.fdFields.right = new FormAttachment(100, 0);
        this.fdFields.bottom = new FormAttachment(100, -50);
        this.wFields.setLayoutData(this.fdFields);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, (Control)this.wFields);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                ValueMapperDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                ValueMapperDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ValueMapperDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                ValueMapperDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    private void getFields() {
        if (!this.gotPreviousFields) {
            this.gotPreviousFields = true;
            try {
                String fieldname = this.wFieldname.getText();
                this.wFieldname.removeAll();
                RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
                if (r != null) {
                    this.wFieldname.setItems(r.getFieldNames());
                    if (fieldname != null) {
                        this.wFieldname.setText(fieldname);
                    }
                }
            }
            catch (KettleException ke) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"ValueMapperDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ValueMapperDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
            }
        }
    }

    public void getData() {
        this.wStepname.setText(this.stepname);
        if (this.input.getFieldToUse() != null) {
            this.wFieldname.setText(this.input.getFieldToUse());
        }
        if (this.input.getTargetField() != null) {
            this.wTargetFieldname.setText(this.input.getTargetField());
        }
        if (this.input.getNonMatchDefault() != null) {
            this.wNonMatchDefault.setText(this.input.getNonMatchDefault());
        }
        for (int i = 0; i < this.input.getSourceValue().length; ++i) {
            TableItem item = this.wFields.table.getItem(i);
            String src = this.input.getSourceValue()[i];
            String tgt = this.input.getTargetValue()[i];
            if (src != null) {
                item.setText(1, src);
            }
            if (tgt == null) continue;
            item.setText(2, tgt);
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wStepname.selectAll();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        this.input.setFieldToUse(this.wFieldname.getText());
        this.input.setTargetField(this.wTargetFieldname.getText());
        this.input.setNonMatchDefault(this.wNonMatchDefault.getText());
        int count = this.wFields.nrNonEmpty();
        this.input.allocate(count);
        for (int i = 0; i < count; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            this.input.getSourceValue()[i] = Const.isEmpty((String)item.getText(1)) ? null : item.getText(1);
            this.input.getTargetValue()[i] = item.getText(2);
        }
        this.dispose();
    }
}

