/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.writetolog;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.writetolog.WriteToLogMeta;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.StyledTextComp;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.trans.step.TableItemInsertListener;

public class WriteToLogDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = WriteToLogMeta.class;
    private WriteToLogMeta input;
    private Label wlLoglevel;
    private CCombo wLoglevel;
    private Label wlPrintHeader;
    private FormData fdPrintHeader;
    private FormData fdlPrintHeader;
    private Button wPrintHeader;
    private FormData fdlLoglevel;
    private FormData fdLoglevel;
    private Label wlLogMessage;
    private StyledTextComp wLogMessage;
    private FormData fdlLogMessage;
    private FormData fdLogMessage;
    private Label wlFields;
    private TableView wFields;
    private FormData fdlFields;
    private FormData fdFields;
    private Map<String, Integer> inputFields;
    private ColumnInfo[] colinf;

    public WriteToLogDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.input = (WriteToLogMeta)in;
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WriteToLogDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"WriteToLogDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"WriteToLogDialog.Stepname.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wlLoglevel = new Label((Composite)this.shell, 131072);
        this.wlLoglevel.setText(BaseMessages.getString(PKG, (String)"WriteToLogDialog.Loglevel.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlLoglevel);
        this.fdlLoglevel = new FormData();
        this.fdlLoglevel.left = new FormAttachment(0, 0);
        this.fdlLoglevel.right = new FormAttachment(middle, -margin);
        this.fdlLoglevel.top = new FormAttachment((Control)this.wStepname, margin);
        this.wlLoglevel.setLayoutData((Object)this.fdlLoglevel);
        this.wLoglevel = new CCombo((Composite)this.shell, 2060);
        this.wLoglevel.setItems(LogLevel.getLogLevelDescriptions());
        this.props.setLook((Control)this.wLoglevel);
        this.fdLoglevel = new FormData();
        this.fdLoglevel.left = new FormAttachment(middle, 0);
        this.fdLoglevel.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdLoglevel.right = new FormAttachment(100, 0);
        this.wLoglevel.setLayoutData((Object)this.fdLoglevel);
        this.wlPrintHeader = new Label((Composite)this.shell, 131072);
        this.wlPrintHeader.setText(BaseMessages.getString(PKG, (String)"WriteToLogDialog.PrintHeader.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlPrintHeader);
        this.fdlPrintHeader = new FormData();
        this.fdlPrintHeader.left = new FormAttachment(0, 0);
        this.fdlPrintHeader.top = new FormAttachment((Control)this.wLoglevel, margin);
        this.fdlPrintHeader.right = new FormAttachment(middle, -margin);
        this.wlPrintHeader.setLayoutData((Object)this.fdlPrintHeader);
        this.wPrintHeader = new Button((Composite)this.shell, 32);
        this.wPrintHeader.setToolTipText(BaseMessages.getString(PKG, (String)"WriteToLogDialog.PrintHeader.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wPrintHeader);
        this.fdPrintHeader = new FormData();
        this.fdPrintHeader.left = new FormAttachment(middle, 0);
        this.fdPrintHeader.top = new FormAttachment((Control)this.wLoglevel, margin);
        this.fdPrintHeader.right = new FormAttachment(100, 0);
        this.wPrintHeader.setLayoutData((Object)this.fdPrintHeader);
        this.wlLogMessage = new Label((Composite)this.shell, 131072);
        this.wlLogMessage.setText(BaseMessages.getString(PKG, (String)"WriteToLogDialog.Shell.Title", (String[])new String[0]));
        this.props.setLook((Control)this.wlLogMessage);
        this.fdlLogMessage = new FormData();
        this.fdlLogMessage.left = new FormAttachment(0, 0);
        this.fdlLogMessage.top = new FormAttachment((Control)this.wPrintHeader, margin);
        this.fdlLogMessage.right = new FormAttachment(middle, -margin);
        this.wlLogMessage.setLayoutData((Object)this.fdlLogMessage);
        this.wLogMessage = new StyledTextComp((VariableSpace)this.transMeta, (Composite)this.shell, 19202, "");
        this.props.setLook((Control)this.wLogMessage, 1);
        this.wLogMessage.addModifyListener(lsMod);
        this.fdLogMessage = new FormData();
        this.fdLogMessage.left = new FormAttachment(middle, 0);
        this.fdLogMessage.top = new FormAttachment((Control)this.wPrintHeader, margin);
        this.fdLogMessage.right = new FormAttachment(100, -2 * margin);
        this.fdLogMessage.height = 125;
        this.wLogMessage.setLayoutData(this.fdLogMessage);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wGet, this.wCancel}, margin, null);
        this.wlFields = new Label((Composite)this.shell, 0);
        this.wlFields.setText(BaseMessages.getString(PKG, (String)"WriteToLogDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFields);
        this.fdlFields = new FormData();
        this.fdlFields.left = new FormAttachment(0, 0);
        this.fdlFields.top = new FormAttachment((Control)this.wLogMessage, margin);
        this.wlFields.setLayoutData((Object)this.fdlFields);
        boolean FieldsCols = true;
        int FieldsRows = this.input.getFieldName().length;
        this.colinf = new ColumnInfo[1];
        this.colinf[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"WriteToLogDialog.Fieldname.Column", (String[])new String[0]), 2, new String[]{""}, false);
        this.wFields = new TableView((VariableSpace)this.transMeta, (Composite)this.shell, 67586, this.colinf, FieldsRows, lsMod, this.props);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment((Control)this.wlFields, margin);
        this.fdFields.right = new FormAttachment(100, 0);
        this.fdFields.bottom = new FormAttachment((Control)this.wOK, -2 * margin);
        this.wFields.setLayoutData(this.fdFields);
        Runnable runnable = new Runnable(){

            public void run() {
                StepMeta stepMeta = WriteToLogDialog.this.transMeta.findStep(WriteToLogDialog.this.stepname);
                if (stepMeta != null) {
                    try {
                        RowMetaInterface row = WriteToLogDialog.this.transMeta.getPrevStepFields(stepMeta);
                        for (int i = 0; i < row.size(); ++i) {
                            WriteToLogDialog.this.inputFields.put(row.getValueMeta(i).getName(), i);
                        }
                        WriteToLogDialog.this.setComboBoxes();
                    }
                    catch (KettleException e) {
                        WriteToLogDialog.this.logError(BaseMessages.getString((Class)PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                    }
                }
            }
        };
        new Thread(runnable).start();
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                WriteToLogDialog.this.cancel();
            }
        };
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                WriteToLogDialog.this.get();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                WriteToLogDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.wGet.addListener(13, this.lsGet);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                WriteToLogDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                WriteToLogDialog.this.cancel();
            }
        });
        this.setSize();
        this.getData();
        this.input.setChanged(this.changed);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.colinf[0].setComboValues(fieldNames);
    }

    private void get() {
        try {
            RowMetaInterface r = this.transMeta.getPrevStepFields(this.stepname);
            if (r != null) {
                TableItemInsertListener insertListener = new TableItemInsertListener(){

                    public boolean tableItemInserted(TableItem tableItem, ValueMetaInterface v) {
                        return true;
                    }
                };
                BaseStepDialog.getFieldsFromPrevious(r, this.wFields, 1, new int[]{1}, new int[0], -1, -1, insertListener);
            }
        }
        catch (KettleException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    public void getData() {
        this.wLoglevel.select(this.input.getLogLevelByDesc().getLevel());
        this.wPrintHeader.setSelection(this.input.isdisplayHeader());
        if (this.input.getLogMessage() != null) {
            this.wLogMessage.setText(this.input.getLogMessage());
        }
        Table table = this.wFields.table;
        if (this.input.getFieldName().length > 0) {
            table.removeAll();
        }
        for (int i = 0; i < this.input.getFieldName().length; ++i) {
            TableItem ti = new TableItem(table, 0);
            ti.setText(0, "" + (i + 1));
            ti.setText(1, this.input.getFieldName()[i]);
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wStepname.selectAll();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        this.stepname = this.wStepname.getText();
        this.input.setdisplayHeader(this.wPrintHeader.getSelection());
        if (this.wLoglevel.getSelectionIndex() < 0) {
            this.input.setLogLevel(3);
        } else {
            this.input.setLogLevel(this.wLoglevel.getSelectionIndex());
        }
        if (this.wLogMessage.getText() != null && this.wLogMessage.getText().length() > 0) {
            this.input.setLogMessage(this.wLogMessage.getText());
        } else {
            this.input.setLogMessage("");
        }
        int nrfields = this.wFields.nrNonEmpty();
        this.input.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            TableItem ti = this.wFields.getNonEmpty(i);
            this.input.getFieldName()[i] = ti.getText(1);
        }
        this.dispose();
    }
}

