/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.xbaseinput;

import java.util.List;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPreviewFactory;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.xbaseinput.XBaseInputMeta;
import org.pentaho.di.ui.core.dialog.EnterNumberDialog;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.dialog.TransPreviewProgressDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;

public class XBaseInputDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = XBaseInputMeta.class;
    private Label wlFilename;
    private Button wbFilename;
    private TextVar wFilename;
    private FormData fdlFilename;
    private FormData fdbFilename;
    private FormData fdFilename;
    private Group gAccepting;
    private FormData fdAccepting;
    private Label wlAccFilenames;
    private Button wAccFilenames;
    private FormData fdlAccFilenames;
    private FormData fdAccFilenames;
    private Label wlAccField;
    private Text wAccField;
    private FormData fdlAccField;
    private FormData fdAccField;
    private Label wlAccStep;
    private CCombo wAccStep;
    private FormData fdlAccStep;
    private FormData fdAccStep;
    private Label wlLimit;
    private Text wLimit;
    private FormData fdlLimit;
    private FormData fdLimit;
    private Label wlAddRownr;
    private Button wAddRownr;
    private FormData fdlAddRownr;
    private FormData fdAddRownr;
    private Label wlFieldRownr;
    private Text wFieldRownr;
    private FormData fdlFieldRownr;
    private FormData fdFieldRownr;
    private Label wlInclFilename;
    private Button wInclFilename;
    private FormData fdlInclFilename;
    private FormData fdInclFilename;
    private Label wlInclFilenameField;
    private Text wInclFilenameField;
    private FormData fdlInclFilenameField;
    private FormData fdInclFilenameField;
    private Label wlCharactersetName;
    private Text wCharactersetName;
    private FormData fdlCharactersetName;
    private FormData fdCharactersetName;
    private XBaseInputMeta input;
    private boolean backupChanged;
    private boolean backupAddRownr;

    public XBaseInputDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.input = (XBaseInputMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XBaseInputDialog.this.input.setChanged();
            }
        };
        this.backupChanged = this.input.hasChanged();
        this.backupAddRownr = this.input.isRowNrAdded();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"XBaseInputDialog.Dialog.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"System.Label.StepName", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wlFilename = new Label((Composite)this.shell, 131072);
        this.wlFilename.setText(BaseMessages.getString(PKG, (String)"System.Label.Filename", (String[])new String[0]));
        this.props.setLook((Control)this.wlFilename);
        this.fdlFilename = new FormData();
        this.fdlFilename.left = new FormAttachment(0, 0);
        this.fdlFilename.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdlFilename.right = new FormAttachment(middle, -margin);
        this.wlFilename.setLayoutData((Object)this.fdlFilename);
        this.wbFilename = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbFilename);
        this.wbFilename.setText(BaseMessages.getString(PKG, (String)"System.Button.Browse", (String[])new String[0]));
        this.fdbFilename = new FormData();
        this.fdbFilename.right = new FormAttachment(100, 0);
        this.fdbFilename.top = new FormAttachment((Control)this.wStepname, margin);
        this.wbFilename.setLayoutData((Object)this.fdbFilename);
        this.wFilename = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wFilename);
        this.wFilename.addModifyListener(lsMod);
        this.fdFilename = new FormData();
        this.fdFilename.left = new FormAttachment(middle, 0);
        this.fdFilename.right = new FormAttachment((Control)this.wbFilename, -margin);
        this.fdFilename.top = new FormAttachment((Control)this.wStepname, margin);
        this.wFilename.setLayoutData(this.fdFilename);
        this.gAccepting = new Group((Composite)this.shell, 16);
        this.gAccepting.setText(BaseMessages.getString(PKG, (String)"XBaseInputDialog.AcceptingGroup.Label", (String[])new String[0]));
        FormLayout acceptingLayout = new FormLayout();
        acceptingLayout.marginWidth = 3;
        acceptingLayout.marginHeight = 3;
        this.gAccepting.setLayout((Layout)acceptingLayout);
        this.props.setLook((Control)this.gAccepting);
        this.wlAccFilenames = new Label((Composite)this.gAccepting, 131072);
        this.wlAccFilenames.setText(BaseMessages.getString(PKG, (String)"XBaseInputDialog.AcceptFilenames.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAccFilenames);
        this.fdlAccFilenames = new FormData();
        this.fdlAccFilenames.top = new FormAttachment(0, margin);
        this.fdlAccFilenames.left = new FormAttachment(0, 0);
        this.fdlAccFilenames.right = new FormAttachment(middle, -margin);
        this.wlAccFilenames.setLayoutData((Object)this.fdlAccFilenames);
        this.wAccFilenames = new Button((Composite)this.gAccepting, 32);
        this.wAccFilenames.setToolTipText(BaseMessages.getString(PKG, (String)"XBaseInputDialog.AcceptFilenames.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wAccFilenames);
        this.fdAccFilenames = new FormData();
        this.fdAccFilenames.top = new FormAttachment(0, margin);
        this.fdAccFilenames.left = new FormAttachment(middle, 0);
        this.fdAccFilenames.right = new FormAttachment(100, 0);
        this.wAccFilenames.setLayoutData((Object)this.fdAccFilenames);
        this.wAccFilenames.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                XBaseInputDialog.this.setFlags();
            }
        });
        this.wlAccStep = new Label((Composite)this.gAccepting, 131072);
        this.wlAccStep.setText(BaseMessages.getString(PKG, (String)"XBaseInputDialog.AcceptStep.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAccStep);
        this.fdlAccStep = new FormData();
        this.fdlAccStep.top = new FormAttachment((Control)this.wAccFilenames, margin);
        this.fdlAccStep.left = new FormAttachment(0, 0);
        this.fdlAccStep.right = new FormAttachment(middle, -margin);
        this.wlAccStep.setLayoutData((Object)this.fdlAccStep);
        this.wAccStep = new CCombo((Composite)this.gAccepting, 18436);
        this.wAccStep.setToolTipText(BaseMessages.getString(PKG, (String)"XBaseInputDialog.AcceptStep.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wAccStep);
        this.fdAccStep = new FormData();
        this.fdAccStep.top = new FormAttachment((Control)this.wAccFilenames, margin);
        this.fdAccStep.left = new FormAttachment(middle, 0);
        this.fdAccStep.right = new FormAttachment(100, 0);
        this.wAccStep.setLayoutData((Object)this.fdAccStep);
        this.wlAccField = new Label((Composite)this.gAccepting, 131072);
        this.wlAccField.setText(BaseMessages.getString(PKG, (String)"XBaseInputDialog.AcceptField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAccField);
        this.fdlAccField = new FormData();
        this.fdlAccField.top = new FormAttachment((Control)this.wAccStep, margin);
        this.fdlAccField.left = new FormAttachment(0, 0);
        this.fdlAccField.right = new FormAttachment(middle, -margin);
        this.wlAccField.setLayoutData((Object)this.fdlAccField);
        this.wAccField = new Text((Composite)this.gAccepting, 18436);
        this.wAccField.setToolTipText(BaseMessages.getString(PKG, (String)"XBaseInputDialog.AcceptField.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wAccField);
        this.fdAccField = new FormData();
        this.fdAccField.top = new FormAttachment((Control)this.wAccStep, margin);
        this.fdAccField.left = new FormAttachment(middle, 0);
        this.fdAccField.right = new FormAttachment(100, 0);
        this.wAccField.setLayoutData((Object)this.fdAccField);
        List prevSteps = this.transMeta.findPreviousSteps(this.transMeta.findStep(this.stepname));
        for (StepMeta prevStep : prevSteps) {
            this.wAccStep.add(prevStep.getName());
        }
        this.fdAccepting = new FormData();
        this.fdAccepting.left = new FormAttachment(middle, 0);
        this.fdAccepting.right = new FormAttachment(100, 0);
        this.fdAccepting.top = new FormAttachment((Control)this.wFilename, margin * 2);
        this.gAccepting.setLayoutData((Object)this.fdAccepting);
        this.wlLimit = new Label((Composite)this.shell, 131072);
        this.wlLimit.setText(BaseMessages.getString(PKG, (String)"XBaseInputDialog.LimitSize.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlLimit);
        this.fdlLimit = new FormData();
        this.fdlLimit.left = new FormAttachment(0, 0);
        this.fdlLimit.right = new FormAttachment(middle, -margin);
        this.fdlLimit.top = new FormAttachment((Control)this.gAccepting, margin * 2);
        this.wlLimit.setLayoutData((Object)this.fdlLimit);
        this.wLimit = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wLimit);
        this.wLimit.addModifyListener(lsMod);
        this.fdLimit = new FormData();
        this.fdLimit.left = new FormAttachment(middle, 0);
        this.fdLimit.top = new FormAttachment((Control)this.gAccepting, margin * 2);
        this.fdLimit.right = new FormAttachment(100, 0);
        this.wLimit.setLayoutData((Object)this.fdLimit);
        this.wlAddRownr = new Label((Composite)this.shell, 131072);
        this.wlAddRownr.setText(BaseMessages.getString(PKG, (String)"XBaseInputDialog.AddRowNr.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlAddRownr);
        this.fdlAddRownr = new FormData();
        this.fdlAddRownr.left = new FormAttachment(0, 0);
        this.fdlAddRownr.top = new FormAttachment((Control)this.wLimit, margin);
        this.fdlAddRownr.right = new FormAttachment(middle, -margin);
        this.wlAddRownr.setLayoutData((Object)this.fdlAddRownr);
        this.wAddRownr = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wAddRownr);
        this.wAddRownr.setToolTipText(BaseMessages.getString(PKG, (String)"XBaseInputDialog.AddRowNr.Tooltip", (String[])new String[0]));
        this.fdAddRownr = new FormData();
        this.fdAddRownr.left = new FormAttachment(middle, 0);
        this.fdAddRownr.top = new FormAttachment((Control)this.wLimit, margin);
        this.wAddRownr.setLayoutData((Object)this.fdAddRownr);
        this.wAddRownr.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XBaseInputDialog.this.input.setChanged();
                XBaseInputDialog.this.setFlags();
            }
        });
        this.wlFieldRownr = new Label((Composite)this.shell, 16384);
        this.wlFieldRownr.setText(BaseMessages.getString(PKG, (String)"XBaseInputDialog.FieldnameOfRowNr.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFieldRownr);
        this.fdlFieldRownr = new FormData();
        this.fdlFieldRownr.left = new FormAttachment((Control)this.wAddRownr, margin);
        this.fdlFieldRownr.top = new FormAttachment((Control)this.wLimit, margin);
        this.wlFieldRownr.setLayoutData((Object)this.fdlFieldRownr);
        this.wFieldRownr = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wFieldRownr);
        this.wFieldRownr.addModifyListener(lsMod);
        this.fdFieldRownr = new FormData();
        this.fdFieldRownr.left = new FormAttachment((Control)this.wlFieldRownr, margin);
        this.fdFieldRownr.top = new FormAttachment((Control)this.wLimit, margin);
        this.fdFieldRownr.right = new FormAttachment(100, 0);
        this.wFieldRownr.setLayoutData((Object)this.fdFieldRownr);
        this.wlInclFilename = new Label((Composite)this.shell, 131072);
        this.wlInclFilename.setText(BaseMessages.getString(PKG, (String)"XBaseInputDialog.InclFilename.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlInclFilename);
        this.fdlInclFilename = new FormData();
        this.fdlInclFilename.left = new FormAttachment(0, 0);
        this.fdlInclFilename.top = new FormAttachment((Control)this.wFieldRownr, margin);
        this.fdlInclFilename.right = new FormAttachment(middle, -margin);
        this.wlInclFilename.setLayoutData((Object)this.fdlInclFilename);
        this.wInclFilename = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wInclFilename);
        this.wInclFilename.setToolTipText(BaseMessages.getString(PKG, (String)"XBaseInputDialog.InclFilename.Tooltip", (String[])new String[0]));
        this.fdInclFilename = new FormData();
        this.fdInclFilename.left = new FormAttachment(middle, 0);
        this.fdInclFilename.top = new FormAttachment((Control)this.wFieldRownr, margin);
        this.wInclFilename.setLayoutData((Object)this.fdInclFilename);
        this.wInclFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                XBaseInputDialog.this.input.setChanged();
                XBaseInputDialog.this.setFlags();
            }
        });
        this.wlInclFilenameField = new Label((Composite)this.shell, 16384);
        this.wlInclFilenameField.setText(BaseMessages.getString(PKG, (String)"XBaseInputDialog.InclFilenameField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlInclFilenameField);
        this.fdlInclFilenameField = new FormData();
        this.fdlInclFilenameField.left = new FormAttachment((Control)this.wInclFilename, margin);
        this.fdlInclFilenameField.top = new FormAttachment((Control)this.wFieldRownr, margin);
        this.wlInclFilenameField.setLayoutData((Object)this.fdlInclFilenameField);
        this.wInclFilenameField = new Text((Composite)this.shell, 18436);
        this.props.setLook((Control)this.wInclFilenameField);
        this.wInclFilenameField.addModifyListener(lsMod);
        this.fdInclFilenameField = new FormData();
        this.fdInclFilenameField.left = new FormAttachment((Control)this.wlInclFilenameField, margin);
        this.fdInclFilenameField.top = new FormAttachment((Control)this.wFieldRownr, margin);
        this.fdInclFilenameField.right = new FormAttachment(100, 0);
        this.wInclFilenameField.setLayoutData((Object)this.fdInclFilenameField);
        this.wlCharactersetName = new Label((Composite)this.shell, 131072);
        this.wlCharactersetName.setText(BaseMessages.getString(PKG, (String)"XBaseInputDialog.CharactersetName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCharactersetName);
        this.fdlCharactersetName = new FormData();
        this.fdlCharactersetName.left = new FormAttachment(0, 0);
        this.fdlCharactersetName.right = new FormAttachment(middle, -margin);
        this.fdlCharactersetName.top = new FormAttachment((Control)this.wInclFilename, margin);
        this.wlCharactersetName.setLayoutData((Object)this.fdlCharactersetName);
        this.wCharactersetName = new Text((Composite)this.shell, 18436);
        this.wCharactersetName.setToolTipText(BaseMessages.getString(PKG, (String)"XBaseInputDialog.CharactersetName.Tooltip", (String[])new String[0]));
        this.props.setLook((Control)this.wCharactersetName);
        this.wCharactersetName.addModifyListener(lsMod);
        this.fdCharactersetName = new FormData();
        this.fdCharactersetName.left = new FormAttachment(middle, 0);
        this.fdCharactersetName.top = new FormAttachment((Control)this.wInclFilename, margin);
        this.fdCharactersetName.right = new FormAttachment(100, 0);
        this.wCharactersetName.setLayoutData((Object)this.fdCharactersetName);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"System.Button.Preview", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wPreview, this.wCancel}, margin, (Control)this.wCharactersetName);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                XBaseInputDialog.this.cancel();
            }
        };
        this.lsPreview = new Listener(){

            public void handleEvent(Event e) {
                XBaseInputDialog.this.preview();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                XBaseInputDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wPreview.addListener(13, this.lsPreview);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                XBaseInputDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wLimit.addSelectionListener((SelectionListener)this.lsDef);
        this.wFieldRownr.addSelectionListener((SelectionListener)this.lsDef);
        this.wAccField.addSelectionListener((SelectionListener)this.lsDef);
        this.wFilename.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                XBaseInputDialog.this.wFilename.setToolTipText(XBaseInputDialog.this.transMeta.environmentSubstitute(XBaseInputDialog.this.wFilename.getText()));
            }
        });
        this.wbFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FileDialog dialog = new FileDialog(XBaseInputDialog.this.shell, 4096);
                dialog.setFilterExtensions(new String[]{"*.dbf;*.DBF", "*"});
                if (XBaseInputDialog.this.wFilename.getText() != null) {
                    dialog.setFileName(XBaseInputDialog.this.wFilename.getText());
                }
                dialog.setFilterNames(new String[]{BaseMessages.getString((Class)PKG, (String)"XBaseInputDialog.Filter.DBaseFiles", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"System.FileType.AllFiles", (String[])new String[0])});
                if (dialog.open() != null) {
                    String str = dialog.getFilterPath() + Const.FILE_SEPARATOR + dialog.getFileName();
                    XBaseInputDialog.this.wFilename.setText(str);
                }
            }
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                XBaseInputDialog.this.cancel();
            }
        });
        this.getData();
        this.input.setChanged(this.changed);
        this.setSize();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    protected void setFlags() {
        this.wlFieldRownr.setEnabled(this.wAddRownr.getSelection());
        this.wFieldRownr.setEnabled(this.wAddRownr.getSelection());
        this.wlInclFilenameField.setEnabled(this.wInclFilename.getSelection());
        this.wInclFilenameField.setEnabled(this.wInclFilename.getSelection());
        this.wlFilename.setEnabled(!this.wAccFilenames.getSelection());
        this.wFilename.setEnabled(!this.wAccFilenames.getSelection());
        this.wbFilename.setEnabled(!this.wAccFilenames.getSelection());
    }

    public void getData() {
        if (this.input.getDbfFileName() != null) {
            this.wFilename.setText(this.input.getDbfFileName());
            this.wFilename.setToolTipText(this.transMeta.environmentSubstitute(this.input.getDbfFileName()));
        }
        this.wFieldRownr.setText(Const.NVL((String)this.input.getRowNrField(), (String)""));
        this.wInclFilename.setSelection(this.input.includeFilename());
        this.wInclFilenameField.setText(Const.NVL((String)this.input.getFilenameField(), (String)""));
        this.wAccFilenames.setSelection(this.input.isAcceptingFilenames());
        this.wAccField.setText(Const.NVL((String)this.input.getAcceptingField(), (String)""));
        this.wAccStep.setText(Const.NVL((String)(this.input.getAcceptingStep() == null ? "" : this.input.getAcceptingStep().getName()), (String)""));
        this.wCharactersetName.setText(Const.NVL((String)this.input.getCharactersetName(), (String)""));
        this.setFlags();
        this.wStepname.selectAll();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setRowNrAdded(this.backupAddRownr);
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    public void getInfo(XBaseInputMeta meta) throws KettleStepException {
        meta.setDbfFileName(this.wFilename.getText());
        meta.setRowLimit(Const.toInt((String)this.wLimit.getText(), (int)0));
        meta.setRowNrAdded(this.wAddRownr.getSelection());
        meta.setRowNrField(this.wFieldRownr.getText());
        meta.setIncludeFilename(this.wInclFilename.getSelection());
        meta.setFilenameField(this.wInclFilenameField.getText());
        meta.setAcceptingFilenames(this.wAccFilenames.getSelection());
        meta.setAcceptingField(this.wAccField.getText());
        meta.setAcceptingStep(this.transMeta.findStep(this.wAccStep.getText()));
        meta.setCharactersetName(this.wCharactersetName.getText());
        if (Const.isEmpty((String)meta.getDbfFileName()) && !meta.isAcceptingFilenames()) {
            throw new KettleStepException(BaseMessages.getString(PKG, (String)"XBaseInputDialog.Exception.SpecifyAFileToUse", (String[])new String[0]));
        }
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        try {
            this.stepname = this.wStepname.getText();
            this.getInfo(this.input);
        }
        catch (KettleStepException e) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(e.toString());
            mb.setText(BaseMessages.getString(PKG, (String)"System.Warning", (String[])new String[0]));
            mb.open();
        }
        this.dispose();
    }

    private void preview() {
        try {
            XBaseInputMeta oneMeta = new XBaseInputMeta();
            this.getInfo(oneMeta);
            if (oneMeta.isAcceptingFilenames()) {
                MessageBox mb = new MessageBox(this.shell, 34);
                mb.setMessage(BaseMessages.getString(PKG, (String)"XBaseInputDialog.Dialog.SpecifyASampleFile.Message", (String[])new String[0]));
                mb.setText(BaseMessages.getString(PKG, (String)"XBaseInputDialog.Dialog.SpecifyASampleFile.Title", (String[])new String[0]));
                mb.open();
                return;
            }
            TransMeta previewMeta = TransPreviewFactory.generatePreviewTransformation((VariableSpace)this.transMeta, (StepMetaInterface)oneMeta, (String)this.wStepname.getText());
            EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"XBaseInputDialog.PreviewSize.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"XBaseInputDialog.PreviewSize.DialogMessage", (String[])new String[0]));
            int previewSize = numberDialog.open();
            if (previewSize > 0) {
                TransPreviewProgressDialog progressDialog = new TransPreviewProgressDialog(this.shell, previewMeta, new String[]{this.wStepname.getText()}, new int[]{previewSize});
                progressDialog.open();
                Trans trans = progressDialog.getTrans();
                String loggingText = progressDialog.getLoggingText();
                if (!progressDialog.isCancelled() && trans.getResult() != null && trans.getResult().getNrErrors() > 0L) {
                    EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                    etd.setReadOnly();
                    etd.open();
                }
                PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, (VariableSpace)this.transMeta, 0, this.wStepname.getText(), progressDialog.getPreviewRowsMeta(this.wStepname.getText()), progressDialog.getPreviewRows(this.wStepname.getText()), loggingText);
                prd.open();
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), e);
        }
    }
}

