/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.trans.steps.xmlinput;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.vfs.FileObject;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.fileinput.FileInputList;
import org.pentaho.di.core.row.RowMeta;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaAndData;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.TransPreviewFactory;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.xmlinput.XMLInputField;
import org.pentaho.di.trans.steps.xmlinput.XMLInputFieldPosition;
import org.pentaho.di.trans.steps.xmlinput.XMLInputMeta;
import org.pentaho.di.ui.core.dialog.EnterNumberDialog;
import org.pentaho.di.ui.core.dialog.EnterSelectionDialog;
import org.pentaho.di.ui.core.dialog.EnterTextDialog;
import org.pentaho.di.ui.core.dialog.ErrorDialog;
import org.pentaho.di.ui.core.dialog.PreviewRowsDialog;
import org.pentaho.di.ui.core.widget.ColumnInfo;
import org.pentaho.di.ui.core.widget.TableView;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.trans.dialog.TransPreviewProgressDialog;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLInputDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = XMLInputMeta.class;
    private CTabFolder wTabFolder;
    private FormData fdTabFolder;
    private CTabItem wFileTab;
    private CTabItem wContentTab;
    private CTabItem wFieldsTab;
    private Composite wFileComp;
    private Composite wContentComp;
    private Composite wFieldsComp;
    private FormData fdFileComp;
    private FormData fdContentComp;
    private FormData fdFieldsComp;
    private Label wlFilename;
    private Button wbbFilename;
    private Button wbdFilename;
    private Button wbeFilename;
    private Button wbaFilename;
    private TextVar wFilename;
    private FormData fdlFilename;
    private FormData fdbFilename;
    private FormData fdbdFilename;
    private FormData fdbeFilename;
    private FormData fdbaFilename;
    private FormData fdFilename;
    private Label wlFilenameList;
    private TableView wFilenameList;
    private FormData fdlFilenameList;
    private FormData fdFilenameList;
    private Label wlFilemask;
    private Text wFilemask;
    private FormData fdlFilemask;
    private FormData fdFilemask;
    private Button wbShowFiles;
    private FormData fdbShowFiles;
    private Label wlInclFilename;
    private Button wInclFilename;
    private FormData fdlInclFilename;
    private FormData fdInclFilename;
    private Label wlInclFilenameField;
    private Text wInclFilenameField;
    private FormData fdlInclFilenameField;
    private FormData fdInclFilenameField;
    private Label wlInclRownum;
    private Button wInclRownum;
    private FormData fdlInclRownum;
    private FormData fdRownum;
    private Label wlInclRownumField;
    private Text wInclRownumField;
    private FormData fdlInclRownumField;
    private FormData fdInclRownumField;
    private Label wlLimit;
    private Text wLimit;
    private FormData fdlLimit;
    private FormData fdLimit;
    private Label wlSkip;
    private Text wSkip;
    private FormData fdlSkip;
    private FormData fdSkip;
    private Label wlFileBaseURI;
    private TextVar wFileBaseURI;
    private FormData fdlFileBaseURI;
    private FormData fdFileBaseURI;
    private Label wlIgnoreEntities;
    private Button wIgnoreEntities;
    private FormData fdlIgnoreEntities;
    private FormData fdIgnoreEntities;
    private Label wlNamespaceAware;
    private Button wNamespaceAware;
    private FormData fdlNamespaceAware;
    private FormData fdNamespaceAware;
    private Label wlPosition;
    private TableView wPosition;
    private FormData fdlPosition;
    private FormData fdPosition;
    private TableView wFields;
    private FormData fdFields;
    private XMLInputMeta input;
    public static final int[] dateLengths = new int[]{23, 19, 14, 10, 10, 10, 10, 8, 8, 8, 8, 6, 6};

    public XMLInputDialog(Shell parent, Object in, TransMeta transMeta, String sname) {
        super(parent, (BaseStepMeta)in, transMeta, sname);
        this.input = (XMLInputMeta)in;
    }

    public String open() {
        int x;
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (StepMetaInterface)this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XMLInputDialog.this.input.setChanged();
            }
        };
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"XMLInputDialog.DialogTitle", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText(BaseMessages.getString(PKG, (String)"System.Label.StepName", (String[])new String[0]));
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        this.props.setLook((Control)this.wTabFolder, 5);
        this.wFileTab = new CTabItem(this.wTabFolder, 0);
        this.wFileTab.setText(BaseMessages.getString(PKG, (String)"XMLInputDialog.File.Tab", (String[])new String[0]));
        this.wFileComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)this.wFileComp);
        FormLayout fileLayout = new FormLayout();
        fileLayout.marginWidth = 3;
        fileLayout.marginHeight = 3;
        this.wFileComp.setLayout((Layout)fileLayout);
        this.wlFilename = new Label(this.wFileComp, 131072);
        this.wlFilename.setText(BaseMessages.getString(PKG, (String)"XMLInputDialog.Filename.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFilename);
        this.fdlFilename = new FormData();
        this.fdlFilename.left = new FormAttachment(0, 0);
        this.fdlFilename.top = new FormAttachment(0, 0);
        this.fdlFilename.right = new FormAttachment(middle, -margin);
        this.wlFilename.setLayoutData((Object)this.fdlFilename);
        this.wbbFilename = new Button(this.wFileComp, 0x1000008);
        this.props.setLook((Control)this.wbbFilename);
        this.wbbFilename.setText(BaseMessages.getString(PKG, (String)"XMLInputDialog.FilenameBrowse.Button", (String[])new String[0]));
        this.wbbFilename.setToolTipText(BaseMessages.getString(PKG, (String)"System.Tooltip.BrowseForFileOrDirAndAdd", (String[])new String[0]));
        this.fdbFilename = new FormData();
        this.fdbFilename.right = new FormAttachment(100, 0);
        this.fdbFilename.top = new FormAttachment(0, 0);
        this.wbbFilename.setLayoutData((Object)this.fdbFilename);
        this.wbaFilename = new Button(this.wFileComp, 0x1000008);
        this.props.setLook((Control)this.wbaFilename);
        this.wbaFilename.setText(BaseMessages.getString(PKG, (String)"XMLInputDialog.FilenameAdd.Button", (String[])new String[0]));
        this.wbaFilename.setToolTipText(BaseMessages.getString(PKG, (String)"XMLInputDialog.FilenameAdd.Tooltip", (String[])new String[0]));
        this.fdbaFilename = new FormData();
        this.fdbaFilename.right = new FormAttachment((Control)this.wbbFilename, -margin);
        this.fdbaFilename.top = new FormAttachment(0, 0);
        this.wbaFilename.setLayoutData((Object)this.fdbaFilename);
        this.wFilename = new TextVar((VariableSpace)this.transMeta, this.wFileComp, 18436);
        this.props.setLook((Control)this.wFilename);
        this.wFilename.addModifyListener(lsMod);
        this.fdFilename = new FormData();
        this.fdFilename.left = new FormAttachment(middle, 0);
        this.fdFilename.right = new FormAttachment((Control)this.wbaFilename, -margin);
        this.fdFilename.top = new FormAttachment(0, 0);
        this.wFilename.setLayoutData(this.fdFilename);
        this.wlFilemask = new Label(this.wFileComp, 131072);
        this.wlFilemask.setText(BaseMessages.getString(PKG, (String)"XMLInputDialog.RegExp.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFilemask);
        this.fdlFilemask = new FormData();
        this.fdlFilemask.left = new FormAttachment(0, 0);
        this.fdlFilemask.top = new FormAttachment((Control)this.wFilename, margin);
        this.fdlFilemask.right = new FormAttachment(middle, -margin);
        this.wlFilemask.setLayoutData((Object)this.fdlFilemask);
        this.wFilemask = new Text(this.wFileComp, 18436);
        this.props.setLook((Control)this.wFilemask);
        this.wFilemask.addModifyListener(lsMod);
        this.fdFilemask = new FormData();
        this.fdFilemask.left = new FormAttachment(middle, 0);
        this.fdFilemask.top = new FormAttachment((Control)this.wFilename, margin);
        this.fdFilemask.right = new FormAttachment(100, 0);
        this.wFilemask.setLayoutData((Object)this.fdFilemask);
        this.wlFilenameList = new Label(this.wFileComp, 131072);
        this.wlFilenameList.setText(BaseMessages.getString(PKG, (String)"XMLInputDialog.FilenameList.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFilenameList);
        this.fdlFilenameList = new FormData();
        this.fdlFilenameList.left = new FormAttachment(0, 0);
        this.fdlFilenameList.top = new FormAttachment((Control)this.wFilemask, margin);
        this.fdlFilenameList.right = new FormAttachment(middle, -margin);
        this.wlFilenameList.setLayoutData((Object)this.fdlFilenameList);
        this.wbdFilename = new Button(this.wFileComp, 0x1000008);
        this.props.setLook((Control)this.wbdFilename);
        this.wbdFilename.setText(BaseMessages.getString(PKG, (String)"XMLInputDialog.FilenameRemove.Button", (String[])new String[0]));
        this.wbdFilename.setToolTipText(BaseMessages.getString(PKG, (String)"XMLInputDialog.FilenameRemove.Tooltip", (String[])new String[0]));
        this.fdbdFilename = new FormData();
        this.fdbdFilename.right = new FormAttachment(100, 0);
        this.fdbdFilename.top = new FormAttachment((Control)this.wFilemask, 40);
        this.wbdFilename.setLayoutData((Object)this.fdbdFilename);
        this.wbeFilename = new Button(this.wFileComp, 0x1000008);
        this.props.setLook((Control)this.wbeFilename);
        this.wbeFilename.setText(BaseMessages.getString(PKG, (String)"XMLInputDialog.FilenameEdit.Button", (String[])new String[0]));
        this.wbeFilename.setToolTipText(BaseMessages.getString(PKG, (String)"XMLInputDialog.FilenameEdit.Tooltip", (String[])new String[0]));
        this.fdbeFilename = new FormData();
        this.fdbeFilename.right = new FormAttachment(100, 0);
        this.fdbeFilename.top = new FormAttachment((Control)this.wbdFilename, margin);
        this.wbeFilename.setLayoutData((Object)this.fdbeFilename);
        this.wbShowFiles = new Button(this.wFileComp, 0x1000008);
        this.props.setLook((Control)this.wbShowFiles);
        this.wbShowFiles.setText(BaseMessages.getString(PKG, (String)"XMLInputDialog.ShowFiles.Button", (String[])new String[0]));
        this.fdbShowFiles = new FormData();
        this.fdbShowFiles.left = new FormAttachment(middle, 0);
        this.fdbShowFiles.bottom = new FormAttachment(100, 0);
        this.wbShowFiles.setLayoutData((Object)this.fdbShowFiles);
        ColumnInfo[] colinfo = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLInputDialog.Files.Filename.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLInputDialog.Files.Wildcard.Column", (String[])new String[0]), 1, false)};
        colinfo[0].setUsingVariables(true);
        colinfo[1].setToolTip(BaseMessages.getString(PKG, (String)"XMLInputDialog.Files.Wildcard.Tooltip", (String[])new String[0]));
        this.wFilenameList = new TableView((VariableSpace)this.transMeta, this.wFileComp, 67588, colinfo, 2, lsMod, this.props);
        this.props.setLook((Control)this.wFilenameList);
        this.fdFilenameList = new FormData();
        this.fdFilenameList.left = new FormAttachment(middle, 0);
        this.fdFilenameList.right = new FormAttachment((Control)this.wbdFilename, -margin);
        this.fdFilenameList.top = new FormAttachment((Control)this.wFilemask, margin);
        this.fdFilenameList.bottom = new FormAttachment((Control)this.wbShowFiles, -margin);
        this.wFilenameList.setLayoutData(this.fdFilenameList);
        this.fdFileComp = new FormData();
        this.fdFileComp.left = new FormAttachment(0, 0);
        this.fdFileComp.top = new FormAttachment(0, 0);
        this.fdFileComp.right = new FormAttachment(100, 0);
        this.fdFileComp.bottom = new FormAttachment(100, 0);
        this.wFileComp.setLayoutData((Object)this.fdFileComp);
        this.wFileComp.layout();
        this.wFileTab.setControl((Control)this.wFileComp);
        this.wContentTab = new CTabItem(this.wTabFolder, 0);
        this.wContentTab.setText(BaseMessages.getString(PKG, (String)"XMLInputDialog.Content.Tab", (String[])new String[0]));
        FormLayout contentLayout = new FormLayout();
        contentLayout.marginWidth = 3;
        contentLayout.marginHeight = 3;
        this.wContentComp = new Composite((Composite)this.wTabFolder, 0);
        this.props.setLook((Control)this.wContentComp);
        this.wContentComp.setLayout((Layout)contentLayout);
        this.wlInclFilename = new Label(this.wContentComp, 131072);
        this.wlInclFilename.setText(BaseMessages.getString(PKG, (String)"XMLInputDialog.InclFilename.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlInclFilename);
        this.fdlInclFilename = new FormData();
        this.fdlInclFilename.left = new FormAttachment(0, 0);
        this.fdlInclFilename.top = new FormAttachment(0, 0);
        this.fdlInclFilename.right = new FormAttachment(middle, -margin);
        this.wlInclFilename.setLayoutData((Object)this.fdlInclFilename);
        this.wInclFilename = new Button(this.wContentComp, 32);
        this.props.setLook((Control)this.wInclFilename);
        this.wInclFilename.setToolTipText(BaseMessages.getString(PKG, (String)"XMLInputDialog.InclFilename.Tooltip", (String[])new String[0]));
        this.fdInclFilename = new FormData();
        this.fdInclFilename.left = new FormAttachment(middle, 0);
        this.fdInclFilename.top = new FormAttachment(0, 0);
        this.wInclFilename.setLayoutData((Object)this.fdInclFilename);
        this.wlInclFilenameField = new Label(this.wContentComp, 16384);
        this.wlInclFilenameField.setText(BaseMessages.getString(PKG, (String)"XMLInputDialog.InclFilenameField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlInclFilenameField);
        this.fdlInclFilenameField = new FormData();
        this.fdlInclFilenameField.left = new FormAttachment((Control)this.wInclFilename, margin);
        this.fdlInclFilenameField.top = new FormAttachment(0, 0);
        this.wlInclFilenameField.setLayoutData((Object)this.fdlInclFilenameField);
        this.wInclFilenameField = new Text(this.wContentComp, 18436);
        this.props.setLook((Control)this.wInclFilenameField);
        this.wInclFilenameField.addModifyListener(lsMod);
        this.fdInclFilenameField = new FormData();
        this.fdInclFilenameField.left = new FormAttachment((Control)this.wlInclFilenameField, margin);
        this.fdInclFilenameField.top = new FormAttachment(0, 0);
        this.fdInclFilenameField.right = new FormAttachment(100, 0);
        this.wInclFilenameField.setLayoutData((Object)this.fdInclFilenameField);
        this.wlInclRownum = new Label(this.wContentComp, 131072);
        this.wlInclRownum.setText(BaseMessages.getString(PKG, (String)"XMLInputDialog.InclRownum.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlInclRownum);
        this.fdlInclRownum = new FormData();
        this.fdlInclRownum.left = new FormAttachment(0, 0);
        this.fdlInclRownum.top = new FormAttachment((Control)this.wInclFilenameField, margin);
        this.fdlInclRownum.right = new FormAttachment(middle, -margin);
        this.wlInclRownum.setLayoutData((Object)this.fdlInclRownum);
        this.wInclRownum = new Button(this.wContentComp, 32);
        this.props.setLook((Control)this.wInclRownum);
        this.wInclRownum.setToolTipText(BaseMessages.getString(PKG, (String)"XMLInputDialog.InclRownum.Tooltip", (String[])new String[0]));
        this.fdRownum = new FormData();
        this.fdRownum.left = new FormAttachment(middle, 0);
        this.fdRownum.top = new FormAttachment((Control)this.wInclFilenameField, margin);
        this.wInclRownum.setLayoutData((Object)this.fdRownum);
        this.wlInclRownumField = new Label(this.wContentComp, 131072);
        this.wlInclRownumField.setText(BaseMessages.getString(PKG, (String)"XMLInputDialog.InclRownumField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlInclRownumField);
        this.fdlInclRownumField = new FormData();
        this.fdlInclRownumField.left = new FormAttachment((Control)this.wInclRownum, margin);
        this.fdlInclRownumField.top = new FormAttachment((Control)this.wInclFilenameField, margin);
        this.wlInclRownumField.setLayoutData((Object)this.fdlInclRownumField);
        this.wInclRownumField = new Text(this.wContentComp, 18436);
        this.props.setLook((Control)this.wInclRownumField);
        this.wInclRownumField.addModifyListener(lsMod);
        this.fdInclRownumField = new FormData();
        this.fdInclRownumField.left = new FormAttachment((Control)this.wlInclRownumField, margin);
        this.fdInclRownumField.top = new FormAttachment((Control)this.wInclFilenameField, margin);
        this.fdInclRownumField.right = new FormAttachment(100, 0);
        this.wInclRownumField.setLayoutData((Object)this.fdInclRownumField);
        this.wlLimit = new Label(this.wContentComp, 131072);
        this.wlLimit.setText(BaseMessages.getString(PKG, (String)"XMLInputDialog.Limit.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlLimit);
        this.fdlLimit = new FormData();
        this.fdlLimit.left = new FormAttachment(0, 0);
        this.fdlLimit.top = new FormAttachment((Control)this.wInclRownumField, margin);
        this.fdlLimit.right = new FormAttachment(middle, -margin);
        this.wlLimit.setLayoutData((Object)this.fdlLimit);
        this.wLimit = new Text(this.wContentComp, 18436);
        this.props.setLook((Control)this.wLimit);
        this.wLimit.addModifyListener(lsMod);
        this.fdLimit = new FormData();
        this.fdLimit.left = new FormAttachment(middle, 0);
        this.fdLimit.top = new FormAttachment((Control)this.wInclRownumField, margin);
        this.fdLimit.right = new FormAttachment(100, 0);
        this.wLimit.setLayoutData((Object)this.fdLimit);
        this.wlSkip = new Label(this.wContentComp, 131072);
        this.wlSkip.setText(BaseMessages.getString(PKG, (String)"XMLInputDialog.Skip.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlSkip);
        this.fdlSkip = new FormData();
        this.fdlSkip.left = new FormAttachment(0, 0);
        this.fdlSkip.top = new FormAttachment((Control)this.wLimit, margin);
        this.fdlSkip.right = new FormAttachment(middle, -margin);
        this.wlSkip.setLayoutData((Object)this.fdlSkip);
        this.wSkip = new Text(this.wContentComp, 18436);
        this.props.setLook((Control)this.wSkip);
        this.wSkip.addModifyListener(lsMod);
        this.fdSkip = new FormData();
        this.fdSkip.left = new FormAttachment(middle, 0);
        this.fdSkip.top = new FormAttachment((Control)this.wLimit, margin);
        this.fdSkip.right = new FormAttachment(100, 0);
        this.wSkip.setLayoutData((Object)this.fdSkip);
        this.wlFileBaseURI = new Label(this.wContentComp, 131072);
        this.wlFileBaseURI.setText(BaseMessages.getString(PKG, (String)"XMLInputDialog.BaseURI.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlFileBaseURI);
        this.fdlFileBaseURI = new FormData();
        this.fdlFileBaseURI.left = new FormAttachment(0, 0);
        this.fdlFileBaseURI.top = new FormAttachment((Control)this.wSkip, margin);
        this.fdlFileBaseURI.right = new FormAttachment(middle, -margin);
        this.wlFileBaseURI.setLayoutData((Object)this.fdlFileBaseURI);
        this.wFileBaseURI = new TextVar((VariableSpace)this.transMeta, this.wContentComp, 18436);
        this.props.setLook((Control)this.wFileBaseURI);
        this.wFileBaseURI.addModifyListener(lsMod);
        this.fdFileBaseURI = new FormData();
        this.fdFileBaseURI.left = new FormAttachment(middle, 0);
        this.fdFileBaseURI.top = new FormAttachment((Control)this.wSkip, margin);
        this.fdFileBaseURI.right = new FormAttachment(100, 0);
        this.wFileBaseURI.setLayoutData(this.fdFileBaseURI);
        this.wlIgnoreEntities = new Label(this.wContentComp, 131072);
        this.wlIgnoreEntities.setText(BaseMessages.getString(PKG, (String)"XMLInputDialog.IgnoreEntities.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlIgnoreEntities);
        this.fdlIgnoreEntities = new FormData();
        this.fdlIgnoreEntities.left = new FormAttachment(0, 0);
        this.fdlIgnoreEntities.top = new FormAttachment((Control)this.wFileBaseURI, margin);
        this.fdlIgnoreEntities.right = new FormAttachment(middle, -margin);
        this.wlIgnoreEntities.setLayoutData((Object)this.fdlIgnoreEntities);
        this.wIgnoreEntities = new Button(this.wContentComp, 32);
        this.props.setLook((Control)this.wIgnoreEntities);
        this.wIgnoreEntities.setToolTipText(BaseMessages.getString(PKG, (String)"XMLInputDialog.IgnoreEntities.Tooltip", (String[])new String[0]));
        this.fdIgnoreEntities = new FormData();
        this.fdIgnoreEntities.left = new FormAttachment(middle, 0);
        this.fdIgnoreEntities.top = new FormAttachment((Control)this.wFileBaseURI, margin);
        this.wIgnoreEntities.setLayoutData((Object)this.fdIgnoreEntities);
        this.wlNamespaceAware = new Label(this.wContentComp, 131072);
        this.wlNamespaceAware.setText(BaseMessages.getString(PKG, (String)"XMLInputDialog.NamespaceAware.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlNamespaceAware);
        this.fdlNamespaceAware = new FormData();
        this.fdlNamespaceAware.left = new FormAttachment(0, 0);
        this.fdlNamespaceAware.top = new FormAttachment((Control)this.wIgnoreEntities, margin);
        this.fdlNamespaceAware.right = new FormAttachment(middle, -margin);
        this.wlNamespaceAware.setLayoutData((Object)this.fdlNamespaceAware);
        this.wNamespaceAware = new Button(this.wContentComp, 32);
        this.props.setLook((Control)this.wNamespaceAware);
        this.wNamespaceAware.setToolTipText(BaseMessages.getString(PKG, (String)"XMLInputDialog.NamespaceAware.Tooltip", (String[])new String[0]));
        this.fdNamespaceAware = new FormData();
        this.fdNamespaceAware.left = new FormAttachment(middle, 0);
        this.fdNamespaceAware.top = new FormAttachment((Control)this.wIgnoreEntities, margin);
        this.wNamespaceAware.setLayoutData((Object)this.fdNamespaceAware);
        this.wlPosition = new Label(this.wContentComp, 131072);
        this.wlPosition.setText(BaseMessages.getString(PKG, (String)"XMLInputDialog.Location.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlPosition);
        this.fdlPosition = new FormData();
        this.fdlPosition.left = new FormAttachment(0, 0);
        this.fdlPosition.top = new FormAttachment((Control)this.wNamespaceAware, margin * 3);
        this.fdlPosition.right = new FormAttachment(middle, -margin);
        this.wlPosition.setLayoutData((Object)this.fdlPosition);
        ColumnInfo[] locationColumns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLInputDialog.Position.Elements.Column", (String[])new String[0]), 1, false)};
        int nrElements = this.input.getInputPosition() != null ? this.input.getInputPosition().length : 0;
        this.wPosition = new TableView((VariableSpace)this.transMeta, this.wContentComp, 65538, locationColumns, nrElements, lsMod, this.props);
        this.wPosition.addModifyListener(lsMod);
        this.fdPosition = new FormData();
        this.fdPosition.left = new FormAttachment(middle, 0);
        this.fdPosition.top = new FormAttachment((Control)this.wNamespaceAware, margin * 3);
        this.fdPosition.bottom = new FormAttachment(100, -50);
        this.fdPosition.right = new FormAttachment(100, 0);
        this.wPosition.setLayoutData(this.fdPosition);
        this.fdContentComp = new FormData();
        this.fdContentComp.left = new FormAttachment(0, 0);
        this.fdContentComp.top = new FormAttachment(0, 0);
        this.fdContentComp.right = new FormAttachment(100, 0);
        this.fdContentComp.bottom = new FormAttachment(100, 0);
        this.wContentComp.setLayoutData((Object)this.fdContentComp);
        this.wContentComp.layout();
        this.wContentTab.setControl((Control)this.wContentComp);
        this.wFieldsTab = new CTabItem(this.wTabFolder, 0);
        this.wFieldsTab.setText(BaseMessages.getString(PKG, (String)"XMLInputDialog.Fields.Tab", (String[])new String[0]));
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginWidth = 5;
        fieldsLayout.marginHeight = 5;
        this.wFieldsComp = new Composite((Composite)this.wTabFolder, 0);
        this.wFieldsComp.setLayout((Layout)fieldsLayout);
        this.props.setLook((Control)this.wFieldsComp);
        this.wGet = new Button(this.wFieldsComp, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"XMLInputDialog.GetFields.Button", (String[])new String[0]));
        this.fdGet = new FormData();
        this.fdGet.left = new FormAttachment(50, 0);
        this.fdGet.bottom = new FormAttachment(100, 0);
        this.wGet.setLayoutData((Object)this.fdGet);
        int FieldsRows = this.input.getInputFields().length;
        String[] dats = Const.getDateFormats();
        String[] nums = Const.getNumberFormats();
        int totsize = dats.length + nums.length;
        String[] formats = new String[totsize];
        for (x = 0; x < dats.length; ++x) {
            formats[x] = dats[x];
        }
        for (x = 0; x < nums.length; ++x) {
            formats[dats.length + x] = nums[x];
        }
        ColumnInfo[] colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLInputDialog.FieldsTable.Name.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLInputDialog.FieldsTable.Type.Column", (String[])new String[0]), 2, ValueMeta.getTypes(), true), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLInputDialog.FieldsTable.Format.Column", (String[])new String[0]), 2, formats), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLInputDialog.FieldsTable.Length.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLInputDialog.FieldsTable.Precision.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLInputDialog.FieldsTable.Currency.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLInputDialog.FieldsTable.Decimal.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLInputDialog.FieldsTable.Group.Column", (String[])new String[0]), 1, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLInputDialog.FieldsTable.TrimType.Column", (String[])new String[0]), 2, XMLInputField.trimTypeDesc, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLInputDialog.FieldsTable.Repeat.Column", (String[])new String[0]), 2, new String[]{BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0])}, true), new ColumnInfo(BaseMessages.getString(PKG, (String)"XMLInputDialog.FieldsTable.Position.Column", (String[])new String[0]), 1, false)};
        this.wFields = new TableView((VariableSpace)this.transMeta, this.wFieldsComp, 65538, colinf, FieldsRows, lsMod, this.props);
        this.fdFields = new FormData();
        this.fdFields.left = new FormAttachment(0, 0);
        this.fdFields.top = new FormAttachment(0, 0);
        this.fdFields.right = new FormAttachment(100, 0);
        this.fdFields.bottom = new FormAttachment((Control)this.wGet, -margin);
        this.wFields.setLayoutData(this.fdFields);
        this.fdFieldsComp = new FormData();
        this.fdFieldsComp.left = new FormAttachment(0, 0);
        this.fdFieldsComp.top = new FormAttachment(0, 0);
        this.fdFieldsComp.right = new FormAttachment(100, 0);
        this.fdFieldsComp.bottom = new FormAttachment(100, 0);
        this.wFieldsComp.setLayoutData((Object)this.fdFieldsComp);
        this.wFieldsComp.layout();
        this.wFieldsTab.setControl((Control)this.wFieldsComp);
        this.fdTabFolder = new FormData();
        this.fdTabFolder.left = new FormAttachment(0, 0);
        this.fdTabFolder.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdTabFolder.right = new FormAttachment(100, 0);
        this.fdTabFolder.bottom = new FormAttachment(100, -50);
        this.wTabFolder.setLayoutData((Object)this.fdTabFolder);
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"XMLInputDialog.Button.PreviewRows", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOK, this.wPreview, this.wCancel}, margin, (Control)this.wTabFolder);
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                XMLInputDialog.this.ok();
            }
        };
        this.lsGet = new Listener(){

            public void handleEvent(Event e) {
                XMLInputDialog.this.get();
            }
        };
        this.lsPreview = new Listener(){

            public void handleEvent(Event e) {
                XMLInputDialog.this.preview();
            }
        };
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                XMLInputDialog.this.cancel();
            }
        };
        this.wOK.addListener(13, this.lsOK);
        this.wGet.addListener(13, this.lsGet);
        this.wPreview.addListener(13, this.lsPreview);
        this.wCancel.addListener(13, this.lsCancel);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                XMLInputDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wLimit.addSelectionListener((SelectionListener)this.lsDef);
        this.wInclRownumField.addSelectionListener((SelectionListener)this.lsDef);
        this.wInclFilenameField.addSelectionListener((SelectionListener)this.lsDef);
        this.wIgnoreEntities.addSelectionListener((SelectionListener)this.lsDef);
        this.wNamespaceAware.addSelectionListener((SelectionListener)this.lsDef);
        SelectionAdapter selA = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                XMLInputDialog.this.wFilenameList.add(XMLInputDialog.this.wFilename.getText(), XMLInputDialog.this.wFilemask.getText());
                XMLInputDialog.this.wFilename.setText("");
                XMLInputDialog.this.wFilemask.setText("");
                XMLInputDialog.this.wFilenameList.removeEmptyRows();
                XMLInputDialog.this.wFilenameList.setRowNums();
                XMLInputDialog.this.wFilenameList.optWidth(true);
            }
        };
        this.wbaFilename.addSelectionListener((SelectionListener)selA);
        this.wFilename.addSelectionListener(selA);
        this.wbdFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int[] idx = XMLInputDialog.this.wFilenameList.getSelectionIndices();
                XMLInputDialog.this.wFilenameList.remove(idx);
                XMLInputDialog.this.wFilenameList.removeEmptyRows();
                XMLInputDialog.this.wFilenameList.setRowNums();
            }
        });
        this.wbeFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                int idx = XMLInputDialog.this.wFilenameList.getSelectionIndex();
                if (idx >= 0) {
                    String[] string = XMLInputDialog.this.wFilenameList.getItem(idx);
                    XMLInputDialog.this.wFilename.setText(string[0]);
                    XMLInputDialog.this.wFilemask.setText(string[1]);
                    XMLInputDialog.this.wFilenameList.remove(idx);
                }
                XMLInputDialog.this.wFilenameList.removeEmptyRows();
                XMLInputDialog.this.wFilenameList.setRowNums();
            }
        });
        this.wbShowFiles.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    XMLInputMeta tfii = new XMLInputMeta();
                    XMLInputDialog.this.getInfo(tfii);
                    FileInputList fileInputList = tfii.getFiles((VariableSpace)XMLInputDialog.this.transMeta);
                    String[] files = fileInputList.getFileStrings();
                    if (files != null && files.length > 0) {
                        EnterSelectionDialog esd = new EnterSelectionDialog(XMLInputDialog.this.shell, files, BaseMessages.getString((Class)PKG, (String)"XMLInputDialog.FilesReadSelection.DialogTitle", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"XMLInputDialog.FilesReadSelection.DialogMessage", (String[])new String[0]));
                        esd.setViewOnly();
                        esd.open();
                    } else {
                        MessageBox mb = new MessageBox(XMLInputDialog.this.shell, 33);
                        mb.setMessage(BaseMessages.getString((Class)PKG, (String)"XMLInputDialog.NoFileFound.DialogMessage", (String[])new String[0]));
                        mb.setText(BaseMessages.getString((Class)PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
                        mb.open();
                    }
                }
                catch (KettleException ex) {
                    new ErrorDialog(XMLInputDialog.this.shell, BaseMessages.getString((Class)PKG, (String)"XMLInputDialog.ErrorParsingData.DialogTitle", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"XMLInputDialog.ErrorParsingData.DialogMessage", (String[])new String[0]), (Exception)((Object)ex));
                }
            }
        });
        this.wInclFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLInputDialog.this.setIncludeFilename();
            }
        });
        this.wInclRownum.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                XMLInputDialog.this.setIncludeRownum();
            }
        });
        this.wFilename.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XMLInputDialog.this.wFilename.setToolTipText(XMLInputDialog.this.transMeta.environmentSubstitute(XMLInputDialog.this.wFilename.getText()));
            }
        });
        this.wbbFilename.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (XMLInputDialog.this.wFilemask.getText() != null && XMLInputDialog.this.wFilemask.getText().length() > 0) {
                    DirectoryDialog dialog = new DirectoryDialog(XMLInputDialog.this.shell, 4096);
                    if (XMLInputDialog.this.wFilename.getText() != null) {
                        String fpath = XMLInputDialog.this.transMeta.environmentSubstitute(XMLInputDialog.this.wFilename.getText());
                        dialog.setFilterPath(fpath);
                    }
                    if (dialog.open() != null) {
                        String str = dialog.getFilterPath();
                        XMLInputDialog.this.wFilename.setText(str);
                    }
                } else {
                    FileDialog dialog = new FileDialog(XMLInputDialog.this.shell, 4096);
                    dialog.setFilterExtensions(new String[]{"*.xml;*.XML", "*"});
                    if (XMLInputDialog.this.wFilename.getText() != null) {
                        String fname = XMLInputDialog.this.transMeta.environmentSubstitute(XMLInputDialog.this.wFilename.getText());
                        dialog.setFileName(fname);
                    }
                    dialog.setFilterNames(new String[]{BaseMessages.getString((Class)PKG, (String)"System.FileType.XMLFiles", (String[])new String[0]), BaseMessages.getString((Class)PKG, (String)"System.FileType.AllFiles", (String[])new String[0])});
                    if (dialog.open() != null) {
                        String str = dialog.getFilterPath() + System.getProperty("file.separator") + dialog.getFileName();
                        XMLInputDialog.this.wFilename.setText(str);
                    }
                }
            }
        });
        this.wFileBaseURI.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                XMLInputDialog.this.wFileBaseURI.setToolTipText(XMLInputDialog.this.transMeta.environmentSubstitute(XMLInputDialog.this.wFileBaseURI.getText()));
            }
        });
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                XMLInputDialog.this.cancel();
            }
        });
        this.wTabFolder.setSelection(0);
        this.setSize();
        this.getData(this.input);
        this.input.setChanged(this.changed);
        this.wFields.optWidth(true);
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void setMultiple() {
    }

    public void setIncludeFilename() {
        this.wlInclFilenameField.setEnabled(this.wInclFilename.getSelection());
        this.wInclFilenameField.setEnabled(this.wInclFilename.getSelection());
    }

    public void setIncludeRownum() {
        this.wlInclRownumField.setEnabled(this.wInclRownum.getSelection());
        this.wInclRownumField.setEnabled(this.wInclRownum.getSelection());
    }

    public void getData(XMLInputMeta in) {
        int i;
        if (in.getFileName() != null) {
            this.wFilenameList.removeAll();
            for (i = 0; i < in.getFileName().length; ++i) {
                this.wFilenameList.add(in.getFileName()[i], in.getFileMask()[i]);
            }
            this.wFilenameList.removeEmptyRows();
            this.wFilenameList.setRowNums();
            this.wFilenameList.optWidth(true);
        }
        this.wInclFilename.setSelection(in.includeFilename());
        this.wInclRownum.setSelection(in.includeRowNumber());
        if (in.getFilenameField() != null) {
            this.wInclFilenameField.setText(in.getFilenameField());
        }
        if (in.getRowNumberField() != null) {
            this.wInclRownumField.setText(in.getRowNumberField());
        }
        this.wLimit.setText("" + in.getRowLimit());
        this.wSkip.setText("" + in.getNrRowsToSkip());
        if (in.getFileBaseURI() != null) {
            this.wFileBaseURI.setText(in.getFileBaseURI());
        }
        this.wIgnoreEntities.setSelection(in.isIgnoreEntities());
        this.wNamespaceAware.setSelection(in.isNamespaceAware());
        this.logDebug(BaseMessages.getString(PKG, (String)"XMLInputDialog.Log.GettingFieldsInfo", (String[])new String[0]));
        for (i = 0; i < in.getInputFields().length; ++i) {
            String rep;
            XMLInputField field = in.getInputFields()[i];
            if (field == null) continue;
            TableItem item = this.wFields.table.getItem(i);
            String name = field.getName();
            String type = field.getTypeDesc();
            String format = field.getFormat();
            String length = "" + field.getLength();
            String prec = "" + field.getPrecision();
            String curr = field.getCurrencySymbol();
            String group = field.getGroupSymbol();
            String decim = field.getDecimalSymbol();
            String trim = field.getTrimTypeDesc();
            String string = rep = field.isRepeated() ? BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]) : BaseMessages.getString(PKG, (String)"System.Combo.No", (String[])new String[0]);
            if (name != null) {
                item.setText(1, name);
            }
            if (type != null) {
                item.setText(2, type);
            }
            if (format != null) {
                item.setText(3, format);
            }
            if (length != null && !"-1".equals(length)) {
                item.setText(4, length);
            }
            if (prec != null && !"-1".equals(prec)) {
                item.setText(5, prec);
            }
            if (curr != null) {
                item.setText(6, curr);
            }
            if (decim != null) {
                item.setText(7, decim);
            }
            if (group != null) {
                item.setText(8, group);
            }
            if (trim != null) {
                item.setText(9, trim);
            }
            if (rep != null) {
                item.setText(10, rep);
            }
            item.setText(11, field.getFieldPositionsCode());
        }
        for (i = 0; i < this.input.getInputPosition().length; ++i) {
            TableItem item = this.wPosition.table.getItem(i);
            if (this.input.getInputPosition()[i] == null) continue;
            item.setText(1, this.input.getInputPosition()[i]);
        }
        this.wFields.removeEmptyRows();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wPosition.removeEmptyRows();
        this.wPosition.setRowNums();
        this.wPosition.optWidth(true);
        this.setMultiple();
        this.setIncludeFilename();
        this.setIncludeRownum();
        this.wStepname.selectAll();
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Const.isEmpty((String)this.wStepname.getText())) {
            return;
        }
        try {
            this.getInfo(this.input);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"XMLInputDialog.ErrorParsingData.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"XMLInputDialog.ErrorParsingData.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
        this.dispose();
    }

    private void getInfo(XMLInputMeta in) throws KettleException {
        int i;
        this.stepname = this.wStepname.getText();
        in.setRowLimit(Const.toLong((String)this.wLimit.getText(), (long)0L));
        in.setNrRowsToSkip(Const.toInt((String)this.wSkip.getText(), (int)0));
        in.setFilenameField(this.wInclFilenameField.getText());
        in.setRowNumberField(this.wInclRownumField.getText());
        in.setIncludeFilename(this.wInclFilename.getSelection());
        in.setIncludeRowNumber(this.wInclRownum.getSelection());
        in.setFileBaseURI(this.wFileBaseURI.getText());
        in.setIgnoreEntities(this.wIgnoreEntities.getSelection());
        in.setNamespaceAware(this.wNamespaceAware.getSelection());
        int nrFiles = this.wFilenameList.getItemCount();
        int nrFields = this.wFields.nrNonEmpty();
        int nrPositions = this.wPosition.nrNonEmpty();
        in.allocate(nrFiles, nrFields, nrPositions);
        in.setFileName(this.wFilenameList.getItems(0));
        in.setFileMask(this.wFilenameList.getItems(1));
        for (i = 0; i < nrFields; ++i) {
            XMLInputField field = new XMLInputField();
            TableItem item = this.wFields.getNonEmpty(i);
            field.setName(item.getText(1));
            field.setType(ValueMeta.getType((String)item.getText(2)));
            field.setFormat(item.getText(3));
            field.setLength(Const.toInt((String)item.getText(4), (int)-1));
            field.setPrecision(Const.toInt((String)item.getText(5), (int)-1));
            field.setCurrencySymbol(item.getText(6));
            field.setDecimalSymbol(item.getText(7));
            field.setGroupSymbol(item.getText(8));
            field.setTrimType(XMLInputField.getTrimTypeByDesc((String)item.getText(9)));
            field.setRepeated(BaseMessages.getString(PKG, (String)"System.Combo.Yes", (String[])new String[0]).equalsIgnoreCase(item.getText(10)));
            field.setFieldPosition(item.getText(11));
            in.getInputFields()[i] = field;
        }
        for (i = 0; i < nrPositions; ++i) {
            TableItem item = this.wPosition.getNonEmpty(i);
            in.getInputPosition()[i] = item.getText(1);
        }
    }

    private boolean checkInputPositionsFilled(XMLInputMeta meta) {
        if (meta.getInputPosition() == null || meta.getInputPosition().length < 1) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"XMLInputDialog.SpecifyRepeatingElement.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString(PKG, (String)"System.Dialog.Error.Title", (String[])new String[0]));
            mb.open();
            return false;
        }
        return true;
    }

    private void get() {
        boolean finished = false;
        int elementsFound = 0;
        try {
            XMLInputMeta meta = new XMLInputMeta();
            this.getInfo(meta);
            if (!this.checkInputPositionsFilled(meta)) {
                return;
            }
            EnterNumberDialog dialog = new EnterNumberDialog(this.shell, 1000, "Number of elements to scan", "Enter the number of elements to scan (0=all)");
            int maxElements = dialog.open();
            RowMeta row = new RowMeta();
            ArrayList<XMLInputFieldPosition> path = new ArrayList<XMLInputFieldPosition>();
            FileInputList inputList = meta.getFiles((VariableSpace)this.transMeta);
            for (int f = 0; f < inputList.getFiles().size() && !finished; ++f) {
                Node rootNode = XMLHandler.loadXMLFile((FileObject)inputList.getFile(f), (String)this.transMeta.environmentSubstitute(meta.getFileBaseURI()), (boolean)meta.isIgnoreEntities(), (boolean)meta.isNamespaceAware());
                for (int p = 0; rootNode != null && p < meta.getInputPosition().length - 1; ++p) {
                    rootNode = XMLHandler.getSubNode((Node)rootNode, (String)meta.getInputPosition()[p]);
                }
                if (rootNode == null) {
                    return;
                }
                if (meta.getInputPosition().length > 1) {
                    String itemElement = meta.getInputPosition()[meta.getInputPosition().length - 1];
                    int nrItems = XMLHandler.countNodes((Node)rootNode, (String)itemElement);
                    for (int i = 0; i < nrItems && !finished; ++i) {
                        Node itemNode = XMLHandler.getSubNodeByNr((Node)rootNode, (String)itemElement, (int)i, (boolean)false);
                        if (i < meta.getNrRowsToSkip()) continue;
                        this.getValues(itemNode, (RowMetaInterface)row, path, 0);
                        if (++elementsFound < maxElements || maxElements <= 0) continue;
                        finished = true;
                    }
                    continue;
                }
                this.getValues(rootNode, (RowMetaInterface)row, path, 0);
                if (++elementsFound < maxElements || maxElements <= 0) continue;
                finished = true;
            }
            for (int i = 0; i < row.size(); ++i) {
                ValueMetaInterface v = row.getValueMeta(i);
                TableItem item = new TableItem(this.wFields.table, 0);
                item.setText(1, v.getName());
                item.setText(2, v.getTypeDesc());
                item.setText(11, v.getOrigin());
            }
            this.wFields.removeEmptyRows();
            this.wFields.setRowNums();
            this.wFields.optWidth(true);
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"XMLInputDialog.ErrorParsingData.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"XMLInputDialog.ErrorParsingData.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
    }

    private void getValues(Node node, RowMetaInterface row, List<XMLInputFieldPosition> path, int level) throws KettleException {
        String[] elements;
        String[] attributes;
        String encoded;
        String baseName = "";
        for (int p = 0; p < path.size(); ++p) {
            XMLInputFieldPosition pos = path.get(p);
            String elementName = pos.getName() + pos.getElementNr();
            if (elementName.startsWith("#")) continue;
            baseName = baseName + StringUtil.initCap((String)new ValueMetaAndData("p", (Object)elementName).toString());
        }
        if (level == 0 && XMLHandler.getNodeValue((Node)node) != null) {
            XMLInputFieldPosition attrPos = new XMLInputFieldPosition(node.getNodeName(), 3);
            path.add(attrPos);
            String root = StringUtil.initCap((String)new ValueMetaAndData("a", (Object)node.getNodeName()).toString());
            String fieldName = baseName + root;
            if (row.searchValueMeta(fieldName) == null) {
                ValueMeta field = new ValueMeta(fieldName, 2);
                encoded = XMLInputFieldPosition.encodePath(path);
                field.setOrigin(encoded);
                row.addValueMeta((ValueMetaInterface)field);
            }
            path.remove(path.size() - 1);
        }
        if ((attributes = XMLHandler.getNodeAttributes((Node)node)) != null) {
            for (int i = 0; i < attributes.length; ++i) {
                XMLInputFieldPosition attrPos = new XMLInputFieldPosition(attributes[i], 2);
                path.add(attrPos);
                String attribute = StringUtil.initCap((String)new ValueMetaAndData("a", (Object)attributes[i]).toString());
                String fieldName = baseName + attribute;
                if (row.searchValueMeta(fieldName) == null) {
                    ValueMeta field = new ValueMeta(fieldName, 2);
                    String encoded2 = XMLInputFieldPosition.encodePath(path);
                    field.setOrigin(encoded2);
                    row.addValueMeta((ValueMetaInterface)field);
                }
                path.remove(path.size() - 1);
            }
        }
        if ((elements = XMLHandler.getNodeElements((Node)node)) != null) {
            for (int e = 0; e < elements.length; ++e) {
                int occurrences = XMLHandler.countNodes((Node)node, (String)elements[e]);
                for (int o = 0; o < occurrences; ++o) {
                    Node itemNode = XMLHandler.getSubNodeByNr((Node)node, (String)elements[e], (int)o, (boolean)false);
                    XMLInputFieldPosition xmlPos = new XMLInputFieldPosition(elements[e], 1, o + 1);
                    path.add(xmlPos);
                    this.getValues(itemNode, row, path, level + 1);
                    path.remove(path.size() - 1);
                }
            }
        } else if (path.size() > 0) {
            int idxLast = path.size() - 1;
            XMLInputFieldPosition last = path.get(idxLast);
            path.remove(idxLast);
            if (path.size() > 0) {
                encoded = XMLInputFieldPosition.encodePath(path);
                if (row.searchValueMeta(baseName) == null) {
                    ValueMeta value = new ValueMeta(baseName, 2);
                    value.setOrigin(encoded);
                    row.addValueMeta((ValueMetaInterface)value);
                }
            }
            path.add(last);
        }
    }

    private void preview() {
        try {
            XMLInputMeta oneMeta = new XMLInputMeta();
            this.getInfo(oneMeta);
            if (!this.checkInputPositionsFilled(oneMeta)) {
                return;
            }
            TransMeta previewMeta = TransPreviewFactory.generatePreviewTransformation((VariableSpace)this.transMeta, (StepMetaInterface)oneMeta, (String)this.wStepname.getText());
            EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"XMLInputDialog.NumberRows.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"XMLInputDialog.NumberRows.DialogMessage", (String[])new String[0]));
            int previewSize = numberDialog.open();
            if (previewSize > 0) {
                TransPreviewProgressDialog progressDialog = new TransPreviewProgressDialog(this.shell, previewMeta, new String[]{this.wStepname.getText()}, new int[]{previewSize});
                progressDialog.open();
                if (!progressDialog.isCancelled()) {
                    Trans trans = progressDialog.getTrans();
                    String loggingText = progressDialog.getLoggingText();
                    if (trans.getResult() != null && trans.getResult().getNrErrors() > 0L) {
                        EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                        etd.setReadOnly();
                        etd.open();
                    }
                    PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, (VariableSpace)this.transMeta, 0, this.wStepname.getText(), progressDialog.getPreviewRowsMeta(this.wStepname.getText()), progressDialog.getPreviewRows(this.wStepname.getText()), loggingText);
                    prd.open();
                }
            }
        }
        catch (KettleException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"XMLInputDialog.ErrorPreviewingData.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"XMLInputDialog.ErrorPreviewingData.DialogMessage", (String[])new String[0]), (Exception)((Object)e));
        }
    }
}

