/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Iterator;
import java.util.List;
import org.pentaho.di.TestFailedException;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.StepPluginType;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.dummytrans.DummyTransMeta;
import org.pentaho.di.trans.steps.injector.InjectorMeta;
import org.pentaho.di.trans.steps.sort.SortRowsMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestUtilities {
    private static final String DATE_FORMAT_NOW = "yyyy-MM-dd HH:mm:ss";

    public static String getEndOfLineCharacters() {
        return TestUtilities.getFileFormat().equalsIgnoreCase("DOS") ? "\r\n" : "\n";
    }

    public static String getFileFormat() {
        if (System.getProperty("os.name").startsWith("Windows")) {
            return "DOS";
        }
        return "Unix";
    }

    public static void checkRows(List<RowMetaAndData> rows1, List<RowMetaAndData> rows2) throws TestFailedException {
        TestUtilities.checkRows(rows1, rows2, -1);
    }

    public static void checkRows(List<RowMetaAndData> rows1, List<RowMetaAndData> rows2, int fileNameColumn) throws TestFailedException {
        int idx = 1;
        if (rows1.size() != rows2.size()) {
            throw new TestFailedException("Number of rows is not the same: " + rows1.size() + " and " + rows2.size());
        }
        Iterator<RowMetaAndData> itrRows1 = rows1.iterator();
        Iterator<RowMetaAndData> itrRows2 = rows2.iterator();
        while (itrRows1.hasNext() && itrRows2.hasNext()) {
            RowMetaAndData rowMetaAndData1 = itrRows1.next();
            RowMetaAndData rowMetaAndData2 = itrRows2.next();
            RowMetaInterface rowMetaInterface1 = rowMetaAndData1.getRowMeta();
            Object[] rowObject1 = rowMetaAndData1.getData();
            Object[] rowObject2 = rowMetaAndData2.getData();
            if (rowMetaAndData1.size() != rowMetaAndData2.size()) {
                throw new TestFailedException("row number " + idx + " is not equal");
            }
            int[] fields = new int[rowMetaInterface1.size()];
            for (int ydx = 0; ydx < rowMetaInterface1.size(); ++ydx) {
                fields[ydx] = ydx;
            }
            if (fileNameColumn > 0) {
                try {
                    rowObject1[fileNameColumn] = rowObject2[fileNameColumn];
                    if (rowMetaAndData1.getRowMeta().compare(rowObject1, rowObject2, fields) != 0) {
                        throw new TestFailedException("row nr " + idx + " is not equal");
                    }
                }
                catch (KettleValueException e) {
                    throw new TestFailedException("row nr " + idx + " is not equal");
                }
            }
            ++idx;
        }
    }

    public static synchronized StepMeta createDummyStep(String name, PluginRegistry pluginRegistry) {
        DummyTransMeta dummyTransMeta = new DummyTransMeta();
        String dummyPid = pluginRegistry.getPluginId(StepPluginType.class, (Object)dummyTransMeta);
        StepMeta dummyStep = new StepMeta(dummyPid, name, (StepMetaInterface)dummyTransMeta);
        return dummyStep;
    }

    public static synchronized StepMeta createInjectorStep(String name, PluginRegistry pluginRegistry) {
        InjectorMeta injectorMeta = new InjectorMeta();
        String injectorPid = pluginRegistry.getPluginId(StepPluginType.class, (Object)injectorMeta);
        StepMeta injectorStep = new StepMeta(injectorPid, name, (StepMetaInterface)injectorMeta);
        return injectorStep;
    }

    public static synchronized String createEmptyTempFile(String fileName) throws IOException {
        return TestUtilities.createEmptyTempFile(fileName, null);
    }

    public static synchronized String createEmptyTempFile(String fileName, String suffix) throws IOException {
        File tempFile = File.createTempFile(fileName, Const.isEmpty((String)suffix) ? "" : suffix);
        tempFile.deleteOnExit();
        return tempFile.getAbsolutePath();
    }

    public static synchronized String createTempFolder(String folderName) {
        String absoluteFolderPath = System.getProperty("java.io.tmpdir") + "/" + folderName + "_" + System.currentTimeMillis();
        if (new File(absoluteFolderPath).mkdir()) {
            return absoluteFolderPath;
        }
        return null;
    }

    public static String now() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat sdf = new SimpleDateFormat(DATE_FORMAT_NOW);
        return sdf.format(cal.getTime());
    }

    public static String writeTextFile(String folderName, String fileName, String delimiter) throws IOException {
        String absolutePath = null;
        File file = new File(folderName + "/" + fileName + ".txt");
        absolutePath = file.getAbsolutePath();
        String endOfLineCharacters = TestUtilities.getEndOfLineCharacters();
        FileWriter fout = new FileWriter(file);
        fout.write("A" + delimiter + "B" + delimiter + "C" + delimiter + "D" + delimiter + "E" + endOfLineCharacters);
        fout.write("1" + delimiter + "b1" + delimiter + "c1" + delimiter + "d1" + delimiter + "e1" + endOfLineCharacters);
        fout.write("2" + delimiter + "b2" + delimiter + "c2" + delimiter + "d2" + delimiter + "e2" + endOfLineCharacters);
        fout.write("3" + delimiter + "b3" + delimiter + "c3" + delimiter + "d3" + delimiter + "e3" + endOfLineCharacters);
        fout.close();
        return absolutePath;
    }

    public static synchronized StepMeta createSortRowsStep(String name, String[] sortFields, boolean[] ascending, boolean[] caseSensitive, String directory, int sortSize, PluginRegistry pluginRegistry) {
        SortRowsMeta sortRowsMeta = new SortRowsMeta();
        sortRowsMeta.setSortSize(Integer.toString(sortSize / 10));
        sortRowsMeta.setFieldName(sortFields);
        sortRowsMeta.setAscending(ascending);
        sortRowsMeta.setCaseSensitive(caseSensitive);
        sortRowsMeta.setDirectory(directory);
        String sortRowsStepPid = pluginRegistry.getPluginId(StepPluginType.class, (Object)sortRowsMeta);
        StepMeta sortRowsStep = new StepMeta(sortRowsStepPid, name, (StepMetaInterface)sortRowsMeta);
        return sortRowsStep;
    }
}

