/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.blackbox;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.CentralLogStore;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.GlobalMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class BlackBoxTests {
    private File transFile;
    private List<File> expectedFiles;
    private static ArrayList<Object> allTests;

    public BlackBoxTests(File transFile, List<File> expectedFiles) {
        this.transFile = transFile;
        this.expectedFiles = expectedFiles;
    }

    @BeforeClass
    public static void setupBlackbox() {
        GlobalMessages.setLocale((Locale)EnvUtil.createLocale((String)"en-US"));
        CentralLogStore.init((int)0, (int)60);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getTests() {
        allTests = new ArrayList();
        File dir = new File("testfiles/blackbox/tests");
        Assert.assertTrue((boolean)dir.exists());
        Assert.assertTrue((boolean)dir.isDirectory());
        BlackBoxTests.processDirectory(dir);
        Object[][] d = new Object[allTests.size()][2];
        for (int i = 0; i < allTests.size(); ++i) {
            Object[] params = (Object[])allTests.get(i);
            d[i][0] = params[0];
            d[i][1] = params[1];
        }
        return Arrays.asList(d);
    }

    protected static void processDirectory(File dir) {
        int i;
        File[] files = dir.listFiles();
        for (i = 0; i < files.length; ++i) {
            if (!files[i].isDirectory()) continue;
            BlackBoxTests.processDirectory(files[i]);
        }
        for (i = 0; i < files.length; ++i) {
            if (!files[i].isFile()) continue;
            String name = files[i].getName();
            if (name.endsWith(".ktr") && !name.endsWith("-tmp.ktr")) {
                List<File> expected = BlackBoxTests.getExpectedOutputFile(dir, name.substring(0, name.length() - 4));
                Object[] params = new Object[]{files[i], expected};
                allTests.add(params);
                continue;
            }
            if (!name.endsWith(".kjb")) continue;
            System.out.println("JOBS NOT YET HANDLED: " + name);
        }
    }

    protected static List<File> getExpectedOutputFile(File dir, String baseName) {
        ArrayList<File> files = new ArrayList<File>();
        File expected = new File(dir, baseName + ".fail.txt");
        if (expected.exists()) {
            files.add(expected);
        }
        for (String extension : new String[]{".txt", ".csv", ".xml"}) {
            expected = new File(dir, baseName + ".expected" + extension);
            if (expected.exists()) {
                files.add(expected);
            }
            boolean found = true;
            int nr = 0;
            while (found) {
                expected = new File(dir, baseName + ".expected_" + nr + extension);
                if (expected.exists()) {
                    files.add(expected);
                    ++nr;
                    continue;
                }
                found = false;
            }
        }
        return files;
    }

    @Test
    public void runTransOrJob() throws Exception {
        LogChannel log = new LogChannel((Object)("BlackBoxTest [" + this.transFile.toString() + "]"));
        Result result = new Result();
        if (!this.transFile.exists()) {
            log.logError("Transformation does not exist: " + this.getPath(this.transFile));
            this.addFailure("Transformation does not exist: " + this.getPath(this.transFile));
            Assert.fail((String)("Transformation does not exist: " + this.getPath(this.transFile)));
        }
        if (this.expectedFiles.isEmpty()) {
            this.addFailure("No expected output files found: " + this.getPath(this.transFile));
            Assert.fail((String)("No expected output files found: " + this.getPath(this.transFile)));
        }
        result = this.runTrans(this.transFile.getAbsolutePath(), (LogChannelInterface)log);
        for (int i = 0; i < this.expectedFiles.size(); ++i) {
            File expected = this.expectedFiles.get(i);
            if (!expected.getAbsoluteFile().toString().contains(".expected")) continue;
            String actualFile = expected.getAbsolutePath();
            actualFile = actualFile.replaceFirst(".expected_" + i + ".", ".actual_" + i + ".");
            actualFile = actualFile.replaceFirst(".expected.", ".actual.");
            File actual = new File(actualFile);
            if (!result.getResult()) continue;
            this.fileCompare(expected, actual, (LogChannelInterface)log);
        }
        if (!result.getResult()) {
            String logStr = CentralLogStore.getAppender().getBuffer(result.getLogChannelId(), true).toString();
            if (this.expectedFiles.size() == 0) {
                Assert.fail((String)("Error running " + this.getPath(this.transFile) + ":" + logStr));
            }
        }
    }

    public void writeLog(File logFile, String logStr) {
        try {
            FileOutputStream stream = new FileOutputStream(logFile);
            int length = logStr.length();
            int pos = 0;
            while (pos < length) {
                String details;
                String line = null;
                int eol = logStr.indexOf("\r\n", pos);
                if (eol != -1) {
                    line = logStr.substring(pos, eol);
                    pos = eol + 2;
                } else {
                    eol = logStr.indexOf("\n", pos);
                    if (eol != -1) {
                        line = logStr.substring(pos, eol);
                        pos = eol + 1;
                    } else {
                        line = logStr.substring(pos);
                        pos = length;
                    }
                }
                if (line == null) continue;
                line = line.substring(22);
                String subject = "";
                int idx = line.indexOf(" - ");
                if (idx != -1) {
                    subject = line.substring(0, idx);
                }
                if ((idx = line.indexOf(" : ", idx)) == -1 || (details = line.substring(idx + 3)).startsWith("\tat ") || details.startsWith("\t... ")) continue;
                ((OutputStream)stream).write((subject + " : " + details + "\r\n").getBytes("UTF-8"));
            }
            ((OutputStream)stream).close();
        }
        catch (Exception e) {
            this.addFailure("Could not write to log file: " + logFile.getAbsolutePath());
        }
    }

    public String getPath(File file) {
        return this.getPath(file.getAbsolutePath());
    }

    public String getPath(String filepath) {
        int idx = filepath.indexOf("/testfiles/");
        if (idx == -1) {
            idx = filepath.indexOf("\\testfiles\\");
        }
        if (idx != -1) {
            return filepath.substring(idx + 1);
        }
        return filepath;
    }

    public void fileCompare(File expected, File actual, LogChannelInterface log) throws IOException {
        FileInputStream expectedStream = new FileInputStream(expected);
        FileInputStream actualStream = new FileInputStream(actual);
        int goldPos = 0;
        int tmpPos = 0;
        byte[] goldBuffer = new byte[2048];
        byte[] tmpBuffer = new byte[2048];
        try {
            goldPos = ((InputStream)expectedStream).read(goldBuffer);
            tmpPos = ((InputStream)actualStream).read(tmpBuffer);
            int lineno = 1;
            int charno = 0;
            int indexGold = 0;
            int indexTmp = 0;
            int totalGold = goldPos;
            int totalTmp = tmpPos;
            while (goldPos > 0 && tmpPos > 0) {
                if (indexGold == goldPos) {
                    goldPos = ((InputStream)expectedStream).read(goldBuffer);
                    if (goldPos > 0) {
                        totalGold += goldPos;
                    }
                    indexGold = 0;
                }
                if (indexTmp == tmpPos) {
                    tmpPos = ((InputStream)actualStream).read(tmpBuffer);
                    if (tmpPos > 0) {
                        totalTmp += tmpPos;
                    }
                    indexTmp = 0;
                }
                if (goldPos < 0 || tmpPos < 0) break;
                ++charno;
                if (goldBuffer[indexGold] != tmpBuffer[indexTmp]) {
                    int start = indexTmp > 10 ? indexTmp - 10 : 0;
                    int end = indexTmp < tmpBuffer.length - 11 ? indexTmp + 10 : tmpBuffer.length - 1;
                    int offset = indexTmp - start;
                    byte[] bytes = new byte[offset];
                    System.arraycopy(tmpBuffer, start, bytes, 0, bytes.length);
                    String frag = "-->" + new String(bytes);
                    frag = frag + "[" + (char)tmpBuffer[indexTmp] + "]";
                    bytes = new byte[end - start - offset];
                    System.arraycopy(tmpBuffer, start + offset + 1, bytes, 0, bytes.length);
                    frag = frag + new String(bytes);
                    frag = frag + "<--";
                    String exp = goldBuffer[indexGold] < 32 ? "\\" + (char)(goldBuffer[indexGold] - 97) : "" + (char)goldBuffer[indexGold];
                    String act = tmpBuffer[indexTmp] < 32 ? "\\" + (char)(tmpBuffer[indexTmp] - 97) : "" + (char)tmpBuffer[indexTmp];
                    String message = "Test files (" + this.getPath(actual) + ") differ at: line " + lineno + " char " + charno + " expecting '" + exp + "' but found '" + act + "' - " + frag;
                    this.addFailure(message);
                    log.logError("BlackBoxTest", new Object[]{message});
                    Assert.fail((String)message);
                } else if (tmpBuffer[indexTmp] == 10) {
                    ++lineno;
                    charno = 0;
                }
                ++indexGold;
                ++indexTmp;
            }
            if (totalGold != totalTmp) {
                String message = "Comparison files are not same length. Expected=" + expected.getPath() + " (" + totalGold + ") " + "Actual=" + actual.getPath() + " (" + totalTmp + ")";
                this.addFailure(message);
                Assert.fail((String)message);
            }
        }
        catch (Exception e) {
            this.addFailure("Error trying to compare output files: " + this.getPath(actual));
            e.printStackTrace();
            Assert.fail((String)("Error trying to compare output files: " + this.getPath(actual)));
        }
    }

    public Result runTrans(String fileName, LogChannelInterface log) throws KettleException {
        Result result = new Result();
        KettleEnvironment.init();
        Trans trans = null;
        TransMeta transMeta = new TransMeta();
        try {
            transMeta = new TransMeta(fileName);
            trans = new Trans(transMeta);
            trans.setLogLevel(LogLevel.ERROR);
            result = trans.getResult();
        }
        catch (Exception e) {
            result = trans.getResult();
            trans = null;
            transMeta = null;
            String message = "Processing has stopped because of an error: " + this.getPath(fileName);
            this.addFailure(message);
            log.logError(message, (Throwable)e);
            Assert.fail((String)message);
            return result;
        }
        try {
            trans.initializeVariablesFrom(null);
            trans.getTransMeta().setInternalKettleVariables((VariableSpace)trans);
            trans.setSafeModeEnabled(true);
            ArrayList remarks = new ArrayList();
            trans.getTransMeta().checkSteps(remarks, false, null);
            for (CheckResultInterface remark : remarks) {
                if (remark.getType() != 4) continue;
                this.addFailure("Check error: " + this.getPath(fileName) + ", " + remark.getErrorCode());
                log.logError("BlackBoxTest", new Object[]{"Check error: " + this.getPath(fileName) + ", " + remark.getErrorCode()});
            }
            try {
                trans.execute(null);
            }
            catch (Exception e) {
                this.addFailure("Unable to prepare and initialize this transformation: " + this.getPath(fileName));
                log.logError("BlackBoxTest", new Object[]{"Unable to prepare and initialize this transformation: " + this.getPath(fileName)});
                Assert.fail((String)("Unable to prepare and initialize this transformation: " + this.getPath(fileName)));
                return null;
            }
            trans.waitUntilFinished();
            result = trans.getResult();
            result.setResult(result.getNrErrors() == 0L);
            return result;
        }
        catch (Exception e) {
            this.addFailure("Unexpected error occurred: " + this.getPath(fileName));
            log.logError("BlackBoxTest", new Object[]{"Unexpected error occurred: " + this.getPath(fileName), e});
            result.setResult(false);
            result.setNrErrors(1L);
            Assert.fail((String)("Unexpected error occurred: " + this.getPath(fileName)));
            return result;
        }
    }

    protected void addFailure(String message) {
        System.err.println("failure: " + message);
    }
}

