/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.cluster;

import java.nio.charset.Charset;
import java.util.Arrays;
import junit.framework.TestCase;
import org.pentaho.di.cluster.ClusterGenerator;
import org.pentaho.di.cluster.ClusterSchema;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.CentralLogStore;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransMeta;

public class BaseCluster
extends TestCase {
    public static TransExecutionConfiguration createClusteredTransExecutionConfiguration() {
        TransExecutionConfiguration config = new TransExecutionConfiguration();
        config.setExecutingClustered(true);
        config.setExecutingLocally(false);
        config.setExecutingRemotely(false);
        config.setClusterPosting(true);
        config.setClusterPreparing(true);
        config.setClusterStarting(true);
        config.setLogLevel(LogLevel.MINIMAL);
        return config;
    }

    public TransMeta loadAndModifyTestTransformation(ClusterGenerator clusterGenerator, String filename) throws KettleException {
        TransMeta transMeta = new TransMeta(filename);
        for (SlaveServer slaveServer : ClusterGenerator.LOCAL_TEST_SLAVES) {
            transMeta.getSlaveServers().add(slaveServer);
        }
        ClusterSchema clusterSchema = transMeta.findClusterSchema("test-cluster");
        BaseCluster.assertNotNull((String)"Cluster schema 'test-cluster' couldn't be found", (Object)clusterSchema);
        clusterSchema.getSlaveServers().clear();
        clusterSchema.getSlaveServers().addAll(Arrays.asList(ClusterGenerator.LOCAL_TEST_SLAVES));
        return transMeta;
    }

    protected void init() throws Exception {
        KettleEnvironment.init();
        CentralLogStore.init((int)5000, (int)60);
    }

    public static String loadFileContent(VariableSpace space, String filename) throws Exception {
        String realFilename = space.environmentSubstitute(filename);
        return KettleVFS.getTextFileContent((String)realFilename, (String)Charset.defaultCharset().name());
    }

    protected void assertEqualsIgnoreWhitespaces(String expected, String two) {
        String oneStripped = this.stripWhiteSpaces(expected);
        String twoStripped = this.stripWhiteSpaces(two);
        BaseCluster.assertEquals((String)oneStripped, (String)twoStripped);
    }

    protected void assertEqualsIgnoreWhitespacesAndCase(String expected, String actual) {
        this.assertEqualsIgnoreWhitespaces(expected.toUpperCase(), actual.toUpperCase());
    }

    private String stripWhiteSpaces(String one) {
        StringBuilder stripped = new StringBuilder();
        boolean previousWhiteSpace = false;
        for (char c : one.toCharArray()) {
            if (Character.isWhitespace(c)) {
                if (!previousWhiteSpace) {
                    stripped.append(' ');
                }
                previousWhiteSpace = true;
                continue;
            }
            if (c == '(' || c == ')' || c == '|' || c == '-' || c == '+' || c == '/' || c == '*' || c == '{' || c == '}' || c == ',') {
                int lastIndex = stripped.length() - 1;
                if (stripped.charAt(lastIndex) == ' ') {
                    stripped.deleteCharAt(lastIndex);
                }
                previousWhiteSpace = true;
            } else {
                previousWhiteSpace = false;
            }
            stripped.append(c);
        }
        if (stripped.length() > 0 && Character.isWhitespace(stripped.charAt(0))) {
            stripped.deleteCharAt(0);
        }
        if (stripped.length() > 0 && Character.isWhitespace(stripped.charAt(stripped.length() - 1))) {
            stripped.deleteCharAt(stripped.length() - 1);
        }
        return stripped.toString();
    }
}

