/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.cluster;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.pentaho.di.cluster.CarteLauncher;
import org.pentaho.di.cluster.ClusterSchema;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.www.Carte;

public class ClusterGenerator {
    public static final String TEST_CLUSTER_NAME = "test-cluster";
    public static final SlaveServer[] LOCAL_TEST_SLAVES = new SlaveServer[]{new SlaveServer("test-localhost-8585-master", "127.0.0.1", "8585", "cluster", "cluster", null, null, null, true), new SlaveServer("test-localhost-8586-slave", "127.0.0.1", "8586", "cluster", "cluster", null, null, null, false), new SlaveServer("test-localhost-8587-slave", "127.0.0.1", "8587", "cluster", "cluster", null, null, null, false), new SlaveServer("test-localhost-8588-slave", "127.0.0.1", "8588", "cluster", "cluster", null, null, null, false)};
    private ClusterSchema clusterSchema = new ClusterSchema();
    private List<Carte> carteList;

    public ClusterGenerator() throws KettleException {
        this.clusterSchema.setName(TEST_CLUSTER_NAME);
        this.clusterSchema.getSlaveServers().addAll(Arrays.asList(LOCAL_TEST_SLAVES));
        this.clusterSchema.setSocketsCompressed(false);
        this.clusterSchema.setBasePort("40000");
        this.clusterSchema.setSocketsBufferSize("2000");
        this.clusterSchema.setSocketsFlushInterval("5000");
        this.carteList = new ArrayList<Carte>();
    }

    public void launchSlaveServers() throws Exception {
        for (SlaveServer slaveServer : LOCAL_TEST_SLAVES) {
            String hostname = slaveServer.getHostname();
            int port = Const.toInt((String)slaveServer.getPort(), (int)80);
            CarteLauncher launcher = new CarteLauncher(hostname, port);
            Thread thread = new Thread(launcher);
            thread.setName("Carte Launcher" + thread.getName());
            thread.start();
            while (launcher.getCarte() == null && !launcher.isFailure()) {
                Thread.sleep(100L);
            }
            if (launcher.getCarte() != null) {
                this.carteList.add(launcher.getCarte());
            }
            if (!launcher.isFailure()) continue;
            this.stopSlaveServers();
            throw launcher.getException();
        }
    }

    public void stopSlaveServers() throws Exception {
        for (Carte carte : this.carteList) {
            carte.getWebServer().stopServer();
        }
    }

    public ClusterSchema getClusterSchema() {
        return this.clusterSchema;
    }

    public void setClusterSchema(ClusterSchema clusterSchema) {
        this.clusterSchema = clusterSchema;
    }
}

