/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.cluster;

import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.pentaho.di.cluster.BaseCluster;
import org.pentaho.di.cluster.ClusterGenerator;
import org.pentaho.di.cluster.ClusterSchema;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.cluster.TransSplitter;

public class MasterSlaveTest
extends BaseCluster {
    ClusterGenerator clusterGenerator;

    protected void setUp() throws Exception {
        this.init();
        this.clusterGenerator = new ClusterGenerator();
        this.clusterGenerator.launchSlaveServers();
    }

    protected void tearDown() throws Exception {
        this.clusterGenerator.stopSlaveServers();
    }

    public void testAll() throws Exception {
        this.runAllocatePorts();
        int ITERATIONS = 2;
        for (int i = 0; i < 2; ++i) {
            this.runParallelFileReadOnMaster();
            this.runParallelFileReadOnMasterWithCopies();
            this.runParallelFileReadOnSlaves();
            this.runParallelFileReadOnSlavesWithPartitioning();
            this.runParallelFileReadOnSlavesWithPartitioning2();
            this.runMultipleCopiesOnMultipleSlaves();
            this.runMultipleCopiesOnMultipleSlaves2();
            this.runOneStepClustered();
        }
    }

    public void runAllocatePorts() throws Exception {
        ClusterSchema clusterSchema = this.clusterGenerator.getClusterSchema();
        SlaveServer master = clusterSchema.findMaster();
        List slaves = clusterSchema.getSlaveServersFromMasterOrLocal();
        String clusteredRunId = UUID.randomUUID().toString();
        SlaveServer slave1 = (SlaveServer)slaves.get(0);
        SlaveServer slave2 = (SlaveServer)slaves.get(1);
        SlaveServer slave3 = (SlaveServer)slaves.get(2);
        int port1 = master.allocateServerSocket(clusteredRunId, 40000, "localhost", "trans1", master.getName(), "A", "0", slave1.getName(), "B", "0");
        MasterSlaveTest.assertEquals((int)40000, (int)port1);
        int port1b = master.allocateServerSocket(clusteredRunId, 40000, "localhost", "trans1", master.getName(), "A", "0", slave1.getName(), "B", "0");
        MasterSlaveTest.assertEquals((int)port1, (int)port1b);
        int port2 = master.allocateServerSocket(clusteredRunId, 40000, "localhost", "trans1", master.getName(), "A", "0", slave2.getName(), "B", "0");
        MasterSlaveTest.assertEquals((int)40001, (int)port2);
        int port3 = master.allocateServerSocket(clusteredRunId, 40000, "localhost", "trans1", master.getName(), "A", "0", slave3.getName(), "B", "0");
        MasterSlaveTest.assertEquals((int)40002, (int)port3);
        master.deAllocateServerSockets("trans1", clusteredRunId);
        port1 = master.allocateServerSocket(clusteredRunId, 40000, "localhost", "trans2", master.getName(), "A", "0", slave1.getName(), "B", "0");
        MasterSlaveTest.assertEquals((int)40000, (int)port1);
        master.deAllocateServerSockets("trans2", clusteredRunId);
    }

    public void runParallelFileReadOnMaster() throws Exception {
        TransMeta transMeta = MasterSlaveTest.loadTransMetaReplaceSlavesInCluster(this.clusterGenerator, "test/org/pentaho/di/cluster/test-parallel-file-read-on-master.ktr");
        TransExecutionConfiguration config = MasterSlaveTest.createClusteredTransExecutionConfiguration();
        TransSplitter transSplitter = Trans.executeClustered((TransMeta)transMeta, (TransExecutionConfiguration)config);
        LogChannel logChannel = MasterSlaveTest.createLogChannel("cluster unit test <testParallelFileReadOnMaster>");
        long nrErrors = Trans.monitorClusteredTransformation((LogChannelInterface)logChannel, (TransSplitter)transSplitter, null, (int)1);
        MasterSlaveTest.assertEquals((long)0L, (long)nrErrors);
        String result = MasterSlaveTest.loadFileContent((VariableSpace)transMeta, "${java.io.tmpdir}/test-parallel-file-read-on-master-result.txt");
        this.assertEqualsIgnoreWhitespacesAndCase("100", result);
    }

    private static LogChannel createLogChannel(String string) {
        LogChannel logChannel = new LogChannel((Object)string);
        logChannel.setLogLevel(LogLevel.BASIC);
        return logChannel;
    }

    public void runParallelFileReadOnMasterWithCopies() throws Exception {
        TransMeta transMeta = MasterSlaveTest.loadTransMetaReplaceSlavesInCluster(this.clusterGenerator, "test/org/pentaho/di/cluster/test-parallel-file-read-on-master-with-copies.ktr");
        TransExecutionConfiguration config = MasterSlaveTest.createClusteredTransExecutionConfiguration();
        TransSplitter transSplitter = Trans.executeClustered((TransMeta)transMeta, (TransExecutionConfiguration)config);
        LogChannel logChannel = MasterSlaveTest.createLogChannel("cluster unit test <runParallelFileReadOnMasterWithCopies>");
        long nrErrors = Trans.monitorClusteredTransformation((LogChannelInterface)logChannel, (TransSplitter)transSplitter, null, (int)1);
        MasterSlaveTest.assertEquals((long)0L, (long)nrErrors);
        String result = MasterSlaveTest.loadFileContent((VariableSpace)transMeta, "${java.io.tmpdir}/test-parallel-file-read-on-master-result-with-copies.txt");
        this.assertEqualsIgnoreWhitespacesAndCase("100", result);
    }

    public void runParallelFileReadOnSlaves() throws Exception {
        TransMeta transMeta = MasterSlaveTest.loadTransMetaReplaceSlavesInCluster(this.clusterGenerator, "test/org/pentaho/di/cluster/test-parallel-file-read-on-slaves.ktr");
        TransExecutionConfiguration config = MasterSlaveTest.createClusteredTransExecutionConfiguration();
        TransSplitter transSplitter = Trans.executeClustered((TransMeta)transMeta, (TransExecutionConfiguration)config);
        LogChannel logChannel = MasterSlaveTest.createLogChannel("cluster unit test <runParallelFileReadOnSlaves>");
        long nrErrors = Trans.monitorClusteredTransformation((LogChannelInterface)logChannel, (TransSplitter)transSplitter, null, (int)1);
        MasterSlaveTest.assertEquals((long)0L, (long)nrErrors);
        String result = MasterSlaveTest.loadFileContent((VariableSpace)transMeta, "${java.io.tmpdir}/test-parallel-file-read-on-slaves.txt");
        this.assertEqualsIgnoreWhitespacesAndCase("100", result);
    }

    public void runParallelFileReadOnSlavesWithPartitioning() throws Exception {
        TransMeta transMeta = MasterSlaveTest.loadTransMetaReplaceSlavesInCluster(this.clusterGenerator, "test/org/pentaho/di/cluster/test-parallel-file-read-on-slaves-with-partitioning.ktr");
        TransExecutionConfiguration config = MasterSlaveTest.createClusteredTransExecutionConfiguration();
        TransSplitter transSplitter = Trans.executeClustered((TransMeta)transMeta, (TransExecutionConfiguration)config);
        LogChannel logChannel = MasterSlaveTest.createLogChannel("cluster unit test <runParallelFileReadOnSlavesWithPartitioning>");
        long nrErrors = Trans.monitorClusteredTransformation((LogChannelInterface)logChannel, (TransSplitter)transSplitter, null, (int)1);
        MasterSlaveTest.assertEquals((long)0L, (long)nrErrors);
        String result = MasterSlaveTest.loadFileContent((VariableSpace)transMeta, "${java.io.tmpdir}/test-parallel-file-read-on-slaves-with-partitioning.txt");
        this.assertEqualsIgnoreWhitespacesAndCase("100", result);
    }

    public void runParallelFileReadOnSlavesWithPartitioning2() throws Exception {
        TransMeta transMeta = MasterSlaveTest.loadTransMetaReplaceSlavesInCluster(this.clusterGenerator, "test/org/pentaho/di/cluster/test-parallel-file-read-on-slaves-with-partitioning2.ktr");
        TransExecutionConfiguration config = MasterSlaveTest.createClusteredTransExecutionConfiguration();
        TransSplitter transSplitter = Trans.executeClustered((TransMeta)transMeta, (TransExecutionConfiguration)config);
        LogChannel logChannel = MasterSlaveTest.createLogChannel("cluster unit test <runParallelFileReadOnSlavesWithPartitioning2>");
        long nrErrors = Trans.monitorClusteredTransformation((LogChannelInterface)logChannel, (TransSplitter)transSplitter, null, (int)1);
        MasterSlaveTest.assertEquals((long)0L, (long)nrErrors);
        String result = MasterSlaveTest.loadFileContent((VariableSpace)transMeta, "${java.io.tmpdir}/test-parallel-file-read-on-slaves-with-partitioning2.txt");
        this.assertEqualsIgnoreWhitespacesAndCase("100", result);
    }

    public void runMultipleCopiesOnMultipleSlaves2() throws Exception {
        TransMeta transMeta = MasterSlaveTest.loadTransMetaReplaceSlavesInCluster(this.clusterGenerator, "test/org/pentaho/di/cluster/test-hops-between-multiple-copies-steps-on-cluster.ktr");
        TransExecutionConfiguration config = MasterSlaveTest.createClusteredTransExecutionConfiguration();
        TransSplitter transSplitter = Trans.executeClustered((TransMeta)transMeta, (TransExecutionConfiguration)config);
        LogChannel logChannel = MasterSlaveTest.createLogChannel("cluster unit test <runMultipleCopiesOnMultipleSlaves2>");
        long nrErrors = Trans.monitorClusteredTransformation((LogChannelInterface)logChannel, (TransSplitter)transSplitter, null, (int)1);
        MasterSlaveTest.assertEquals((long)0L, (long)nrErrors);
        String result = MasterSlaveTest.loadFileContent((VariableSpace)transMeta, "${java.io.tmpdir}/test-multiple-copies-on-multiple-slaves2.txt");
        this.assertEqualsIgnoreWhitespacesAndCase("90000", result);
    }

    public void runMultipleCopiesOnMultipleSlaves() throws Exception {
        TransMeta transMeta = MasterSlaveTest.loadTransMetaReplaceSlavesInCluster(this.clusterGenerator, "test/org/pentaho/di/cluster/test-multiple-copies-on-multiple-slaves.ktr");
        TransExecutionConfiguration config = MasterSlaveTest.createClusteredTransExecutionConfiguration();
        TransSplitter transSplitter = Trans.executeClustered((TransMeta)transMeta, (TransExecutionConfiguration)config);
        LogChannel logChannel = MasterSlaveTest.createLogChannel("cluster unit test <testMultipleCopiesOnMultipleSlaves>");
        long nrErrors = Trans.monitorClusteredTransformation((LogChannelInterface)logChannel, (TransSplitter)transSplitter, null, (int)1);
        MasterSlaveTest.assertEquals((long)0L, (long)nrErrors);
        String result = MasterSlaveTest.loadFileContent((VariableSpace)transMeta, "${java.io.tmpdir}/test-multiple-copies-on-multiple-slaves.txt");
        this.assertEqualsIgnoreWhitespacesAndCase("100", result);
    }

    public void runOneStepClustered() throws Exception {
        TransMeta transMeta = MasterSlaveTest.loadTransMetaReplaceSlavesInCluster(this.clusterGenerator, "test/org/pentaho/di/cluster/one-step-clustered.ktr");
        TransExecutionConfiguration config = MasterSlaveTest.createClusteredTransExecutionConfiguration();
        TransSplitter transSplitter = Trans.executeClustered((TransMeta)transMeta, (TransExecutionConfiguration)config);
        LogChannel logChannel = MasterSlaveTest.createLogChannel("cluster unit test <runOneStepClustered>");
        long nrErrors = Trans.monitorClusteredTransformation((LogChannelInterface)logChannel, (TransSplitter)transSplitter, null, (int)1);
        MasterSlaveTest.assertEquals((long)0L, (long)nrErrors);
        String result = MasterSlaveTest.loadFileContent((VariableSpace)transMeta, "${java.io.tmpdir}/one-step-clustered.txt");
        this.assertEqualsIgnoreWhitespacesAndCase("10000", result);
    }

    private static TransMeta loadTransMetaReplaceSlavesInCluster(ClusterGenerator clusterGenerator, String testFilename) throws KettleException {
        TransMeta transMeta = new TransMeta(testFilename);
        for (SlaveServer slaveServer : ClusterGenerator.LOCAL_TEST_SLAVES) {
            transMeta.getSlaveServers().add(slaveServer);
        }
        ClusterSchema clusterSchema = transMeta.findClusterSchema("test-cluster");
        MasterSlaveTest.assertNotNull((String)"Cluster schema 'test-cluster' couldn't be found", (Object)clusterSchema);
        clusterSchema.getSlaveServers().clear();
        clusterSchema.getSlaveServers().addAll(Arrays.asList(ClusterGenerator.LOCAL_TEST_SLAVES));
        return transMeta;
    }
}

