/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.cluster;

import org.apache.commons.vfs.FileObject;
import org.pentaho.di.cluster.BaseCluster;
import org.pentaho.di.cluster.ClusterGenerator;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransExecutionConfiguration;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.cluster.TransSplitter;

public class PartitioningTest
extends BaseCluster {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPartitioningSwimmingLanesOnCluster() throws Exception {
        this.init();
        ClusterGenerator clusterGenerator = new ClusterGenerator();
        try {
            clusterGenerator.launchSlaveServers();
            TransMeta transMeta = this.loadAndModifyTestTransformation(clusterGenerator, "test/org/pentaho/di/cluster/partitioning-swimming-lanes-on-cluster.ktr");
            TransExecutionConfiguration config = PartitioningTest.createClusteredTransExecutionConfiguration();
            TransSplitter transSplitter = Trans.executeClustered((TransMeta)transMeta, (TransExecutionConfiguration)config);
            long nrErrors = Trans.monitorClusteredTransformation((LogChannelInterface)new LogChannel((Object)"cluster unit test <testParallelFileReadOnMaster>"), (TransSplitter)transSplitter, null, (int)1);
            PartitioningTest.assertEquals((long)0L, (long)nrErrors);
            String[] results = new String[]{"8", "9", "9", "9", "9", "8", "8", "8", "8", "8", "8", "8"};
            String[] files = new String[]{"000", "001", "002", "003", "004", "005", "006", "007", "008", "009", "010", "011"};
            for (int i = 0; i < results.length; ++i) {
                String filename = "${java.io.tmpdir}/partitioning-swimming-lanes-on-cluster-" + files[i] + ".txt";
                String result = PartitioningTest.loadFileContent((VariableSpace)transMeta, filename);
                this.assertEqualsIgnoreWhitespacesAndCase(results[i], result);
                FileObject file = KettleVFS.getFileObject((String)transMeta.environmentSubstitute(filename));
                file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            PartitioningTest.fail((String)e.toString());
        }
        finally {
            try {
                clusterGenerator.stopSlaveServers();
            }
            catch (Exception e) {
                e.printStackTrace();
                PartitioningTest.fail((String)e.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPartitioningRepartitioningOnCluster() throws Exception {
        this.init();
        ClusterGenerator clusterGenerator = new ClusterGenerator();
        try {
            clusterGenerator.launchSlaveServers();
            TransMeta transMeta = this.loadAndModifyTestTransformation(clusterGenerator, "test/org/pentaho/di/cluster/partitioning-repartitioning-on-cluster.ktr");
            TransExecutionConfiguration config = PartitioningTest.createClusteredTransExecutionConfiguration();
            TransSplitter transSplitter = Trans.executeClustered((TransMeta)transMeta, (TransExecutionConfiguration)config);
            long nrErrors = Trans.monitorClusteredTransformation((LogChannelInterface)new LogChannel((Object)"cluster unit test <testParallelFileReadOnMaster>"), (TransSplitter)transSplitter, null, (int)1);
            PartitioningTest.assertEquals((long)0L, (long)nrErrors);
            String[] results = new String[]{"8", "9", "9", "9", "9", "8", "8", "8", "8", "8", "8", "8"};
            String[] files = new String[]{"000", "001", "002", "003", "004", "005", "006", "007", "008", "009", "010", "011"};
            for (int i = 0; i < results.length; ++i) {
                String filename = "${java.io.tmpdir}/partitioning-repartitioning-on-cluster-" + files[i] + ".txt";
                String result = PartitioningTest.loadFileContent((VariableSpace)transMeta, filename);
                this.assertEqualsIgnoreWhitespacesAndCase(results[i], result);
                FileObject file = KettleVFS.getFileObject((String)transMeta.environmentSubstitute(filename));
                file.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            PartitioningTest.fail((String)e.toString());
        }
        finally {
            try {
                clusterGenerator.stopSlaveServers();
            }
            catch (Exception e) {
                e.printStackTrace();
                PartitioningTest.fail((String)e.toString());
            }
        }
    }
}

