/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.cluster;

import java.io.File;
import java.util.UUID;
import junit.framework.TestCase;
import org.pentaho.di.cluster.CarteLauncher;
import org.pentaho.di.core.KettleEnvironment;
import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.logging.CentralLogStore;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingObjectType;
import org.pentaho.di.core.logging.SimpleLoggingObject;
import org.pentaho.di.www.SlaveSequence;
import org.pentaho.di.www.SlaveServerConfig;

public class SlaveSequenceTest
extends TestCase {
    private LoggingObjectInterface loggingObject;

    protected void init() throws Exception {
        KettleEnvironment.init();
        CentralLogStore.init((int)5000, (int)60);
        this.loggingObject = new SimpleLoggingObject("SlaveSequenceTest", LoggingObjectType.GENERAL, null);
    }

    public void testSlaveSequenceRetrieval_Specifed() throws Exception {
        this.init();
        String SLAVE_SEQUENCE_NAME = "test";
        SlaveServerConfig slaveConfig = new SlaveServerConfig("localhost", 8282, false);
        slaveConfig.getSlaveServer().setUsername("cluster");
        slaveConfig.getSlaveServer().setPassword("cluster");
        String dbDir = System.getProperty("java.io.tmpdir") + "/" + UUID.randomUUID().toString() + "-slaveSeqTest-H2-DB";
        DatabaseMeta databaseMeta = new DatabaseMeta("H2", "H2", "Native", null, dbDir, null, null, null);
        slaveConfig.getDatabases().add(databaseMeta);
        String table = "SLAVE_SEQUENCE";
        String nameField = "SEQ_NAME";
        String valueField = "SEQ_VALUE";
        SlaveSequence slaveSequence = new SlaveSequence(SLAVE_SEQUENCE_NAME, 1L, databaseMeta, null, table, nameField, valueField);
        slaveConfig.getSlaveSequences().add(slaveSequence);
        Database db = new Database(this.loggingObject, databaseMeta);
        db.connect();
        db.execStatement("CREATE TABLE SLAVE_SEQUENCE(SEQ_NAME VARCHAR(100), SEQ_VALUE INTEGER);");
        db.disconnect();
        CarteLauncher carteLauncher = new CarteLauncher(slaveConfig);
        Thread thread = new Thread(carteLauncher);
        thread.start();
        while (carteLauncher.getCarte() == null && !carteLauncher.isFailure()) {
            Thread.sleep(100L);
        }
        long value = slaveConfig.getSlaveServer().getNextSlaveSequenceValue(SLAVE_SEQUENCE_NAME, 1000L);
        SlaveSequenceTest.assertEquals((long)1L, (long)value);
        value = slaveConfig.getSlaveServer().getNextSlaveSequenceValue(SLAVE_SEQUENCE_NAME, 1000L);
        SlaveSequenceTest.assertEquals((long)1001L, (long)value);
        try {
            slaveConfig.getSlaveServer().getNextSlaveSequenceValue("Unknown sequence", 1000L);
            SlaveSequenceTest.fail((String)"No error was thrown for retrieval of an unknown sequence");
        }
        catch (Exception e) {
            // empty catch block
        }
        carteLauncher.getCarte().getWebServer().stopServer();
        File dir = new File(dbDir);
        if (dir.exists()) {
            for (File child : dir.listFiles()) {
                if (!child.isFile()) continue;
                child.delete();
            }
            dir.delete();
        }
    }

    public void testSlaveSequenceRetrieval_AutoCreation() throws Exception {
        this.init();
        String SLAVE_SEQUENCE_NAME = "test";
        SlaveServerConfig slaveConfig = new SlaveServerConfig("localhost", 8282, false);
        slaveConfig.getSlaveServer().setUsername("cluster");
        slaveConfig.getSlaveServer().setPassword("cluster");
        String dbDir = System.getProperty("java.io.tmpdir") + "/" + UUID.randomUUID().toString() + "-slaveSeqTest-H2-DB";
        DatabaseMeta databaseMeta = new DatabaseMeta("H2", "H2", "Native", null, dbDir, null, null, null);
        slaveConfig.getDatabases().add(databaseMeta);
        String table = "SLAVE_SEQUENCE";
        String nameField = "SEQ_NAME";
        String valueField = "SEQ_VALUE";
        SlaveSequence slaveSequence = new SlaveSequence(SLAVE_SEQUENCE_NAME, 1L, databaseMeta, null, table, nameField, valueField);
        slaveConfig.setAutomaticCreationAllowed(true);
        slaveConfig.setAutoSequence(slaveSequence);
        Database db = new Database(this.loggingObject, databaseMeta);
        db.connect();
        db.execStatement("CREATE TABLE SLAVE_SEQUENCE(SEQ_NAME VARCHAR(100), SEQ_VALUE INTEGER);");
        db.disconnect();
        CarteLauncher carteLauncher = new CarteLauncher(slaveConfig);
        Thread thread = new Thread(carteLauncher);
        thread.start();
        while (carteLauncher.getCarte() == null && !carteLauncher.isFailure()) {
            Thread.sleep(100L);
        }
        try {
            long value = slaveConfig.getSlaveServer().getNextSlaveSequenceValue(SLAVE_SEQUENCE_NAME, 1000L);
            SlaveSequenceTest.assertEquals((long)1L, (long)value);
            value = slaveConfig.getSlaveServer().getNextSlaveSequenceValue(SLAVE_SEQUENCE_NAME, 1000L);
            SlaveSequenceTest.assertEquals((long)1001L, (long)value);
            value = slaveConfig.getSlaveServer().getNextSlaveSequenceValue("new sequence", 1000L);
            SlaveSequenceTest.assertEquals((long)1L, (long)value);
            value = slaveConfig.getSlaveServer().getNextSlaveSequenceValue("new sequence", 1000L);
            SlaveSequenceTest.assertEquals((long)1001L, (long)value);
            value = slaveConfig.getSlaveServer().getNextSlaveSequenceValue(SLAVE_SEQUENCE_NAME, 1000L);
            SlaveSequenceTest.assertEquals((long)2001L, (long)value);
        }
        catch (Exception e) {
            SlaveSequenceTest.fail((String)"And error was thrown for retrieval of an unknown sequence, auto-creation expected");
        }
        carteLauncher.getCarte().getWebServer().stopServer();
        File dir = new File(dbDir);
        if (dir.exists()) {
            for (File child : dir.listFiles()) {
                if (!child.isFile()) continue;
                child.delete();
            }
            dir.delete();
        }
    }
}

