/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.compatibility;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.pentaho.di.compatibility.ValueBigNumber;

public class ValueBigNumberTest
extends TestCase {
    public void testConstructor1() {
        ValueBigNumber vs = new ValueBigNumber();
        ValueBigNumberTest.assertEquals((int)6, (int)vs.getType());
        ValueBigNumberTest.assertEquals((String)"BigNumber", (String)vs.getTypeDesc());
        ValueBigNumberTest.assertNull((Object)vs.getBigNumber());
        ValueBigNumberTest.assertEquals((int)-1, (int)vs.getLength());
        ValueBigNumberTest.assertEquals((int)-1, (int)vs.getPrecision());
        ValueBigNumber vs1 = new ValueBigNumber(BigDecimal.ONE);
        vs1.setLength(2);
        ValueBigNumberTest.assertEquals((int)2, (int)vs1.getLength());
        ValueBigNumberTest.assertEquals((int)-1, (int)vs1.getPrecision());
        vs1.setLength(4, 2);
        ValueBigNumberTest.assertEquals((int)4, (int)vs1.getLength());
        ValueBigNumberTest.assertEquals((int)2, (int)vs1.getPrecision());
        vs1.setPrecision(3);
        ValueBigNumberTest.assertEquals((int)3, (int)vs1.getPrecision());
    }

    public void testGetters() {
        ValueBigNumber vs1 = new ValueBigNumber();
        ValueBigNumber vs2 = new ValueBigNumber(BigDecimal.ZERO);
        ValueBigNumber vs3 = new ValueBigNumber(BigDecimal.ONE);
        ValueBigNumberTest.assertEquals((boolean)false, (boolean)vs1.getBoolean());
        ValueBigNumberTest.assertEquals((boolean)false, (boolean)vs2.getBoolean());
        ValueBigNumberTest.assertEquals((boolean)true, (boolean)vs3.getBoolean());
        ValueBigNumberTest.assertEquals(null, (String)vs1.getString());
        ValueBigNumberTest.assertEquals((String)"0", (String)vs2.getString());
        ValueBigNumberTest.assertEquals((String)"1", (String)vs3.getString());
        ValueBigNumberTest.assertEquals((double)0.0, (double)vs1.getNumber(), (double)0.001);
        ValueBigNumberTest.assertEquals((double)0.0, (double)vs2.getNumber(), (double)0.001);
        ValueBigNumberTest.assertEquals((double)1.0, (double)vs3.getNumber(), (double)0.001);
        ValueBigNumberTest.assertEquals((long)0L, (long)vs1.getInteger());
        ValueBigNumberTest.assertEquals((long)0L, (long)vs2.getInteger());
        ValueBigNumberTest.assertEquals((long)1L, (long)vs3.getInteger());
        ValueBigNumberTest.assertNull((Object)vs1.getBigNumber());
        ValueBigNumberTest.assertEquals((Object)new BigDecimal(0L), (Object)vs2.getBigNumber());
        ValueBigNumberTest.assertEquals((Object)new BigDecimal(1L), (Object)vs3.getBigNumber());
        ValueBigNumberTest.assertNull((Object)vs1.getDate());
        ValueBigNumberTest.assertEquals((long)0L, (long)vs2.getDate().getTime());
        ValueBigNumberTest.assertEquals((long)1L, (long)vs3.getDate().getTime());
        ValueBigNumberTest.assertNull((Object)vs1.getSerializable());
        ValueBigNumberTest.assertEquals((Object)BigDecimal.ZERO, (Object)vs2.getSerializable());
        ValueBigNumberTest.assertEquals((Object)BigDecimal.ONE, (Object)vs3.getSerializable());
    }

    public void testSetters() {
        TimeZone.setDefault(TimeZone.getTimeZone("CET"));
        ValueBigNumber vs = new ValueBigNumber();
        vs.setString("unknown");
        ValueBigNumberTest.assertEquals((Object)BigDecimal.ZERO, (Object)vs.getBigNumber());
        vs.setString("-4.0");
        ValueBigNumberTest.assertEquals((Object)BigDecimal.valueOf(-4.0), (Object)vs.getBigNumber());
        vs.setString("0.0");
        ValueBigNumberTest.assertEquals((Object)BigDecimal.valueOf(0.0), (Object)vs.getBigNumber());
        vs.setString("0");
        ValueBigNumberTest.assertEquals((Object)BigDecimal.ZERO, (Object)vs.getBigNumber());
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS", Locale.US);
        Date dt = null;
        try {
            dt = format.parse("2006/06/07 01:02:03.004");
        }
        catch (ParseException ex) {
            dt = null;
        }
        vs.setDate(dt);
        ValueBigNumberTest.assertEquals((Object)new BigDecimal("1149634923004"), (Object)vs.getBigNumber());
        vs.setBoolean(true);
        ValueBigNumberTest.assertEquals((Object)BigDecimal.ONE, (Object)vs.getBigNumber());
        vs.setBoolean(false);
        ValueBigNumberTest.assertEquals((Object)BigDecimal.ZERO, (Object)vs.getBigNumber());
        vs.setNumber(5.0);
        ValueBigNumberTest.assertEquals((Object)BigDecimal.valueOf(5.0), (Object)vs.getBigNumber());
        vs.setNumber(0.0);
        ValueBigNumberTest.assertEquals((Object)BigDecimal.valueOf(0.0), (Object)vs.getBigNumber());
        vs.setInteger(5L);
        ValueBigNumberTest.assertEquals((Object)BigDecimal.valueOf(5L), (Object)vs.getBigNumber());
        vs.setInteger(0L);
        ValueBigNumberTest.assertEquals((Object)BigDecimal.ZERO, (Object)vs.getBigNumber());
        vs.setBigNumber(new BigDecimal(5));
        ValueBigNumberTest.assertEquals((double)5.0, (double)vs.getNumber(), (double)0.1);
        vs.setBigNumber(new BigDecimal(0));
        ValueBigNumberTest.assertEquals((double)0.0, (double)vs.getNumber(), (double)0.1);
    }
}

