/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.compatibility;

import java.math.BigDecimal;
import java.util.Date;
import junit.framework.TestCase;
import org.pentaho.di.compatibility.ValueBoolean;

public class ValueBooleanTest
extends TestCase {
    public void testConstructor1() {
        ValueBoolean vs = new ValueBoolean();
        ValueBooleanTest.assertEquals((int)4, (int)vs.getType());
        ValueBooleanTest.assertEquals((String)"Boolean", (String)vs.getTypeDesc());
        ValueBooleanTest.assertEquals((boolean)false, (boolean)vs.getBoolean());
        ValueBooleanTest.assertEquals((int)-1, (int)vs.getLength());
        ValueBooleanTest.assertEquals((int)-1, (int)vs.getPrecision());
        ValueBoolean vs1 = new ValueBoolean(true);
        ValueBooleanTest.assertEquals((int)4, (int)vs1.getType());
        vs1.setLength(2);
        ValueBooleanTest.assertEquals((int)-1, (int)vs1.getLength());
        ValueBooleanTest.assertEquals((int)-1, (int)vs1.getPrecision());
        vs1.setLength(2, 2);
        ValueBooleanTest.assertEquals((int)-1, (int)vs1.getLength());
        ValueBooleanTest.assertEquals((int)-1, (int)vs1.getPrecision());
        vs1.setPrecision(2);
        ValueBooleanTest.assertEquals((int)-1, (int)vs1.getLength());
        ValueBooleanTest.assertEquals((int)-1, (int)vs1.getPrecision());
    }

    public void testGetters() {
        ValueBoolean vs1 = new ValueBoolean(true);
        ValueBoolean vs2 = new ValueBoolean(false);
        ValueBooleanTest.assertEquals((boolean)true, (boolean)vs1.getBoolean());
        ValueBooleanTest.assertEquals((boolean)false, (boolean)vs2.getBoolean());
        ValueBooleanTest.assertEquals((String)"Y", (String)vs1.getString());
        ValueBooleanTest.assertEquals((String)"N", (String)vs2.getString());
        ValueBooleanTest.assertEquals((double)1.0, (double)vs1.getNumber(), (double)0.001);
        ValueBooleanTest.assertEquals((double)0.0, (double)vs2.getNumber(), (double)0.001);
        ValueBooleanTest.assertEquals((long)1L, (long)vs1.getInteger());
        ValueBooleanTest.assertEquals((long)0L, (long)vs2.getInteger());
        ValueBooleanTest.assertEquals((Object)new BigDecimal(1), (Object)vs1.getBigNumber());
        ValueBooleanTest.assertEquals((Object)new BigDecimal(0), (Object)vs2.getBigNumber());
        ValueBooleanTest.assertNull((Object)vs1.getDate());
        ValueBooleanTest.assertNull((Object)vs2.getDate());
        ValueBooleanTest.assertEquals((Object)new Boolean(true), (Object)vs1.getSerializable());
        ValueBooleanTest.assertEquals((Object)new Boolean(false), (Object)vs2.getSerializable());
    }

    public void testSetters() {
        ValueBoolean vs = new ValueBoolean(true);
        vs.setString("unknown");
        ValueBooleanTest.assertEquals((boolean)false, (boolean)vs.getBoolean());
        vs.setString("y");
        ValueBooleanTest.assertEquals((boolean)true, (boolean)vs.getBoolean());
        vs.setString("Y");
        ValueBooleanTest.assertEquals((boolean)true, (boolean)vs.getBoolean());
        vs.setString("yes");
        ValueBooleanTest.assertEquals((boolean)true, (boolean)vs.getBoolean());
        vs.setString("YES");
        ValueBooleanTest.assertEquals((boolean)true, (boolean)vs.getBoolean());
        vs.setString("true");
        ValueBooleanTest.assertEquals((boolean)true, (boolean)vs.getBoolean());
        vs.setString("TRUE");
        ValueBooleanTest.assertEquals((boolean)true, (boolean)vs.getBoolean());
        vs.setString("false");
        ValueBooleanTest.assertEquals((boolean)false, (boolean)vs.getBoolean());
        vs.setDate(new Date());
        ValueBooleanTest.assertEquals((boolean)false, (boolean)vs.getBoolean());
        vs.setBoolean(true);
        ValueBooleanTest.assertEquals((boolean)true, (boolean)vs.getBoolean());
        vs.setBoolean(false);
        ValueBooleanTest.assertEquals((boolean)false, (boolean)vs.getBoolean());
        vs.setNumber(5.0);
        ValueBooleanTest.assertEquals((boolean)true, (boolean)vs.getBoolean());
        vs.setNumber(0.0);
        ValueBooleanTest.assertEquals((boolean)false, (boolean)vs.getBoolean());
        vs.setInteger(5L);
        ValueBooleanTest.assertEquals((boolean)true, (boolean)vs.getBoolean());
        vs.setInteger(0L);
        ValueBooleanTest.assertEquals((boolean)false, (boolean)vs.getBoolean());
        vs.setBigNumber(new BigDecimal(5));
        ValueBooleanTest.assertEquals((boolean)true, (boolean)vs.getBoolean());
        vs.setBigNumber(new BigDecimal(0));
        ValueBooleanTest.assertEquals((boolean)false, (boolean)vs.getBoolean());
    }

    public void testClone() {
        ValueBoolean vs1 = new ValueBoolean(true);
        ValueBoolean cloneVs1 = (ValueBoolean)vs1.clone();
        ValueBooleanTest.assertTrue((cloneVs1.getBoolean() == vs1.getBoolean() ? 1 : 0) != 0);
        ValueBooleanTest.assertFalse((cloneVs1 == vs1 ? 1 : 0) != 0);
        ValueBoolean vs2 = new ValueBoolean(false);
        ValueBoolean cloneVs2 = (ValueBoolean)vs2.clone();
        ValueBooleanTest.assertTrue((cloneVs2.getBoolean() == vs2.getBoolean() ? 1 : 0) != 0);
        ValueBooleanTest.assertFalse((cloneVs2 == vs2 ? 1 : 0) != 0);
    }
}

