/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.compatibility;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import junit.framework.TestCase;
import org.pentaho.di.compatibility.ValueDate;

public class ValueDateTest
extends TestCase {
    private static Date dt = null;

    public void testConstructor1() {
        ValueDate vs = new ValueDate();
        ValueDateTest.assertEquals((int)3, (int)vs.getType());
        ValueDateTest.assertEquals((String)"Date", (String)vs.getTypeDesc());
        ValueDateTest.assertNull((Object)vs.getDate());
        ValueDateTest.assertEquals((int)-1, (int)vs.getLength());
        ValueDateTest.assertEquals((int)-1, (int)vs.getPrecision());
        ValueDate vs1 = new ValueDate(dt);
        vs1.setLength(2);
        ValueDateTest.assertEquals((int)-1, (int)vs1.getLength());
        ValueDateTest.assertEquals((int)-1, (int)vs1.getPrecision());
        vs1.setLength(4, 2);
        ValueDateTest.assertEquals((int)-1, (int)vs1.getLength());
        ValueDateTest.assertEquals((int)2, (int)vs1.getPrecision());
        vs1.setPrecision(3);
        ValueDateTest.assertEquals((int)3, (int)vs1.getPrecision());
    }

    public void testGetters() {
        TimeZone.setDefault(TimeZone.getTimeZone("CET"));
        ValueDate vs1 = new ValueDate();
        ValueDate vs2 = new ValueDate(dt);
        ValueDateTest.assertEquals((boolean)false, (boolean)vs1.getBoolean());
        ValueDateTest.assertEquals((boolean)false, (boolean)vs2.getBoolean());
        ValueDateTest.assertNull((Object)vs1.getString());
        ValueDateTest.assertEquals((String)"2006/06/07 01:02:03.004", (String)vs2.getString());
        ValueDateTest.assertEquals((double)0.0, (double)vs1.getNumber(), (double)0.001);
        ValueDateTest.assertEquals((double)1.149634923004E12, (double)vs2.getNumber(), (double)1.0E9);
        ValueDateTest.assertEquals((long)0L, (long)vs1.getInteger());
        ValueDateTest.assertEquals((long)1149634923004L, (long)vs2.getInteger());
        ValueDateTest.assertEquals((Object)BigDecimal.ZERO, (Object)vs1.getBigNumber());
        ValueDateTest.assertEquals((Object)new BigDecimal(1149634923004L), (Object)vs2.getBigNumber());
        ValueDateTest.assertNull((Object)vs1.getDate());
        ValueDateTest.assertEquals((long)1149634923004L, (long)vs2.getDate().getTime());
        ValueDateTest.assertNull((Object)vs1.getSerializable());
        ValueDateTest.assertEquals((Object)dt, (Object)vs2.getSerializable());
    }

    public void testSetters() {
        TimeZone.setDefault(TimeZone.getTimeZone("CET"));
        ValueDate vs = new ValueDate();
        try {
            vs.setString(null);
            ValueDateTest.fail((String)"Expected NullPointerException");
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        vs.setString("unknown");
        ValueDateTest.assertNull((Object)vs.getDate());
        vs.setString("2006/06/07 01:02:03.004");
        ValueDateTest.assertEquals((Object)dt, (Object)vs.getDate());
        vs.setDate(dt);
        ValueDateTest.assertEquals((Object)dt, (Object)vs.getDate());
        vs.setBoolean(true);
        ValueDateTest.assertNull((Object)vs.getDate());
        vs.setBoolean(false);
        ValueDateTest.assertNull((Object)vs.getDate());
        vs.setNumber((double)dt.getTime());
        ValueDateTest.assertEquals((Object)dt, (Object)vs.getDate());
        vs.setInteger(dt.getTime());
        ValueDateTest.assertEquals((Object)dt, (Object)vs.getDate());
        vs.setBigNumber(new BigDecimal(dt.getTime()));
        ValueDateTest.assertEquals((Object)dt, (Object)vs.getDate());
    }

    static {
        TimeZone.setDefault(TimeZone.getTimeZone("CET"));
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS", Locale.US);
        try {
            dt = format.parse("2006/06/07 01:02:03.004");
        }
        catch (ParseException ex) {
            dt = null;
        }
    }
}

