/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.compatibility;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import junit.framework.TestCase;
import org.pentaho.di.compatibility.ValueInteger;

public class ValueIntegerTest
extends TestCase {
    public void testConstructor1() {
        ValueInteger vs = new ValueInteger();
        ValueIntegerTest.assertEquals((int)5, (int)vs.getType());
        ValueIntegerTest.assertEquals((String)"Integer", (String)vs.getTypeDesc());
        ValueIntegerTest.assertEquals((long)0L, (long)vs.getInteger());
        ValueIntegerTest.assertEquals((int)-1, (int)vs.getLength());
        ValueIntegerTest.assertEquals((int)0, (int)vs.getPrecision());
        ValueInteger vs1 = new ValueInteger(10L);
        vs1.setLength(2);
        ValueIntegerTest.assertEquals((int)2, (int)vs1.getLength());
        ValueIntegerTest.assertEquals((int)0, (int)vs1.getPrecision());
        vs1.setLength(4, 2);
        ValueIntegerTest.assertEquals((int)4, (int)vs1.getLength());
        ValueIntegerTest.assertEquals((int)0, (int)vs1.getPrecision());
        vs1.setPrecision(3);
        ValueIntegerTest.assertEquals((int)0, (int)vs1.getPrecision());
    }

    public void testGetters() {
        ValueInteger vs1 = new ValueInteger(-4L);
        ValueInteger vs2 = new ValueInteger(0L);
        ValueInteger vs3 = new ValueInteger(3L);
        ValueIntegerTest.assertEquals((boolean)true, (boolean)vs1.getBoolean());
        ValueIntegerTest.assertEquals((boolean)false, (boolean)vs2.getBoolean());
        ValueIntegerTest.assertEquals((boolean)true, (boolean)vs3.getBoolean());
        ValueIntegerTest.assertEquals((String)"-4", (String)vs1.getString());
        ValueIntegerTest.assertEquals((String)"0", (String)vs2.getString());
        ValueIntegerTest.assertEquals((String)"3", (String)vs3.getString());
        ValueIntegerTest.assertEquals((double)-4.0, (double)vs1.getNumber(), (double)0.001);
        ValueIntegerTest.assertEquals((double)0.0, (double)vs2.getNumber(), (double)0.001);
        ValueIntegerTest.assertEquals((double)3.0, (double)vs3.getNumber(), (double)0.001);
        ValueIntegerTest.assertEquals((long)-4L, (long)vs1.getInteger());
        ValueIntegerTest.assertEquals((long)0L, (long)vs2.getInteger());
        ValueIntegerTest.assertEquals((long)3L, (long)vs3.getInteger());
        ValueIntegerTest.assertEquals((Object)new BigDecimal(-4L), (Object)vs1.getBigNumber());
        ValueIntegerTest.assertEquals((Object)new BigDecimal(0L), (Object)vs2.getBigNumber());
        ValueIntegerTest.assertEquals((Object)new BigDecimal(3L), (Object)vs3.getBigNumber());
        ValueIntegerTest.assertEquals((long)-4L, (long)vs1.getDate().getTime());
        ValueIntegerTest.assertEquals((long)0L, (long)vs2.getDate().getTime());
        ValueIntegerTest.assertEquals((long)3L, (long)vs3.getDate().getTime());
        ValueIntegerTest.assertEquals((Object)new Long(-4L), (Object)vs1.getSerializable());
        ValueIntegerTest.assertEquals((Object)new Long(0L), (Object)vs2.getSerializable());
        ValueIntegerTest.assertEquals((Object)new Long(3L), (Object)vs3.getSerializable());
    }

    public void testSetters() {
        ValueInteger vs = new ValueInteger(0L);
        vs.setString("unknown");
        ValueIntegerTest.assertEquals((long)0L, (long)vs.getInteger());
        vs.setString("-4.0");
        ValueIntegerTest.assertEquals((long)0L, (long)vs.getInteger());
        vs.setString("-4");
        ValueIntegerTest.assertEquals((long)-4L, (long)vs.getInteger());
        vs.setString("0");
        ValueIntegerTest.assertEquals((long)0L, (long)vs.getInteger());
        vs.setString("3");
        ValueIntegerTest.assertEquals((long)3L, (long)vs.getInteger());
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS z");
        Date dt = null;
        try {
            dt = format.parse("2006/06/07 01:02:03.004 CET");
        }
        catch (ParseException ex) {
            dt = null;
        }
        vs.setDate(dt);
        ValueIntegerTest.assertEquals((long)1149638523004L, (long)vs.getInteger());
        vs.setBoolean(true);
        ValueIntegerTest.assertEquals((long)1L, (long)vs.getInteger());
        vs.setBoolean(false);
        ValueIntegerTest.assertEquals((long)0L, (long)vs.getInteger());
        vs.setNumber(5.0);
        ValueIntegerTest.assertEquals((long)5L, (long)vs.getInteger());
        vs.setNumber(0.0);
        ValueIntegerTest.assertEquals((long)0L, (long)vs.getInteger());
        vs.setInteger(5L);
        ValueIntegerTest.assertEquals((long)5L, (long)vs.getInteger());
        vs.setInteger(0L);
        ValueIntegerTest.assertEquals((long)0L, (long)vs.getInteger());
        vs.setBigNumber(new BigDecimal(5));
        ValueIntegerTest.assertEquals((long)5L, (long)vs.getInteger());
        vs.setBigNumber(new BigDecimal(0));
        ValueIntegerTest.assertEquals((long)0L, (long)vs.getInteger());
    }
}

