/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.compatibility;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import junit.framework.TestCase;
import org.pentaho.di.compatibility.ValueNumber;

public class ValueNumberTest
extends TestCase {
    public void testConstructor1() {
        ValueNumber vs = new ValueNumber();
        ValueNumberTest.assertEquals((int)1, (int)vs.getType());
        ValueNumberTest.assertEquals((String)"Number", (String)vs.getTypeDesc());
        ValueNumberTest.assertEquals((double)0.0, (double)vs.getNumber(), (double)0.001);
        ValueNumberTest.assertEquals((int)-1, (int)vs.getLength());
        ValueNumberTest.assertEquals((int)-1, (int)vs.getPrecision());
        ValueNumber vs1 = new ValueNumber(10.0);
        vs1.setLength(2);
        ValueNumberTest.assertEquals((int)2, (int)vs1.getLength());
        ValueNumberTest.assertEquals((int)-1, (int)vs1.getPrecision());
        vs1.setLength(4, 2);
        ValueNumberTest.assertEquals((int)4, (int)vs1.getLength());
        ValueNumberTest.assertEquals((int)2, (int)vs1.getPrecision());
        vs1.setPrecision(3);
        ValueNumberTest.assertEquals((int)3, (int)vs1.getPrecision());
    }

    public void testGetters() {
        ValueNumber vs1 = new ValueNumber(-4.0);
        ValueNumber vs2 = new ValueNumber(0.0);
        ValueNumber vs3 = new ValueNumber(3.0);
        ValueNumber vs4 = new ValueNumber(3.5);
        ValueNumberTest.assertEquals((boolean)true, (boolean)vs1.getBoolean());
        ValueNumberTest.assertEquals((boolean)false, (boolean)vs2.getBoolean());
        ValueNumberTest.assertEquals((boolean)true, (boolean)vs3.getBoolean());
        ValueNumberTest.assertEquals((String)"-4.0", (String)vs1.getString());
        ValueNumberTest.assertEquals((String)"0.0", (String)vs2.getString());
        ValueNumberTest.assertEquals((String)"3.0", (String)vs3.getString());
        ValueNumberTest.assertEquals((double)-4.0, (double)vs1.getNumber(), (double)0.001);
        ValueNumberTest.assertEquals((double)0.0, (double)vs2.getNumber(), (double)0.001);
        ValueNumberTest.assertEquals((double)3.0, (double)vs3.getNumber(), (double)0.001);
        ValueNumberTest.assertEquals((long)-4L, (long)vs1.getInteger());
        ValueNumberTest.assertEquals((long)0L, (long)vs2.getInteger());
        ValueNumberTest.assertEquals((long)3L, (long)vs3.getInteger());
        ValueNumberTest.assertEquals((long)4L, (long)vs4.getInteger());
        ValueNumberTest.assertEquals((Object)BigDecimal.valueOf(-4.0), (Object)vs1.getBigNumber());
        ValueNumberTest.assertEquals((Object)BigDecimal.valueOf(0.0), (Object)vs2.getBigNumber());
        ValueNumberTest.assertEquals((Object)BigDecimal.valueOf(3.0), (Object)vs3.getBigNumber());
        ValueNumberTest.assertEquals((Object)BigDecimal.valueOf(3.5), (Object)vs4.getBigNumber());
        ValueNumberTest.assertEquals((long)-4L, (long)vs1.getDate().getTime());
        ValueNumberTest.assertEquals((long)0L, (long)vs2.getDate().getTime());
        ValueNumberTest.assertEquals((long)3L, (long)vs3.getDate().getTime());
        ValueNumberTest.assertEquals((long)3L, (long)vs4.getDate().getTime());
        ValueNumberTest.assertEquals((Object)new Double(-4.0), (Object)vs1.getSerializable());
        ValueNumberTest.assertEquals((Object)new Double(0.0), (Object)vs2.getSerializable());
        ValueNumberTest.assertEquals((Object)new Double(3.0), (Object)vs3.getSerializable());
    }

    public void testSetters() {
        ValueNumber vs = new ValueNumber(0.0);
        vs.setString("unknown");
        ValueNumberTest.assertEquals((double)0.0, (double)vs.getNumber(), (double)0.001);
        vs.setString("-4.0");
        ValueNumberTest.assertEquals((double)-4.0, (double)vs.getNumber(), (double)0.001);
        vs.setString("0.0");
        ValueNumberTest.assertEquals((double)0.0, (double)vs.getNumber(), (double)0.001);
        vs.setString("0");
        ValueNumberTest.assertEquals((double)0.0, (double)vs.getNumber(), (double)0.001);
        vs.setString("3.0");
        SimpleDateFormat format = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSS", Locale.US);
        Date dt = null;
        try {
            dt = format.parse("2006/06/07 01:02:03.004");
        }
        catch (ParseException ex) {
            dt = null;
        }
        vs.setDate(dt);
        ValueNumberTest.assertEquals((double)1.149634923004E12, (double)vs.getNumber(), (double)5.0E8);
        vs.setBoolean(true);
        ValueNumberTest.assertEquals((double)1.0, (double)vs.getNumber(), (double)0.1);
        vs.setBoolean(false);
        ValueNumberTest.assertEquals((double)0.0, (double)vs.getNumber(), (double)0.1);
        vs.setNumber(5.0);
        ValueNumberTest.assertEquals((double)5.0, (double)vs.getNumber(), (double)0.1);
        vs.setNumber(0.0);
        ValueNumberTest.assertEquals((double)0.0, (double)vs.getNumber(), (double)0.1);
        vs.setInteger(5L);
        ValueNumberTest.assertEquals((double)5.0, (double)vs.getNumber(), (double)0.1);
        vs.setInteger(0L);
        ValueNumberTest.assertEquals((double)0.0, (double)vs.getNumber(), (double)0.1);
        vs.setBigNumber(new BigDecimal(5));
        ValueNumberTest.assertEquals((double)5.0, (double)vs.getNumber(), (double)0.1);
        vs.setBigNumber(new BigDecimal(0));
        ValueNumberTest.assertEquals((double)0.0, (double)vs.getNumber(), (double)0.1);
    }
}

